/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c", include=JsonTypeInfo.As.PROPERTY)
public interface JavaType {
    public static final FullyQualified[] EMPTY_FULLY_QUALIFIED_ARRAY = new FullyQualified[0];
    public static final Variable[] EMPTY_VARIABLE_ARRAY = new Variable[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final JavaType[] EMPTY_JAVA_TYPE_ARRAY = new JavaType[0];
    public static final Annotation.ElementValue[] EMPTY_ANNOTATION_VALUE_ARRAY = new Annotation.ElementValue[0];

    default public @Nullable Integer getManagedReference() {
        return null;
    }

    default public JavaType withManagedReference(Integer id) {
        return this;
    }

    default public JavaType unsafeSetManagedReference(Integer id) {
        return this;
    }

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return ShallowClass.build(typeName);
    }

    default public boolean isAssignableFrom(Pattern pattern) {
        if (this instanceof FullyQualified) {
            FullyQualified fq = (FullyQualified)this;
            if (pattern.matcher(fq.getFullyQualifiedName()).matches()) {
                return true;
            }
            if (fq.getSupertype() != null && fq.getSupertype().isAssignableFrom(pattern)) {
                return true;
            }
            for (FullyQualified anInterface : fq.getInterfaces()) {
                if (!anInterface.isAssignableFrom(pattern)) continue;
                return true;
            }
            return false;
        }
        if (this instanceof GenericTypeVariable) {
            GenericTypeVariable generic = (GenericTypeVariable)this;
            for (JavaType bound : generic.getBounds()) {
                if (!bound.isAssignableFrom(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum Primitive implements JavaType
    {
        Boolean,
        Byte,
        Char,
        Double,
        Float,
        Int,
        Long,
        Short,
        Void,
        String,
        None,
        Null;


        public static @Nullable Primitive fromKeyword(String keyword) {
            switch (keyword) {
                case "boolean": {
                    return Boolean;
                }
                case "byte": {
                    return Byte;
                }
                case "char": {
                    return Char;
                }
                case "double": {
                    return Double;
                }
                case "float": {
                    return Float;
                }
                case "int": {
                    return Int;
                }
                case "long": {
                    return Long;
                }
                case "short": {
                    return Short;
                }
                case "void": {
                    return Void;
                }
                case "String": {
                    return String;
                }
                case "null": {
                    return Null;
                }
                case "": {
                    return None;
                }
            }
            return null;
        }

        public static @Nullable Primitive fromClassName(String className) {
            switch (className) {
                case "java.lang.Boolean": {
                    return Boolean;
                }
                case "java.lang.Byte": {
                    return Byte;
                }
                case "java.lang.Character": {
                    return Char;
                }
                case "java.lang.Double": {
                    return Double;
                }
                case "java.lang.Float": {
                    return Float;
                }
                case "java.lang.Integer": {
                    return Int;
                }
                case "java.lang.Long": {
                    return Long;
                }
                case "java.lang.Short": {
                    return Short;
                }
                case "java.lang.Void": {
                    return Void;
                }
                case "java.lang.String": {
                    return String;
                }
            }
            return null;
        }

        public String getKeyword() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Int: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
                case Void: {
                    return "void";
                }
                case String: {
                    return "String";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        public String getClassName() {
            switch (this) {
                case Boolean: {
                    return "java.lang.Boolean";
                }
                case Byte: {
                    return "java.lang.Byte";
                }
                case Char: {
                    return "java.lang.Character";
                }
                case Double: {
                    return "java.lang.Double";
                }
                case Float: {
                    return "java.lang.Float";
                }
                case Int: {
                    return "java.lang.Integer";
                }
                case Long: {
                    return "java.lang.Long";
                }
                case Short: {
                    return "java.lang.Short";
                }
                case Void: {
                    return "java.lang.Void";
                }
                case String: {
                    return "java.lang.String";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        public String toString() {
            return this.getKeyword();
        }

        public boolean isNumeric() {
            return this == Double || this == Int || this == Float || this == Long || this == Short;
        }
    }

    public static class ShallowClass
    extends Class {
        public ShallowClass(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            super(managedReference, flagsBitMap, fullyQualifiedName, kind, (List<JavaType>)null, null, owningClass, null, null, null, null);
        }

        @JsonCreator
        ShallowClass() {
        }

        public static ShallowClass build(String fullyQualifiedName) {
            ShallowClass owningClass = null;
            int firstClassNameIndex = 0;
            int lastDelimiter = 0;
            int prev = 32;
            for (int i = 0; i < fullyQualifiedName.length(); ++i) {
                char c = fullyQualifiedName.charAt(i);
                if (firstClassNameIndex == 0 && (prev == 46 || prev == 36) && Character.isUpperCase(c)) {
                    firstClassNameIndex = i;
                } else if (c == '.' || c == '$') {
                    lastDelimiter = i;
                }
                prev = c;
            }
            if (lastDelimiter > firstClassNameIndex) {
                owningClass = ShallowClass.build(fullyQualifiedName.substring(0, lastDelimiter));
            }
            return new ShallowClass(null, 1L, fullyQualifiedName, FullyQualified.Kind.Class, Collections.emptyList(), null, (FullyQualified)owningClass, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        public abstract FullyQualified withFullyQualifiedName(String var1);

        public abstract List<FullyQualified> getAnnotations();

        public abstract boolean hasFlags(Flag ... var1);

        public abstract Set<Flag> getFlags();

        public abstract List<FullyQualified> getInterfaces();

        public abstract Kind getKind();

        public abstract List<Variable> getMembers();

        public abstract List<Method> getMethods();

        public abstract List<JavaType> getTypeParameters();

        public Iterator<Method> getVisibleMethods() {
            return this.getVisibleMethods(this.getPackageName());
        }

        private Iterator<Method> getVisibleMethods(String packageName) {
            return new FullyQualifiedIterator<Method>(this, packageName, Method::getFlagsBitMap, FullyQualified::getMethods, fq -> fq.getVisibleMethods(packageName));
        }

        public Iterator<Variable> getVisibleMembers() {
            return this.getVisibleMembers(this.getPackageName());
        }

        private Iterator<Variable> getVisibleMembers(String packageName) {
            return new FullyQualifiedIterator<Variable>(this, packageName, Variable::getFlagsBitMap, FullyQualified::getMembers, fq -> fq.getVisibleMembers(packageName));
        }

        public abstract @Nullable FullyQualified getOwningClass();

        public abstract @Nullable FullyQualified getSupertype();

        public String getClassName() {
            String fqn = this.getFullyQualifiedName();
            String className = fqn.substring(fqn.lastIndexOf(46) + 1);
            return TypeUtils.toFullyQualifiedName(className);
        }

        public String getPackageName() {
            String fqn = this.getFullyQualifiedName();
            int endPackage = fqn.lastIndexOf(46);
            return endPackage < 0 ? "" : fqn.substring(0, endPackage);
        }

        public boolean isAssignableTo(String fullyQualifiedName) {
            return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), fullyQualifiedName) || this.getInterfaces().stream().anyMatch(anInterface -> anInterface.isAssignableTo(fullyQualifiedName)) || this.getSupertype() != null && this.getSupertype().isAssignableTo(fullyQualifiedName);
        }

        public boolean isAssignableFrom(@Nullable JavaType type) {
            if (type instanceof FullyQualified) {
                FullyQualified clazz = (FullyQualified)type;
                return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), clazz.getFullyQualifiedName()) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(this::isAssignableFrom);
            }
            if (type instanceof GenericTypeVariable) {
                GenericTypeVariable generic = (GenericTypeVariable)type;
                for (JavaType bound : generic.getBounds()) {
                    if (!this.isAssignableFrom(bound)) continue;
                    return true;
                }
            }
            return false;
        }

        private static class FullyQualifiedIterator<E>
        implements Iterator<E> {
            private final FullyQualified fq;
            private final String visibleFromPackage;
            private final Function<E, Long> flags;
            private final Function<FullyQualified, Iterator<E>> recursive;
            private FullyQualified rec;
            private E peek;
            private Iterator<E> current;
            private @Nullable Iterator<E> supertype;
            private @Nullable Iterator<FullyQualified> interfaces;
            private @Nullable Iterator<E> interfaceE;

            private FullyQualifiedIterator(FullyQualified fq, String visibleFromPackage, Function<E, Long> flags, Function<FullyQualified, List<E>> base, Function<FullyQualified, Iterator<E>> recursive) {
                this.fq = fq;
                this.rec = fq;
                this.visibleFromPackage = visibleFromPackage;
                this.flags = flags;
                this.recursive = recursive;
                this.current = base.apply(fq).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.current.hasNext()) {
                    this.peek = this.current.next();
                    long peekFlags = this.flags.apply(this.peek);
                    if (((Flag.Public.getBitMask() | Flag.Protected.getBitMask()) & peekFlags) != 0L) {
                        return true;
                    }
                    if ((Flag.Private.getBitMask() & peekFlags) == 0L && this.rec.getPackageName().equals(this.visibleFromPackage)) {
                        return true;
                    }
                    return true;
                }
                if (this.supertype == null) {
                    this.supertype = this.fq.getSupertype() == null ? Collections.emptyIterator() : this.recursive.apply(this.fq.getSupertype());
                    this.current = this.supertype;
                    this.rec = this.fq.getSupertype();
                    return this.hasNext();
                }
                if (this.interfaces == null) {
                    this.interfaces = this.fq.getInterfaces().iterator();
                    return this.hasNext();
                }
                if (this.interfaces.hasNext()) {
                    this.rec = this.interfaces.next();
                    this.current = this.recursive.apply(this.rec);
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public E next() {
                return this.peek;
            }
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation,
            Record,
            Value;

        }
    }

    public static class GenericTypeVariable
    implements JavaType {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private String name;
        private Variance variance;
        private JavaType @Nullable [] bounds;

        public GenericTypeVariable(@Nullable Integer managedReference, String name, Variance variance, @Nullable List<JavaType> bounds) {
            this(managedReference, name, variance, (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY));
        }

        GenericTypeVariable(@Nullable Integer managedReference, String name, Variance variance, JavaType @Nullable [] bounds) {
            this.managedReference = managedReference;
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])bounds);
        }

        @JsonCreator
        GenericTypeVariable() {
        }

        public List<JavaType> getBounds() {
            return this.bounds == null ? Collections.emptyList() : Arrays.asList(this.bounds);
        }

        public GenericTypeVariable withBounds(@Nullable List<JavaType> bounds) {
            Object[] boundsArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(boundsArray, this.bounds)) {
                return this;
            }
            return new GenericTypeVariable(this.managedReference, this.name, this.variance, (JavaType[])boundsArray);
        }

        @Override
        public GenericTypeVariable unsafeSetManagedReference(@Nullable Integer id) {
            this.managedReference = id;
            return this;
        }

        public GenericTypeVariable unsafeSet(String name, Variance variance, @Nullable List<JavaType> bounds) {
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public GenericTypeVariable unsafeSet(String name, Variance variance, JavaType @Nullable [] bounds) {
            this.name = name;
            this.variance = variance;
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])bounds);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericTypeVariable that = (GenericTypeVariable)o;
            return this.name.equals(that.name) && this.variance == that.variance && (this.variance == Variance.INVARIANT && this.bounds == null && that.bounds == null || this.bounds != null && Arrays.equals(this.bounds, that.bounds));
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @NonNull
        @Generated
        public GenericTypeVariable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new GenericTypeVariable(managedReference, this.name, this.variance, this.bounds);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }

        @NonNull
        @Generated
        public GenericTypeVariable withName(String name) {
            return this.name == name ? this : new GenericTypeVariable(this.managedReference, name, this.variance, this.bounds);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public GenericTypeVariable withVariance(Variance variance) {
            return this.variance == variance ? this : new GenericTypeVariable(this.managedReference, this.name, variance, this.bounds);
        }

        @Generated
        public Variance getVariance() {
            return this.variance;
        }

        public static enum Variance {
            INVARIANT,
            COVARIANT,
            CONTRAVARIANT;

        }
    }

    public static class Variable
    implements JavaType {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private long flagsBitMap;
        private String name;
        private @Nullable JavaType owner;
        private JavaType type;
        private FullyQualified @Nullable [] annotations;

        public Variable(@Nullable Integer managedReference, long flagsBitMap, String name, @Nullable JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this(managedReference, flagsBitMap, name, owner, type, (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY));
        }

        Variable(@Nullable Integer managedReference, long flagsBitMap, String name, @Nullable JavaType owner, @Nullable JavaType type, FullyQualified @Nullable [] annotations) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.name = name;
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
        }

        @JsonCreator
        Variable() {
        }

        public @Nullable JavaType getOwner() {
            return this.owner;
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Variable withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, this.type, (FullyQualified[])annotationsArray);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Variable withFlags(Set<Flag> flags) {
            return this.withFlagsBitMap(Flag.flagsToBitMap(flags));
        }

        @Override
        public Variable unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Variable unsafeSet(JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            return this;
        }

        public Variable unsafeSet(JavaType owner, @Nullable JavaType type, FullyQualified @Nullable [] annotations) {
            this.owner = owner;
            this.type = TypeUtils.unknownIfNull(type);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.name, variable.name) && Objects.equals(this.owner, variable.owner);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().variableSignature(this);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }

        @Generated
        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Override
        @NonNull
        @Generated
        public Variable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Variable(managedReference, this.flagsBitMap, this.name, this.owner, this.type, this.annotations);
        }

        @NonNull
        @Generated
        private Variable withFlagsBitMap(long flagsBitMap) {
            return this.flagsBitMap == flagsBitMap ? this : new Variable(this.managedReference, flagsBitMap, this.name, this.owner, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Variable withName(String name) {
            return this.name == name ? this : new Variable(this.managedReference, this.flagsBitMap, name, this.owner, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Variable withOwner(@Nullable JavaType owner) {
            return this.owner == owner ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, owner, this.type, this.annotations);
        }

        @NonNull
        @Generated
        public Variable withType(JavaType type) {
            return this.type == type ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, type, this.annotations);
        }
    }

    public static class Method
    implements JavaType {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private long flagsBitMap;
        private FullyQualified declaringType;
        private String name;
        private JavaType returnType;
        private String @Nullable [] parameterNames;
        private JavaType @Nullable [] parameterTypes;
        private JavaType @Nullable [] thrownExceptions;
        private FullyQualified @Nullable [] annotations;
        @Incubating(since="7.34.0")
        private @Nullable List<String> defaultValue;
        private String @Nullable [] declaredFormalTypeNames;

        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, @Nullable List<String> parameterNames, @Nullable List<JavaType> parameterTypes, @Nullable List<JavaType> thrownExceptions, @Nullable List<FullyQualified> annotations, @Nullable List<String> defaultValue, @Nullable List<String> declaredFormalTypeNames) {
            this(managedReference, flagsBitMap, declaringType, name, returnType, (String[])ListUtils.arrayOrNullIfEmpty(parameterNames, (Object[])EMPTY_STRING_ARRAY), (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY), (JavaType[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), defaultValue, (String[])ListUtils.arrayOrNullIfEmpty(declaredFormalTypeNames, (Object[])EMPTY_STRING_ARRAY));
        }

        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, String @Nullable [] parameterNames, JavaType @Nullable [] parameterTypes, JavaType @Nullable [] thrownExceptions, FullyQualified @Nullable [] annotations, @Nullable List<String> defaultValue, String @Nullable [] declaredFormalTypeNames) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.name = name;
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterNames = (String[])ListUtils.nullIfEmpty((Object[])parameterNames);
            this.parameterTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])parameterTypes);
            this.thrownExceptions = (JavaType[])ListUtils.nullIfEmpty((Object[])thrownExceptions);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.defaultValue = ListUtils.nullIfEmpty(defaultValue);
            this.declaredFormalTypeNames = (String[])ListUtils.nullIfEmpty((Object[])declaredFormalTypeNames);
        }

        @JsonCreator
        Method() {
        }

        @Override
        public Method unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Method unsafeSet(@Nullable FullyQualified declaringType, @Nullable JavaType returnType, @Nullable List<JavaType> parameterTypes, @Nullable List<JavaType> thrownExceptions, @Nullable List<FullyQualified> annotations) {
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            this.thrownExceptions = (JavaType[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            return this;
        }

        public Method unsafeSet(@Nullable FullyQualified declaringType, @Nullable JavaType returnType, JavaType @Nullable [] parameterTypes, JavaType @Nullable [] thrownExceptions, FullyQualified @Nullable [] annotations) {
            this.declaringType = TypeUtils.unknownIfNull(declaringType);
            this.returnType = TypeUtils.unknownIfNull(returnType);
            this.parameterTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])parameterTypes);
            this.thrownExceptions = (JavaType[])ListUtils.nullIfEmpty((Object[])thrownExceptions);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.declaredFormalTypeNames = (String[])ListUtils.nullIfEmpty((Object[])this.declaredFormalTypeNames);
            return this;
        }

        public boolean isConstructor() {
            return "<constructor>".equals(this.name);
        }

        public @Nullable String getConstructorName() {
            if (!this.isConstructor()) {
                return null;
            }
            String className = ((Class)this.getReturnType()).getClassName();
            int beginIndex = className.lastIndexOf(".");
            return beginIndex == -1 ? className : className.substring(beginIndex + 1);
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public @Nullable Method getOverride() {
            if (this.declaringType instanceof Unknown) {
                return null;
            }
            Stack<FullyQualified> interfaces = new Stack<FullyQualified>();
            interfaces.addAll(this.declaringType.getInterfaces());
            while (!interfaces.isEmpty()) {
                FullyQualified declaring = (FullyQualified)interfaces.pop();
                interfaces.addAll(declaring.getInterfaces());
                block1: for (Method method : declaring.getMethods()) {
                    if (!method.getName().equals(this.name)) continue;
                    List<JavaType> params = method.getParameterTypes();
                    if (this.getParameterTypes().size() != method.getParameterTypes().size()) continue;
                    for (int i = 0; i < params.size(); ++i) {
                        JavaType param = params.get(i);
                        JavaType subtypeParam = this.getParameterTypes().get(i);
                        if (TypeUtils.isOfType(subtypeParam, param)) continue;
                        if (!(param instanceof GenericTypeVariable)) continue block1;
                        GenericTypeVariable genericParam = (GenericTypeVariable)param;
                        if (genericParam.getBounds().isEmpty()) continue;
                        for (JavaType bound : genericParam.getBounds()) {
                            if (TypeUtils.isAssignableTo(bound, subtypeParam)) continue;
                            continue block1;
                        }
                    }
                    return method;
                }
            }
            return null;
        }

        public boolean isOverride() {
            return this.getOverride() != null;
        }

        public boolean isInheritedFrom(String fullyQualifiedTypeName) {
            if (this.declaringType instanceof Unknown) {
                return false;
            }
            Stack<FullyQualified> interfaces = new Stack<FullyQualified>();
            interfaces.addAll(this.declaringType.getInterfaces());
            while (!interfaces.isEmpty()) {
                FullyQualified declaring = (FullyQualified)interfaces.pop();
                interfaces.addAll(declaring.getInterfaces());
                if (declaring.getFullyQualifiedName().equals(fullyQualifiedTypeName)) continue;
                block1: for (Method method : declaring.getMethods()) {
                    if (!method.getName().equals(this.name)) continue;
                    List<JavaType> params = method.getParameterTypes();
                    if (this.getParameterTypes().size() != method.getParameterTypes().size()) continue;
                    for (int i = 0; i < params.size(); ++i) {
                        if (!TypeUtils.isOfType(this.getParameterTypes().get(i), params.get(i))) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        public List<String> getParameterNames() {
            return this.parameterNames == null ? Collections.emptyList() : Arrays.asList(this.parameterNames);
        }

        public List<String> getDeclaredFormalTypeNames() {
            return this.declaredFormalTypeNames == null ? Collections.emptyList() : Arrays.asList(this.declaredFormalTypeNames);
        }

        public Method withParameterNames(@Nullable List<String> parameterNames) {
            Object[] parameterNamesArray = (String[])ListUtils.arrayOrNullIfEmpty(parameterNames, (Object[])EMPTY_STRING_ARRAY);
            if (Arrays.equals(parameterNamesArray, this.parameterNames)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, (String[])parameterNamesArray, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        public List<JavaType> getParameterTypes() {
            return this.parameterTypes == null ? Collections.emptyList() : Arrays.asList(this.parameterTypes);
        }

        public Method withParameterTypes(@Nullable List<JavaType> parameterTypes) {
            Object[] parameterTypesArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(parameterTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(parameterTypesArray, this.parameterTypes)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, (JavaType[])parameterTypesArray, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        public List<JavaType> getThrownExceptions() {
            return this.thrownExceptions == null ? Collections.emptyList() : Arrays.asList(this.thrownExceptions);
        }

        public Method withThrownExceptions(@Nullable List<JavaType> thrownExceptions) {
            Object[] thrownExceptionsArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(thrownExceptions, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(thrownExceptionsArray, this.thrownExceptions)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, (JavaType[])thrownExceptionsArray, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Method withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, (FullyQualified[])annotationsArray, this.defaultValue, this.declaredFormalTypeNames);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Method withFlags(Set<Flag> flags) {
            return this.withFlagsBitMap(Flag.flagsToBitMap(flags));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            return Objects.equals(this.declaringType, method.declaringType) && this.name.equals(method.name) && Objects.equals(this.returnType, method.returnType) && Arrays.equals(this.parameterTypes, method.parameterTypes);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().methodSignature(this);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }

        @Generated
        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public JavaType getReturnType() {
            return this.returnType;
        }

        @Generated
        public @Nullable List<String> getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        @NonNull
        @Generated
        public Method withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Method(managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        @NonNull
        @Generated
        private Method withFlagsBitMap(long flagsBitMap) {
            return this.flagsBitMap == flagsBitMap ? this : new Method(this.managedReference, flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        @NonNull
        @Generated
        public Method withDeclaringType(FullyQualified declaringType) {
            return this.declaringType == declaringType ? this : new Method(this.managedReference, this.flagsBitMap, declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        @NonNull
        @Generated
        public Method withName(String name) {
            return this.name == name ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        @NonNull
        @Generated
        public Method withReturnType(JavaType returnType) {
            return this.returnType == returnType ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, this.declaredFormalTypeNames);
        }

        @NonNull
        @Generated
        public Method withDeclaredFormalTypeNames(String @Nullable [] declaredFormalTypeNames) {
            return this.declaredFormalTypeNames == declaredFormalTypeNames ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations, this.defaultValue, declaredFormalTypeNames);
        }
    }

    public static class Annotation
    extends FullyQualified {
        private final FullyQualified type;
        private final ElementValue @Nullable [] values;

        public Annotation(FullyQualified type, List<ElementValue> values) {
            this(type, (ElementValue[])ListUtils.arrayOrNullIfEmpty(values, (Object[])EMPTY_ANNOTATION_VALUE_ARRAY));
        }

        @JsonCreator
        Annotation(FullyQualified type, ElementValue @Nullable [] values) {
            this.type = type;
            this.values = (ElementValue[])ListUtils.nullIfEmpty((Object[])values);
        }

        public List<ElementValue> getValues() {
            return this.values == null ? Collections.emptyList() : Arrays.asList(this.values);
        }

        public Annotation withValues(@Nullable List<ElementValue> values) {
            Object[] valuesArray = (ElementValue[])ListUtils.arrayOrNullIfEmpty(values, (Object[])EMPTY_ANNOTATION_VALUE_ARRAY);
            if (Arrays.equals(valuesArray, this.values)) {
                return this;
            }
            return new Annotation(this.type, (ElementValue[])valuesArray);
        }

        @Override
        public String getFullyQualifiedName() {
            return this.type.getFullyQualifiedName();
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            return this.withType(this.type.withFullyQualifiedName(fullyQualifiedName));
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.type.getAnnotations();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return this.type.hasFlags(test);
        }

        @Override
        public Set<Flag> getFlags() {
            return this.type.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.type.getInterfaces();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return this.type.getKind();
        }

        @Override
        public List<Variable> getMembers() {
            return this.type.getMembers();
        }

        @Override
        public List<Method> getMethods() {
            return this.type.getMethods();
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return this.type.getTypeParameters();
        }

        @Override
        public @Nullable FullyQualified getOwningClass() {
            return this.type.getOwningClass();
        }

        @Override
        public @Nullable FullyQualified getSupertype() {
            return this.type.getSupertype();
        }

        @Generated
        public FullyQualified getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public Annotation withType(FullyQualified type) {
            return this.type == type ? this : new Annotation(type, this.values);
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c", include=JsonTypeInfo.As.PROPERTY)
        public static interface ElementValue {
            public JavaType getElement();

            public Object getValue();
        }

        public static final class ArrayElementValue
        implements ElementValue {
            private final JavaType element;
            private final Object @Nullable [] constantValues;
            private final JavaType @Nullable [] referenceValues;

            public static ArrayElementValue from(JavaType element, Object[] values) {
                if (values.length > 0 && values[0] instanceof JavaType) {
                    return new ArrayElementValue(element, null, (JavaType[])values);
                }
                return new ArrayElementValue(element, values, null);
            }

            @Override
            public Object getValue() {
                return this.getValues();
            }

            public List<?> getValues() {
                return Arrays.asList(this.constantValues != null ? this.constantValues : this.referenceValues);
            }

            @Generated
            public ArrayElementValue(JavaType element, Object @Nullable [] constantValues, JavaType @Nullable [] referenceValues) {
                this.element = element;
                this.constantValues = constantValues;
                this.referenceValues = referenceValues;
            }

            @Override
            @Generated
            public JavaType getElement() {
                return this.element;
            }

            @Generated
            public Object @Nullable [] getConstantValues() {
                return this.constantValues;
            }

            @Generated
            public JavaType @Nullable [] getReferenceValues() {
                return this.referenceValues;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ArrayElementValue)) {
                    return false;
                }
                ArrayElementValue other = (ArrayElementValue)o;
                JavaType this$element = this.getElement();
                JavaType other$element = other.getElement();
                if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                    return false;
                }
                if (!Arrays.deepEquals(this.getConstantValues(), other.getConstantValues())) {
                    return false;
                }
                return Arrays.deepEquals(this.getReferenceValues(), other.getReferenceValues());
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaType $element = this.getElement();
                result = result * 59 + ($element == null ? 43 : $element.hashCode());
                result = result * 59 + Arrays.deepHashCode(this.getConstantValues());
                result = result * 59 + Arrays.deepHashCode(this.getReferenceValues());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "JavaType.Annotation.ArrayElementValue(element=" + this.getElement() + ", constantValues=" + Arrays.deepToString(this.getConstantValues()) + ", referenceValues=" + Arrays.deepToString(this.getReferenceValues()) + ")";
            }
        }

        public static final class SingleElementValue
        implements ElementValue {
            private final JavaType element;
            private final @Nullable Object constantValue;
            private final @Nullable JavaType referenceValue;

            public static SingleElementValue from(JavaType element, Object value) {
                if (value instanceof JavaType) {
                    return new SingleElementValue(element, null, (JavaType)value);
                }
                return new SingleElementValue(element, value, null);
            }

            @Override
            public Object getValue() {
                return this.constantValue != null ? this.constantValue : this.referenceValue;
            }

            @Generated
            public SingleElementValue(JavaType element, @Nullable Object constantValue, @Nullable JavaType referenceValue) {
                this.element = element;
                this.constantValue = constantValue;
                this.referenceValue = referenceValue;
            }

            @Override
            @Generated
            public JavaType getElement() {
                return this.element;
            }

            @Generated
            public @Nullable Object getConstantValue() {
                return this.constantValue;
            }

            @Generated
            public @Nullable JavaType getReferenceValue() {
                return this.referenceValue;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SingleElementValue)) {
                    return false;
                }
                SingleElementValue other = (SingleElementValue)o;
                JavaType this$element = this.getElement();
                JavaType other$element = other.getElement();
                if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                    return false;
                }
                Object this$constantValue = this.getConstantValue();
                Object other$constantValue = other.getConstantValue();
                if (this$constantValue == null ? other$constantValue != null : !this$constantValue.equals(other$constantValue)) {
                    return false;
                }
                JavaType this$referenceValue = this.getReferenceValue();
                JavaType other$referenceValue = other.getReferenceValue();
                return !(this$referenceValue == null ? other$referenceValue != null : !this$referenceValue.equals(other$referenceValue));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaType $element = this.getElement();
                result = result * 59 + ($element == null ? 43 : $element.hashCode());
                Object $constantValue = this.getConstantValue();
                result = result * 59 + ($constantValue == null ? 43 : $constantValue.hashCode());
                JavaType $referenceValue = this.getReferenceValue();
                result = result * 59 + ($referenceValue == null ? 43 : $referenceValue.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "JavaType.Annotation.SingleElementValue(element=" + this.getElement() + ", constantValue=" + this.getConstantValue() + ", referenceValue=" + this.getReferenceValue() + ")";
            }
        }
    }

    public static final class Unknown
    extends FullyQualified {
        private static final Unknown INSTANCE = new Unknown();

        private Unknown() {
        }

        @JsonCreator
        public static Unknown getInstance() {
            return INSTANCE;
        }

        @Override
        public String getFullyQualifiedName() {
            return "<unknown>";
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            return this;
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return false;
        }

        @Override
        public Set<Flag> getFlags() {
            return Collections.emptySet();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return Collections.emptyList();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return FullyQualified.Kind.Class;
        }

        @Override
        public List<Variable> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public List<Method> getMethods() {
            return Collections.emptyList();
        }

        @Override
        public @Nullable FullyQualified getOwningClass() {
            return null;
        }

        @Override
        public @Nullable FullyQualified getSupertype() {
            return null;
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return Collections.emptyList();
        }

        public String toString() {
            return "Unknown";
        }

        @Override
        public boolean isAssignableFrom(Pattern pattern) {
            return false;
        }

        @Override
        public boolean isAssignableFrom(@Nullable JavaType type) {
            return false;
        }

        @Override
        public boolean isAssignableTo(String fullyQualifiedName) {
            return false;
        }
    }

    public static class Array
    implements JavaType {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private JavaType elemType;
        private FullyQualified @Nullable [] annotations;

        public Array(@Nullable Integer managedReference, @Nullable JavaType elemType, FullyQualified @Nullable [] annotations) {
            this.managedReference = managedReference;
            this.elemType = TypeUtils.unknownIfNull(elemType);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
        }

        @JsonCreator
        Array() {
        }

        public JavaType getElemType() {
            return this.elemType;
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Array withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Array(this.managedReference, this.elemType, (FullyQualified[])annotationsArray);
        }

        @Override
        public Array unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Array unsafeSet(JavaType elemType, FullyQualified @Nullable [] annotations) {
            this.elemType = TypeUtils.unknownIfNull(elemType);
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            return Objects.equals(this.elemType, array.elemType);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @NonNull
        @Generated
        public Array withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Array(managedReference, this.elemType, this.annotations);
        }

        @NonNull
        @Generated
        public Array withElemType(JavaType elemType) {
            return this.elemType == elemType ? this : new Array(this.managedReference, elemType, this.annotations);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }
    }

    public static class Parameterized
    extends FullyQualified {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private FullyQualified type;
        private JavaType @Nullable [] typeParameters;

        public Parameterized(@Nullable Integer managedReference, @Nullable FullyQualified type, @Nullable List<JavaType> typeParameters) {
            this(managedReference, type, (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY));
        }

        Parameterized(@Nullable Integer managedReference, @Nullable FullyQualified type, JavaType @Nullable [] typeParameters) {
            this.managedReference = managedReference;
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
        }

        @JsonCreator
        Parameterized() {
        }

        public FullyQualified getType() {
            return this.type;
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return this.typeParameters == null ? Collections.emptyList() : Arrays.asList(this.typeParameters);
        }

        public Parameterized withTypeParameters(@Nullable List<JavaType> typeParameters) {
            Object[] typeParametersArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(typeParametersArray, this.typeParameters)) {
                return this;
            }
            return new Parameterized(this.managedReference, this.type, (JavaType[])typeParametersArray);
        }

        @Override
        public Parameterized unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Parameterized unsafeSet(@Nullable FullyQualified type, @Nullable List<JavaType> typeParameters) {
            assert (type != this);
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public Parameterized unsafeSet(@Nullable FullyQualified type, JavaType @Nullable [] typeParameters) {
            assert (type != this);
            this.type = TypeUtils.unknownIfNull(type);
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            return this;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.type.getFullyQualifiedName();
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            FullyQualified qualified = this.type.withFullyQualifiedName(fullyQualifiedName);
            if (this.type == qualified) {
                return this;
            }
            return new Parameterized(this.managedReference, qualified, this.typeParameters);
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.type.getAnnotations();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return this.type.hasFlags(test);
        }

        @Override
        public Set<Flag> getFlags() {
            return this.type.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.type.getInterfaces();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return this.type.getKind();
        }

        @Override
        public List<Variable> getMembers() {
            return this.type.getMembers();
        }

        @Override
        public List<Method> getMethods() {
            return this.type.getMethods();
        }

        @Override
        public @Nullable FullyQualified getOwningClass() {
            return this.type.getOwningClass();
        }

        @Override
        public FullyQualified getSupertype() {
            return this.type.getSupertype();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameterized that = (Parameterized)o;
            return Objects.equals(this.type, that.type) && Arrays.equals(this.typeParameters, that.typeParameters);
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }

        @Override
        @NonNull
        @Generated
        public Parameterized withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Parameterized(managedReference, this.type, this.typeParameters);
        }

        @NonNull
        @Generated
        public Parameterized withType(FullyQualified type) {
            return this.type == type ? this : new Parameterized(this.managedReference, type, this.typeParameters);
        }
    }

    public static class Class
    extends FullyQualified {
        @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
        private @Nullable Integer managedReference;
        private long flagsBitMap;
        private String fullyQualifiedName;
        private FullyQualified.Kind kind;
        private JavaType @Nullable [] typeParameters;
        private @Nullable FullyQualified supertype;
        private @Nullable FullyQualified owningClass;
        private FullyQualified @Nullable [] annotations;
        private FullyQualified @Nullable [] interfaces;
        private Variable @Nullable [] members;
        private Method @Nullable [] methods;

        public Class(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this(managedReference, flagsBitMap, fullyQualifiedName, kind, (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY), supertype, owningClass, (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY), (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY), (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY));
        }

        Class(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, JavaType @Nullable [] typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, FullyQualified @Nullable [] annotations, FullyQualified @Nullable [] interfaces, Variable @Nullable [] members, Method @Nullable [] methods) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_CLASS_FLAGS;
            this.fullyQualifiedName = fullyQualifiedName;
            this.kind = kind;
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.interfaces = (FullyQualified[])ListUtils.nullIfEmpty((Object[])interfaces);
            this.members = (Variable[])ListUtils.nullIfEmpty((Object[])members);
            this.methods = (Method[])ListUtils.nullIfEmpty((Object[])methods);
        }

        @JsonCreator
        Class() {
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
        }

        public Class withAnnotations(@Nullable List<FullyQualified> annotations) {
            Object[] annotationsArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(annotationsArray, this.annotations)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, (FullyQualified[])annotationsArray, this.interfaces, this.members, this.methods);
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.interfaces == null ? Collections.emptyList() : Arrays.asList(this.interfaces);
        }

        public Class withInterfaces(@Nullable List<FullyQualified> interfaces) {
            Object[] interfacesArray = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            if (Arrays.equals(interfacesArray, this.interfaces)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, (FullyQualified[])interfacesArray, this.members, this.methods);
        }

        @Override
        public List<Variable> getMembers() {
            return this.members == null ? Collections.emptyList() : Arrays.asList(this.members);
        }

        public Class withMembers(@Nullable List<Variable> members) {
            Object[] membersArray = (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY);
            if (Arrays.equals(membersArray, this.members)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, (Variable[])membersArray, this.methods);
        }

        @Override
        public List<Method> getMethods() {
            return this.methods == null ? Collections.emptyList() : Arrays.asList(this.methods);
        }

        public Class withMethods(@Nullable List<Method> methods) {
            Object[] methodsArray = (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY);
            if (Arrays.equals(methodsArray, this.methods)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, (Method[])methodsArray);
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        @Override
        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public JavaType withFlags(Set<Flag> flags) {
            long flagsBitMap = Flag.flagsToBitMap(flags);
            if (flagsBitMap == this.flagsBitMap) {
                return this;
            }
            return new Class(this.managedReference, flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        public List<JavaType> getTypeParameters() {
            return this.typeParameters == null ? Collections.emptyList() : Arrays.asList(this.typeParameters);
        }

        public Class withTypeParameters(@Nullable List<JavaType> typeParameters) {
            Object[] typeParametersArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(typeParametersArray, this.typeParameters)) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, (JavaType[])typeParametersArray, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        public boolean isParameterized() {
            return this.typeParameters != null && this.typeParameters.length > 0;
        }

        @Override
        public Class unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Class unsafeSet(@Nullable List<JavaType> typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this.typeParameters = (JavaType[])ListUtils.arrayOrNullIfEmpty(typeParameters, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(annotations, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            this.interfaces = (FullyQualified[])ListUtils.arrayOrNullIfEmpty(interfaces, (Object[])EMPTY_FULLY_QUALIFIED_ARRAY);
            this.members = (Variable[])ListUtils.arrayOrNullIfEmpty(members, (Object[])EMPTY_VARIABLE_ARRAY);
            this.methods = (Method[])ListUtils.arrayOrNullIfEmpty(methods, (Object[])EMPTY_METHOD_ARRAY);
            return this;
        }

        public Class unsafeSet(JavaType @Nullable [] typeParameters, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, FullyQualified @Nullable [] annotations, FullyQualified @Nullable [] interfaces, Variable @Nullable [] members, Method @Nullable [] methods) {
            this.typeParameters = (JavaType[])ListUtils.nullIfEmpty((Object[])typeParameters);
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = (FullyQualified[])ListUtils.nullIfEmpty((Object[])annotations);
            this.interfaces = (FullyQualified[])ListUtils.nullIfEmpty((Object[])interfaces);
            this.members = (Variable[])ListUtils.nullIfEmpty((Object[])members);
            this.methods = (Method[])ListUtils.nullIfEmpty((Object[])methods);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Class aClass = (Class)o;
            return TypeUtils.fullyQualifiedNamesAreEqual(this.fullyQualifiedName, aClass.fullyQualifiedName) && (this.typeParameters == null && aClass.typeParameters == null || this.typeParameters != null && Arrays.equals(this.typeParameters, aClass.typeParameters));
        }

        public String toString() {
            return new DefaultJavaTypeSignatureBuilder().signature(this);
        }

        @Override
        @Generated
        public @Nullable Integer getManagedReference() {
            return this.managedReference;
        }

        @Generated
        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        @Override
        @Generated
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        @Generated
        public FullyQualified.Kind getKind() {
            return this.kind;
        }

        @Override
        @Generated
        public @Nullable FullyQualified getSupertype() {
            return this.supertype;
        }

        @Override
        @Generated
        public @Nullable FullyQualified getOwningClass() {
            return this.owningClass;
        }

        @Override
        @NonNull
        @Generated
        public Class withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Class(managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        @NonNull
        @Generated
        public Class withFullyQualifiedName(String fullyQualifiedName) {
            return this.fullyQualifiedName == fullyQualifiedName ? this : new Class(this.managedReference, this.flagsBitMap, fullyQualifiedName, this.kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        @Generated
        public Class withKind(FullyQualified.Kind kind) {
            return this.kind == kind ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, kind, this.typeParameters, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        @Generated
        public Class withSupertype(@Nullable FullyQualified supertype) {
            return this.supertype == supertype ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        @Generated
        public Class withOwningClass(@Nullable FullyQualified owningClass) {
            return this.owningClass == owningClass ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.typeParameters, this.supertype, owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }
    }

    public static class Intersection
    implements JavaType {
        private JavaType @Nullable [] bounds;

        public Intersection(@Nullable List<JavaType> bounds) {
            this.bounds = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
        }

        Intersection(JavaType @Nullable [] throwableTypes) {
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])throwableTypes);
        }

        @JsonCreator
        Intersection() {
        }

        public List<JavaType> getBounds() {
            if (this.bounds == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.bounds);
        }

        public Intersection withBounds(@Nullable List<JavaType> bounds) {
            Object[] boundsArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(boundsArray, this.bounds)) {
                return this;
            }
            return new Intersection((JavaType[])boundsArray);
        }

        public Intersection unsafeSet(List<JavaType> bounds) {
            this.bounds = (JavaType[])ListUtils.arrayOrNullIfEmpty(bounds, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public Intersection unsafeSet(JavaType[] bounds) {
            this.bounds = (JavaType[])ListUtils.nullIfEmpty((Object[])bounds);
            return this;
        }
    }

    public static class MultiCatch
    implements JavaType {
        private JavaType @Nullable [] throwableTypes;

        public MultiCatch(@Nullable List<JavaType> throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
        }

        MultiCatch(JavaType @Nullable [] throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])throwableTypes);
        }

        @JsonCreator
        MultiCatch() {
        }

        public List<JavaType> getThrowableTypes() {
            if (this.throwableTypes == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(this.throwableTypes);
        }

        public MultiCatch withThrowableTypes(@Nullable List<JavaType> throwableTypes) {
            Object[] throwableTypesArray = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            if (Arrays.equals(throwableTypesArray, this.throwableTypes)) {
                return this;
            }
            return new MultiCatch((JavaType[])throwableTypesArray);
        }

        public MultiCatch unsafeSet(List<JavaType> throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.arrayOrNullIfEmpty(throwableTypes, (Object[])EMPTY_JAVA_TYPE_ARRAY);
            return this;
        }

        public MultiCatch unsafeSet(JavaType[] throwableTypes) {
            this.throwableTypes = (JavaType[])ListUtils.nullIfEmpty((Object[])throwableTypes);
            return this;
        }
    }
}

