/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.regexp;

import java.io.File;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.AbstractFileSetCheck;
import org.openrewrite.tools.checkstyle.api.FileText;
import org.openrewrite.tools.checkstyle.checks.regexp.DetectorOptions;
import org.openrewrite.tools.checkstyle.checks.regexp.MultilineDetector;

@StatelessCheck
public class RegexpMultilineCheck
extends AbstractFileSetCheck {
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String format = "$.";
    private String message;
    private int minimum;
    private int maximum;
    private boolean ignoreCase;
    private boolean matchAcrossLines;
    private MultilineDetector detector;

    @Override
    public void beginProcessing(String charset) {
        DetectorOptions options = DetectorOptions.newBuilder().reporter(this).compileFlags(this.getRegexCompileFlags()).format(this.format).message(this.message).minimum(this.minimum).maximum(this.maximum).ignoreCase(this.ignoreCase).build();
        this.detector = new MultilineDetector(options);
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        this.detector.processLines(fileText);
    }

    private int getRegexCompileFlags() {
        int result = this.matchAcrossLines ? 32 : 8;
        return result;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setMatchAcrossLines(boolean matchAcrossLines) {
        this.matchAcrossLines = matchAcrossLines;
    }
}

