/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.meta;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.tools.checkstyle.Checker;
import org.openrewrite.tools.checkstyle.DefaultConfiguration;
import org.openrewrite.tools.checkstyle.TreeWalker;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.meta.JavadocMetadataScraper;

public final class MetadataGeneratorUtil {
    private MetadataGeneratorUtil() {
    }

    public static void generate(String path, String ... moduleFolders) throws IOException, CheckstyleException {
        JavadocMetadataScraper.resetModuleDetailsStore();
        Checker checker = new Checker();
        checker.setModuleClassLoader(Checker.class.getClassLoader());
        DefaultConfiguration scraperCheckConfig = new DefaultConfiguration(JavadocMetadataScraper.class.getName());
        DefaultConfiguration defaultConfiguration = new DefaultConfiguration("configuration");
        DefaultConfiguration treeWalkerConfig = new DefaultConfiguration(TreeWalker.class.getName());
        defaultConfiguration.addProperty("charset", StandardCharsets.UTF_8.name());
        defaultConfiguration.addChild(treeWalkerConfig);
        treeWalkerConfig.addChild(scraperCheckConfig);
        checker.configure(defaultConfiguration);
        MetadataGeneratorUtil.dumpMetadata(checker, path, moduleFolders);
    }

    private static void dumpMetadata(Checker checker, String path, String ... moduleFolders) throws CheckstyleException, IOException {
        ArrayList<File> validFiles = new ArrayList<File>();
        for (String folder : moduleFolders) {
            try (Stream<Path> files = Files.walk(Paths.get(path + "/" + folder, new String[0]), new FileVisitOption[0]);){
                validFiles.addAll(files.map(Path::toFile).filter(file -> file.getName().endsWith("SuppressWarningsHolder.java") || file.getName().endsWith("Check.java") || file.getName().endsWith("Filter.java")).collect(Collectors.toList()));
            }
        }
        checker.process(validFiles);
    }
}

