/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.CheckClassAdapter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParserExecutionContextView;
import org.openrewrite.java.internal.parser.JavaParserCaller;
import org.openrewrite.java.internal.parser.JavaParserClasspathLoader;

@Incubating(since="8.44.0")
public final class TypeTable
implements JavaParserClasspathLoader {
    public static final String VERIFY_CLASS_WRITING = "org.openrewrite.java.TypeTableClassWritingVerification";
    public static final String DEFAULT_RESOURCE_PATH = "META-INF/rewrite/classpath.tsv.zip";
    private static final Map<GroupArtifactVersion, Path> classesDirByArtifact = new LinkedHashMap<GroupArtifactVersion, Path>();

    public static @Nullable TypeTable fromClasspath(ExecutionContext ctx, Collection<String> artifactNames) {
        TypeTable typeTable;
        block8: {
            InputStream is = JavaParserCaller.findCaller().getClassLoader().getResourceAsStream(DEFAULT_RESOURCE_PATH);
            try {
                TypeTable typeTable2 = typeTable = is == null ? null : new TypeTable(ctx, is, artifactNames);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return typeTable;
    }

    public TypeTable(ExecutionContext ctx, InputStream is, Collection<String> artifactNames) {
        try (InflaterInputStream inflate = new InflaterInputStream(is);){
            new Reader(ctx).read(inflate, TypeTable.artifactsNotYetWritten(artifactNames));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Collection<String> artifactsNotYetWritten(Collection<String> artifactNames) {
        ArrayList<String> notWritten = new ArrayList<String>(artifactNames);
        for (String artifactName : artifactNames) {
            for (GroupArtifactVersion groupArtifactVersion : classesDirByArtifact.keySet()) {
                if (!Pattern.compile(artifactName + ".*").matcher(groupArtifactVersion.getArtifactId() + "-" + groupArtifactVersion.getVersion()).matches()) continue;
                notWritten.remove(artifactName);
            }
        }
        return notWritten;
    }

    private static Path getClassesDir(ExecutionContext ctx, GroupArtifactVersion gav) {
        Path jarsFolder = JavaParserExecutionContextView.view(ctx).getParserClasspathDownloadTarget().toPath().resolve(".tt");
        if (!Files.exists(jarsFolder, new LinkOption[0]) && !jarsFolder.toFile().mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + jarsFolder));
        }
        Path classesDir = jarsFolder;
        for (String g : gav.getGroupId().split("\\.")) {
            classesDir = classesDir.resolve(g);
        }
        if (!Files.exists(classesDir = classesDir.resolve(gav.getArtifactId()).resolve(gav.getVersion()), new LinkOption[0]) && !classesDir.toFile().mkdirs()) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir));
        }
        return classesDir;
    }

    public static Writer newWriter(OutputStream out) {
        return new Writer(out);
    }

    @Override
    public @Nullable Path load(String artifactName) {
        for (Map.Entry<GroupArtifactVersion, Path> gavAndClassesDir : classesDirByArtifact.entrySet()) {
            GroupArtifactVersion gav = gavAndClassesDir.getKey();
            if (!Pattern.compile(artifactName + ".*").matcher(gav.getArtifactId() + "-" + gav.getVersion()).matches()) continue;
            return gavAndClassesDir.getValue();
        }
        return null;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TypeTable;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public String toString() {
        return "TypeTable()";
    }

    private static final class GroupArtifactVersion {
        private final String groupId;
        private final String artifactId;
        private final String version;

        @Generated
        public GroupArtifactVersion(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupArtifactVersion)) {
                return false;
            }
            GroupArtifactVersion other = (GroupArtifactVersion)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.GroupArtifactVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    static class Reader {
        private final ExecutionContext ctx;
        private @Nullable GroupArtifactVersion gav;
        private final Map<ClassDefinition, List<Member>> membersByClassName = new HashMap<ClassDefinition, List<Member>>();

        public void read(InputStream is, Collection<String> artifactNames) throws IOException {
            Set artifactNamePatterns = artifactNames.stream().map(name -> Pattern.compile(name + ".*")).collect(Collectors.toSet());
            try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
                in.lines().skip(1L).forEach(line -> {
                    String[] fields = line.split("\t", -1);
                    GroupArtifactVersion rowGav = new GroupArtifactVersion(fields[0], fields[1], fields[2]);
                    if (!rowGav.equals(this.gav)) {
                        this.writeClassesDir();
                    }
                    String artifactVersion = fields[1] + "-" + fields[2];
                    for (Pattern artifactNamePattern : artifactNamePatterns) {
                        if (!artifactNamePattern.matcher(artifactVersion).matches()) continue;
                        this.gav = rowGav;
                        break;
                    }
                    if (this.gav != null) {
                        Member member = new Member(new ClassDefinition(Integer.parseInt(fields[3]), fields[4], fields[5].isEmpty() ? null : fields[5], fields[6].isEmpty() ? null : fields[6], fields[7].isEmpty() ? null : fields[7].split("\\|")), Integer.parseInt(fields[8]), fields[9], fields[10], fields[11].isEmpty() ? null : fields[11], fields[12].isEmpty() ? null : fields[12].split("\\|"));
                        this.membersByClassName.computeIfAbsent(member.getClassDefinition(), cd -> new ArrayList()).add(member);
                    }
                });
            }
            this.writeClassesDir();
        }

        private void writeClassesDir() {
            if (this.gav == null) {
                return;
            }
            Path classesDir = TypeTable.getClassesDir(this.ctx, this.gav);
            classesDirByArtifact.put(this.gav, classesDir);
            this.membersByClassName.forEach((classDef, members) -> {
                Path classFile = classesDir.resolve(classDef.getName() + ".class");
                if (!Files.exists(classFile.getParent(), new LinkOption[0]) && !classFile.getParent().toFile().mkdirs()) {
                    throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir.getParent()));
                }
                ClassWriter cw = new ClassWriter(0);
                ClassWriter classWriter = (Boolean)this.ctx.getMessage(TypeTable.VERIFY_CLASS_WRITING, (Object)false) != false ? new CheckClassAdapter((ClassVisitor)cw) : cw;
                classWriter.visit(52, classDef.getAccess(), classDef.getName(), classDef.getSignature(), classDef.getSuperclassSignature(), classDef.getSuperinterfaceSignatures());
                HashSet<ClassDefinition> innerClasses = new HashSet<ClassDefinition>();
                for (ClassDefinition innerClassDef : this.membersByClassName.keySet()) {
                    if (!innerClassDef.getName().contains("$")) continue;
                    innerClasses.add(innerClassDef);
                }
                for (ClassDefinition innerClass : innerClasses) {
                    int lastIndexOf$ = innerClass.getName().lastIndexOf(36);
                    classWriter.visitInnerClass(innerClass.getName(), innerClass.getName().substring(0, lastIndexOf$), innerClass.getName().substring(lastIndexOf$ + 1), innerClass.getAccess() & 0x761F);
                }
                for (Member member : members) {
                    if (member.getDescriptor().contains("(")) {
                        classWriter.visitMethod(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), member.getExceptions()).visitEnd();
                        continue;
                    }
                    classWriter.visitField(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), null).visitEnd();
                }
                try {
                    Files.write(classFile, cw.toByteArray(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.gav = null;
        }

        @Generated
        public Reader(ExecutionContext ctx) {
            this.ctx = ctx;
        }
    }

    public static class Writer
    implements AutoCloseable {
        private final PrintStream out;
        private final DeflaterOutputStream deflater;

        public Writer(OutputStream out) {
            this.deflater = new DeflaterOutputStream(out);
            this.out = new PrintStream(this.deflater);
            this.out.println("groupId\tartifactId\tversion\tclassAccess\tclassName\tclassSignature\tclassSuperclassSignature\tclassSuperinterfaceSignatures\taccess\tname\tdescriptor\tsignature\tparameterNames\texceptions");
        }

        public Jar jar(String groupId, String artifactId, String version) {
            return new Jar(groupId, artifactId, version);
        }

        @Override
        public void close() throws IOException {
            this.deflater.flush();
            this.out.close();
        }

        public final class Jar {
            private final String groupId;
            private final String artifactId;
            private final String version;

            public void write(Path jar) {
                try (JarFile jarFile = new JarFile(jar.toFile());){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        try {
                            new ClassReader(inputStream).accept(new ClassVisitor(589824){
                                @Nullable ClassDefinition classDefinition;

                                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                    this.classDefinition = Jar.this.classDefinition(access, name, signature, superName, interfaces);
                                    super.visit(version, access, name, signature, superName, interfaces);
                                }

                                public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                                    Objects.requireNonNull(this.classDefinition).writeField(access, name, descriptor, signature);
                                    return super.visitField(access, name, descriptor, signature, value);
                                }

                                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                                    Objects.requireNonNull(this.classDefinition).writeMethod(access, name, descriptor, signature, null, exceptions);
                                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                                }
                            }, 1);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public ClassDefinition classDefinition(int access, String name, @Nullable String signature, String superclassName, String @Nullable [] superinterfaceSignatures) {
                return new ClassDefinition(this, access, name, signature, superclassName, superinterfaceSignatures);
            }

            @Generated
            public Jar(String groupId, String artifactId, String version) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
            }

            @Generated
            public String getGroupId() {
                return this.groupId;
            }

            @Generated
            public String getArtifactId() {
                return this.artifactId;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jar)) {
                    return false;
                }
                Jar other = (Jar)o;
                String this$groupId = this.getGroupId();
                String other$groupId = other.getGroupId();
                if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                    return false;
                }
                String this$artifactId = this.getArtifactId();
                String other$artifactId = other.getArtifactId();
                if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $groupId = this.getGroupId();
                result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
                String $artifactId = this.getArtifactId();
                result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.Jar(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
            }
        }

        public final class ClassDefinition {
            private final Jar jar;
            private final int classAccess;
            private final String className;
            private final @Nullable String classSignature;
            private final String classSuperclassName;
            private final String @Nullable [] classSuperinterfaceSignatures;

            public void writeMethod(int access, String name, String descriptor, @Nullable String signature, String @Nullable [] parameterNames, String @Nullable [] exceptions) {
                if ((0x1002 & access) == 0) {
                    Writer.this.out.printf("%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s%n", this.jar.groupId, this.jar.artifactId, this.jar.version, this.classAccess, this.className, this.classSignature == null ? "" : this.classSignature, this.classSuperclassName, this.classSuperinterfaceSignatures == null ? "" : String.join((CharSequence)"|", this.classSuperinterfaceSignatures), access, name, descriptor, signature == null ? "" : signature, parameterNames == null ? "" : String.join((CharSequence)"|", parameterNames), exceptions == null ? "" : String.join((CharSequence)"|", exceptions));
                }
            }

            public void writeField(int access, String name, String descriptor, @Nullable String signature) {
                if ((0x1002 & access) == 0) {
                    this.writeMethod(access, name, descriptor, signature, null, null);
                }
            }

            @Generated
            public ClassDefinition(Jar jar, int classAccess, @Nullable String className, String classSignature, @Nullable String classSuperclassName, String[] classSuperinterfaceSignatures) {
                this.jar = jar;
                this.classAccess = classAccess;
                this.className = className;
                this.classSignature = classSignature;
                this.classSuperclassName = classSuperclassName;
                this.classSuperinterfaceSignatures = classSuperinterfaceSignatures;
            }

            @Generated
            public Jar getJar() {
                return this.jar;
            }

            @Generated
            public int getClassAccess() {
                return this.classAccess;
            }

            @Generated
            public String getClassName() {
                return this.className;
            }

            @Generated
            public @Nullable String getClassSignature() {
                return this.classSignature;
            }

            @Generated
            public String getClassSuperclassName() {
                return this.classSuperclassName;
            }

            @Generated
            public String @Nullable [] getClassSuperinterfaceSignatures() {
                return this.classSuperinterfaceSignatures;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClassDefinition)) {
                    return false;
                }
                ClassDefinition other = (ClassDefinition)o;
                if (this.getClassAccess() != other.getClassAccess()) {
                    return false;
                }
                Jar this$jar = this.getJar();
                Jar other$jar = other.getJar();
                if (this$jar == null ? other$jar != null : !((Object)this$jar).equals(other$jar)) {
                    return false;
                }
                String this$className = this.getClassName();
                String other$className = other.getClassName();
                if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                    return false;
                }
                String this$classSignature = this.getClassSignature();
                String other$classSignature = other.getClassSignature();
                if (this$classSignature == null ? other$classSignature != null : !this$classSignature.equals(other$classSignature)) {
                    return false;
                }
                String this$classSuperclassName = this.getClassSuperclassName();
                String other$classSuperclassName = other.getClassSuperclassName();
                if (this$classSuperclassName == null ? other$classSuperclassName != null : !this$classSuperclassName.equals(other$classSuperclassName)) {
                    return false;
                }
                return Arrays.deepEquals(this.getClassSuperinterfaceSignatures(), other.getClassSuperinterfaceSignatures());
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getClassAccess();
                Jar $jar = this.getJar();
                result = result * 59 + ($jar == null ? 43 : ((Object)$jar).hashCode());
                String $className = this.getClassName();
                result = result * 59 + ($className == null ? 43 : $className.hashCode());
                String $classSignature = this.getClassSignature();
                result = result * 59 + ($classSignature == null ? 43 : $classSignature.hashCode());
                String $classSuperclassName = this.getClassSuperclassName();
                result = result * 59 + ($classSuperclassName == null ? 43 : $classSuperclassName.hashCode());
                result = result * 59 + Arrays.deepHashCode(this.getClassSuperinterfaceSignatures());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.ClassDefinition(jar=" + this.getJar() + ", classAccess=" + this.getClassAccess() + ", className=" + this.getClassName() + ", classSignature=" + this.getClassSignature() + ", classSuperclassName=" + this.getClassSuperclassName() + ", classSuperinterfaceSignatures=" + Arrays.deepToString(this.getClassSuperinterfaceSignatures()) + ")";
            }
        }
    }

    private static final class Member {
        private final ClassDefinition classDefinition;
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final String @Nullable [] exceptions;

        @Generated
        public Member(ClassDefinition classDefinition, int access, String name, String descriptor, @Nullable String signature, String @Nullable [] exceptions) {
            this.classDefinition = classDefinition;
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
        }

        @Generated
        public ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public String @Nullable [] getExceptions() {
            return this.exceptions;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            ClassDefinition this$classDefinition = this.getClassDefinition();
            ClassDefinition other$classDefinition = other.getClassDefinition();
            if (this$classDefinition == null ? other$classDefinition != null : !((Object)this$classDefinition).equals(other$classDefinition)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            return Arrays.deepEquals(this.getExceptions(), other.getExceptions());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            ClassDefinition $classDefinition = this.getClassDefinition();
            result = result * 59 + ($classDefinition == null ? 43 : ((Object)$classDefinition).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getExceptions());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.Member(classDefinition=" + this.getClassDefinition() + ", access=" + this.getAccess() + ", name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", signature=" + this.getSignature() + ", exceptions=" + Arrays.deepToString(this.getExceptions()) + ")";
        }
    }

    private static final class ClassDefinition {
        private final int access;
        private final String name;
        private final @Nullable String signature;
        private final @Nullable String superclassSignature;
        private final String @Nullable [] superinterfaceSignatures;

        @Generated
        public ClassDefinition(int access, String name, @Nullable String signature, @Nullable String superclassSignature, String @Nullable [] superinterfaceSignatures) {
            this.access = access;
            this.name = name;
            this.signature = signature;
            this.superclassSignature = superclassSignature;
            this.superinterfaceSignatures = superinterfaceSignatures;
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public @Nullable String getSuperclassSignature() {
            return this.superclassSignature;
        }

        @Generated
        public String @Nullable [] getSuperinterfaceSignatures() {
            return this.superinterfaceSignatures;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDefinition)) {
                return false;
            }
            ClassDefinition other = (ClassDefinition)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$superclassSignature = this.getSuperclassSignature();
            String other$superclassSignature = other.getSuperclassSignature();
            if (this$superclassSignature == null ? other$superclassSignature != null : !this$superclassSignature.equals(other$superclassSignature)) {
                return false;
            }
            return Arrays.deepEquals(this.getSuperinterfaceSignatures(), other.getSuperinterfaceSignatures());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $superclassSignature = this.getSuperclassSignature();
            result = result * 59 + ($superclassSignature == null ? 43 : $superclassSignature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getSuperinterfaceSignatures());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.ClassDefinition(access=" + this.getAccess() + ", name=" + this.getName() + ", signature=" + this.getSignature() + ", superclassSignature=" + this.getSuperclassSignature() + ", superinterfaceSignatures=" + Arrays.deepToString(this.getSuperinterfaceSignatures()) + ")";
        }
    }
}

