/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class MethodCalls
extends DataTable<Row> {
    public MethodCalls(Recipe recipe) {
        super(recipe, "Method calls", "The text of matching method invocations.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="The source file that the method call occurred in.")
        private final String sourceFile;
        @Column(displayName="Method call", description="The text of the method call.")
        private final String method;
        @Column(displayName="Class name", description="The class name of the method call.")
        private final String className;
        @Column(displayName="Method name", description="The method name of the method call.")
        private final String methodName;
        @Column(displayName="Argument types", description="The argument types of the method call.")
        private final String argumentTypes;

        @Generated
        public Row(String sourceFile, String method, String className, String methodName, String argumentTypes) {
            this.sourceFile = sourceFile;
            this.method = method;
            this.className = className;
            this.methodName = methodName;
            this.argumentTypes = argumentTypes;
        }

        @Generated
        public String getSourceFile() {
            return this.sourceFile;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Generated
        public String getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$argumentTypes = this.getArgumentTypes();
            String other$argumentTypes = other.getArgumentTypes();
            return !(this$argumentTypes == null ? other$argumentTypes != null : !this$argumentTypes.equals(other$argumentTypes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $argumentTypes = this.getArgumentTypes();
            result = result * 59 + ($argumentTypes == null ? 43 : $argumentTypes.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MethodCalls.Row(sourceFile=" + this.getSourceFile() + ", method=" + this.getMethod() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", argumentTypes=" + this.getArgumentTypes() + ")";
        }
    }
}

