/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RewriteTestClassesShouldNotBePublic
extends Recipe {
    public String getDisplayName() {
        return "RewriteTest classes should not be public";
    }

    public String getDescription() {
        return "Remove the public modifier from classes that implement RewriteTest.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType("org.openrewrite.test.RewriteTest", true), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (TypeUtils.isAssignableTo("org.openrewrite.test.RewriteTest", (JavaType)((J.ClassDeclaration)cd).getType()) && ((J.ClassDeclaration)cd).getKind() != J.ClassDeclaration.Kind.Type.Interface && ((J.ClassDeclaration)cd).getModifiers().stream().anyMatch(mod -> mod.getType() == J.Modifier.Type.Public) && ((J.ClassDeclaration)cd).getModifiers().stream().noneMatch(mod -> mod.getType() == J.Modifier.Type.Abstract) && !this.hasPublicStaticFieldOrMethod((J.ClassDeclaration)cd)) {
                    ArrayList modifierComments = new ArrayList();
                    List modifiers = ListUtils.map(((J.ClassDeclaration)cd).getModifiers(), mod -> {
                        if (mod.getType() == J.Modifier.Type.Public) {
                            modifierComments.addAll(mod.getComments());
                            return null;
                        }
                        if (!modifierComments.isEmpty()) {
                            J.Modifier nextModifier = (J.Modifier)mod.withComments(ListUtils.concatAll(new ArrayList(modifierComments), mod.getComments()));
                            modifierComments.clear();
                            return nextModifier;
                        }
                        return mod;
                    });
                    if (!modifierComments.isEmpty()) {
                        cd = (J.ClassDeclaration)cd.withComments(ListUtils.concatAll(cd.getComments(), modifierComments));
                    }
                    cd = this.maybeAutoFormat(cd, ((J.ClassDeclaration)cd).withModifiers(modifiers), ((J.ClassDeclaration)cd).getName(), ctx, this.getCursor().getParentTreeCursor());
                }
                return cd;
            }

            private boolean hasPublicStaticFieldOrMethod(J.ClassDeclaration cd) {
                if (cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).anyMatch(method -> method.hasModifier(J.Modifier.Type.Public) && method.hasModifier(J.Modifier.Type.Static))) {
                    return true;
                }
                return cd.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).anyMatch(field -> field.hasModifier(J.Modifier.Type.Public) && field.hasModifier(J.Modifier.Type.Static));
            }
        });
    }
}

