/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.tools.checkstyle.ModuleFactory;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.api.Violation;
import org.openrewrite.tools.checkstyle.utils.ModuleReflectionUtil;

public class PackageObjectFactory
implements ModuleFactory {
    public static final String BASE_PACKAGE = "org.openrewrite.tools.checkstyle";
    public static final String UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE = "PackageObjectFactory.unableToInstantiateExceptionMessage";
    public static final String AMBIGUOUS_MODULE_NAME_EXCEPTION_MESSAGE = "PackageObjectFactory.ambiguousModuleNameExceptionMessage";
    public static final String CHECK_SUFFIX = "Check";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String NULL_LOADER_MESSAGE = "moduleClassLoader must not be null";
    public static final String NULL_PACKAGE_MESSAGE = "package name must not be null";
    public static final String STRING_SEPARATOR = ", ";
    private static final Map<String, String> NAME_TO_FULL_MODULE_NAME = new HashMap<String, String>();
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;
    private Map<String, Set<String>> thirdPartyNameToFullModuleNames;
    private ModuleLoadOption moduleLoadOption;

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        this(packageNames, moduleClassLoader, ModuleLoadOption.SEARCH_REGISTERED_PACKAGES);
    }

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader, ModuleLoadOption moduleLoadOption) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        if (packageNames.contains(null)) {
            throw new IllegalArgumentException(NULL_PACKAGE_MESSAGE);
        }
        this.packages = new LinkedHashSet<String>(packageNames);
        this.moduleClassLoader = moduleClassLoader;
        this.moduleLoadOption = moduleLoadOption;
    }

    public PackageObjectFactory(String packageName, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException(NULL_LOADER_MESSAGE);
        }
        if (packageName == null) {
            throw new IllegalArgumentException(NULL_PACKAGE_MESSAGE);
        }
        this.packages = Collections.singleton(packageName);
        this.moduleClassLoader = moduleClassLoader;
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        Object instance = null;
        if (!name.contains(PACKAGE_SEPARATOR) && (instance = this.createFromStandardCheckSet(name)) == null) {
            if (this.thirdPartyNameToFullModuleNames == null) {
                this.thirdPartyNameToFullModuleNames = this.generateThirdPartyNameToFullModuleName(this.moduleClassLoader);
            }
            instance = this.createObjectFromMap(name, this.thirdPartyNameToFullModuleNames);
        }
        if (instance == null) {
            instance = this.createObject(name);
        }
        if (instance == null && this.moduleLoadOption == ModuleLoadOption.TRY_IN_ALL_REGISTERED_PACKAGES) {
            instance = this.createModuleByTryInEachPackage(name);
        }
        if (instance == null) {
            String attemptedNames = null;
            if (!name.contains(PACKAGE_SEPARATOR)) {
                String nameCheck = name + CHECK_SUFFIX;
                attemptedNames = PackageObjectFactory.joinPackageNamesWithClassName(name, this.packages) + STRING_SEPARATOR + nameCheck + STRING_SEPARATOR + PackageObjectFactory.joinPackageNamesWithClassName(nameCheck, this.packages);
            }
            Violation exceptionMessage = new Violation(1, "org.openrewrite.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, attemptedNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getViolation());
        }
        return instance;
    }

    private Object createFromStandardCheckSet(String name) throws CheckstyleException {
        String fullModuleName = NAME_TO_FULL_MODULE_NAME.get(name);
        Object instance = null;
        if (fullModuleName == null) {
            String fullCheckModuleName = NAME_TO_FULL_MODULE_NAME.get(name + CHECK_SUFFIX);
            if (fullCheckModuleName != null) {
                instance = this.createObject(fullCheckModuleName);
            }
        } else {
            instance = this.createObject(fullModuleName);
        }
        return instance;
    }

    private Object createObjectFromMap(String name, Map<String, Set<String>> map) throws CheckstyleException {
        Set<String> fullModuleNames = map.get(name);
        Object instance = null;
        if (fullModuleNames == null) {
            Set<String> fullCheckModuleNames = map.get(name + CHECK_SUFFIX);
            if (fullCheckModuleNames != null) {
                instance = this.createObjectFromFullModuleNames(name, fullCheckModuleNames);
            }
        } else {
            instance = this.createObjectFromFullModuleNames(name, fullModuleNames);
        }
        return instance;
    }

    private Object createObjectFromFullModuleNames(String name, Set<String> fullModuleNames) throws CheckstyleException {
        if (fullModuleNames.size() != 1) {
            String optionalNames = fullModuleNames.stream().sorted().collect(Collectors.joining(STRING_SEPARATOR));
            Violation exceptionMessage = new Violation(1, "org.openrewrite.tools.checkstyle.messages", AMBIGUOUS_MODULE_NAME_EXCEPTION_MESSAGE, new String[]{name, optionalNames}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getViolation());
        }
        Object returnValue = this.createObject(fullModuleNames.iterator().next());
        return returnValue;
    }

    private Map<String, Set<String>> generateThirdPartyNameToFullModuleName(ClassLoader loader) {
        Map<String, Set<String>> returnValue;
        try {
            returnValue = ModuleReflectionUtil.getCheckstyleModules(this.packages, loader).stream().collect(Collectors.groupingBy(Class::getSimpleName, Collectors.mapping(Class::getCanonicalName, Collectors.toSet())));
        }
        catch (IOException ignore) {
            returnValue = Collections.emptyMap();
        }
        return returnValue;
    }

    public static String getShortFromFullModuleNames(String fullName) {
        return NAME_TO_FULL_MODULE_NAME.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(fullName)).map(Map.Entry::getKey).findFirst().orElse(fullName);
    }

    private static String joinPackageNamesWithClassName(String className, Set<String> packages) {
        return packages.stream().collect(Collectors.joining(PACKAGE_SEPARATOR + className + STRING_SEPARATOR, "", PACKAGE_SEPARATOR + className));
    }

    private Object createObject(String className) throws CheckstyleException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, this.moduleClassLoader);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException throwable) {
            // empty catch block
        }
        Object instance = null;
        if (clazz != null) {
            try {
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new CheckstyleException("Unable to instantiate " + className, ex);
            }
        }
        return instance;
    }

    private Object createModuleByTryInEachPackage(String name) throws CheckstyleException {
        String possibleName;
        List possibleNames = this.packages.stream().map(packageName -> packageName + PACKAGE_SEPARATOR + name).flatMap(className -> Stream.of(className, className + CHECK_SUFFIX)).collect(Collectors.toList());
        Object instance = null;
        Iterator iterator = possibleNames.iterator();
        while (iterator.hasNext() && (instance = this.createObject(possibleName = (String)iterator.next())) == null) {
        }
        return instance;
    }

    private static void fillShortToFullModuleNamesMap() {
        PackageObjectFactory.fillChecksFromAnnotationPackage();
        PackageObjectFactory.fillChecksFromBlocksPackage();
        PackageObjectFactory.fillChecksFromCodingPackage();
        PackageObjectFactory.fillChecksFromDesignPackage();
        PackageObjectFactory.fillChecksFromHeaderPackage();
        PackageObjectFactory.fillChecksFromImportsPackage();
        PackageObjectFactory.fillChecksFromIndentationPackage();
        PackageObjectFactory.fillChecksFromJavadocPackage();
        PackageObjectFactory.fillChecksFromMetricsPackage();
        PackageObjectFactory.fillChecksFromModifierPackage();
        PackageObjectFactory.fillChecksFromNamingPackage();
        PackageObjectFactory.fillChecksFromRegexpPackage();
        PackageObjectFactory.fillChecksFromSizesPackage();
        PackageObjectFactory.fillChecksFromWhitespacePackage();
        PackageObjectFactory.fillModulesFromChecksPackage();
        PackageObjectFactory.fillModulesFromFilefiltersPackage();
        PackageObjectFactory.fillModulesFromFiltersPackage();
        PackageObjectFactory.fillModulesFromCheckstylePackage();
    }

    private static void fillChecksFromAnnotationPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AnnotationLocationCheck", "org.openrewrite.tools.checkstyle.checks.annotation.AnnotationLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("AnnotationOnSameLineCheck", "org.openrewrite.tools.checkstyle.checks.annotation.AnnotationOnSameLineCheck");
        NAME_TO_FULL_MODULE_NAME.put("AnnotationUseStyleCheck", "org.openrewrite.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingDeprecatedCheck", "org.openrewrite.tools.checkstyle.checks.annotation.MissingDeprecatedCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingOverrideCheck", "org.openrewrite.tools.checkstyle.checks.annotation.MissingOverrideCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageAnnotationCheck", "org.openrewrite.tools.checkstyle.checks.annotation.PackageAnnotationCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsCheck", "org.openrewrite.tools.checkstyle.checks.annotation.SuppressWarningsCheck");
    }

    private static void fillChecksFromBlocksPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AvoidNestedBlocksCheck", "org.openrewrite.tools.checkstyle.checks.blocks.AvoidNestedBlocksCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyBlockCheck", "org.openrewrite.tools.checkstyle.checks.blocks.EmptyBlockCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyCatchBlockCheck", "org.openrewrite.tools.checkstyle.checks.blocks.EmptyCatchBlockCheck");
        NAME_TO_FULL_MODULE_NAME.put("LeftCurlyCheck", "org.openrewrite.tools.checkstyle.checks.blocks.LeftCurlyCheck");
        NAME_TO_FULL_MODULE_NAME.put("NeedBracesCheck", "org.openrewrite.tools.checkstyle.checks.blocks.NeedBracesCheck");
        NAME_TO_FULL_MODULE_NAME.put("RightCurlyCheck", "org.openrewrite.tools.checkstyle.checks.blocks.RightCurlyCheck");
    }

    private static void fillChecksFromCodingPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ArrayTrailingCommaCheck", "org.openrewrite.tools.checkstyle.checks.coding.ArrayTrailingCommaCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidDoubleBraceInitializationCheck", "org.openrewrite.tools.checkstyle.checks.coding.AvoidDoubleBraceInitializationCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidInlineConditionalsCheck", "org.openrewrite.tools.checkstyle.checks.coding.AvoidInlineConditionalsCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidNoArgumentSuperConstructorCallCheck", "org.openrewrite.tools.checkstyle.checks.coding.AvoidNoArgumentSuperConstructorCallCheck");
        NAME_TO_FULL_MODULE_NAME.put("CovariantEqualsCheck", "org.openrewrite.tools.checkstyle.checks.coding.CovariantEqualsCheck");
        NAME_TO_FULL_MODULE_NAME.put("DeclarationOrderCheck", "org.openrewrite.tools.checkstyle.checks.coding.DeclarationOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("DefaultComesLastCheck", "org.openrewrite.tools.checkstyle.checks.coding.DefaultComesLastCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyStatementCheck", "org.openrewrite.tools.checkstyle.checks.coding.EmptyStatementCheck");
        NAME_TO_FULL_MODULE_NAME.put("EqualsAvoidNullCheck", "org.openrewrite.tools.checkstyle.checks.coding.EqualsAvoidNullCheck");
        NAME_TO_FULL_MODULE_NAME.put("EqualsHashCodeCheck", "org.openrewrite.tools.checkstyle.checks.coding.EqualsHashCodeCheck");
        NAME_TO_FULL_MODULE_NAME.put("ExplicitInitializationCheck", "org.openrewrite.tools.checkstyle.checks.coding.ExplicitInitializationCheck");
        NAME_TO_FULL_MODULE_NAME.put("FallThroughCheck", "org.openrewrite.tools.checkstyle.checks.coding.FallThroughCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalLocalVariableCheck", "org.openrewrite.tools.checkstyle.checks.coding.FinalLocalVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("HiddenFieldCheck", "org.openrewrite.tools.checkstyle.checks.coding.HiddenFieldCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalCatchCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalCatchCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalInstantiationCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalInstantiationCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalThrowsCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalThrowsCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTokenCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalTokenCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTokenTextCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalTokenTextCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalTypeCheck", "org.openrewrite.tools.checkstyle.checks.coding.IllegalTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("InnerAssignmentCheck", "org.openrewrite.tools.checkstyle.checks.coding.InnerAssignmentCheck");
        NAME_TO_FULL_MODULE_NAME.put("MagicNumberCheck", "org.openrewrite.tools.checkstyle.checks.coding.MagicNumberCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingCtorCheck", "org.openrewrite.tools.checkstyle.checks.coding.MissingCtorCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingSwitchDefaultCheck", "org.openrewrite.tools.checkstyle.checks.coding.MissingSwitchDefaultCheck");
        NAME_TO_FULL_MODULE_NAME.put("ModifiedControlVariableCheck", "org.openrewrite.tools.checkstyle.checks.coding.ModifiedControlVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("MultipleStringLiteralsCheck", "org.openrewrite.tools.checkstyle.checks.coding.MultipleStringLiteralsCheck");
        NAME_TO_FULL_MODULE_NAME.put("MultipleVariableDeclarationsCheck", "org.openrewrite.tools.checkstyle.checks.coding.MultipleVariableDeclarationsCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedForDepthCheck", "org.openrewrite.tools.checkstyle.checks.coding.NestedForDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedIfDepthCheck", "org.openrewrite.tools.checkstyle.checks.coding.NestedIfDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NestedTryDepthCheck", "org.openrewrite.tools.checkstyle.checks.coding.NestedTryDepthCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoCloneCheck", "org.openrewrite.tools.checkstyle.checks.coding.NoCloneCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoEnumTrailingCommaCheck", "org.openrewrite.tools.checkstyle.checks.coding.NoEnumTrailingCommaCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoFinalizerCheck", "org.openrewrite.tools.checkstyle.checks.coding.NoFinalizerCheck");
        NAME_TO_FULL_MODULE_NAME.put("OneStatementPerLineCheck", "org.openrewrite.tools.checkstyle.checks.coding.OneStatementPerLineCheck");
        NAME_TO_FULL_MODULE_NAME.put("OverloadMethodsDeclarationOrderCheck", "org.openrewrite.tools.checkstyle.checks.coding.OverloadMethodsDeclarationOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageDeclarationCheck", "org.openrewrite.tools.checkstyle.checks.coding.PackageDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterAssignmentCheck", "org.openrewrite.tools.checkstyle.checks.coding.ParameterAssignmentCheck");
        NAME_TO_FULL_MODULE_NAME.put("RequireThisCheck", "org.openrewrite.tools.checkstyle.checks.coding.RequireThisCheck");
        NAME_TO_FULL_MODULE_NAME.put("ReturnCountCheck", "org.openrewrite.tools.checkstyle.checks.coding.ReturnCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("SimplifyBooleanExpressionCheck", "org.openrewrite.tools.checkstyle.checks.coding.SimplifyBooleanExpressionCheck");
        NAME_TO_FULL_MODULE_NAME.put("SimplifyBooleanReturnCheck", "org.openrewrite.tools.checkstyle.checks.coding.SimplifyBooleanReturnCheck");
        NAME_TO_FULL_MODULE_NAME.put("StringLiteralEqualityCheck", "org.openrewrite.tools.checkstyle.checks.coding.StringLiteralEqualityCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuperCloneCheck", "org.openrewrite.tools.checkstyle.checks.coding.SuperCloneCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuperFinalizeCheck", "org.openrewrite.tools.checkstyle.checks.coding.SuperFinalizeCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessaryParenthesesCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnnecessaryParenthesesCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonAfterOuterTypeDeclarationCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnnecessarySemicolonAfterOuterTypeDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonAfterTypeMemberDeclarationCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnnecessarySemicolonAfterTypeMemberDeclarationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonInEnumerationCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnnecessarySemicolonInEnumerationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnnecessarySemicolonInTryWithResourcesCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnnecessarySemicolonInTryWithResourcesCheck");
        NAME_TO_FULL_MODULE_NAME.put("VariableDeclarationUsageDistanceCheck", "org.openrewrite.tools.checkstyle.checks.coding.VariableDeclarationUsageDistanceCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoArrayTrailingCommaCheck", "org.openrewrite.tools.checkstyle.checks.coding.NoArrayTrailingCommaCheck");
        NAME_TO_FULL_MODULE_NAME.put("MatchXpathCheck", "org.openrewrite.tools.checkstyle.checks.coding.MatchXpathCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnusedLocalVariableCheck", "org.openrewrite.tools.checkstyle.checks.coding.UnusedLocalVariableCheck");
    }

    private static void fillChecksFromDesignPackage() {
        NAME_TO_FULL_MODULE_NAME.put("DesignForExtensionCheck", "org.openrewrite.tools.checkstyle.checks.design.DesignForExtensionCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalClassCheck", "org.openrewrite.tools.checkstyle.checks.design.FinalClassCheck");
        NAME_TO_FULL_MODULE_NAME.put("HideUtilityClassConstructorCheck", "org.openrewrite.tools.checkstyle.checks.design.HideUtilityClassConstructorCheck");
        NAME_TO_FULL_MODULE_NAME.put("InnerTypeLastCheck", "org.openrewrite.tools.checkstyle.checks.design.InnerTypeLastCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceIsTypeCheck", "org.openrewrite.tools.checkstyle.checks.design.InterfaceIsTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("MutableExceptionCheck", "org.openrewrite.tools.checkstyle.checks.design.MutableExceptionCheck");
        NAME_TO_FULL_MODULE_NAME.put("OneTopLevelClassCheck", "org.openrewrite.tools.checkstyle.checks.design.OneTopLevelClassCheck");
        NAME_TO_FULL_MODULE_NAME.put("ThrowsCountCheck", "org.openrewrite.tools.checkstyle.checks.design.ThrowsCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("VisibilityModifierCheck", "org.openrewrite.tools.checkstyle.checks.design.VisibilityModifierCheck");
    }

    private static void fillChecksFromHeaderPackage() {
        NAME_TO_FULL_MODULE_NAME.put("HeaderCheck", "org.openrewrite.tools.checkstyle.checks.header.HeaderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpHeaderCheck", "org.openrewrite.tools.checkstyle.checks.header.RegexpHeaderCheck");
    }

    private static void fillChecksFromImportsPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AvoidStarImportCheck", "org.openrewrite.tools.checkstyle.checks.imports.AvoidStarImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidStaticImportCheck", "org.openrewrite.tools.checkstyle.checks.imports.AvoidStaticImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("CustomImportOrderCheck", "org.openrewrite.tools.checkstyle.checks.imports.CustomImportOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalImportCheck", "org.openrewrite.tools.checkstyle.checks.imports.IllegalImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("ImportControlCheck", "org.openrewrite.tools.checkstyle.checks.imports.ImportControlCheck");
        NAME_TO_FULL_MODULE_NAME.put("ImportOrderCheck", "org.openrewrite.tools.checkstyle.checks.imports.ImportOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RedundantImportCheck", "org.openrewrite.tools.checkstyle.checks.imports.RedundantImportCheck");
        NAME_TO_FULL_MODULE_NAME.put("UnusedImportsCheck", "org.openrewrite.tools.checkstyle.checks.imports.UnusedImportsCheck");
    }

    private static void fillChecksFromIndentationPackage() {
        NAME_TO_FULL_MODULE_NAME.put("CommentsIndentationCheck", "org.openrewrite.tools.checkstyle.checks.indentation.CommentsIndentationCheck");
        NAME_TO_FULL_MODULE_NAME.put("IndentationCheck", "org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck");
    }

    private static void fillChecksFromJavadocPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AtclauseOrderCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.AtclauseOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("InvalidJavadocPositionCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.InvalidJavadocPositionCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocBlockTagLocationCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocBlockTagLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocContentLocationCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocContentLocationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocMethodCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocMethodCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocMissingLeadingAsteriskCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocMissingLeadingAsteriskCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocMissingWhitespaceAfterAsteriskCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocMissingWhitespaceAfterAsteriskCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocPackageCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocPackageCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocParagraphCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocParagraphCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocStyleCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocTagContinuationIndentationCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocTagContinuationIndentationCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocTypeCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavadocVariableCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.JavadocVariableCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocMethodCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.MissingJavadocMethodCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocPackageCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.MissingJavadocPackageCheck");
        NAME_TO_FULL_MODULE_NAME.put("MissingJavadocTypeCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.MissingJavadocTypeCheck");
        NAME_TO_FULL_MODULE_NAME.put("NonEmptyAtclauseDescriptionCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.NonEmptyAtclauseDescriptionCheck");
        NAME_TO_FULL_MODULE_NAME.put("RequireEmptyLineBeforeBlockTagGroupCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.RequireEmptyLineBeforeBlockTagGroupCheck");
        NAME_TO_FULL_MODULE_NAME.put("SingleLineJavadocCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.SingleLineJavadocCheck");
        NAME_TO_FULL_MODULE_NAME.put("SummaryJavadocCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.SummaryJavadocCheck");
        NAME_TO_FULL_MODULE_NAME.put("WriteTagCheck", "org.openrewrite.tools.checkstyle.checks.javadoc.WriteTagCheck");
    }

    private static void fillChecksFromMetricsPackage() {
        NAME_TO_FULL_MODULE_NAME.put("BooleanExpressionComplexityCheck", "org.openrewrite.tools.checkstyle.checks.metrics.BooleanExpressionComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassDataAbstractionCouplingCheck", "org.openrewrite.tools.checkstyle.checks.metrics.ClassDataAbstractionCouplingCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassFanOutComplexityCheck", "org.openrewrite.tools.checkstyle.checks.metrics.ClassFanOutComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("CyclomaticComplexityCheck", "org.openrewrite.tools.checkstyle.checks.metrics.CyclomaticComplexityCheck");
        NAME_TO_FULL_MODULE_NAME.put("JavaNCSSCheck", "org.openrewrite.tools.checkstyle.checks.metrics.JavaNCSSCheck");
        NAME_TO_FULL_MODULE_NAME.put("NPathComplexityCheck", "org.openrewrite.tools.checkstyle.checks.metrics.NPathComplexityCheck");
    }

    private static void fillChecksFromModifierPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ClassMemberImpliedModifierCheck", "org.openrewrite.tools.checkstyle.checks.modifier.ClassMemberImpliedModifierCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceMemberImpliedModifierCheck", "org.openrewrite.tools.checkstyle.checks.modifier.InterfaceMemberImpliedModifierCheck");
        NAME_TO_FULL_MODULE_NAME.put("ModifierOrderCheck", "org.openrewrite.tools.checkstyle.checks.modifier.ModifierOrderCheck");
        NAME_TO_FULL_MODULE_NAME.put("RedundantModifierCheck", "org.openrewrite.tools.checkstyle.checks.modifier.RedundantModifierCheck");
    }

    private static void fillChecksFromNamingPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AbbreviationAsWordInNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.AbbreviationAsWordInNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("AbstractClassNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.AbstractClassNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("CatchParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.CatchParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ClassTypeParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.ClassTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ConstantNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.ConstantNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("InterfaceTypeParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.InterfaceTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LambdaParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.LambdaParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LocalFinalVariableNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.LocalFinalVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("LocalVariableNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.LocalVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MemberNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.MemberNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.MethodNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodTypeParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.MethodTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("PackageNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.PackageNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.ParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("RecordComponentNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.RecordComponentNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("RecordTypeParameterNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.RecordTypeParameterNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("StaticVariableNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.StaticVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("TypeNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.TypeNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("PatternVariableNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.PatternVariableNameCheck");
        NAME_TO_FULL_MODULE_NAME.put("IllegalIdentifierNameCheck", "org.openrewrite.tools.checkstyle.checks.naming.IllegalIdentifierNameCheck");
    }

    private static void fillChecksFromRegexpPackage() {
        NAME_TO_FULL_MODULE_NAME.put("RegexpCheck", "org.openrewrite.tools.checkstyle.checks.regexp.RegexpCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpMultilineCheck", "org.openrewrite.tools.checkstyle.checks.regexp.RegexpMultilineCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpOnFilenameCheck", "org.openrewrite.tools.checkstyle.checks.regexp.RegexpOnFilenameCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpSinglelineCheck", "org.openrewrite.tools.checkstyle.checks.regexp.RegexpSinglelineCheck");
        NAME_TO_FULL_MODULE_NAME.put("RegexpSinglelineJavaCheck", "org.openrewrite.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck");
    }

    private static void fillChecksFromSizesPackage() {
        NAME_TO_FULL_MODULE_NAME.put("AnonInnerLengthCheck", "org.openrewrite.tools.checkstyle.checks.sizes.AnonInnerLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("ExecutableStatementCountCheck", "org.openrewrite.tools.checkstyle.checks.sizes.ExecutableStatementCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("FileLengthCheck", "org.openrewrite.tools.checkstyle.checks.sizes.FileLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("LambdaBodyLengthCheck", "org.openrewrite.tools.checkstyle.checks.sizes.LambdaBodyLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("LineLengthCheck", "org.openrewrite.tools.checkstyle.checks.sizes.LineLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodCountCheck", "org.openrewrite.tools.checkstyle.checks.sizes.MethodCountCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodLengthCheck", "org.openrewrite.tools.checkstyle.checks.sizes.MethodLengthCheck");
        NAME_TO_FULL_MODULE_NAME.put("OuterTypeNumberCheck", "org.openrewrite.tools.checkstyle.checks.sizes.OuterTypeNumberCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParameterNumberCheck", "org.openrewrite.tools.checkstyle.checks.sizes.ParameterNumberCheck");
        NAME_TO_FULL_MODULE_NAME.put("RecordComponentNumberCheck", "org.openrewrite.tools.checkstyle.checks.sizes.RecordComponentNumberCheck");
    }

    private static void fillChecksFromWhitespacePackage() {
        NAME_TO_FULL_MODULE_NAME.put("EmptyForInitializerPadCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.EmptyForInitializerPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyForIteratorPadCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.EmptyForIteratorPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("EmptyLineSeparatorCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.EmptyLineSeparatorCheck");
        NAME_TO_FULL_MODULE_NAME.put("FileTabCharacterCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.FileTabCharacterCheck");
        NAME_TO_FULL_MODULE_NAME.put("GenericWhitespaceCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.GenericWhitespaceCheck");
        NAME_TO_FULL_MODULE_NAME.put("MethodParamPadCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.MethodParamPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoLineWrapCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.NoLineWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoWhitespaceAfterCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.NoWhitespaceAfterCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoWhitespaceBeforeCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.NoWhitespaceBeforeCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoWhitespaceBeforeCaseDefaultColonCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.NoWhitespaceBeforeCaseDefaultColonCheck");
        NAME_TO_FULL_MODULE_NAME.put("OperatorWrapCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.OperatorWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("ParenPadCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.ParenPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("SeparatorWrapCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.SeparatorWrapCheck");
        NAME_TO_FULL_MODULE_NAME.put("SingleSpaceSeparatorCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.SingleSpaceSeparatorCheck");
        NAME_TO_FULL_MODULE_NAME.put("TypecastParenPadCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.TypecastParenPadCheck");
        NAME_TO_FULL_MODULE_NAME.put("WhitespaceAfterCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.WhitespaceAfterCheck");
        NAME_TO_FULL_MODULE_NAME.put("WhitespaceAroundCheck", "org.openrewrite.tools.checkstyle.checks.whitespace.WhitespaceAroundCheck");
    }

    private static void fillModulesFromChecksPackage() {
        NAME_TO_FULL_MODULE_NAME.put("ArrayTypeStyleCheck", "org.openrewrite.tools.checkstyle.checks.ArrayTypeStyleCheck");
        NAME_TO_FULL_MODULE_NAME.put("AvoidEscapedUnicodeCharactersCheck", "org.openrewrite.tools.checkstyle.checks.AvoidEscapedUnicodeCharactersCheck");
        NAME_TO_FULL_MODULE_NAME.put("DescendantTokenCheck", "org.openrewrite.tools.checkstyle.checks.DescendantTokenCheck");
        NAME_TO_FULL_MODULE_NAME.put("FinalParametersCheck", "org.openrewrite.tools.checkstyle.checks.FinalParametersCheck");
        NAME_TO_FULL_MODULE_NAME.put("NewlineAtEndOfFileCheck", "org.openrewrite.tools.checkstyle.checks.NewlineAtEndOfFileCheck");
        NAME_TO_FULL_MODULE_NAME.put("NoCodeInFileCheck", "org.openrewrite.tools.checkstyle.checks.NoCodeInFileCheck");
        NAME_TO_FULL_MODULE_NAME.put("OuterTypeFilenameCheck", "org.openrewrite.tools.checkstyle.checks.OuterTypeFilenameCheck");
        NAME_TO_FULL_MODULE_NAME.put("OrderedPropertiesCheck", "org.openrewrite.tools.checkstyle.checks.OrderedPropertiesCheck");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsHolder", "org.openrewrite.tools.checkstyle.checks.SuppressWarningsHolder");
        NAME_TO_FULL_MODULE_NAME.put("TodoCommentCheck", "org.openrewrite.tools.checkstyle.checks.TodoCommentCheck");
        NAME_TO_FULL_MODULE_NAME.put("TrailingCommentCheck", "org.openrewrite.tools.checkstyle.checks.TrailingCommentCheck");
        NAME_TO_FULL_MODULE_NAME.put("TranslationCheck", "org.openrewrite.tools.checkstyle.checks.TranslationCheck");
        NAME_TO_FULL_MODULE_NAME.put("UncommentedMainCheck", "org.openrewrite.tools.checkstyle.checks.UncommentedMainCheck");
        NAME_TO_FULL_MODULE_NAME.put("UniquePropertiesCheck", "org.openrewrite.tools.checkstyle.checks.UniquePropertiesCheck");
        NAME_TO_FULL_MODULE_NAME.put("UpperEllCheck", "org.openrewrite.tools.checkstyle.checks.UpperEllCheck");
    }

    private static void fillModulesFromFilefiltersPackage() {
        NAME_TO_FULL_MODULE_NAME.put("BeforeExecutionExclusionFileFilter", "org.openrewrite.tools.checkstyle.filefilters.BeforeExecutionExclusionFileFilter");
    }

    private static void fillModulesFromFiltersPackage() {
        NAME_TO_FULL_MODULE_NAME.put("SeverityMatchFilter", "org.openrewrite.tools.checkstyle.filters.SeverityMatchFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWithPlainTextCommentFilter", "org.openrewrite.tools.checkstyle.filters.SuppressWithPlainTextCommentFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionCommentFilter", "org.openrewrite.tools.checkstyle.filters.SuppressionCommentFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionFilter", "org.openrewrite.tools.checkstyle.filters.SuppressionFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionSingleFilter", "org.openrewrite.tools.checkstyle.filters.SuppressionSingleFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionXpathFilter", "org.openrewrite.tools.checkstyle.filters.SuppressionXpathFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressionXpathSingleFilter", "org.openrewrite.tools.checkstyle.filters.SuppressionXpathSingleFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWarningsFilter", "org.openrewrite.tools.checkstyle.filters.SuppressWarningsFilter");
        NAME_TO_FULL_MODULE_NAME.put("SuppressWithNearbyCommentFilter", "org.openrewrite.tools.checkstyle.filters.SuppressWithNearbyCommentFilter");
    }

    private static void fillModulesFromCheckstylePackage() {
        NAME_TO_FULL_MODULE_NAME.put("Checker", "org.openrewrite.tools.checkstyle.Checker");
        NAME_TO_FULL_MODULE_NAME.put("TreeWalker", "org.openrewrite.tools.checkstyle.TreeWalker");
    }

    static {
        PackageObjectFactory.fillShortToFullModuleNamesMap();
    }

    public static enum ModuleLoadOption {
        SEARCH_REGISTERED_PACKAGES,
        TRY_IN_ALL_REGISTERED_PACKAGES;

    }
}

