/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrewrite.tools.checkstyle.api.AuditEvent;
import org.openrewrite.tools.checkstyle.api.Filter;

public class FilterSet
implements Filter {
    private final Set<Filter> filters = new HashSet<Filter>();

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public Set<Filter> getFilters() {
        return Collections.unmodifiableSet(this.filters);
    }

    public String toString() {
        return this.filters.toString();
    }

    @Override
    public boolean accept(AuditEvent event) {
        boolean result = true;
        for (Filter filter : this.filters) {
            if (filter.accept(event)) continue;
            result = false;
            break;
        }
        return result;
    }

    public void clear() {
        this.filters.clear();
    }
}

