/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private static final JavaType.Class TYPE_OBJECT = JavaType.ShallowClass.build("java.lang.Object");

    private TypeUtils() {
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.FullyQualified && "java.lang.String".equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
    }

    public static boolean fullyQualifiedNamesAreEqual(@Nullable String fqn1, @Nullable String fqn2) {
        if (fqn1 != null && fqn2 != null) {
            return fqn1.equals(fqn2) || fqn1.length() == fqn2.length() && fqn1.replace('$', '.').equals(fqn2.replace('$', '.'));
        }
        return fqn1 == null && fqn2 == null;
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2) {
        if (type1 instanceof JavaType.Unknown || type2 instanceof JavaType.Unknown) {
            return false;
        }
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        if (TypeUtils.isString(type1) && TypeUtils.isString(type2)) {
            return true;
        }
        if (type1 instanceof JavaType.Primitive && type2 instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type1).getKeyword().equals(((JavaType.Primitive)type2).getKeyword());
        }
        if (type1 instanceof JavaType.FullyQualified && type2 instanceof JavaType.FullyQualified && TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type1).getFullyQualifiedName(), ((JavaType.FullyQualified)type2).getFullyQualifiedName())) {
            if (type1 instanceof JavaType.Class && type2 instanceof JavaType.Class) {
                return true;
            }
            if (type1 instanceof JavaType.Parameterized && type2 instanceof JavaType.Parameterized) {
                DefaultJavaTypeSignatureBuilder signatureBuilder = new DefaultJavaTypeSignatureBuilder();
                return signatureBuilder.signature(type1).equals(signatureBuilder.signature(type2));
            }
        }
        if (type1 instanceof JavaType.Array && type2 instanceof JavaType.Array) {
            return TypeUtils.isOfType(((JavaType.Array)type1).getElemType(), ((JavaType.Array)type2).getElemType());
        }
        if (type1 instanceof JavaType.GenericTypeVariable && type2 instanceof JavaType.GenericTypeVariable) {
            DefaultJavaTypeSignatureBuilder signatureBuilder = new DefaultJavaTypeSignatureBuilder();
            return signatureBuilder.signature(type1).equals(signatureBuilder.signature(type2));
        }
        if (type1 instanceof JavaType.Method && type2 instanceof JavaType.Method) {
            int index;
            JavaType.Method method1 = (JavaType.Method)type1;
            JavaType.Method method2 = (JavaType.Method)type2;
            if (!(method1.getName().equals(method2.getName()) && method1.getFlags().size() == method2.getFlags().size() && method1.getFlags().containsAll(method2.getFlags()) && TypeUtils.isOfType(method1.getDeclaringType(), method2.getDeclaringType()) && TypeUtils.isOfType(method1.getReturnType(), method2.getReturnType()) && method1.getAnnotations().size() == method2.getAnnotations().size() && method1.getThrownExceptions().size() == method2.getThrownExceptions().size() && method1.getParameterTypes().size() == method2.getParameterTypes().size())) {
                return false;
            }
            for (index = 0; index < method1.getParameterTypes().size(); ++index) {
                if (TypeUtils.isOfType(method1.getParameterTypes().get(index), method2.getParameterTypes().get(index))) continue;
                return false;
            }
            for (index = 0; index < method1.getThrownExceptions().size(); ++index) {
                if (TypeUtils.isOfType(method1.getThrownExceptions().get(index), method2.getThrownExceptions().get(index))) continue;
                return false;
            }
            for (index = 0; index < method1.getAnnotations().size(); ++index) {
                if (TypeUtils.isOfType(method1.getAnnotations().get(index), method2.getAnnotations().get(index))) continue;
                return false;
            }
            return true;
        }
        return type1.equals(type2);
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        if (type instanceof JavaType.FullyQualified) {
            return TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type).getFullyQualifiedName(), fqn);
        }
        if (type instanceof JavaType.Variable) {
            return TypeUtils.isOfClassType(((JavaType.Variable)type).getType(), fqn);
        }
        if (type instanceof JavaType.Method) {
            return TypeUtils.isOfClassType(((JavaType.Method)type).getReturnType(), fqn);
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.isOfClassType(((JavaType.Array)type).getElemType(), fqn);
        }
        if (type instanceof JavaType.Primitive) {
            return type == JavaType.Primitive.fromKeyword(fqn);
        }
        return false;
    }

    @Incubating(since="8.1.4")
    public static boolean isOfTypeWithName(@Nullable JavaType.FullyQualified type, boolean matchOverride, Predicate<String> matcher) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        if (matcher.test(type.getFullyQualifiedName())) {
            return true;
        }
        if (matchOverride) {
            if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && TypeUtils.isOfTypeWithName(TYPE_OBJECT, true, matcher)) {
                return true;
            }
            if (TypeUtils.isOfTypeWithName(type.getSupertype(), true, matcher)) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!TypeUtils.isOfTypeWithName(anInterface, true, matcher)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        try {
            if (to instanceof JavaType.Unknown || from instanceof JavaType.Unknown) {
                return false;
            }
            if (to == from) {
                return true;
            }
            if (to instanceof JavaType.Parameterized) {
                JavaType.Parameterized toParameterized = (JavaType.Parameterized)to;
                if (!(from instanceof JavaType.Parameterized)) {
                    return toParameterized.getTypeParameters().stream().allMatch(p -> TypeUtils.isAssignableTo(p, (JavaType)TYPE_OBJECT));
                }
                JavaType.Parameterized fromParameterized = (JavaType.Parameterized)from;
                List<JavaType> toParameters = toParameterized.getTypeParameters();
                List<JavaType> fromParameters = fromParameterized.getTypeParameters();
                int parameterCount = toParameters.size();
                return parameterCount == fromParameters.size() && TypeUtils.isAssignableTo(toParameterized.getType(), (JavaType)fromParameterized.getType()) && IntStream.range(0, parameterCount).allMatch(i -> TypeUtils.isAssignableTo((JavaType)toParameters.get(i), (JavaType)fromParameters.get(i)));
            }
            if (to instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified toFq = (JavaType.FullyQualified)to;
                return TypeUtils.isAssignableTo(toFq.getFullyQualifiedName(), from);
            }
            if (to instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericTo = (JavaType.GenericTypeVariable)to;
                if (genericTo.getBounds().isEmpty()) {
                    return genericTo.getName().equals("?");
                }
                return false;
            }
            if (to instanceof JavaType.Variable) {
                return TypeUtils.isAssignableTo(((JavaType.Variable)to).getType(), from);
            }
            if (to instanceof JavaType.Method) {
                return TypeUtils.isAssignableTo(((JavaType.Method)to).getReturnType(), from);
            }
            if (to instanceof JavaType.Primitive) {
                if (from instanceof JavaType.FullyQualified) {
                    JavaType.ShallowClass boxed = JavaType.ShallowClass.build(((JavaType.Primitive)to).getClassName());
                    return TypeUtils.isAssignableTo(boxed, from);
                }
            } else if (to instanceof JavaType.Array && from instanceof JavaType.Array) {
                return TypeUtils.isAssignableTo(((JavaType.Array)to).getElemType(), ((JavaType.Array)from).getElemType());
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(String to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                if (from instanceof JavaType.Parameterized && to.equals(from.toString())) {
                    return true;
                }
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                return TypeUtils.fullyQualifiedNamesAreEqual(to, classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype()) || classFrom.getInterfaces().stream().anyMatch(i -> TypeUtils.isAssignableTo(to, (JavaType)i));
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else if (from instanceof JavaType.Primitive) {
                JavaType.Primitive fromPrimitive = (JavaType.Primitive)from;
                JavaType.Primitive toPrimitive = JavaType.Primitive.fromKeyword(to);
                if (fromPrimitive == toPrimitive) {
                    return true;
                }
                if (fromPrimitive == JavaType.Primitive.Boolean || fromPrimitive == JavaType.Primitive.Void) {
                    return false;
                }
                if (toPrimitive != null) {
                    switch (toPrimitive) {
                        case Char: {
                            return fromPrimitive == JavaType.Primitive.Byte;
                        }
                        case Short: {
                            switch (fromPrimitive) {
                                case Byte: 
                                case Char: {
                                    return true;
                                }
                            }
                            return false;
                        }
                        case Int: {
                            switch (fromPrimitive) {
                                case Byte: 
                                case Char: 
                                case Short: {
                                    return true;
                                }
                            }
                            return false;
                        }
                        case Long: {
                            switch (fromPrimitive) {
                                case Byte: 
                                case Char: 
                                case Short: 
                                case Int: {
                                    return true;
                                }
                            }
                            return false;
                        }
                        case Float: {
                            return fromPrimitive != JavaType.Primitive.Double;
                        }
                        case Double: {
                            return true;
                        }
                    }
                    return false;
                }
                if ("java.lang.String".equals(to)) {
                    return fromPrimitive == JavaType.Primitive.String;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(Pattern to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                if (to.matcher(classFrom.getFullyQualifiedName()).matches() || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype())) {
                    return true;
                }
                for (JavaType.FullyQualified anInterface : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableTo(to, (JavaType)anInterface)) continue;
                    return true;
                }
                return false;
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
                if (from instanceof JavaType.Primitive) {
                    JavaType.Primitive primitive = (JavaType.Primitive)from;
                    return to.toString().equals(primitive.getKeyword());
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Nullable
    public static JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    @Nullable
    public static JavaType.Parameterized asParameterized(@Nullable JavaType type) {
        return type instanceof JavaType.Parameterized ? (JavaType.Parameterized)type : null;
    }

    @Nullable
    public static JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    @Nullable
    public static JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    @Nullable
    public static JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    @Nullable
    public static JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        if (type instanceof JavaType.FullyQualified) {
            if (type == JavaType.Unknown.getInstance()) {
                return null;
            }
            return (JavaType.FullyQualified)type;
        }
        return null;
    }

    public static boolean isOverride(@Nullable JavaType.Method method) {
        return TypeUtils.findOverriddenMethod(method).isPresent();
    }

    public static Optional<JavaType.Method> findOverriddenMethod(@Nullable JavaType.Method method) {
        Optional<JavaType.Method> methodResult;
        block2: {
            JavaType.FullyQualified i;
            if (method == null) {
                return Optional.empty();
            }
            JavaType.FullyQualified dt = method.getDeclaringType();
            List<JavaType> argTypes = method.getParameterTypes();
            methodResult = TypeUtils.findDeclaredMethod(dt.getSupertype(), method.getName(), argTypes);
            if (methodResult.isPresent()) break block2;
            Iterator<JavaType.FullyQualified> iterator = dt.getInterfaces().iterator();
            while (iterator.hasNext() && !(methodResult = TypeUtils.findDeclaredMethod(i = iterator.next(), method.getName(), argTypes)).isPresent()) {
            }
        }
        return methodResult.filter(m -> !m.getFlags().contains((Object)Flag.Private) && !m.getFlags().contains((Object)Flag.Static));
    }

    public static Optional<JavaType.Method> findDeclaredMethod(@Nullable JavaType.FullyQualified clazz, String name, List<JavaType> argumentTypes) {
        if (clazz == null) {
            return Optional.empty();
        }
        for (JavaType.Method method : clazz.getMethods()) {
            if (!TypeUtils.methodHasSignature(clazz, method, name, argumentTypes)) continue;
            return Optional.of(method);
        }
        Optional<JavaType.Method> methodResult = TypeUtils.findDeclaredMethod(clazz.getSupertype(), name, argumentTypes);
        if (methodResult.isPresent()) {
            return methodResult;
        }
        for (JavaType.FullyQualified i : clazz.getInterfaces()) {
            methodResult = TypeUtils.findDeclaredMethod(i, name, argumentTypes);
            if (!methodResult.isPresent()) continue;
            return methodResult;
        }
        return Optional.empty();
    }

    private static boolean methodHasSignature(JavaType.FullyQualified clazz, JavaType.Method m, String name, List<JavaType> argTypes) {
        if (!name.equals(m.getName())) {
            return false;
        }
        List<JavaType> mArgs = m.getParameterTypes();
        if (mArgs.size() != argTypes.size()) {
            return false;
        }
        IdentityHashMap<JavaType, JavaType> parameterMap = new IdentityHashMap<JavaType, JavaType>();
        List<JavaType> declaringTypeParams = m.getDeclaringType().getTypeParameters();
        List<JavaType> typeParameters = clazz.getTypeParameters();
        if (typeParameters.size() != declaringTypeParams.size()) {
            return false;
        }
        for (int j = 0; j < typeParameters.size(); ++j) {
            JavaType typeAttributed = typeParameters.get(j);
            JavaType generic = declaringTypeParams.get(j);
            parameterMap.put(generic, typeAttributed);
        }
        for (int i = 0; i < mArgs.size(); ++i) {
            JavaType actual;
            JavaType declared = mArgs.get(i);
            if (TypeUtils.isOfType(declared, actual = argTypes.get(i)) || parameterMap.get(declared) == actual) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedType(@Nullable JavaType type) {
        return TypeUtils.isWellFormedType(type, new HashSet<JavaType>());
    }

    public static boolean isWellFormedType(@Nullable JavaType type, Set<JavaType> seen) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        return TypeUtils.isWellFormedType0(type, seen);
    }

    private static boolean isWellFormedType0(JavaType type, Set<JavaType> seen) {
        if (!seen.add(type)) {
            return true;
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            return TypeUtils.isWellFormedType(parameterized.getType(), seen) && parameterized.getTypeParameters().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Array) {
            JavaType.Array arr = (JavaType.Array)type;
            return TypeUtils.isWellFormedType(arr.getElemType(), seen);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable gen = (JavaType.GenericTypeVariable)type;
            return gen.getBounds().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Variable) {
            JavaType.Variable var = (JavaType.Variable)type;
            return TypeUtils.isWellFormedType(var.getType(), seen) && TypeUtils.isWellFormedType(var.getOwner(), seen);
        }
        if (type instanceof JavaType.MultiCatch) {
            JavaType.MultiCatch mc = (JavaType.MultiCatch)type;
            return mc.getThrowableTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Method) {
            JavaType.Method m = (JavaType.Method)type;
            return TypeUtils.isWellFormedType(m.getReturnType(), seen) && TypeUtils.isWellFormedType(m.getDeclaringType(), seen) && m.getParameterTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        return true;
    }

    public static JavaType.FullyQualified unknownIfNull(@Nullable JavaType.FullyQualified t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    public static JavaType unknownIfNull(@Nullable JavaType t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    static boolean deepEquals(@Nullable List<? extends JavaType> ts1, @Nullable List<? extends JavaType> ts2) {
        if (ts1 == null || ts2 == null) {
            return ts1 == null && ts2 == null;
        }
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.equals(t2);
    }
}

