/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.search.FindMissingTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.Marker;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;

public class Assertions {
    private static final Map<Integer, JavaVersion> javaVersions = new HashMap<Integer, JavaVersion>();
    private static final Map<String, JavaProject> javaProjects = new HashMap<String, JavaProject>();
    private static final Map<String, JavaSourceSet> javaSourceSets = new HashMap<String, JavaSourceSet>();
    private static final Parser.Builder javaParser = JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true);

    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (ctx.getMessage("org.openrewrite.java.skipSourceSetTypeGeneration") == null) {
            ctx.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)true);
        }
    }

    static SourceFile validateTypes(SourceFile after, RecipeSpec testMethodSpec, RecipeSpec testClassSpec) {
        if (after instanceof JavaSourceFile) {
            TypeValidation typeValidation;
            TypeValidation typeValidation2 = typeValidation = testMethodSpec.getTypeValidation() != null ? testMethodSpec.getTypeValidation() : testClassSpec.getTypeValidation();
            if (typeValidation == null) {
                typeValidation = new TypeValidation();
            }
            Assertions.assertValidTypes(typeValidation, (JavaSourceFile)after);
        }
        return after;
    }

    public static void assertValidTypes(TypeValidation typeValidation, J sf) {
        if (typeValidation.identifiers() || typeValidation.methodInvocations() || typeValidation.methodDeclarations() || typeValidation.classDeclarations() || typeValidation.constructorInvocations()) {
            List<FindMissingTypes.MissingTypeResult> missingTypeResults = FindMissingTypes.findMissingTypes(sf);
            if (!(missingTypeResults = missingTypeResults.stream().filter(missingType -> {
                if (typeValidation.identifiers() && missingType.getJ() instanceof J.Identifier) {
                    return true;
                }
                if (typeValidation.classDeclarations() && missingType.getJ() instanceof J.ClassDeclaration) {
                    return true;
                }
                if (typeValidation.methodInvocations() && missingType.getJ() instanceof J.MethodInvocation) {
                    return true;
                }
                if (typeValidation.constructorInvocations() && missingType.getJ() instanceof J.NewClass) {
                    return true;
                }
                if (typeValidation.methodDeclarations() && missingType.getJ() instanceof J.MethodDeclaration) {
                    return true;
                }
                return typeValidation.variableDeclarations() && missingType.getJ() instanceof J.VariableDeclarations.NamedVariable;
            }).collect(Collectors.toList())).isEmpty()) {
                throw new IllegalStateException("AST contains missing or invalid type information\n" + missingTypeResults.stream().map(v -> v.getPath() + "\n" + v.getPrintedTree()).collect(Collectors.joining("\n\n")));
            }
        }
    }

    public static SourceSpecs java(@Nullable @Language(value="java") String before) {
        return Assertions.java(before, (SourceSpec<J.CompilationUnit> s) -> {});
    }

    public static SourceSpecs java(@Nullable @Language(value="java") String before, Consumer<SourceSpec<J.CompilationUnit>> spec) {
        SourceSpec java = new SourceSpec(J.CompilationUnit.class, null, javaParser, before, Assertions::validateTypes, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<J.CompilationUnit>)java);
        return java;
    }

    public static SourceSpecs java(@Nullable @Language(value="java") String before, @Nullable @Language(value="java") String after) {
        return Assertions.java(before, after, s -> {});
    }

    public static SourceSpecs java(@Nullable @Language(value="java") String before, @Nullable @Language(value="java") String after, Consumer<SourceSpec<J.CompilationUnit>> spec) {
        SourceSpec java = new SourceSpec(J.CompilationUnit.class, null, javaParser, before, Assertions::validateTypes, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<J.CompilationUnit>)java);
        return java;
    }

    private static void acceptSpec(Consumer<SourceSpec<J.CompilationUnit>> spec, SourceSpec<J.CompilationUnit> java) {
        ThrowingConsumer userSuppliedAfterRecipe = java.getAfterRecipe();
        java.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        spec.accept(java);
    }

    public static SourceSpecs mavenProject(String project, Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... sources) {
        return SourceSpecs.dir((String)project, spec, (SourceSpecs[])sources);
    }

    public static SourceSpecs mavenProject(String project, SourceSpecs ... sources) {
        return Assertions.mavenProject(project, (SourceSpec<SourceFile> spec) -> Assertions.project(spec, project), sources);
    }

    public static SourceSpecs srcMainJava(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... javaSources) {
        return SourceSpecs.dir((String)"src/main/java", spec, (SourceSpecs[])javaSources);
    }

    public static SourceSpecs srcMainJava(SourceSpecs ... javaSources) {
        return Assertions.srcMainJava((SourceSpec<SourceFile> spec) -> Assertions.sourceSet(spec, "main"), javaSources);
    }

    public static SourceSpecs srcMainResources(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... resources) {
        return SourceSpecs.dir((String)"src/main/resources", spec, (SourceSpecs[])resources);
    }

    public static SourceSpecs srcMainResources(SourceSpecs ... resources) {
        return Assertions.srcMainResources((SourceSpec<SourceFile> spec) -> Assertions.sourceSet(spec, "main"), resources);
    }

    public static SourceSpecs srcTestJava(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... javaSources) {
        return SourceSpecs.dir((String)"src/test/java", spec, (SourceSpecs[])javaSources);
    }

    public static SourceSpecs srcTestJava(SourceSpecs ... javaSources) {
        return Assertions.srcTestJava((SourceSpec<SourceFile> spec) -> Assertions.sourceSet(spec, "test"), javaSources);
    }

    public static SourceSpecs srcTestResources(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... resources) {
        return SourceSpecs.dir((String)"src/test/resources", spec, (SourceSpecs[])resources);
    }

    public static SourceSpecs srcTestResources(SourceSpecs ... resources) {
        return Assertions.srcTestResources((SourceSpec<SourceFile> spec) -> Assertions.sourceSet(spec, "test"), resources);
    }

    public static SourceSpecs srcSmokeTestJava(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... javaSources) {
        return SourceSpecs.dir((String)"src/smokeTest/java", spec, (SourceSpecs[])javaSources);
    }

    public static SourceSpecs srcSmokeTestJava(SourceSpecs ... javaSources) {
        return Assertions.srcSmokeTestJava((SourceSpec<SourceFile> spec) -> Assertions.sourceSet(spec, "smokeTest"), javaSources);
    }

    public static SourceSpec<?> version(SourceSpec<?> sourceSpec, int version) {
        return sourceSpec.markers(new Marker[]{Assertions.javaVersion(version)});
    }

    public static SourceSpecs version(SourceSpecs sourceSpec, int version) {
        for (SourceSpec spec : sourceSpec) {
            spec.markers(new Marker[]{Assertions.javaVersion(version)});
        }
        return sourceSpec;
    }

    public static SourceSpec<?> project(SourceSpec<?> sourceSpec, String projectName) {
        return sourceSpec.markers(new Marker[]{Assertions.javaProject(projectName)});
    }

    public static SourceSpec<?> sourceSet(SourceSpec<?> sourceSpec, String sourceSet) {
        sourceSpec.markers(new Marker[]{Assertions.javaSourceSet(sourceSet)});
        return sourceSpec;
    }

    public static UncheckedConsumer<List<SourceFile>> addTypesToSourceSet(String sourceSetName, List<String> extendsFrom, List<Path> classpath) {
        return sourceFiles -> {
            JavaSourceSet sourceSet = JavaSourceSet.build(sourceSetName, classpath, new JavaTypeCache(), false);
            for (int i = 0; i < sourceFiles.size(); ++i) {
                SourceFile sourceFile = (SourceFile)sourceFiles.get(i);
                Optional maybeCurrentSourceSet = sourceFile.getMarkers().findFirst(JavaSourceSet.class);
                if (!maybeCurrentSourceSet.isPresent() || !((JavaSourceSet)maybeCurrentSourceSet.get()).getName().equals(sourceSetName)) continue;
                sourceFiles.set(i, (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().computeByType((Marker)sourceSet, (original, updated) -> updated)));
            }
        };
    }

    public static UncheckedConsumer<List<SourceFile>> addTypesToSourceSet(String sourceSetName, List<String> extendsFrom) {
        return Assertions.addTypesToSourceSet(sourceSetName, extendsFrom, Collections.emptyList());
    }

    public static UncheckedConsumer<List<SourceFile>> addTypesToSourceSet(String sourceSetName) {
        return Assertions.addTypesToSourceSet(sourceSetName, Collections.emptyList(), Collections.emptyList());
    }

    public static JavaVersion javaVersion(int version) {
        return javaVersions.computeIfAbsent(version, v -> new JavaVersion(Tree.randomId(), "openjdk", "adoptopenjdk", Integer.toString(v), Integer.toString(v)));
    }

    private static JavaProject javaProject(String projectName) {
        return javaProjects.computeIfAbsent(projectName, name -> new JavaProject(Tree.randomId(), (String)name, null));
    }

    private static JavaSourceSet javaSourceSet(String sourceSet) {
        return javaSourceSets.computeIfAbsent(sourceSet, name -> new JavaSourceSet(Tree.randomId(), (String)name, Collections.emptyList()));
    }
}

