/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import java.util.Optional;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.GeneralFormatStyle;

public class AutoFormatVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    public AutoFormatVisitor() {
        this(null);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visit(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)((SourceFile)cu).getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)((SourceFile)cu).getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new SpacesVisitor(Optional.ofNullable((SpacesStyle)((SourceFile)cu).getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), (EmptyForInitializerPadStyle)((SourceFile)cu).getStyle(EmptyForInitializerPadStyle.class), (EmptyForIteratorPadStyle)((SourceFile)cu).getStyle(EmptyForIteratorPadStyle.class), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit(t, p, cursor.fork());
        t = new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, (Object)p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(Optional.ofNullable((GeneralFormatStyle)((SourceFile)cu).getStyle(GeneralFormatStyle.class)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu)), this.stopAfter).visit(t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit(t, p, cursor.fork());
        return t;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof J.CompilationUnit)) {
                return cu;
            }
            JavaSourceFile t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visit((Tree)cu, (Object)p);
            t = (JavaSourceFile)new BlankLinesVisitor(Optional.ofNullable((BlankLinesStyle)((SourceFile)cu).getStyle(BlankLinesStyle.class)).orElse(IntelliJ.blankLines()), this.stopAfter).visit((Tree)t, (Object)p);
            t = (JavaSourceFile)new SpacesVisitor(Optional.ofNullable((SpacesStyle)((SourceFile)cu).getStyle(SpacesStyle.class)).orElse(IntelliJ.spaces()), (EmptyForInitializerPadStyle)((SourceFile)cu).getStyle(EmptyForInitializerPadStyle.class), (EmptyForIteratorPadStyle)((SourceFile)cu).getStyle(EmptyForIteratorPadStyle.class), this.stopAfter).visit((Tree)t, (Object)p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor(Optional.ofNullable((WrappingAndBracesStyle)((SourceFile)cu).getStyle(WrappingAndBracesStyle.class)).orElse(IntelliJ.wrappingAndBraces()), this.stopAfter).visit((Tree)t, (Object)p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, (Object)p);
            t = (JavaSourceFile)new TabsAndIndentsVisitor(Optional.ofNullable((TabsAndIndentsStyle)((SourceFile)cu).getStyle(TabsAndIndentsStyle.class)).orElse(IntelliJ.tabsAndIndents()), this.stopAfter).visit((Tree)t, (Object)p);
            assert (t != null);
            return t;
        }
        return (J)tree;
    }
}

