/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.Tree;
import org.openrewrite.java.cleanup.DefaultComesLastStyle;
import org.openrewrite.java.cleanup.EmptyBlockStyle;
import org.openrewrite.java.cleanup.EqualsAvoidsNullStyle;
import org.openrewrite.java.cleanup.ExplicitInitializationStyle;
import org.openrewrite.java.cleanup.FallThroughStyle;
import org.openrewrite.java.cleanup.HiddenFieldStyle;
import org.openrewrite.java.cleanup.HideUtilityClassConstructorStyle;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Checkstyle
extends NamedStyles {
    private static final Checkstyle INSTANCE = new Checkstyle();
    private static final String NAME = "org.openrewrite.java.Checkstyle";
    private static final String DISPLAY_NAME = "Checkstyle";
    private static final String DESCRIPTION = "Checkstyle defaults for styles";
    public static final EmptyBlockStyle.BlockPolicy defaultBlockPolicy = EmptyBlockStyle.BlockPolicy.STATEMENT;

    private Checkstyle() {
        super(Tree.randomId(), NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), Arrays.asList(Checkstyle.defaultComesLast(), Checkstyle.emptyBlock(), Checkstyle.equalsAvoidsNull(), Checkstyle.explicitInitialization(), Checkstyle.fallThrough(), Checkstyle.hiddenFieldStyle(), Checkstyle.hideUtilityClassConstructorStyle(), Checkstyle.unnecessaryParentheses()));
    }

    Checkstyle(Collection<Style> styles) {
        super(Tree.randomId(), NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), styles);
    }

    @JsonCreator
    public static Checkstyle defaults() {
        return INSTANCE;
    }

    public static DefaultComesLastStyle defaultComesLast() {
        return new DefaultComesLastStyle(false);
    }

    public static EmptyBlockStyle emptyBlock() {
        return new EmptyBlockStyle(defaultBlockPolicy, true, true, true, true, true, true, true, true, true, true, true, true);
    }

    public static EqualsAvoidsNullStyle equalsAvoidsNull() {
        return new EqualsAvoidsNullStyle(false);
    }

    public static ExplicitInitializationStyle explicitInitialization() {
        return new ExplicitInitializationStyle(false);
    }

    public static FallThroughStyle fallThrough() {
        return new FallThroughStyle(false);
    }

    public static HiddenFieldStyle hiddenFieldStyle() {
        return new HiddenFieldStyle(false, false, false, false);
    }

    public static HideUtilityClassConstructorStyle hideUtilityClassConstructorStyle() {
        return new HideUtilityClassConstructorStyle(Arrays.asList("@lombok.experimental.UtilityClass", "@lombok.Data"));
    }

    public static UnnecessaryParenthesesStyle unnecessaryParentheses() {
        return new UnnecessaryParenthesesStyle(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
    }
}

