/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.HiddenFieldStyle;
import org.openrewrite.java.cleanup.HiddenFieldVisitor;
import org.openrewrite.java.tree.J;

@Incubating(since="7.6.0")
public class HiddenField
extends Recipe {
    public String getDisplayName() {
        return "Hidden field";
    }

    public String getDescription() {
        return "Refactor local variables or parameters which shadow a field defined in the same class.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new HiddenFieldFromCompilationUnitStyle();
    }

    private static class HiddenFieldFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private HiddenFieldFromCompilationUnitStyle() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
            HiddenFieldStyle style = (HiddenFieldStyle)cu.getStyle(HiddenFieldStyle.class);
            if (style == null) {
                style = HiddenFieldStyle.hiddenFieldStyle();
            }
            this.doAfterVisit(new HiddenFieldVisitor(style));
            return cu;
        }
    }
}

