/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class GenerateGetter
extends Recipe {
    @Option(displayName="Field name", description="Name of field to generate getter for.", example="foo")
    private final String fieldName;

    public String getDisplayName() {
        return "Generate getter";
    }

    public String getDescription() {
        return "Generate a `get` accessor method.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GenerateGetterVisitor<ExecutionContext>();
    }

    public GenerateGetter(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    public String toString() {
        return "GenerateGetter(fieldName=" + this.getFieldName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateGetter)) {
            return false;
        }
        GenerateGetter other = (GenerateGetter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof GenerateGetter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }

    private class GenerateGetterVisitor<P>
    extends JavaIsoVisitor<P> {
        private final JavaTemplate getter = JavaTemplate.builder(() -> ((GenerateGetterVisitor)this).getCursor(), "public #{} get#{}() {\n    return #{};\n}").build();

        private GenerateGetterVisitor() {
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            if (variable.isField(this.getCursor()) && variable.getSimpleName().equals(GenerateGetter.this.fieldName)) {
                this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "varCursor", (Object)this.getCursor());
            }
            return super.visitVariable(variable, (Object)p);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            J.VariableDeclarations.NamedVariable var;
            JavaType.FullyQualified fullyQualified;
            J c = super.visitClassDeclaration(classDecl, (Object)p);
            Cursor varCursor = (Cursor)this.getCursor().pollNearestMessage("varCursor");
            if (varCursor != null && (fullyQualified = TypeUtils.asFullyQualified((var = (J.VariableDeclarations.NamedVariable)varCursor.getValue()).getType())) != null) {
                c = (J.ClassDeclaration)c.withTemplate(this.getter, ((J.ClassDeclaration)c).getBody().getCoordinates().lastStatement(), fullyQualified.getClassName(), StringUtils.capitalize((String)var.getSimpleName()), var.getSimpleName());
            }
            return c;
        }
    }
}

