/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.java.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Autodetect detect(List<J.CompilationUnit> cus) {
        IndentStatistics indentStatistics = new IndentStatistics();
        ImportLayoutStatistics importLayoutStatistics = new ImportLayoutStatistics();
        SpacesStatistics spacesStatistics = new SpacesStatistics();
        for (J.CompilationUnit cu : cus) {
            new FindIndentJavaVisitor().visit(cu, indentStatistics);
            new FindImportLayout().visit(cu, importLayoutStatistics);
            new FindSpacesStyle().visit(cu, spacesStatistics);
        }
        return new Autodetect(Tree.randomId(), Arrays.asList(indentStatistics.getTabsAndIndentsStyle(), importLayoutStatistics.getImportLayoutStyle(), spacesStatistics.getSpacesStyle()));
    }

    private static class FindSpacesStyle
    extends JavaIsoVisitor<SpacesStatistics> {
        private FindSpacesStyle() {
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, SpacesStatistics stats) {
            stats.beforeCatch += this.hasSpace(_catch.getParameter().getPrefix());
            return super.visitCatch(_catch, stats);
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(doWhileLoop.getWhileCondition().getPrefix());
            return super.visitDoWhileLoop(doWhileLoop, stats);
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            return super.visitForEachLoop(forLoop, stats);
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            return super.visitForLoop(forLoop, stats);
        }

        @Override
        public J.If visitIf(J.If iff, SpacesStatistics stats) {
            stats.beforeIf += this.hasSpace(iff.getIfCondition().getPrefix());
            return super.visitIf(iff, stats);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, SpacesStatistics stats) {
            stats.beforeMethodDeclaration += this.hasSpace(method.getPadding().getParameters().getBefore());
            return super.visitMethodDeclaration(method, stats);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(method.getPadding().getArguments().getBefore());
            return super.visitMethodInvocation(method, stats);
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, SpacesStatistics stats) {
            stats.beforeSwitch += this.hasSpace(_switch.getSelector().getPrefix());
            return super.visitSwitch(_switch, stats);
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, SpacesStatistics stats) {
            stats.beforeSynchronized += this.hasSpace(_sync.getLock().getPrefix());
            return super.visitSynchronized(_sync, stats);
        }

        @Override
        public J.Try visitTry(J.Try _try, SpacesStatistics stats) {
            if (_try.getPadding().getResources() != null) {
                stats.beforeTry += this.hasSpace(_try.getPadding().getResources().getBefore());
            }
            return super.visitTry(_try, stats);
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(whileLoop.getCondition().getPrefix());
            return super.visitWhileLoop(whileLoop, stats);
        }

        private int hasSpace(Space space) {
            return space.getWhitespace().contains(" ") ? 1 : -1;
        }
    }

    private static class SpacesStatistics {
        int beforeIf = 1;
        int beforeMethodCall = 0;
        int beforeMethodDeclaration = 0;
        int beforeFor = 1;
        int beforeWhile = 1;
        int beforeSwitch = 1;
        int beforeTry = 1;
        int beforeCatch = 1;
        int beforeSynchronized = 1;

        private SpacesStatistics() {
        }

        public SpacesStyle getSpacesStyle() {
            SpacesStyle spaces = IntelliJ.spaces();
            return spaces.withBeforeParentheses(new SpacesStyle.BeforeParentheses(this.beforeMethodDeclaration > 0, this.beforeMethodCall > 0, this.beforeIf > 0, this.beforeFor > 0 || this.beforeWhile > 0, this.beforeWhile > 0 || this.beforeFor > 0, this.beforeSwitch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeTry > 0 || this.beforeCatch > 0, this.beforeSynchronized > 0, false));
        }
    }

    private static class FindImportLayout
    extends JavaIsoVisitor<ImportLayoutStatistics> {
        private FindImportLayout() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ImportLayoutStatistics importLayoutStatistics) {
            LinkedHashSet<ImportLayoutStatistics.Block> blocks = new LinkedHashSet<ImportLayoutStatistics.Block>();
            boolean staticBlock = false;
            int blockStart = 0;
            int i = 0;
            for (J.Import anImport : cu.getImports()) {
                if (anImport.getPrefix().getWhitespace().contains("\n\n") || anImport.getPrefix().getWhitespace().contains("\r\n\r\n")) {
                    if (i - blockStart > 0) {
                        blocks.add(new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, cu.getImports().subList(blockStart, i)));
                    }
                    blockStart = i;
                }
                if (anImport.getQualid().getSimpleName().equals("*")) {
                    JavaType.FullyQualified fq;
                    if (anImport.isStatic()) {
                        int count = 0;
                        for (JavaType type : cu.getTypesInUse()) {
                            if (!(type instanceof JavaType.Variable) || (fq = TypeUtils.asFullyQualified(((JavaType.Variable)type).getType())) == null || !anImport.getTypeName().equals(fq.getFullyQualifiedName())) continue;
                            ++count;
                        }
                        importLayoutStatistics.minimumFoldedStaticImports = Math.min(importLayoutStatistics.minimumFoldedStaticImports, count);
                    } else {
                        HashSet<String> fqns = new HashSet<String>();
                        for (JavaType type : cu.getTypesInUse()) {
                            if (!(type instanceof JavaType.FullyQualified)) continue;
                            fq = (JavaType.FullyQualified)type;
                            if (!anImport.getPackageName().equals(fq.getPackageName())) continue;
                            fqns.add(fq.getFullyQualifiedName());
                        }
                        importLayoutStatistics.minimumFoldedImports = Math.min(importLayoutStatistics.minimumFoldedImports, fqns.size());
                    }
                }
                staticBlock = anImport.isStatic();
                ++i;
            }
            if (i - blockStart > 0) {
                blocks.add(new ImportLayoutStatistics.Block(staticBlock ? ImportLayoutStatistics.BlockType.ImportStatic : ImportLayoutStatistics.BlockType.Import, cu.getImports().subList(blockStart, i)));
            }
            importLayoutStatistics.blocksPerSourceFile.add(new ArrayList(blocks));
            return cu;
        }
    }

    private static class ImportLayoutStatistics {
        List<List<Block>> blocksPerSourceFile = new ArrayList<List<Block>>();
        int minimumFoldedImports = Integer.MAX_VALUE;
        int minimumFoldedStaticImports = Integer.MAX_VALUE;

        private ImportLayoutStatistics() {
        }

        public ImportLayoutStyle getImportLayoutStyle() {
            return this.blocksPerSourceFile.stream().max(Comparator.comparing(List::size).thenComparing(blocks -> blocks.stream().filter(b -> "all other imports".equals(((Block)b).pattern)).count())).map(longestBlocks -> {
                ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
                boolean importAllOthers = false;
                boolean importStaticAllOthers = false;
                int i = 0;
                for (Block block : longestBlocks) {
                    if (i++ != 0) {
                        builder = builder.blankLine();
                    }
                    switch (block.type) {
                        case Import: {
                            assert (block.pattern != null);
                            if ("all other imports".equals(block.pattern) && !importAllOthers) {
                                importAllOthers = true;
                                builder = builder.importAllOthers();
                                break;
                            }
                            if (longestBlocks.stream().noneMatch(b -> ((Block)b).type == BlockType.Import && "all other imports".equals(((Block)b).pattern)) && !importAllOthers) {
                                importAllOthers = true;
                                builder = builder.importAllOthers().blankLine();
                            }
                            builder = builder.importPackage(block.pattern);
                            break;
                        }
                        case ImportStatic: {
                            assert (block.pattern != null);
                            if ("all other imports".equals(block.pattern) && !importStaticAllOthers) {
                                importStaticAllOthers = true;
                                builder = builder.importStaticAllOthers();
                                break;
                            }
                            if (longestBlocks.stream().noneMatch(b -> ((Block)b).type == BlockType.ImportStatic && "all other imports".equals(((Block)b).pattern)) && !importStaticAllOthers) {
                                importStaticAllOthers = true;
                                builder = builder.importStaticAllOthers().blankLine();
                            }
                            builder = builder.staticImportPackage(block.pattern);
                        }
                    }
                }
                if (!importAllOthers) {
                    builder = importStaticAllOthers ? builder.blankLine().importAllOthers() : builder.importAllOthers();
                }
                if (!importStaticAllOthers) {
                    builder = builder.blankLine().importStaticAllOthers();
                }
                builder.classCountToUseStarImport(Math.max(this.minimumFoldedImports, 5));
                builder.nameCountToUseStarImport(Math.max(this.minimumFoldedStaticImports, 3));
                return builder.build();
            }).orElse(IntelliJ.importLayout());
        }

        static class Block {
            private final BlockType type;
            @Nullable
            private final String pattern;

            Block(BlockType type, List<J.Import> imports) {
                this.type = type;
                this.pattern = Block.getPattern(imports);
            }

            static String getPattern(List<J.Import> imports) {
                String longestCommonPrefix = null;
                for (J.Import anImport : imports) {
                    String pkg = anImport.getPackageName();
                    longestCommonPrefix = Block.longestCommonPrefix(pkg, longestCommonPrefix);
                    if (!longestCommonPrefix.isEmpty()) continue;
                    return "all other imports";
                }
                if (longestCommonPrefix == null) {
                    return "all other imports";
                }
                if (longestCommonPrefix.startsWith("java.")) {
                    return "java.*";
                }
                if (longestCommonPrefix.startsWith("javax.")) {
                    return "javax.*";
                }
                if (longestCommonPrefix.chars().filter(c -> c == 46).count() > 1L) {
                    return longestCommonPrefix + "*";
                }
                return "all other imports";
            }

            static String longestCommonPrefix(String pkg, @Nullable String lcp) {
                int i;
                if (lcp == null) {
                    return pkg;
                }
                char[] p1 = pkg.toCharArray();
                char[] p2 = lcp.toCharArray();
                for (i = 0; i < p1.length && i < p2.length && p1[i] == p2[i]; ++i) {
                }
                return lcp.substring(0, i);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Block)) {
                    return false;
                }
                Block other = (Block)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BlockType this$type = this.type;
                BlockType other$type = other.type;
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$pattern = this.pattern;
                String other$pattern = other.pattern;
                return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Block;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BlockType $type = this.type;
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $pattern = this.pattern;
                result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
                return result;
            }
        }

        static enum BlockType {
            Import,
            ImportStatic;

        }
    }

    private static class FindIndentJavaVisitor
    extends JavaIsoVisitor<IndentStatistics> {
        private FindIndentJavaVisitor() {
        }

        @Override
        public Space visitSpace(Space space, Space.Location loc, IndentStatistics stats) {
            Integer lastIndent = (Integer)this.getCursor().getNearestMessage("lastIndent");
            if (lastIndent == null) {
                lastIndent = 0;
            }
            String prefix = space.getWhitespace();
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int indent = 0;
                for (char c2 : chars = prefix.toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        indent = 0;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    ++indent;
                }
                stats.indentFrequencies.merge(indent - lastIndent, 1L, Long::sum);
                this.getCursor().putMessage("lastIndent", (Object)indent);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    stats.linesWithSpaceIndents++;
                } else {
                    stats.linesWithTabIndents++;
                }
            }
            return space;
        }
    }

    private static class IndentStatistics {
        private final Map<Integer, Long> indentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;

        private IndentStatistics() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            Map.Entry<Integer, Long> i1 = null;
            Map.Entry<Integer, Long> i2 = null;
            for (Map.Entry<Integer, Long> sample : this.indentFrequencies.entrySet()) {
                if (sample.getKey() == 0) continue;
                if (i1 == null || (Long)i1.getValue() < sample.getValue()) {
                    i1 = sample;
                    continue;
                }
                if (i2 != null && (Long)i2.getValue() >= sample.getValue()) continue;
                i2 = sample;
            }
            int indent1 = i1 == null ? 4 : (Integer)i1.getKey();
            int indent2 = i2 == null ? indent1 : (Integer)i2.getKey();
            int indent = Math.min(indent1, indent2);
            int continuationIndent = Math.max(indent1, indent2);
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent, continuationIndent, false);
        }
    }
}

