/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AspectjUtils;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private Pattern targetTypePattern;
    private Pattern methodNamePattern;
    private Pattern argumentPattern;

    public MethodMatcher(String signature) {
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)signature))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                MethodMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                MethodMatcher.this.methodNamePattern = Pattern.compile(ctx.simpleNamePattern().children.stream().map(c -> AspectjUtils.aspectjNameToPattern(c.toString())).collect(Collectors.joining("")));
                MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public boolean matches(@Nullable JavaType type) {
        if (!(type instanceof JavaType.Method)) {
            return false;
        }
        JavaType.Method methodType = (JavaType.Method)type;
        return this.matchesTargetType(methodType.getDeclaringType()) && this.methodNamePattern.matcher(methodType.getName()).matches() && this.argumentPattern.matcher(methodType.getGenericSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        if (enclosing.getType() == null) {
            return false;
        }
        return (this.targetTypePattern.toString().equals("[^.]*") || this.matchesTargetType(enclosing.getType())) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(method.getParameters().stream().map(v -> {
            if (v instanceof J.VariableDeclarations) {
                J.VariableDeclarations vd = (J.VariableDeclarations)v;
                if (vd.getTypeAsFullyQualified() != null) {
                    return vd.getTypeAsFullyQualified();
                }
                return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
            }
            return null;
        }).filter(Objects::nonNull).map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(J.MethodInvocation method) {
        if (method.getType() == null || method.getType().getDeclaringType() == null) {
            return false;
        }
        if (method.getType().getResolvedSignature() == null) {
            return false;
        }
        return this.matchesTargetType(method.getType().getDeclaringType()) && this.methodNamePattern.matcher(method.getSimpleName()).matches() && this.argumentPattern.matcher(method.getType().getResolvedSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(J.NewClass constructor) {
        if (constructor.getType() == null) {
            return false;
        }
        List<Expression> args = constructor.getArguments();
        String signaturePattern = "";
        if (args != null) {
            signaturePattern = args.stream().map(Expression::getType).filter(Objects::nonNull).map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","));
        }
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(constructor.getType());
        assert (type != null);
        return this.matchesTargetType(type) && this.methodNamePattern.matcher(type.getClassName()).matches() && this.argumentPattern.matcher(signaturePattern).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        return type != null && (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches() || type != JavaType.Class.OBJECT && this.matchesTargetType(type.getSupertype() == null ? JavaType.Class.OBJECT : type.getSupertype()));
    }

    @Nullable
    private static String typePattern(JavaType type) {
        JavaType elemType;
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array && (elemType = ((JavaType.Array)type).getElemType()) != null) {
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        assert (method.getType() != null);
        return method.getType().getDeclaringType().getFullyQualifiedName() + " " + method.getSimpleName() + "(" + method.getType().getResolvedSignature().getParamTypes().stream().map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(",")) + ")";
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public Pattern getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }
}

