/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSearchResult;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

@Incubating(since="7.5.0")
public class UsesType<P>
extends JavaIsoVisitor<P> {
    private static final Marker FOUND_TYPE = new JavaSearchResult(Tree.randomId(), null, null);
    private final List<String> fullyQualifiedTypeSegments;

    public UsesType(String fullyQualifiedType) {
        Scanner scanner = new Scanner(fullyQualifiedType);
        scanner.useDelimiter("\\.");
        this.fullyQualifiedTypeSegments = new ArrayList<String>();
        while (scanner.hasNext()) {
            this.fullyQualifiedTypeSegments.add(scanner.next());
        }
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        Set<JavaType> types = cu.getTypesInUse();
        block0: for (JavaType type : types) {
            String segment;
            if (!(type instanceof JavaType.FullyQualified)) continue;
            JavaType.FullyQualified fq = (JavaType.FullyQualified)type;
            Scanner scanner = new Scanner(fq.getFullyQualifiedName());
            scanner.useDelimiter("\\.");
            for (int i = 0; scanner.hasNext() && i < this.fullyQualifiedTypeSegments.size() && !(segment = this.fullyQualifiedTypeSegments.get(i)).equals("*"); ++i) {
                String test = scanner.next();
                if (!segment.equals(test)) continue block0;
            }
            return cu.withMarkers(cu.getMarkers().addIfAbsent(FOUND_TYPE));
        }
        return cu;
    }
}

