/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class PrimitiveWrapperClassConstructorToValueOf
extends Recipe {
    public String getDisplayName() {
        return "Use primitive wrapper `valueOf` method";
    }

    public String getDescription() {
        return "The constructor of all primitive types has been deprecated in favor of using the static factory method `valueOf` available for each of the primitive type wrappers.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.doAfterVisit(new UsesType("java.lang.Boolean"));
                this.doAfterVisit(new UsesType("java.lang.Byte"));
                this.doAfterVisit(new UsesType("java.lang.Character"));
                this.doAfterVisit(new UsesType("java.lang.Double"));
                this.doAfterVisit(new UsesType("java.lang.Float"));
                this.doAfterVisit(new UsesType("java.lang.Integer"));
                this.doAfterVisit(new UsesType("java.lang.Long"));
                this.doAfterVisit(new UsesType("java.lang.Short"));
                return cu;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
                J j = super.visitNewClass(newClass, executionContext);
                J.NewClass nc = (J.NewClass)j;
                JavaType.FullyQualified type = TypeUtils.asFullyQualified(nc.getType());
                if (type != null && nc.getArguments() != null && nc.getArguments().size() == 1) {
                    JavaTemplate.Builder valueOf = null;
                    switch (type.getFullyQualifiedName()) {
                        case "java.lang.Boolean": {
                            valueOf = this.template("#{}.valueOf(#{any(boolean)});");
                            break;
                        }
                        case "java.lang.Byte": {
                            valueOf = this.template("#{}.valueOf(#{any(byte)});");
                            break;
                        }
                        case "java.lang.Character": {
                            valueOf = this.template("#{}.valueOf(#{any(char)});");
                            break;
                        }
                        case "java.lang.Double": {
                            valueOf = this.template("#{}.valueOf(#{any(double)});");
                            break;
                        }
                        case "java.lang.Float": {
                            valueOf = this.template("#{}.valueOf(#{any(float)});");
                            break;
                        }
                        case "java.lang.Integer": {
                            valueOf = this.template("#{}.valueOf(#{any(int)});");
                            break;
                        }
                        case "java.lang.Long": {
                            valueOf = this.template("#{}.valueOf(#{any(long)});");
                            break;
                        }
                        case "java.lang.Short": {
                            valueOf = this.template("#{}.valueOf(#{any(short)});");
                            break;
                        }
                    }
                    if (valueOf != null) {
                        j = nc.withTemplate(valueOf.build(), nc.getCoordinates().replace(), type.getClassName(), nc.getArguments().get(0));
                    }
                }
                return j;
            }
        };
    }
}

