/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class FindImplementations
extends Recipe {
    private final String interfaceFullyQualifiedName;

    public FindImplementations(String interfaceFullyQualifiedName) {
        this.interfaceFullyQualifiedName = interfaceFullyQualifiedName;
    }

    public String getDisplayName() {
        return "Find class declarations implementing an interface";
    }

    public String getDescription() {
        return "Find source files that contain a class declaration implementing a specific interface.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!TypeUtils.isOfClassType(((J.ClassDeclaration)(classDecl = super.visitClassDeclaration((J.ClassDeclaration)classDecl, ctx))).getType(), FindImplementations.this.interfaceFullyQualifiedName) && TypeUtils.isAssignableTo(FindImplementations.this.interfaceFullyQualifiedName, (JavaType)((J.ClassDeclaration)classDecl).getType())) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)classDecl);
                }
                return classDecl;
            }
        };
    }
}

