/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public class UseJavaStyleArrayDeclarations
extends Recipe {
    public String getDisplayName() {
        return "No C-style array declarations";
    }

    public String getDescription() {
        return "Change C-Style array declarations `int i[];` to `int[] i;`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1197");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ArrayType visitArrayType(J.ArrayType arrayType, ExecutionContext executionContext) {
                return (J.ArrayType)SearchResult.found((Tree)arrayType);
            }

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                if (!variable.getDimensionsAfterName().isEmpty()) {
                    variable = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)variable);
                }
                return variable;
            }
        };
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J varDecls = super.visitVariableDeclarations(multiVariable, executionContext);
                List dimensions = (List)this.getCursor().pollMessage("VAR_DIMENSIONS");
                if (dimensions != null) {
                    varDecls = ((J.VariableDeclarations)varDecls).withDimensionsBeforeName(dimensions);
                }
                return varDecls;
            }

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                J nv = super.visitVariable(variable, executionContext);
                if (!((J.VariableDeclarations.NamedVariable)nv).getDimensionsAfterName().isEmpty()) {
                    this.getCursor().dropParentUntil(J.VariableDeclarations.class::isInstance).putMessage("VAR_DIMENSIONS", ((J.VariableDeclarations.NamedVariable)nv).getDimensionsAfterName());
                    nv = ((J.VariableDeclarations.NamedVariable)nv).withDimensionsAfterName(ListUtils.map(((J.VariableDeclarations.NamedVariable)nv).getDimensionsAfterName(), dim -> null));
                }
                return nv;
            }
        };
    }
}

