/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.SelfLoathing;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.controlflow.ControlFlowIllegalStateException;
import org.openrewrite.java.controlflow.ControlFlowNode;
import org.openrewrite.java.controlflow.ControlFlowSummary;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

@Incubating(since="7.25.0")
public final class ControlFlow {
    private static final String CONTROL_FLOW_MESSAGE_KEY = "__CONTROL_FLOW_SUMMARY";
    @Nullable
    private Cursor start;

    public Optional<ControlFlowSummary> findControlFlow() {
        if (this.start == null) {
            return Optional.empty();
        }
        return (Optional)this.start.computeMessageIfAbsent(CONTROL_FLOW_MESSAGE_KEY, __ -> {
            ControlFlowSimpleSummary summary = ControlFlow.findControlFlowInternal(this.start, ControlFlowNode.GraphType.METHOD_BODY_OR_STATIC_INITIALIZER_OR_INSTANCE_INITIALIZER);
            return Optional.of(ControlFlowSummary.forGraph(summary.start, summary.end));
        });
    }

    private static ControlFlowSimpleSummary findControlFlowInternal(Cursor start, ControlFlowNode.GraphType graphType) {
        ControlFlowNode.Start startNode = ControlFlowNode.Start.create(graphType);
        ControlFlowAnalysis analysis = new ControlFlowAnalysis(startNode, true);
        analysis.visit((Tree)start.getValue(), 1, start.getParentOrThrow());
        ControlFlowNode.End end = (ControlFlowNode.End)analysis.current.iterator().next();
        return new ControlFlowSimpleSummary(startNode, end);
    }

    public static ControlFlow startingAt(Cursor start) {
        Iterator cursorPath = start.getPathAsCursors();
        Cursor methodDeclarationBlockCursor = null;
        while (cursorPath.hasNext()) {
            Cursor nextCursor = (Cursor)cursorPath.next();
            Object next = nextCursor.getValue();
            if (next instanceof J.Block) {
                methodDeclarationBlockCursor = nextCursor;
                if (!J.Block.isStaticOrInitBlock(nextCursor)) continue;
                return new ControlFlow(nextCursor);
            }
            if (!(next instanceof J.MethodDeclaration)) continue;
            return new ControlFlow(methodDeclarationBlockCursor);
        }
        return new ControlFlow(null);
    }

    private ControlFlow(@Nullable Cursor start) {
        this.start = start;
    }

    private static final class ControlFlowSimpleSummary {
        private final ControlFlowNode.Start start;
        private final ControlFlowNode.End end;

        public ControlFlowSimpleSummary(ControlFlowNode.Start start, ControlFlowNode.End end) {
            this.start = start;
            this.end = end;
        }

        public ControlFlowNode.Start getStart() {
            return this.start;
        }

        public ControlFlowNode.End getEnd() {
            return this.end;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlFlowSimpleSummary)) {
                return false;
            }
            ControlFlowSimpleSummary other = (ControlFlowSimpleSummary)o;
            ControlFlowNode.Start this$start = this.getStart();
            ControlFlowNode.Start other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            ControlFlowNode.End this$end = this.getEnd();
            ControlFlowNode.End other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !this$end.equals(other$end));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ControlFlowNode.Start $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            ControlFlowNode.End $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ControlFlow.ControlFlowSimpleSummary(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }

    private static class ControlFlowAnalysis<P>
    extends JavaIsoVisitor<P> {
        protected Set<? extends ControlFlowNode> current;
        private final ControlFlowNode.GraphType graphType;
        private final boolean methodEntryPoint;
        protected final Set<ControlFlowNode> exitFlow = new HashSet<ControlFlowNode>();
        protected final Set<ControlFlowNode> continueFlow = new HashSet<ControlFlowNode>();
        protected final Set<ControlFlowNode> breakFlow = new HashSet<ControlFlowNode>();

        ControlFlowAnalysis(ControlFlowNode.Start start, boolean methodEntryPoint) {
            this.current = Collections.singleton(Objects.requireNonNull(start, "start cannot be null"));
            this.graphType = start.getGraphType();
            this.methodEntryPoint = methodEntryPoint;
        }

        ControlFlowAnalysis(Set<? extends ControlFlowNode> current, ControlFlowNode.GraphType graphType) {
            this.current = Objects.requireNonNull(current, "current cannot be null");
            this.graphType = Objects.requireNonNull(graphType, "graphType cannot be null");
            this.methodEntryPoint = false;
        }

        ControlFlowNode.BasicBlock currentAsBasicBlock() {
            if (this.current.isEmpty()) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("No current node!").addCursor(this.getCursor()));
            }
            if (this.current.size() == 1 && this.current.iterator().next() instanceof ControlFlowNode.BasicBlock) {
                return (ControlFlowNode.BasicBlock)this.current.iterator().next();
            }
            return this.addBasicBlockToCurrent();
        }

        ControlFlowNode.BasicBlock newEmptyBasicBlockFromCurrent() {
            ControlFlowNode.BasicBlock currentBasicBlock = this.currentAsBasicBlock();
            if (currentBasicBlock.hasLeader()) {
                return currentBasicBlock.addBasicBlock();
            }
            return currentBasicBlock;
        }

        ControlFlowNode.BasicBlock addBasicBlockToCurrent() {
            HashSet<ControlFlowNode> newCurrent = new HashSet<ControlFlowNode>(this.current);
            ControlFlowNode.BasicBlock basicBlock = ControlFlowAnalysis.addBasicBlock(newCurrent);
            this.current = Collections.singleton(basicBlock);
            return basicBlock;
        }

        <C extends ControlFlowNode> void addSuccessorToCurrent(C node) {
            this.current.forEach(c -> c.addSuccessor(node));
            this.current = Collections.singleton(node);
        }

        void addCursorToBasicBlock() {
            this.currentAsBasicBlock().addCursorToBasicBlock(this.getCursor());
        }

        ControlFlowAnalysis<P> createAnalysisForRecursion(Set<? extends ControlFlowNode> start) {
            return new ControlFlowAnalysis<P>(start, this.graphType);
        }

        ControlFlowAnalysis<P> visitRecursive(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.createAnalysisForRecursion(start);
            analysis.visit(toVisit, param, this.getCursor());
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringExit(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursive(start, toVisit, param);
            this.transferExit(analysis);
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringAll(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursiveTransferringExit(start, toVisit, param);
            this.transferContinueFlow(analysis);
            this.transferBreakFlow(analysis);
            return analysis;
        }

        void transferExit(ControlFlowAnalysis<P> analysis) {
            if (!analysis.exitFlow.isEmpty()) {
                this.exitFlow.addAll(analysis.exitFlow);
            }
        }

        void transferContinueFlow(ControlFlowAnalysis<P> analysis) {
            if (!analysis.continueFlow.isEmpty()) {
                this.continueFlow.addAll(analysis.continueFlow);
            }
        }

        void transferBreakFlow(ControlFlowAnalysis<P> analysis) {
            if (!analysis.breakFlow.isEmpty()) {
                this.breakFlow.addAll(analysis.breakFlow);
            }
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, P p) {
            this.addCursorToBasicBlock();
            this.visit(assignment.getAssignment(), p);
            this.visit(assignment.getVariable(), p);
            return assignment;
        }

        void visitStatementList(List<Statement> statements, P p) {
            for (Statement statement : statements) {
                ControlFlowAnalysis<P> analysis = this.visitRecursive(this.current, statement, p);
                this.current = analysis.current;
                this.continueFlow.addAll(analysis.continueFlow);
                this.breakFlow.addAll(analysis.breakFlow);
                this.exitFlow.addAll(analysis.exitFlow);
                if (!this.current.isEmpty() || !(statement instanceof J.Try)) continue;
                break;
            }
        }

        @Override
        public J.Block visitBlock(J.Block block, P p) {
            this.addCursorToBasicBlock();
            this.visitStatementList(block.getStatements(), p);
            if (this.methodEntryPoint) {
                ControlFlowNode.End end = ControlFlowNode.End.create(this.graphType);
                this.addSuccessorToCurrent(end);
                this.exitFlow.forEach(exit -> exit.addSuccessor(end));
                this.current = Collections.singleton(end);
            }
            return block;
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, P p) {
            this.addCursorToBasicBlock();
            this.visit(_sync.getLock(), p);
            this.visit(_sync.getBody(), p);
            return _sync;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
            this.visit(method.getSelect(), p);
            this.visit(method.getArguments(), p);
            this.addCursorToBasicBlock();
            return method;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, P p) {
            this.visit(newClass.getEnclosing(), p);
            this.visit(newClass.getArguments(), p);
            this.addCursorToBasicBlock();
            return newClass;
        }

        @Override
        public J.Literal visitLiteral(J.Literal literal, P p) {
            this.addCursorToBasicBlock();
            return literal;
        }

        @Override
        public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)parens.getTree(), p);
            return parens;
        }

        @Override
        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)controlParens.getTree(), p);
            return controlParens;
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
            this.visit(typeCast.getExpression(), p);
            this.addCursorToBasicBlock();
            return typeCast;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
            this.visit(multiVariable.getTypeExpression(), p);
            for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                this.visit(variable, p);
            }
            this.addCursorToBasicBlock();
            return multiVariable;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            this.visit(variable.getInitializer(), p);
            this.visit(variable.getName(), p);
            this.addCursorToBasicBlock();
            return variable;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, P p) {
            if (unary.getOperator() == J.Unary.Type.Not) {
                this.addCursorToBasicBlock();
                this.visit(unary.getExpression(), p);
                this.current.forEach(controlFlowNode -> {
                    if (controlFlowNode instanceof ControlFlowNode.BasicBlock) {
                        ControlFlowNode.BasicBlock basicBlock = (ControlFlowNode.BasicBlock)controlFlowNode;
                        basicBlock.invertNextConditional();
                    }
                });
            } else {
                this.visit(unary.getExpression(), p);
                this.addCursorToBasicBlock();
            }
            return unary;
        }

        @Override
        @SelfLoathing(name="Jonathan Leitschuh")
        public J.Switch visitSwitch(J.Switch _switch, P p) {
            this.addCursorToBasicBlock();
            this.visit(_switch.getSelector(), p);
            ControlFlowAnalysis analysis = new ControlFlowAnalysis<P>(this.current, this.graphType){
                private final Set<ControlFlowNode> caseFlow;
                {
                    super(current, graphType);
                    this.caseFlow = new HashSet<ControlFlowNode>();
                }

                @Override
                @SelfLoathing(name="Jonathan Leitschuh")
                ControlFlowAnalysis<P> createAnalysisForRecursion(Set<? extends ControlFlowNode> start) {
                    return new ControlFlowAnalysis<P>(start, graphType){

                        @Override
                        public J.Case visitCase(J.Case _case, P p) {
                            if (ControlFlowAnalysis.isDefaultCase(_case)) {
                                this.current = Stream.concat(this.current.stream(), caseFlow.stream()).collect(Collectors.toSet());
                                this.addCursorToBasicBlock();
                                return super.visitCase(_case, p);
                            }
                            this.addCursorToBasicBlock();
                            ControlFlowNode.ConditionNode conditionNode = this.currentAsBasicBlock().addConditionNodeTruthFirst();
                            this.current = Stream.concat(Stream.of(conditionNode), caseFlow.stream()).collect(Collectors.toSet());
                            caseFlow.clear();
                            switch (_case.getType()) {
                                case Statement: {
                                    if (_case.getStatements().isEmpty()) {
                                        this.visit(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), p);
                                        break;
                                    }
                                    this.visitStatementList(_case.getStatements(), p);
                                    break;
                                }
                                case Rule: {
                                    this.visit(_case.getBody(), p);
                                    this.breakFlow.add(this.currentAsBasicBlock());
                                    this.current = Collections.emptySet();
                                }
                            }
                            caseFlow.addAll(this.current);
                            this.current = Collections.singleton(conditionNode);
                            return _case;
                        }
                    };
                }
            };
            analysis.visit(_switch.getCases(), p, this.getCursor());
            this.transferContinueFlow(analysis);
            this.transferExit(analysis);
            this.current = Stream.concat(analysis.current.stream(), analysis.breakFlow.stream()).collect(Collectors.toSet());
            return _switch;
        }

        @Override
        public J.Case visitCase(J.Case _case, P p) {
            if (!ControlFlowAnalysis.isDefaultCase(_case)) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Case statements should be visited by the switch statement").addCursor(this.getCursor()));
            }
            return super.visitCase(_case, (Object)p);
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingTruthFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeTruthFirst();
            }).collect(Collectors.toSet());
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingFalseFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeFalseFirst();
            }).collect(Collectors.toSet());
        }

        private static ControlFlowNode.ConditionNode getControlFlowNodeMissingOneSuccessor(Set<ControlFlowNode.ConditionNode> nodes) {
            for (ControlFlowNode.ConditionNode node : nodes) {
                if (!(node.getTruthySuccessor() == null ^ node.getFalsySuccessor() == null)) continue;
                return node;
            }
            throw new IllegalArgumentException("No control flow node missing only one successor");
        }

        private static ControlFlowNode.ConditionNode getControlFlowNodeMissingBothSuccessors(Set<ControlFlowNode.ConditionNode> nodes) {
            for (ControlFlowNode.ConditionNode node : nodes) {
                if (node.getTruthySuccessor() != null || node.getFalsySuccessor() != null) continue;
                return node;
            }
            throw new IllegalArgumentException("No control flow node missing both successors");
        }

        private void visitBranching(BranchingAdapter branching, P p) {
            this.addCursorToBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursiveTransferringAll(this.current, branching.getCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> thenAnalysis = this.visitRecursiveTransferringAll(conditionNodes, branching.getTruePart(), p);
            Set<ControlFlowNode.ConditionNode> newCurrent = Collections.singleton(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes));
            if (branching.getFalsePart() != null) {
                ControlFlowAnalysis<P> elseAnalysis = this.visitRecursiveTransferringAll(newCurrent, branching.getFalsePart(), p);
                this.current = Stream.concat(thenAnalysis.current.stream(), elseAnalysis.current.stream()).collect(Collectors.toSet());
            } else {
                this.current = Stream.concat(newCurrent.stream(), thenAnalysis.current.stream()).collect(Collectors.toSet());
            }
        }

        @Override
        public J.Ternary visitTernary(J.Ternary ternary, P p) {
            this.visitBranching(BranchingAdapter.of(ternary), p);
            return ternary;
        }

        @Override
        public J.If visitIf(J.If iff, P p) {
            this.visitBranching(BranchingAdapter.of(iff), p);
            return iff;
        }

        @Override
        public J.If.Else visitElse(J.If.Else elze, P p) {
            this.addCursorToBasicBlock();
            this.visit(elze.getBody(), p);
            return elze;
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, P p) {
            if (J.Binary.Type.And.equals((Object)binary.getOperator())) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, binary.getRight(), p);
                this.current = Stream.concat(right.current.stream(), Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes))).collect(Collectors.toSet());
            } else if (J.Binary.Type.Or.equals((Object)binary.getOperator())) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingFalseFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, binary.getRight(), p);
                this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), right.current.stream()).collect(Collectors.toSet());
            } else {
                this.visit(binary.getLeft(), p);
                this.visit(binary.getRight(), p);
                this.addCursorToBasicBlock();
            }
            return binary;
        }

        @Override
        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, P p) {
            this.visit(instanceOf.getExpression(), p);
            this.addCursorToBasicBlock();
            return instanceOf;
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock basicBlock = this.newEmptyBasicBlockFromCurrent();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(Collections.singleton(basicBlock), doWhileLoop.getBody(), p);
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(bodyAnalysis.current, doWhileLoop.getWhileCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            conditionNodes.forEach(conditionNode -> {
                conditionNode.addSuccessor(basicBlock);
                bodyAnalysis.continueFlow.forEach(continueNode -> continueNode.addSuccessor(conditionNode));
            });
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return doWhileLoop;
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock entryBlock = this.currentAsBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(Collections.singleton(entryBlock), whileLoop.getCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(conditionNodes, whileLoop.getBody(), p);
            bodyAnalysis.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            bodyAnalysis.continueFlow.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return whileLoop;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
            this.addCursorToBasicBlock();
            final ControlFlowNode.BasicBlock[] entryBlock = new ControlFlowNode.BasicBlock[1];
            ControlFlowAnalysis controlAnalysisFirstBit = new ControlFlowAnalysis<P>(this.current, this.graphType){

                @Override
                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    this.visit(control.getInit(), p);
                    entryBlock[0] = this.currentAsBasicBlock();
                    Expression condition = control.getCondition() instanceof J.Empty ? ControlFlowAnalysis.trueLiteral() : control.getCondition();
                    ControlFlowAnalysis conditionAnalysis = this.visitRecursive(this.current, condition, p);
                    this.current = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
                    return control;
                }
            };
            controlAnalysisFirstBit.visit(forLoop.getControl(), p, this.getCursor());
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(controlAnalysisFirstBit.current, forLoop.getBody(), p);
            ControlFlowAnalysis controlAnalysisSecondBit = new ControlFlowAnalysis<P>(bodyAnalysis.current, this.graphType){

                @Override
                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    if (this.current.isEmpty()) {
                        this.current = Collections.singleton(ControlFlowNode.BasicBlock.create());
                    }
                    if (control.getUpdate().isEmpty() || control.getUpdate().get(0) instanceof J.Empty) {
                        this.visit(control.getUpdate(), p);
                        return control;
                    }
                    this.current = Collections.singleton(this.newEmptyBasicBlockFromCurrent());
                    this.visit(control.getUpdate(), p);
                    return control;
                }
            };
            controlAnalysisSecondBit.visit(forLoop.getControl(), p, this.getCursor());
            bodyAnalysis.continueFlow.forEach(continueControlFlowNode -> continueControlFlowNode.addSuccessor(entryBlock[0].getSuccessor()));
            controlAnalysisSecondBit.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock[0].getSuccessor()));
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingOneSuccessor(ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(controlAnalysisFirstBit.current))), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        private static J.Literal trueLiteral() {
            return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, true, "true", null, JavaType.Primitive.Boolean);
        }

        @Override
        @SelfLoathing(name="Jonathan Leitschuh")
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
            String iteratorVariableNumber = VariableNameUtils.generateVariableName(forLoop.getControl().getVariable().getVariables().get(0).getSimpleName() + "Iterator", this.getCursor(), VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
            JavaType controlLoopType = forLoop.getControl().getVariable().getVariables().get(0).getType();
            if (controlLoopType == null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("No type for for loop control variable").addCursor(this.getCursor()));
            }
            J.VariableDeclarations fakeIteratorAssignment = this.createFakeIteratorVariableDeclarations(iteratorVariableNumber, controlLoopType, forLoop);
            this.visit(fakeIteratorAssignment, p, this.getCursor());
            this.addCursorToBasicBlock();
            final J.MethodInvocation fakeConditionalMethod = this.createFakeConditionalMethod(fakeIteratorAssignment.getVariables().get(0).getName(), forLoop.getControl().getIterable());
            ControlFlowAnalysis controlAnalysis = new ControlFlowAnalysis<P>(this.current, this.graphType){

                @Override
                public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
                    this.addCursorToBasicBlock();
                    this.visit(control.getVariable(), p);
                    this.visit(fakeConditionalMethod, p);
                    return control;
                }
            };
            controlAnalysis.visit(forLoop.getControl(), p, this.getCursor());
            ControlFlowNode.ConditionNode conditionalEntry = controlAnalysis.currentAsBasicBlock().addConditionNodeTruthFirst();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(Collections.singleton(conditionalEntry), forLoop.getBody(), p);
            bodyAnalysis.continueFlow.forEach(continueFlowNode -> continueFlowNode.addSuccessor(conditionalEntry));
            bodyAnalysis.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(conditionalEntry));
            this.current = Stream.concat(Stream.of(conditionalEntry), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        private J.VariableDeclarations createFakeIteratorVariableDeclarations(String variableName, JavaType iteratorType, J.ForEachLoop forLoop) {
            Expression iterable = forLoop.getControl().getIterable();
            String type = iteratorType instanceof JavaType.Primitive ? ((JavaType.Primitive)iteratorType).getClassName() : iteratorType.toString();
            Supplier<Cursor> cursorSupplier = () -> this.getCursor().dropParentUntil(J.Block.class::isInstance);
            JavaTemplate fakeIterableVariableTemplate = iterable.getType() instanceof JavaType.Array ? JavaTemplate.builder(cursorSupplier, "final Iterator<" + type + "> " + variableName + " = Arrays.stream(#{anyArray()}).iterator();").imports("java.util.Arrays").build() : JavaTemplate.builder(cursorSupplier, "final Iterator<" + type + "> " + variableName + " = #{any(java.lang.Iterable)}.iterator();").build();
            J.Block block = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
            if (block == null) {
                throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unable to create new J.VariableDeclarations, couldn't find an outer J.Block").addCursor(this.getCursor()));
            }
            J.Label maybeParentLabel = (J.Label)this.getCursor().firstEnclosing(J.Label.class);
            JavaCoordinates coordinates = maybeParentLabel != null && maybeParentLabel.getStatement() == forLoop ? maybeParentLabel.getCoordinates().before() : forLoop.getCoordinates().before();
            J.Block newFakeBlock = (J.Block)block.withTemplate(fakeIterableVariableTemplate, coordinates, iterable);
            for (Statement statement : newFakeBlock.getStatements()) {
                J.VariableDeclarations maybeNewDeclaration;
                if (!(statement instanceof J.VariableDeclarations) || !(maybeNewDeclaration = (J.VariableDeclarations)statement).getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).anyMatch(name -> name.equals(variableName))) continue;
                return maybeNewDeclaration;
            }
            throw new ControlFlowIllegalStateException(ControlFlowIllegalStateException.exceptionMessageBuilder("Unable to create new J.VariableDeclarations with name `" + variableName + "`").addCursor(this.getCursor()));
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        protected J.MethodInvocation createFakeConditionalMethod(J.Identifier iteratorIdentifier, Expression iterable) {
            JavaTemplate fakeConditionalTemplate = JavaTemplate.builder(() -> ((ControlFlowAnalysis)this).getCursor(), "#{any(java.util.Iterator)}.hasNext()").build();
            JavaCoordinates coordinates = iterable.getCoordinates().replace();
            J.MethodInvocation fakeConditional = (J.MethodInvocation)iterable.withTemplate(fakeConditionalTemplate, coordinates, iteratorIdentifier);
            if (iterable == fakeConditional) {
                throw new IllegalStateException("Failed to create a fake conditional!");
            }
            return fakeConditional;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, P p) {
            this.addCursorToBasicBlock();
            return identifier;
        }

        @Override
        public J.Assert visitAssert(J.Assert _assert, P p) {
            this.visit(_assert.getCondition(), p);
            if (_assert.getDetail() != null) {
                this.visit(_assert.getDetail().getElement(), p);
            }
            this.addCursorToBasicBlock();
            return _assert;
        }

        @Override
        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
            this.addCursorToBasicBlock();
            return arrayAccess;
        }

        @Override
        public J.Try visitTry(J.Try _try, P p) {
            this.addCursorToBasicBlock();
            this.visit(_try.getResources(), p);
            if (_try.getFinally() == null) {
                this.visit(_try.getBody(), p);
            } else {
                ControlFlowAnalysis<P> tryBodyAnalysis = new ControlFlowAnalysis<P>(this.current, this.graphType);
                tryBodyAnalysis.visit(_try.getBody(), p, this.getCursor());
                if (!tryBodyAnalysis.current.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromCurrent = this.visitRecursiveTransferringAll(tryBodyAnalysis.current, _try.getFinally(), p);
                    this.current = finallyAnalysisFromCurrent.current;
                } else {
                    this.current = Collections.emptySet();
                }
                if (!tryBodyAnalysis.exitFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromExitFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.exitFlow, _try.getFinally(), p);
                    this.exitFlow.addAll(finallyAnalysisFromExitFlow.current);
                }
                if (!tryBodyAnalysis.breakFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromBreakFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.breakFlow, _try.getFinally(), p);
                    this.breakFlow.addAll(finallyAnalysisFromBreakFlow.current);
                }
                if (!tryBodyAnalysis.continueFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromContinueFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.continueFlow, _try.getFinally(), p);
                    this.continueFlow.addAll(finallyAnalysisFromContinueFlow.current);
                }
            }
            return _try;
        }

        @Override
        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, P p) {
            this.visit(tryResource.getVariableDeclarations(), p);
            return tryResource;
        }

        @Override
        public J.Lambda visitLambda(J.Lambda lambda, P p) {
            this.addCursorToBasicBlock();
            if (lambda.getBody() instanceof J.Block) {
                ControlFlowSimpleSummary summary = ControlFlow.findControlFlowInternal(new Cursor(this.getCursor(), (Object)lambda.getBody()), ControlFlowNode.GraphType.LAMBDA);
                this.currentAsBasicBlock().addSuccessor(summary.start);
                this.current = Collections.singleton(summary.end);
                return lambda;
            }
            return super.visitLambda(lambda, (Object)p);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
            this.addCursorToBasicBlock();
            return classDecl;
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, P p) {
            J.MethodInvocation parent = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
            if (parent != null && parent.getArguments().contains(empty)) {
                return empty;
            }
            this.addCursorToBasicBlock();
            return super.visitEmpty(empty, (Object)p);
        }

        @Override
        public J.Return visitReturn(J.Return _return, P p) {
            this.visit(_return.getExpression(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return _return;
        }

        @Override
        public J.Throw visitThrow(J.Throw thrown, P p) {
            this.visit(thrown.getException(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return thrown;
        }

        @Override
        public J.Continue visitContinue(J.Continue continueStatement, P p) {
            this.addCursorToBasicBlock();
            this.continueFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return continueStatement;
        }

        @Override
        public J.Break visitBreak(J.Break breakStatement, P p) {
            this.addCursorToBasicBlock();
            this.breakFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return breakStatement;
        }

        private static ControlFlowNode.BasicBlock addBasicBlock(Collection<ControlFlowNode> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalStateException("No nodes to add to a basic block!");
            }
            Iterator<ControlFlowNode> cfnIterator = nodes.iterator();
            ControlFlowNode.BasicBlock basicBlock = cfnIterator.next().addBasicBlock();
            while (cfnIterator.hasNext()) {
                cfnIterator.next().addSuccessor(basicBlock);
            }
            return basicBlock;
        }

        private static boolean isDefaultCase(J.Case _case) {
            List<Expression> expressions = _case.getExpressions();
            return expressions.size() == 1 && expressions.get(0) instanceof J.Identifier && "default".equals(((J.Identifier)expressions.get(0)).getSimpleName());
        }

        private static interface BranchingAdapter {
            public Expression getCondition();

            public J getTruePart();

            @Nullable
            public J getFalsePart();

            public static BranchingAdapter of(final J.If ifStatement) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ifStatement.getIfCondition();
                    }

                    @Override
                    public J getTruePart() {
                        return ifStatement.getThenPart();
                    }

                    @Override
                    @Nullable
                    public J getFalsePart() {
                        return ifStatement.getElsePart();
                    }
                };
            }

            public static BranchingAdapter of(final J.Ternary ternary) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ternary.getCondition();
                    }

                    @Override
                    public J getTruePart() {
                        return ternary.getTruePart();
                    }

                    @Override
                    public J getFalsePart() {
                        return ternary.getFalsePart();
                    }
                };
            }
        }
    }
}

