/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class PublicGetVisitor
extends Recipe {
    private static final MethodMatcher getVisitor = new MethodMatcher("org.openrewrite.Recipe getVisitor()", true);

    public String getDisplayName() {
        return "Make all `Recipe#getVisitor()` methods public";
    }

    public String getDescription() {
        return "It would be a breaking API change to increase the visibility of the method by default, but any recipe can increase visibility of the `Recipe` class. Making them public makes recipes easier to use in other recipes in unexpected ways.";
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
                for (JavaType.Method type : cu.getTypesInUse().getDeclaredMethods()) {
                    if (!getVisitor.matches(type)) continue;
                    return (J)SearchResult.found((Tree)cu);
                }
                return cu;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J m = super.visitMethodDeclaration(method, ctx);
                if (getVisitor.matches(method, (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)) && J.Modifier.hasModifier(((J.MethodDeclaration)m).getModifiers(), J.Modifier.Type.Protected)) {
                    m = ((J.MethodDeclaration)m).withModifiers(ListUtils.map(((J.MethodDeclaration)m).getModifiers(), mod -> mod.getType() == J.Modifier.Type.Protected ? mod.withType(J.Modifier.Type.Public) : mod));
                }
                return m;
            }
        };
    }
}

