/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;

@Incubating(since="7.21.0")
public class RemoveUnneededBlock
extends Recipe {
    public String getDisplayName() {
        return "Remove unneeded block";
    }

    public String getDescription() {
        return "Flatten blocks into inline statements when possible.";
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new RemoveUnneededBlockStatementVisitor();
    }

    static class RemoveUnneededBlockStatementVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        RemoveUnneededBlockStatementVisitor() {
        }

        @Override
        public J.Block visitBlock(J.Block block, ExecutionContext executionContext) {
            J.NewClass newClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
            J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            J directParent = (J)this.getCursor().getParentTreeCursor().getValue();
            J bl = super.visitBlock(block, executionContext);
            if (classDeclaration == directParent || newClass == directParent) {
                return bl;
            }
            return block.withStatements(ListUtils.flatMap(((J.Block)bl).getStatements(), stmt -> {
                if (!(stmt instanceof J.Block)) {
                    return stmt;
                }
                J.Block nested = (J.Block)stmt;
                return ListUtils.map(nested.getStatements(), inlinedStmt -> this.maybeAutoFormat(stmt, inlinedStmt, executionContext, this.getCursor()));
            }));
        }
    }
}

