/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.LoathingOfOthers;
import org.openrewrite.internal.SelfLoathing;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.template.Coordinates;
import org.openrewrite.template.SourceTemplate;

public interface J
extends Tree {
    public static void clearCaches() {
        JavaTemplateParser.clearCache();
    }

    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJava((JavaVisitor)v.adapt(JavaVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JavaVisitor.class);
    }

    @Nullable
    default public <P> J acceptJava(JavaVisitor<P> v, P p) {
        return (J)v.defaultValue(this, p);
    }

    public <J2 extends J> J2 withPrefix(Space var1);

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    default public <J2 extends J> J2 withComments(List<Comment> comments) {
        return this.withPrefix(this.getPrefix().withComments(comments));
    }

    @Incubating(since="7.0.0")
    default public <J2 extends J> J2 withTemplate(SourceTemplate<J, JavaCoordinates> template, JavaCoordinates coordinates, Object ... parameters) {
        return (J2)((J)template.withTemplate((Tree)this, (Coordinates)coordinates, parameters));
    }

    @Deprecated
    default public String print() {
        PrintOutputCapture outputCapture = new PrintOutputCapture((Object)0);
        new JavaPrinter().visit(this, outputCapture);
        return outputCapture.getOut();
    }

    @Deprecated
    default public String printTrimmed() {
        return StringUtils.trimIndent((String)this.print());
    }

    public static final class Yield
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final boolean implicit;
        private final Expression value;

        @Override
        public CoordinateBuilder.Yield getCoordinates() {
            return new CoordinateBuilder.Yield(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitYield(this, p);
        }

        public Yield(UUID id, Space prefix, Markers markers, boolean implicit, Expression value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.implicit = implicit;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public Expression getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "J.Yield(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", implicit=" + this.isImplicit() + ", value=" + this.getValue() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Yield)) {
                return false;
            }
            Yield other = (Yield)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Yield withId(UUID id) {
            return this.id == id ? this : new Yield(id, this.prefix, this.markers, this.implicit, this.value);
        }

        @NonNull
        public Yield withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Yield(this.id, prefix, this.markers, this.implicit, this.value);
        }

        @NonNull
        public Yield withMarkers(Markers markers) {
            return this.markers == markers ? this : new Yield(this.id, this.prefix, markers, this.implicit, this.value);
        }

        @NonNull
        public Yield withImplicit(boolean implicit) {
            return this.implicit == implicit ? this : new Yield(this.id, this.prefix, this.markers, implicit, this.value);
        }

        @NonNull
        public Yield withValue(Expression value) {
            return this.value == value ? this : new Yield(this.id, this.prefix, this.markers, this.implicit, value);
        }
    }

    public static final class Wildcard
    implements J,
    Expression,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JLeftPadded<Bound> bound;
        @Nullable
        private final NameTree boundedType;

        @Nullable
        public Bound getBound() {
            return this.bound == null ? null : this.bound.getElement();
        }

        public Wildcard withBound(@Nullable Bound bound) {
            return this.getPadding().withBound(JLeftPadded.withElement(this.bound, bound));
        }

        @Override
        public JavaType getType() {
            return null;
        }

        public Wildcard withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Wildcard)) {
                return false;
            }
            Wildcard other = (Wildcard)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Wildcard(UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        private Wildcard(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<Bound> bound, @Nullable NameTree boundedType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.bound = bound;
            this.boundedType = boundedType;
        }

        @NonNull
        public Wildcard withId(UUID id) {
            return this.id == id ? this : new Wildcard(this.padding, id, this.prefix, this.markers, this.bound, this.boundedType);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Wildcard withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Wildcard(this.padding, this.id, prefix, this.markers, this.bound, this.boundedType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Wildcard withMarkers(Markers markers) {
            return this.markers == markers ? this : new Wildcard(this.padding, this.id, this.prefix, markers, this.bound, this.boundedType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Wildcard withBoundedType(@Nullable NameTree boundedType) {
            return this.boundedType == boundedType ? this : new Wildcard(this.padding, this.id, this.prefix, this.markers, this.bound, boundedType);
        }

        @Nullable
        public NameTree getBoundedType() {
            return this.boundedType;
        }

        public static enum Bound {
            Extends,
            Super;

        }

        public static class Padding {
            private final Wildcard t;

            @Nullable
            public JLeftPadded<Bound> getBound() {
                return this.t.bound;
            }

            public Wildcard withBound(@Nullable JLeftPadded<Bound> bound) {
                return this.t.bound == bound ? this.t : new Wildcard(this.t.id, this.t.prefix, this.t.markers, bound, this.t.boundedType);
            }

            public Padding(Wildcard t) {
                this.t = t;
            }
        }
    }

    public static final class WhileLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> condition;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public WhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitWhileLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.WhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", condition=" + this.getCondition() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhileLoop)) {
                return false;
            }
            WhileLoop other = (WhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public WhileLoop(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        private WhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> condition, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.body = body;
        }

        @NonNull
        public WhileLoop withId(UUID id) {
            return this.id == id ? this : new WhileLoop(this.padding, id, this.prefix, this.markers, this.condition, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public WhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WhileLoop(this.padding, this.id, prefix, this.markers, this.condition, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public WhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new WhileLoop(this.padding, this.id, this.prefix, markers, this.condition, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public WhileLoop withCondition(ControlParentheses<Expression> condition) {
            return this.condition == condition ? this : new WhileLoop(this.padding, this.id, this.prefix, this.markers, condition, this.body);
        }

        public ControlParentheses<Expression> getCondition() {
            return this.condition;
        }

        public static class Padding {
            private final WhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public WhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new WhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.condition, body);
            }

            public Padding(WhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class VariableDeclarations
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeTree typeExpression;
        @Nullable
        private final Space varargs;
        private final List<JLeftPadded<Space>> dimensionsBeforeName;
        private final List<JRightPadded<NamedVariable>> variables;

        public List<NamedVariable> getVariables() {
            return JRightPadded.getElements(this.variables);
        }

        public VariableDeclarations withVariables(List<NamedVariable> vars) {
            return this.getPadding().withVariables(JRightPadded.withElements(this.variables, vars));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitVariableDeclarations(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.VariableDeclarations getCoordinates() {
            return new CoordinateBuilder.VariableDeclarations(this);
        }

        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeExpression != null && this.typeExpression instanceof AnnotatedType) {
                allAnnotations.addAll(((AnnotatedType)this.typeExpression).getAnnotations());
            }
            return allAnnotations;
        }

        @Nullable
        public JavaType.FullyQualified getTypeAsFullyQualified() {
            return this.typeExpression == null ? null : TypeUtils.asFullyQualified(this.typeExpression.getType());
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.typeExpression == null ? null : this.typeExpression.getType();
        }

        public VariableDeclarations withType(@Nullable JavaType type) {
            return this.typeExpression == null ? this : this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableDeclarations)) {
                return false;
            }
            VariableDeclarations other = (VariableDeclarations)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public VariableDeclarations(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        private VariableDeclarations(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeTree typeExpression, @Nullable Space varargs, List<JLeftPadded<Space>> dimensionsBeforeName, List<JRightPadded<NamedVariable>> variables) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.varargs = varargs;
            this.dimensionsBeforeName = dimensionsBeforeName;
            this.variables = variables;
        }

        @NonNull
        public VariableDeclarations withId(UUID id) {
            return this.id == id ? this : new VariableDeclarations(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public VariableDeclarations withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableDeclarations(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public VariableDeclarations withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public VariableDeclarations withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        public VariableDeclarations withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public VariableDeclarations withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeExpression, this.varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public VariableDeclarations withVarargs(@Nullable Space varargs) {
            return this.varargs == varargs ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, varargs, this.dimensionsBeforeName, this.variables);
        }

        @Nullable
        public Space getVarargs() {
            return this.varargs;
        }

        @NonNull
        public VariableDeclarations withDimensionsBeforeName(List<JLeftPadded<Space>> dimensionsBeforeName) {
            return this.dimensionsBeforeName == dimensionsBeforeName ? this : new VariableDeclarations(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.varargs, dimensionsBeforeName, this.variables);
        }

        public List<JLeftPadded<Space>> getDimensionsBeforeName() {
            return this.dimensionsBeforeName;
        }

        public static class Padding {
            private final VariableDeclarations t;

            public List<JRightPadded<NamedVariable>> getVariables() {
                return this.t.variables;
            }

            public VariableDeclarations withVariables(List<JRightPadded<NamedVariable>> variables) {
                return this.t.variables == variables ? this.t : new VariableDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, this.t.varargs, this.t.dimensionsBeforeName, variables);
            }

            public Padding(VariableDeclarations t) {
                this.t = t;
            }
        }

        public static final class NamedVariable
        implements J,
        NameTree {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Identifier name;
            private final List<JLeftPadded<Space>> dimensionsAfterName;
            @Nullable
            private final JLeftPadded<Expression> initializer;
            @Nullable
            private final JavaType.Variable variableType;

            @Nullable
            public Expression getInitializer() {
                return this.initializer == null ? null : this.initializer.getElement();
            }

            public NamedVariable withInitializer(@Nullable Expression initializer) {
                if (initializer == null) {
                    return this.initializer == null ? this : new NamedVariable(this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, null, this.variableType);
                }
                return this.getPadding().withInitializer(JLeftPadded.withElement(this.initializer, initializer));
            }

            @Override
            public JavaType getType() {
                return this.variableType != null ? this.variableType.getType() : null;
            }

            public NamedVariable withType(@Nullable JavaType type) {
                return this.variableType != null ? this.withVariableType(this.variableType.withType(type)) : this;
            }

            public String getSimpleName() {
                return this.name.getSimpleName();
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitVariable(this, p);
            }

            public boolean isField(Cursor cursor) {
                return cursor.getParentOrThrow().getParentOrThrow().getParentOrThrow().getParentOrThrow().getParentOrThrow().getValue() instanceof ClassDeclaration;
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NamedVariable)) {
                    return false;
                }
                NamedVariable other = (NamedVariable)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public NamedVariable(UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType.Variable variableType) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            private NamedVariable(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Identifier name, List<JLeftPadded<Space>> dimensionsAfterName, @Nullable JLeftPadded<Expression> initializer, @Nullable JavaType.Variable variableType) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.dimensionsAfterName = dimensionsAfterName;
                this.initializer = initializer;
                this.variableType = variableType;
            }

            @NonNull
            public NamedVariable withId(UUID id) {
                return this.id == id ? this : new NamedVariable(this.padding, id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public NamedVariable withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new NamedVariable(this.padding, this.id, prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public NamedVariable withMarkers(Markers markers) {
                return this.markers == markers ? this : new NamedVariable(this.padding, this.id, this.prefix, markers, this.name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            public NamedVariable withName(Identifier name) {
                return this.name == name ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, name, this.dimensionsAfterName, this.initializer, this.variableType);
            }

            public Identifier getName() {
                return this.name;
            }

            @NonNull
            public NamedVariable withDimensionsAfterName(List<JLeftPadded<Space>> dimensionsAfterName) {
                return this.dimensionsAfterName == dimensionsAfterName ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, dimensionsAfterName, this.initializer, this.variableType);
            }

            public List<JLeftPadded<Space>> getDimensionsAfterName() {
                return this.dimensionsAfterName;
            }

            @NonNull
            public NamedVariable withVariableType(@Nullable JavaType.Variable variableType) {
                return this.variableType == variableType ? this : new NamedVariable(this.padding, this.id, this.prefix, this.markers, this.name, this.dimensionsAfterName, this.initializer, variableType);
            }

            @Nullable
            public JavaType.Variable getVariableType() {
                return this.variableType;
            }

            public static class Padding {
                private final NamedVariable t;

                @Nullable
                public JLeftPadded<Expression> getInitializer() {
                    return this.t.initializer;
                }

                public NamedVariable withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                    return this.t.initializer == initializer ? this.t : new NamedVariable(this.t.id, this.t.prefix, this.t.markers, this.t.name, this.t.dimensionsAfterName, initializer, this.t.variableType);
                }

                public Padding(NamedVariable t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Unary
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Type> operator;
        private final Expression expression;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Unary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitUnary(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.expression.getSideEffects();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary other = (Unary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unary(UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        private Unary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Type> operator, Expression expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        public Unary withId(UUID id) {
            return this.id == id ? this : new Unary(this.padding, id, this.prefix, this.markers, this.operator, this.expression, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Unary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unary(this.padding, this.id, prefix, this.markers, this.operator, this.expression, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Unary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unary(this.padding, this.id, this.prefix, markers, this.operator, this.expression, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Unary withExpression(Expression expression) {
            return this.expression == expression ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, expression, this.type);
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public Unary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Unary(this.padding, this.id, this.prefix, this.markers, this.operator, this.expression, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static enum Type {
            PreIncrement,
            PreDecrement,
            PostIncrement,
            PostDecrement,
            Positive,
            Negative,
            Complement,
            Not;

        }

        public static class Padding {
            private final Unary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Unary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Unary(this.t.id, this.t.prefix, this.t.markers, operator, this.t.expression, this.t.type);
            }

            public Padding(Unary t) {
                this.t = t;
            }
        }
    }

    public static final class TypeParameters
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final List<JRightPadded<TypeParameter>> typeParameters;

        public List<TypeParameter> getTypeParameters() {
            return JRightPadded.getElements(this.typeParameters);
        }

        public TypeParameters withTypeParameters(List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JRightPadded.withElements(this.typeParameters, typeParameters));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameters)) {
                return false;
            }
            TypeParameters other = (TypeParameters)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeParameters(UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<JRightPadded<TypeParameter>> typeParameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeParameters = typeParameters;
        }

        private TypeParameters(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, List<JRightPadded<TypeParameter>> typeParameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeParameters = typeParameters;
        }

        @NonNull
        public TypeParameters withId(UUID id) {
            return this.id == id ? this : new TypeParameters(this.padding, id, this.prefix, this.markers, this.annotations, this.typeParameters);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public TypeParameters withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameters(this.padding, this.id, prefix, this.markers, this.annotations, this.typeParameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public TypeParameters withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameters(this.padding, this.id, this.prefix, markers, this.annotations, this.typeParameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public TypeParameters withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameters(this.padding, this.id, this.prefix, this.markers, annotations, this.typeParameters);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public static class Padding {
            private final TypeParameters t;

            public List<JRightPadded<TypeParameter>> getTypeParameters() {
                return this.t.typeParameters;
            }

            public TypeParameters withTypeParameters(List<JRightPadded<TypeParameter>> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new TypeParameters(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, typeParameters);
            }

            public Padding(TypeParameters t) {
                this.t = t;
            }
        }
    }

    public static final class TypeParameter
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Expression name;
        @Nullable
        private final JContainer<TypeTree> bounds;

        @Nullable
        public List<TypeTree> getBounds() {
            return this.bounds == null ? null : this.bounds.getElements();
        }

        public TypeParameter withBounds(@Nullable List<TypeTree> bounds) {
            return this.getPadding().withBounds(JContainer.withElementsNullable(this.bounds, bounds));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeParameter(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.TypeParameter(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", bounds=" + this.getBounds() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeParameter)) {
                return false;
            }
            TypeParameter other = (TypeParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeParameter(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
        }

        private TypeParameter(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<Annotation> annotations, Expression name, @Nullable JContainer<TypeTree> bounds) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.bounds = bounds;
        }

        @NonNull
        public TypeParameter withId(UUID id) {
            return this.id == id ? this : new TypeParameter(this.padding, id, this.prefix, this.markers, this.annotations, this.name, this.bounds);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public TypeParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeParameter(this.padding, this.id, prefix, this.markers, this.annotations, this.name, this.bounds);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public TypeParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeParameter(this.padding, this.id, this.prefix, markers, this.annotations, this.name, this.bounds);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public TypeParameter withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, annotations, this.name, this.bounds);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public TypeParameter withName(Expression name) {
            return this.name == name ? this : new TypeParameter(this.padding, this.id, this.prefix, this.markers, this.annotations, name, this.bounds);
        }

        public Expression getName() {
            return this.name;
        }

        public static class Padding {
            private final TypeParameter t;

            @Nullable
            public JContainer<TypeTree> getBounds() {
                return this.t.bounds;
            }

            public TypeParameter withBounds(@Nullable JContainer<TypeTree> bounds) {
                return this.t.bounds == bounds ? this.t : new TypeParameter(this.t.id, this.t.prefix, this.t.markers, this.t.annotations, this.t.name, bounds);
            }

            public Padding(TypeParameter t) {
                this.t = t;
            }
        }
    }

    public static final class TypeCast
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<TypeTree> clazz;
        private final Expression expression;

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public TypeCast withType(@Nullable JavaType type) {
            return this.withClazz((ControlParentheses<TypeTree>)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTypeCast(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeCast)) {
                return false;
            }
            TypeCast other = (TypeCast)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public TypeCast(UUID id, Space prefix, Markers markers, ControlParentheses<TypeTree> clazz, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<TypeTree> getClazz() {
            return this.clazz;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public TypeCast withId(UUID id) {
            return this.id == id ? this : new TypeCast(id, this.prefix, this.markers, this.clazz, this.expression);
        }

        @NonNull
        public TypeCast withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeCast(this.id, prefix, this.markers, this.clazz, this.expression);
        }

        @NonNull
        public TypeCast withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeCast(this.id, this.prefix, markers, this.clazz, this.expression);
        }

        @NonNull
        public TypeCast withClazz(ControlParentheses<TypeTree> clazz) {
            return this.clazz == clazz ? this : new TypeCast(this.id, this.prefix, this.markers, clazz, this.expression);
        }

        @NonNull
        public TypeCast withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeCast(this.id, this.prefix, this.markers, this.clazz, expression);
        }
    }

    public static final class Try
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JContainer<Resource> resources;
        private final Block body;
        private final List<Catch> catches;
        @Nullable
        private final JLeftPadded<Block> finallie;

        @Nullable
        public List<Resource> getResources() {
            return this.resources == null ? null : this.resources.getElements();
        }

        public Try withResources(@Nullable List<Resource> resources) {
            return this.getPadding().withResources(JContainer.withElementsNullable(this.resources, resources));
        }

        @Nullable
        public Block getFinally() {
            return this.finallie == null ? null : this.finallie.getElement();
        }

        public Try withFinally(@Nullable Block finallie) {
            return this.getPadding().withFinally(JLeftPadded.withElement(this.finallie, finallie));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTry(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.Try(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", resources=" + this.getResources() + ", body=" + this.getBody() + ", catches=" + this.getCatches() + ", finallie=" + this.finallie + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Try)) {
                return false;
            }
            Try other = (Try)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Try(UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        private Try(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JContainer<Resource> resources, Block body, List<Catch> catches, @Nullable JLeftPadded<Block> finallie) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.resources = resources;
            this.body = body;
            this.catches = catches;
            this.finallie = finallie;
        }

        @NonNull
        public Try withId(UUID id) {
            return this.id == id ? this : new Try(this.padding, id, this.prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Try withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Try(this.padding, this.id, prefix, this.markers, this.resources, this.body, this.catches, this.finallie);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Try withMarkers(Markers markers) {
            return this.markers == markers ? this : new Try(this.padding, this.id, this.prefix, markers, this.resources, this.body, this.catches, this.finallie);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Try withBody(Block body) {
            return this.body == body ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, body, this.catches, this.finallie);
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public Try withCatches(List<Catch> catches) {
            return this.catches == catches ? this : new Try(this.padding, this.id, this.prefix, this.markers, this.resources, this.body, catches, this.finallie);
        }

        public List<Catch> getCatches() {
            return this.catches;
        }

        public static class Padding {
            private final Try t;

            @Nullable
            public JContainer<Resource> getResources() {
                return this.t.resources;
            }

            public Try withResources(@Nullable JContainer<Resource> resources) {
                return this.t.resources == resources ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, resources, this.t.body, this.t.catches, this.t.finallie);
            }

            @Nullable
            public JLeftPadded<Block> getFinally() {
                return this.t.finallie;
            }

            public Try withFinally(@Nullable JLeftPadded<Block> finallie) {
                return this.t.finallie == finallie ? this.t : new Try(this.t.id, this.t.prefix, this.t.markers, this.t.resources, this.t.body, this.t.catches, finallie);
            }

            public Padding(Try t) {
                this.t = t;
            }
        }

        public static final class Catch
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final ControlParentheses<VariableDeclarations> parameter;
            private final Block body;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitCatch(this, p);
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Catch)) {
                    return false;
                }
                Catch other = (Catch)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Catch(UUID id, Space prefix, Markers markers, ControlParentheses<VariableDeclarations> parameter, Block body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parameter = parameter;
                this.body = body;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public ControlParentheses<VariableDeclarations> getParameter() {
                return this.parameter;
            }

            public Block getBody() {
                return this.body;
            }

            @NonNull
            public Catch withId(UUID id) {
                return this.id == id ? this : new Catch(id, this.prefix, this.markers, this.parameter, this.body);
            }

            @NonNull
            public Catch withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Catch(this.id, prefix, this.markers, this.parameter, this.body);
            }

            @NonNull
            public Catch withMarkers(Markers markers) {
                return this.markers == markers ? this : new Catch(this.id, this.prefix, markers, this.parameter, this.body);
            }

            @NonNull
            public Catch withParameter(ControlParentheses<VariableDeclarations> parameter) {
                return this.parameter == parameter ? this : new Catch(this.id, this.prefix, this.markers, parameter, this.body);
            }

            @NonNull
            public Catch withBody(Block body) {
                return this.body == body ? this : new Catch(this.id, this.prefix, this.markers, this.parameter, body);
            }
        }

        public static final class Resource
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final TypedTree variableDeclarations;
            private final boolean terminatedWithSemicolon;

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitTryResource(this, p);
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resource)) {
                    return false;
                }
                Resource other = (Resource)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Resource(UUID id, Space prefix, Markers markers, TypedTree variableDeclarations, boolean terminatedWithSemicolon) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variableDeclarations = variableDeclarations;
                this.terminatedWithSemicolon = terminatedWithSemicolon;
            }

            public UUID getId() {
                return this.id;
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public TypedTree getVariableDeclarations() {
                return this.variableDeclarations;
            }

            public boolean isTerminatedWithSemicolon() {
                return this.terminatedWithSemicolon;
            }

            @NonNull
            public String toString() {
                return "J.Try.Resource(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variableDeclarations=" + this.getVariableDeclarations() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
            }

            @NonNull
            public Resource withId(UUID id) {
                return this.id == id ? this : new Resource(id, this.prefix, this.markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Resource(this.id, prefix, this.markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withMarkers(Markers markers) {
                return this.markers == markers ? this : new Resource(this.id, this.prefix, markers, this.variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withVariableDeclarations(TypedTree variableDeclarations) {
                return this.variableDeclarations == variableDeclarations ? this : new Resource(this.id, this.prefix, this.markers, variableDeclarations, this.terminatedWithSemicolon);
            }

            @NonNull
            public Resource withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
                return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new Resource(this.id, this.prefix, this.markers, this.variableDeclarations, terminatedWithSemicolon);
            }
        }
    }

    public static final class Throw
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression exception;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitThrow(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Throw(UUID id, Space prefix, Markers markers, Expression exception) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exception = exception;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getException() {
            return this.exception;
        }

        @NonNull
        public Throw withId(UUID id) {
            return this.id == id ? this : new Throw(id, this.prefix, this.markers, this.exception);
        }

        @NonNull
        public Throw withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Throw(this.id, prefix, this.markers, this.exception);
        }

        @NonNull
        public Throw withMarkers(Markers markers) {
            return this.markers == markers ? this : new Throw(this.id, this.prefix, markers, this.exception);
        }

        @NonNull
        public Throw withException(Expression exception) {
            return this.exception == exception ? this : new Throw(this.id, this.prefix, this.markers, exception);
        }
    }

    public static final class Ternary
    implements J,
    Expression,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        private final JLeftPadded<Expression> truePart;
        private final JLeftPadded<Expression> falsePart;
        @Nullable
        private final JavaType type;

        public Expression getTruePart() {
            return this.truePart.getElement();
        }

        public Ternary withTruePart(Expression truePart) {
            return this.getPadding().withTruePart(this.truePart.withElement(truePart));
        }

        public Expression getFalsePart() {
            return this.falsePart.getElement();
        }

        public Ternary withFalsePart(Expression falsePart) {
            return this.getPadding().withFalsePart(this.falsePart.withElement(falsePart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitTernary(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ternary)) {
                return false;
            }
            Ternary other = (Ternary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Ternary(UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        private Ternary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression condition, JLeftPadded<Expression> truePart, JLeftPadded<Expression> falsePart, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.truePart = truePart;
            this.falsePart = falsePart;
            this.type = type;
        }

        @NonNull
        public Ternary withId(UUID id) {
            return this.id == id ? this : new Ternary(this.padding, id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Ternary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Ternary(this.padding, this.id, prefix, this.markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Ternary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ternary(this.padding, this.id, this.prefix, markers, this.condition, this.truePart, this.falsePart, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Ternary withCondition(Expression condition) {
            return this.condition == condition ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, condition, this.truePart, this.falsePart, this.type);
        }

        public Expression getCondition() {
            return this.condition;
        }

        @NonNull
        public Ternary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Ternary(this.padding, this.id, this.prefix, this.markers, this.condition, this.truePart, this.falsePart, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Ternary t;

            public JLeftPadded<Expression> getTruePart() {
                return this.t.truePart;
            }

            public Ternary withTruePart(JLeftPadded<Expression> truePart) {
                return this.t.truePart == truePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, truePart, this.t.falsePart, this.t.type);
            }

            public JLeftPadded<Expression> getFalsePart() {
                return this.t.falsePart;
            }

            public Ternary withFalsePart(JLeftPadded<Expression> falsePart) {
                return this.t.falsePart == falsePart ? this.t : new Ternary(this.t.id, this.t.prefix, this.t.markers, this.t.condition, this.t.truePart, falsePart, this.t.type);
            }

            public Padding(Ternary t) {
                this.t = t;
            }
        }
    }

    public static final class Synchronized
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> lock;
        private final Block body;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSynchronized(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Synchronized)) {
                return false;
            }
            Synchronized other = (Synchronized)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Synchronized(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> lock, Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.lock = lock;
            this.body = body;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getLock() {
            return this.lock;
        }

        public Block getBody() {
            return this.body;
        }

        @NonNull
        public String toString() {
            return "J.Synchronized(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", lock=" + this.getLock() + ", body=" + this.getBody() + ")";
        }

        @NonNull
        public Synchronized withId(UUID id) {
            return this.id == id ? this : new Synchronized(id, this.prefix, this.markers, this.lock, this.body);
        }

        @NonNull
        public Synchronized withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Synchronized(this.id, prefix, this.markers, this.lock, this.body);
        }

        @NonNull
        public Synchronized withMarkers(Markers markers) {
            return this.markers == markers ? this : new Synchronized(this.id, this.prefix, markers, this.lock, this.body);
        }

        @NonNull
        public Synchronized withLock(ControlParentheses<Expression> lock) {
            return this.lock == lock ? this : new Synchronized(this.id, this.prefix, this.markers, lock, this.body);
        }

        @NonNull
        public Synchronized withBody(Block body) {
            return this.body == body ? this : new Synchronized(this.id, this.prefix, this.markers, this.lock, body);
        }
    }

    public static final class SwitchExpression
    implements J,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        @Transient
        @Nullable
        public JavaType getType() {
            return (JavaType)((AtomicReference)new JavaVisitor<AtomicReference<JavaType>>(){

                @Override
                public J visitBlock(Block block, AtomicReference<JavaType> javaType) {
                    if (!block.getStatements().isEmpty()) {
                        Case caze = (Case)block.getStatements().get(0);
                        javaType.set(caze.getExpressions().get(0).getType());
                    }
                    return block;
                }
            }.reduce(this, new AtomicReference())).get();
        }

        @Override
        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitchExpression(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwitchExpression)) {
                return false;
            }
            SwitchExpression other = (SwitchExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public SwitchExpression(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block getCases() {
            return this.cases;
        }

        @NonNull
        public String toString() {
            return "J.SwitchExpression(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        @NonNull
        public SwitchExpression withId(UUID id) {
            return this.id == id ? this : new SwitchExpression(id, this.prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        public SwitchExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SwitchExpression(this.id, prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        public SwitchExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new SwitchExpression(this.id, this.prefix, markers, this.selector, this.cases);
        }

        @NonNull
        public SwitchExpression withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new SwitchExpression(this.id, this.prefix, this.markers, selector, this.cases);
        }

        @NonNull
        public SwitchExpression withCases(Block cases) {
            return this.cases == cases ? this : new SwitchExpression(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Switch
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> selector;
        private final Block cases;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitSwitch(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Switch)) {
                return false;
            }
            Switch other = (Switch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Switch(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> selector, Block cases) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.selector = selector;
            this.cases = cases;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ControlParentheses<Expression> getSelector() {
            return this.selector;
        }

        public Block getCases() {
            return this.cases;
        }

        @NonNull
        public String toString() {
            return "J.Switch(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", selector=" + this.getSelector() + ", cases=" + this.getCases() + ")";
        }

        @NonNull
        public Switch withId(UUID id) {
            return this.id == id ? this : new Switch(id, this.prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        public Switch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Switch(this.id, prefix, this.markers, this.selector, this.cases);
        }

        @NonNull
        public Switch withMarkers(Markers markers) {
            return this.markers == markers ? this : new Switch(this.id, this.prefix, markers, this.selector, this.cases);
        }

        @NonNull
        public Switch withSelector(ControlParentheses<Expression> selector) {
            return this.selector == selector ? this : new Switch(this.id, this.prefix, this.markers, selector, this.cases);
        }

        @NonNull
        public Switch withCases(Block cases) {
            return this.cases == cases ? this : new Switch(this.id, this.prefix, this.markers, this.selector, cases);
        }
    }

    public static final class Return
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Expression expression;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitReturn(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Return)) {
                return false;
            }
            Return other = (Return)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Return(UUID id, Space prefix, Markers markers, @Nullable Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        public Return withId(UUID id) {
            return this.id == id ? this : new Return(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        public Return withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Return(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        public Return withMarkers(Markers markers) {
            return this.markers == markers ? this : new Return(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        public Return withExpression(@Nullable Expression expression) {
            return this.expression == expression ? this : new Return(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class Primitive
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType.Primitive type;

        public Primitive withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (!(type instanceof JavaType.Primitive)) {
                throw new IllegalArgumentException("Cannot apply a non-primitive type to Primitive");
            }
            return new Primitive(this.id, this.prefix, this.markers, (JavaType.Primitive)type);
        }

        @Override
        @NonNull
        public JavaType.Primitive getType() {
            return this.type;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Primitive)) {
                return false;
            }
            Primitive other = (Primitive)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Primitive(UUID id, Space prefix, Markers markers, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
        }

        @NonNull
        public Primitive withId(UUID id) {
            return this.id == id ? this : new Primitive(id, this.prefix, this.markers, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Primitive withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Primitive(this.id, prefix, this.markers, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Primitive withMarkers(Markers markers) {
            return this.markers == markers ? this : new Primitive(this.id, this.prefix, markers, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ControlParentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public ControlParentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitControlParentheses(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            J element = (J)this.tree.getElement();
            if (element instanceof Expression) {
                return ((Expression)element).getType();
            }
            if (element instanceof NameTree) {
                return ((NameTree)element).getType();
            }
            if (element instanceof VariableDeclarations) {
                return ((VariableDeclarations)element).getType();
            }
            return null;
        }

        public ControlParentheses<J2> withType(@Nullable JavaType type) {
            return this.tree.getElement() instanceof Expression ? this.withTree(((Expression)this.tree.getElement()).withType(type)) : (this.tree.getElement() instanceof NameTree ? this.withTree(((NameTree)this.tree.getElement()).withType(type)) : this);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControlParentheses)) {
                return false;
            }
            ControlParentheses other = (ControlParentheses)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ControlParentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        private ControlParentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @NonNull
        public ControlParentheses<J2> withId(UUID id) {
            return this.id == id ? this : new ControlParentheses<J2>(this.padding, id, this.prefix, this.markers, this.tree);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ControlParentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ControlParentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ControlParentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new ControlParentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final ControlParentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((ControlParentheses)this.t).tree;
            }

            public ControlParentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((ControlParentheses)this.t).tree == tree ? this.t : new ControlParentheses<J2>(((ControlParentheses)this.t).id, ((ControlParentheses)this.t).prefix, ((ControlParentheses)this.t).markers, tree);
            }

            public Padding(ControlParentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static class Parentheses<J2 extends J>
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J2> tree;

        public J2 getTree() {
            return (J2)((J)this.tree.getElement());
        }

        public Parentheses<J2> withTree(J2 tree) {
            return this.getPadding().withTree(this.tree.withElement(tree));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getSideEffects() : Collections.emptyList();
        }

        @Override
        public JavaType getType() {
            return this.tree.getElement() instanceof Expression ? ((Expression)this.tree.getElement()).getType() : (this.tree.getElement() instanceof NameTree ? ((NameTree)this.tree.getElement()).getType() : null);
        }

        public Parentheses<J2> withType(@Nullable JavaType type) {
            return this.tree.getElement() instanceof Expression ? this.withTree(((Expression)this.tree.getElement()).withType(type)) : (this.tree.getElement() instanceof NameTree ? this.withTree(((NameTree)this.tree.getElement()).withType(type)) : this);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Parentheses(UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        private Parentheses(@Nullable WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, JRightPadded<J2> tree) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tree = tree;
        }

        @NonNull
        public Parentheses<J2> withId(UUID id) {
            return this.id == id ? this : new Parentheses<J2>(this.padding, id, this.prefix, this.markers, this.tree);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Parentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses<J2>(this.padding, this.id, prefix, this.markers, this.tree);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Parentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<J2>(this.padding, this.id, this.prefix, markers, this.tree);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends J> {
            private final Parentheses<J2> t;

            public JRightPadded<J2> getTree() {
                return ((Parentheses)this.t).tree;
            }

            public Parentheses<J2> withTree(JRightPadded<J2> tree) {
                return ((Parentheses)this.t).tree == tree ? this.t : new Parentheses<J2>(((Parentheses)this.t).id, ((Parentheses)this.t).prefix, ((Parentheses)this.t).markers, tree);
            }

            public Padding(Parentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static final class ParameterizedType
    implements J,
    TypeTree,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree clazz;
        @Nullable
        private final JContainer<Expression> typeParameters;

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ParameterizedType withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Override
        public JavaType getType() {
            return this.clazz.getType();
        }

        public ParameterizedType withType(@Nullable JavaType type) {
            if (type == this.clazz.getType()) {
                return this;
            }
            return this.withClazz((NameTree)this.clazz.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitParameterizedType(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ParameterizedType(UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
        }

        private ParameterizedType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree clazz, @Nullable JContainer<Expression> typeParameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeParameters = typeParameters;
        }

        @NonNull
        public ParameterizedType withId(UUID id) {
            return this.id == id ? this : new ParameterizedType(this.padding, id, this.prefix, this.markers, this.clazz, this.typeParameters);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ParameterizedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ParameterizedType(this.padding, this.id, prefix, this.markers, this.clazz, this.typeParameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ParameterizedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ParameterizedType(this.padding, this.id, this.prefix, markers, this.clazz, this.typeParameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ParameterizedType withClazz(NameTree clazz) {
            return this.clazz == clazz ? this : new ParameterizedType(this.padding, this.id, this.prefix, this.markers, clazz, this.typeParameters);
        }

        public NameTree getClazz() {
            return this.clazz;
        }

        public static class Padding {
            private final ParameterizedType t;

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ParameterizedType withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ParameterizedType(this.t.id, this.t.prefix, this.t.markers, this.t.clazz, typeParameters);
            }

            public Padding(ParameterizedType t) {
                this.t = t;
            }
        }
    }

    public static final class Package
    implements Statement,
    J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final List<Annotation> annotations;

        public String getPackageName() {
            return this.expression.withPrefix(Space.EMPTY).print(new Cursor(null, (Object)new CompilationUnit(null, null, Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null, null, false, null, null, null, null, Space.EMPTY)));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Package getCoordinates() {
            return new CoordinateBuilder.Package(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Package)) {
                return false;
            }
            Package other = (Package)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Package(UUID id, Space prefix, Markers markers, Expression expression, List<Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.annotations = annotations;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        @NonNull
        public String toString() {
            return "J.Package(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ", annotations=" + this.getAnnotations() + ")";
        }

        @NonNull
        public Package withId(UUID id) {
            return this.id == id ? this : new Package(id, this.prefix, this.markers, this.expression, this.annotations);
        }

        @NonNull
        public Package withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Package(this.id, prefix, this.markers, this.expression, this.annotations);
        }

        @NonNull
        public Package withMarkers(Markers markers) {
            return this.markers == markers ? this : new Package(this.id, this.prefix, markers, this.expression, this.annotations);
        }

        @NonNull
        public Package withExpression(Expression expression) {
            return this.expression == expression ? this : new Package(this.id, this.prefix, this.markers, expression, this.annotations);
        }

        @NonNull
        public Package withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new Package(this.id, this.prefix, this.markers, this.expression, annotations);
        }
    }

    public static final class NewClass
    implements J,
    Statement,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> enclosing;
        private final Space nooh;
        @Nullable
        private final TypeTree clazz;
        private final JContainer<Expression> arguments;
        @Nullable
        private final Block body;
        @Nullable
        private final JavaType.Method constructorType;

        @Nullable
        public Expression getEnclosing() {
            return this.enclosing == null ? null : this.enclosing.getElement();
        }

        public NewClass withEnclosing(Expression enclosing) {
            return this.getPadding().withEnclosing(JRightPadded.withElement(this.enclosing, enclosing));
        }

        public Space getNew() {
            return this.nooh;
        }

        public NewClass withNew(Space nooh) {
            if (nooh == this.nooh) {
                return this;
            }
            return new NewClass(this.id, this.prefix, this.markers, this.enclosing, nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Override
        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        @Override
        public NewClass withArguments(List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElements(this.arguments, arguments));
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.constructorType == null ? null : this.constructorType.getDeclaringType();
        }

        @Override
        @Nullable
        public JavaType.Method getMethodType() {
            return this.getConstructorType();
        }

        @Override
        public NewClass withMethodType(@Nullable JavaType.Method methodType) {
            return this.withConstructorType(methodType);
        }

        @Override
        public NewClass withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this new class, use withConstructorType(..)");
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewClass(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewClass)) {
                return false;
            }
            NewClass other = (NewClass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NewClass(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType.Method constructorType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.constructorType = constructorType;
        }

        private NewClass(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> enclosing, Space nooh, @Nullable TypeTree clazz, JContainer<Expression> arguments, @Nullable Block body, @Nullable JavaType.Method constructorType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enclosing = enclosing;
            this.nooh = nooh;
            this.clazz = clazz;
            this.arguments = arguments;
            this.body = body;
            this.constructorType = constructorType;
        }

        @NonNull
        public NewClass withId(UUID id) {
            return this.id == id ? this : new NewClass(this.padding, id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public NewClass withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewClass(this.padding, this.id, prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public NewClass withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewClass(this.padding, this.id, this.prefix, markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, this.constructorType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public NewClass withClazz(@Nullable TypeTree clazz) {
            return this.clazz == clazz ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, clazz, this.arguments, this.body, this.constructorType);
        }

        @Nullable
        public TypeTree getClazz() {
            return this.clazz;
        }

        @NonNull
        public NewClass withBody(@Nullable Block body) {
            return this.body == body ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, body, this.constructorType);
        }

        @Nullable
        public Block getBody() {
            return this.body;
        }

        @NonNull
        public NewClass withConstructorType(@Nullable JavaType.Method constructorType) {
            return this.constructorType == constructorType ? this : new NewClass(this.padding, this.id, this.prefix, this.markers, this.enclosing, this.nooh, this.clazz, this.arguments, this.body, constructorType);
        }

        @Nullable
        public JavaType.Method getConstructorType() {
            return this.constructorType;
        }

        public static class Padding {
            private final NewClass t;

            @Nullable
            public JRightPadded<Expression> getEnclosing() {
                return this.t.enclosing;
            }

            public NewClass withEnclosing(@Nullable JRightPadded<Expression> enclosing) {
                return this.t.enclosing == enclosing ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, enclosing, this.t.nooh, this.t.clazz, this.t.arguments, this.t.body, this.t.constructorType);
            }

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public NewClass withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new NewClass(this.t.id, this.t.prefix, this.t.markers, this.t.enclosing, this.t.nooh, this.t.clazz, arguments, this.t.body, this.t.constructorType);
            }

            public Padding(NewClass t) {
                this.t = t;
            }
        }
    }

    public static final class ArrayDimension
    implements J {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> index;

        public Expression getIndex() {
            return this.index.getElement();
        }

        public ArrayDimension withIndex(Expression index) {
            return this.getPadding().withIndex(this.index.withElement(index));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayDimension(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayDimension)) {
                return false;
            }
            ArrayDimension other = (ArrayDimension)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayDimension(UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        private ArrayDimension(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> index) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.index = index;
        }

        @NonNull
        public ArrayDimension withId(UUID id) {
            return this.id == id ? this : new ArrayDimension(this.padding, id, this.prefix, this.markers, this.index);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ArrayDimension withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayDimension(this.padding, this.id, prefix, this.markers, this.index);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ArrayDimension withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayDimension(this.padding, this.id, this.prefix, markers, this.index);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final ArrayDimension t;

            public JRightPadded<Expression> getIndex() {
                return this.t.index;
            }

            public ArrayDimension withIndex(JRightPadded<Expression> index) {
                return this.t.index == index ? this.t : new ArrayDimension(this.t.id, this.t.prefix, this.t.markers, index);
            }

            public Padding(ArrayDimension t) {
                this.t = t;
            }
        }
    }

    public static final class NewArray
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final TypeTree typeExpression;
        private final List<ArrayDimension> dimensions;
        @Nullable
        private final JContainer<Expression> initializer;
        @Nullable
        private final JavaType type;

        @Nullable
        public List<Expression> getInitializer() {
            return this.initializer == null ? null : this.initializer.getElements();
        }

        public NewArray withInitializer(List<Expression> initializer) {
            return this.getPadding().withInitializer(JContainer.withElementsNullable(this.initializer, initializer));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitNewArray(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.NewArray(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", typeExpression=" + this.getTypeExpression() + ", dimensions=" + this.getDimensions() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NewArray)) {
                return false;
            }
            NewArray other = (NewArray)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public NewArray(UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        private NewArray(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable TypeTree typeExpression, List<ArrayDimension> dimensions, @Nullable JContainer<Expression> initializer, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.dimensions = dimensions;
            this.initializer = initializer;
            this.type = type;
        }

        @NonNull
        public NewArray withId(UUID id) {
            return this.id == id ? this : new NewArray(this.padding, id, this.prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public NewArray withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NewArray(this.padding, this.id, prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public NewArray withMarkers(Markers markers) {
            return this.markers == markers ? this : new NewArray(this.padding, this.id, this.prefix, markers, this.typeExpression, this.dimensions, this.initializer, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public NewArray withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, typeExpression, this.dimensions, this.initializer, this.type);
        }

        @Nullable
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public NewArray withDimensions(List<ArrayDimension> dimensions) {
            return this.dimensions == dimensions ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, dimensions, this.initializer, this.type);
        }

        public List<ArrayDimension> getDimensions() {
            return this.dimensions;
        }

        @NonNull
        public NewArray withType(@Nullable JavaType type) {
            return this.type == type ? this : new NewArray(this.padding, this.id, this.prefix, this.markers, this.typeExpression, this.dimensions, this.initializer, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NewArray t;

            @Nullable
            public JContainer<Expression> getInitializer() {
                return this.t.initializer;
            }

            public NewArray withInitializer(@Nullable JContainer<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new NewArray(this.t.id, this.t.prefix, this.t.markers, this.t.typeExpression, this.t.dimensions, initializer, this.t.type);
            }

            public Padding(NewArray t) {
                this.t = t;
            }
        }
    }

    public static final class MultiCatch
    implements J,
    TypeTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<NameTree>> alternatives;

        public List<NameTree> getAlternatives() {
            return JRightPadded.getElements(this.alternatives);
        }

        public MultiCatch withAlternatives(List<NameTree> alternatives) {
            return this.getPadding().withAlternatives(JRightPadded.withElements(this.alternatives, alternatives));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMultiCatch(this, p);
        }

        public MultiCatch withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public JavaType getType() {
            return new JavaType.MultiCatch(this.alternatives.stream().filter(Objects::nonNull).map(alt -> ((NameTree)alt.getElement()).getType()).collect(Collectors.toList()));
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MultiCatch(UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        private MultiCatch(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<NameTree>> alternatives) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.alternatives = alternatives;
        }

        @NonNull
        public MultiCatch withId(UUID id) {
            return this.id == id ? this : new MultiCatch(this.padding, id, this.prefix, this.markers, this.alternatives);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MultiCatch withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiCatch(this.padding, this.id, prefix, this.markers, this.alternatives);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MultiCatch withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiCatch(this.padding, this.id, this.prefix, markers, this.alternatives);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final MultiCatch t;

            public List<JRightPadded<NameTree>> getAlternatives() {
                return this.t.alternatives;
            }

            public MultiCatch withAlternatives(List<JRightPadded<NameTree>> alternatives) {
                return this.t.alternatives == alternatives ? this.t : new MultiCatch(this.t.id, this.t.prefix, this.t.markers, alternatives);
            }

            public Padding(MultiCatch t) {
                this.t = t;
            }
        }
    }

    public static final class Modifier
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;
        private final List<Annotation> annotations;

        public static boolean hasModifier(Collection<Modifier> modifiers, Type modifier) {
            return modifiers.stream().anyMatch(m -> m.getType() == modifier);
        }

        public String toString() {
            return this.type.toString().toLowerCase();
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Modifier)) {
                return false;
            }
            Modifier other = (Modifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Modifier(UUID id, Space prefix, Markers markers, Type type, List<Annotation> annotations) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.annotations = annotations;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Type getType() {
            return this.type;
        }

        @NonNull
        public Modifier withId(UUID id) {
            return this.id == id ? this : new Modifier(id, this.prefix, this.markers, this.type, this.annotations);
        }

        @NonNull
        public Modifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Modifier(this.id, prefix, this.markers, this.type, this.annotations);
        }

        @NonNull
        public Modifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Modifier(this.id, this.prefix, markers, this.type, this.annotations);
        }

        @NonNull
        public Modifier withType(Type type) {
            return this.type == type ? this : new Modifier(this.id, this.prefix, this.markers, type, this.annotations);
        }

        @NonNull
        public Modifier withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new Modifier(this.id, this.prefix, this.markers, this.type, annotations);
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public static enum Type {
            Default,
            Public,
            Protected,
            Private,
            Abstract,
            Static,
            Final,
            Transient,
            Volatile,
            Synchronized,
            Native,
            Strictfp;

        }
    }

    public static final class MethodInvocation
    implements J,
    Statement,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final JRightPadded<Expression> select;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final Identifier name;
        private final JContainer<Expression> arguments;
        @Nullable
        private final JavaType.Method methodType;

        @Nullable
        public Expression getSelect() {
            return this.select == null ? null : this.select.getElement();
        }

        public MethodInvocation withSelect(@Nullable Expression select) {
            return this.getPadding().withSelect(JRightPadded.withElement(this.select, select));
        }

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MethodInvocation withName(Identifier name) {
            if (this.name == name) {
                return this;
            }
            JavaType.Method newType = null;
            if (this.methodType != null) {
                newType = name.getType() instanceof JavaType.Method && name.getType() != this.methodType ? (JavaType.Method)name.getType() : (this.methodType.getName().equals(name.getSimpleName()) ? this.methodType : this.methodType.withName(name.getSimpleName()));
            }
            return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, name.withType(newType), this.arguments, newType);
        }

        @Override
        public List<Expression> getArguments() {
            return this.arguments.getElements();
        }

        @Override
        public MethodInvocation withArguments(List<Expression> arguments) {
            if (this.arguments.getElements() == arguments) {
                return this;
            }
            return this.getPadding().withArguments(JContainer.withElements(this.arguments, arguments));
        }

        @Override
        public MethodInvocation withMethodType(@Nullable JavaType.Method type) {
            if (type == this.methodType) {
                return this;
            }
            return new MethodInvocation(this.id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, type);
        }

        @Override
        public MethodInvocation withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this method invocation, use withMethodType(..)");
        }

        public MethodInvocation withDeclaringType(JavaType.FullyQualified type) {
            if (this.methodType == null) {
                return this;
            }
            return this.withMethodType(this.methodType.withDeclaringType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodInvocation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.MethodInvocation getCoordinates() {
            return new CoordinateBuilder.MethodInvocation(this);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.methodType == null ? null : this.methodType.getReturnType();
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodInvocation)) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MethodInvocation(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method methodType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.methodType = methodType;
        }

        private MethodInvocation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> select, @Nullable JContainer<Expression> typeParameters, Identifier name, JContainer<Expression> arguments, @Nullable JavaType.Method methodType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.select = select;
            this.typeParameters = typeParameters;
            this.name = name;
            this.arguments = arguments;
            this.methodType = methodType;
        }

        @NonNull
        public MethodInvocation withId(UUID id) {
            return this.id == id ? this : new MethodInvocation(this.padding, id, this.prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MethodInvocation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodInvocation(this.padding, this.id, prefix, this.markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MethodInvocation withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodInvocation(this.padding, this.id, this.prefix, markers, this.select, this.typeParameters, this.name, this.arguments, this.methodType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MethodInvocation withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
            return this.typeParameters == typeParameters ? this : new MethodInvocation(this.padding, this.id, this.prefix, this.markers, this.select, typeParameters, this.name, this.arguments, this.methodType);
        }

        public Identifier getName() {
            return this.name;
        }

        @Override
        @Nullable
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        public static class Padding {
            private final MethodInvocation t;

            @Nullable
            public JRightPadded<Expression> getSelect() {
                return this.t.select;
            }

            public MethodInvocation withSelect(@Nullable JRightPadded<Expression> select) {
                return this.t.select == select ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, select, this.t.typeParameters, this.t.name, this.t.arguments, this.t.methodType);
            }

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodInvocation withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, typeParameters, this.t.name, this.t.arguments, this.t.methodType);
            }

            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public MethodInvocation withArguments(JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new MethodInvocation(this.t.id, this.t.prefix, this.t.markers, this.t.select, this.t.typeParameters, this.t.name, arguments, this.t.methodType);
            }

            public Padding(MethodInvocation t) {
                this.t = t;
            }
        }
    }

    public static final class MethodDeclaration
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        @Nullable
        private transient WeakReference<Annotations> annotations;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        @Nullable
        private final TypeParameters typeParameters;
        @Nullable
        private final TypeTree returnTypeExpression;
        private final IdentifierWithAnnotations name;
        private final JContainer<Statement> parameters;
        @Nullable
        private final JContainer<NameTree> throwz;
        @Nullable
        private final Block body;
        @Nullable
        private final JLeftPadded<Expression> defaultValue;
        @Nullable
        private final JavaType.Method methodType;

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getTypeParameters();
        }

        public MethodDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            if (typeParameters == null) {
                if (this.getAnnotations().getTypeParameters() == null) {
                    return this;
                }
                return this.getAnnotations().withTypeParameters(null);
            }
            TypeParameters currentTypeParameters = this.getAnnotations().getTypeParameters();
            if (currentTypeParameters == null) {
                return this.getAnnotations().withTypeParameters(new TypeParameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, typeParameters.stream().map(JRightPadded::build).collect(Collectors.toList())));
            }
            return this.getAnnotations().withTypeParameters(currentTypeParameters.withTypeParameters(typeParameters));
        }

        public Identifier getName() {
            return this.name.getIdentifier();
        }

        public MethodDeclaration withName(Identifier name) {
            return this.getAnnotations().withName(this.name.withIdentifier(name));
        }

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public MethodDeclaration withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters(JContainer.withElements(this.parameters, parameters));
        }

        @Nullable
        public List<NameTree> getThrows() {
            return this.throwz == null ? null : this.throwz.getElements();
        }

        public MethodDeclaration withThrows(@Nullable List<NameTree> throwz) {
            return this.getPadding().withThrows(JContainer.withElementsNullable(this.throwz, throwz));
        }

        @Nullable
        public Expression getDefaultValue() {
            return this.defaultValue == null ? null : this.defaultValue.getElement();
        }

        public MethodDeclaration withDefaultValue(@Nullable Expression defaultValue) {
            return this.getPadding().withDefaultValue(JLeftPadded.withElement(this.defaultValue, defaultValue));
        }

        public MethodDeclaration withMethodType(@Nullable JavaType.Method type) {
            if (type == this.methodType) {
                return this;
            }
            return new MethodDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, type);
        }

        @Override
        public JavaType getType() {
            return this.methodType == null ? null : this.methodType.getReturnType();
        }

        public MethodDeclaration withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this method declaration, use withMethodType(..)");
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMethodDeclaration(this, p);
        }

        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean isConstructor() {
            return this.getReturnTypeExpression() == null;
        }

        public String getSimpleName() {
            return this.name.getIdentifier().getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        @Override
        @Transient
        public CoordinateBuilder.MethodDeclaration getCoordinates() {
            return new CoordinateBuilder.MethodDeclaration(this);
        }

        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeParameters != null) {
                allAnnotations.addAll(this.typeParameters.getAnnotations());
            }
            if (this.returnTypeExpression instanceof AnnotatedType) {
                allAnnotations.addAll(((AnnotatedType)this.returnTypeExpression).getAnnotations());
            }
            allAnnotations.addAll(this.name.getAnnotations());
            return allAnnotations;
        }

        public String toString() {
            return "MethodDeclaration{" + (this.getMethodType() == null ? "unknown" : this.getMethodType()) + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public Annotations getAnnotations() {
            Annotations a;
            if (this.annotations == null) {
                a = new Annotations(this);
                this.annotations = new WeakReference<Annotations>(a);
            } else {
                a = (Annotations)this.annotations.get();
                if (a == null || a.t != this) {
                    a = new Annotations(this);
                    this.annotations = new WeakReference<Annotations>(a);
                }
            }
            return a;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodDeclaration)) {
                return false;
            }
            MethodDeclaration other = (MethodDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MethodDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, IdentifierWithAnnotations name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method methodType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.methodType = methodType;
        }

        private MethodDeclaration(@Nullable WeakReference<Padding> padding, @Nullable WeakReference<Annotations> annotations, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, @Nullable TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, IdentifierWithAnnotations name, JContainer<Statement> parameters, @Nullable JContainer<NameTree> throwz, @Nullable Block body, @Nullable JLeftPadded<Expression> defaultValue, @Nullable JavaType.Method methodType) {
            this.padding = padding;
            this.annotations = annotations;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.throwz = throwz;
            this.body = body;
            this.defaultValue = defaultValue;
            this.methodType = methodType;
        }

        @NonNull
        public MethodDeclaration withId(UUID id) {
            return this.id == id ? this : new MethodDeclaration(this.padding, this.annotations, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MethodDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MethodDeclaration(this.padding, this.annotations, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MethodDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public MethodDeclaration withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        public MethodDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public MethodDeclaration withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, returnTypeExpression, this.name, this.parameters, this.throwz, this.body, this.defaultValue, this.methodType);
        }

        @Nullable
        public TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @NonNull
        public MethodDeclaration withBody(@Nullable Block body) {
            return this.body == body ? this : new MethodDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.throwz, body, this.defaultValue, this.methodType);
        }

        @Nullable
        public Block getBody() {
            return this.body;
        }

        @Nullable
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        public static final class IdentifierWithAnnotations {
            private final Identifier identifier;
            private final List<Annotation> annotations;

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                return o instanceof IdentifierWithAnnotations;
            }

            public int hashCode() {
                boolean result = true;
                return 1;
            }

            public IdentifierWithAnnotations(Identifier identifier, List<Annotation> annotations) {
                this.identifier = identifier;
                this.annotations = annotations;
            }

            @NonNull
            public String toString() {
                return "J.MethodDeclaration.IdentifierWithAnnotations(identifier=" + this.getIdentifier() + ", annotations=" + this.getAnnotations() + ")";
            }

            public Identifier getIdentifier() {
                return this.identifier;
            }

            @NonNull
            public IdentifierWithAnnotations withIdentifier(Identifier identifier) {
                return this.identifier == identifier ? this : new IdentifierWithAnnotations(identifier, this.annotations);
            }

            public List<Annotation> getAnnotations() {
                return this.annotations;
            }

            @NonNull
            public IdentifierWithAnnotations withAnnotations(List<Annotation> annotations) {
                return this.annotations == annotations ? this : new IdentifierWithAnnotations(this.identifier, annotations);
            }
        }

        public static class Annotations {
            private final MethodDeclaration t;

            @Nullable
            public TypeParameters getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodDeclaration withTypeParameters(@Nullable TypeParameters typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            public IdentifierWithAnnotations getName() {
                return this.t.name;
            }

            public MethodDeclaration withName(IdentifierWithAnnotations name) {
                return this.t.name == name ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            public Annotations(MethodDeclaration t) {
                this.t = t;
            }
        }

        public static class Padding {
            private final MethodDeclaration t;

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public MethodDeclaration withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Nullable
            public JContainer<NameTree> getThrows() {
                return this.t.throwz;
            }

            public MethodDeclaration withThrows(@Nullable JContainer<NameTree> throwz) {
                return this.t.throwz == throwz ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            @Nullable
            public JLeftPadded<Expression> getDefaultValue() {
                return this.t.defaultValue;
            }

            public MethodDeclaration withDefaultValue(@Nullable JLeftPadded<Expression> defaultValue) {
                return this.t.defaultValue == defaultValue ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, defaultValue, this.t.methodType);
            }

            @Nullable
            public TypeParameters getTypeParameters() {
                return this.t.typeParameters;
            }

            public MethodDeclaration withTypeParameters(@Nullable TypeParameters typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, typeParameters, this.t.returnTypeExpression, this.t.name, this.t.parameters, this.t.throwz, this.t.body, this.t.defaultValue, this.t.methodType);
            }

            public Padding(MethodDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class MemberReference
    implements J,
    Expression,
    TypedTree,
    MethodCall {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> containing;
        @Nullable
        private final JContainer<Expression> typeParameters;
        private final JLeftPadded<Identifier> reference;
        @Nullable
        private final JavaType type;
        @Nullable
        private final JavaType.Method methodType;
        @Nullable
        private final JavaType.Variable variableType;

        public Expression getContaining() {
            return this.containing.getElement();
        }

        public MemberReference withContaining(Expression containing) {
            return this.getPadding().withContaining(JRightPadded.withElement(this.containing, containing));
        }

        @Nullable
        public List<Expression> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public MemberReference withTypeParameters(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Override
        public List<Expression> getArguments() {
            return Collections.emptyList();
        }

        @Override
        public MemberReference withArguments(List<Expression> arguments) {
            return this;
        }

        public Identifier getReference() {
            return this.reference.getElement();
        }

        public MemberReference withReference(Identifier reference) {
            return this.getPadding().withReference(this.reference.withElement(reference));
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitMemberReference(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberReference)) {
                return false;
            }
            MemberReference other = (MemberReference)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public MemberReference(UUID id, Space prefix, Markers markers, JRightPadded<Expression> containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType.Method methodType, @Nullable JavaType.Variable variableType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.methodType = methodType;
            this.variableType = variableType;
        }

        private MemberReference(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> containing, @Nullable JContainer<Expression> typeParameters, JLeftPadded<Identifier> reference, @Nullable JavaType type, @Nullable JavaType.Method methodType, @Nullable JavaType.Variable variableType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.containing = containing;
            this.typeParameters = typeParameters;
            this.reference = reference;
            this.type = type;
            this.methodType = methodType;
            this.variableType = variableType;
        }

        @NonNull
        public MemberReference withId(UUID id) {
            return this.id == id ? this : new MemberReference(this.padding, id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public MemberReference withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MemberReference(this.padding, this.id, prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public MemberReference withMarkers(Markers markers) {
            return this.markers == markers ? this : new MemberReference(this.padding, this.id, this.prefix, markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, this.variableType);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        @NonNull
        public MemberReference withType(@Nullable JavaType type) {
            return this.type == type ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, type, this.methodType, this.variableType);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @Override
        @NonNull
        public MemberReference withMethodType(@Nullable JavaType.Method methodType) {
            return this.methodType == methodType ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, methodType, this.variableType);
        }

        @Override
        @Nullable
        public JavaType.Method getMethodType() {
            return this.methodType;
        }

        @NonNull
        public MemberReference withVariableType(@Nullable JavaType.Variable variableType) {
            return this.variableType == variableType ? this : new MemberReference(this.padding, this.id, this.prefix, this.markers, this.containing, this.typeParameters, this.reference, this.type, this.methodType, variableType);
        }

        @Nullable
        public JavaType.Variable getVariableType() {
            return this.variableType;
        }

        public static class Padding {
            private final MemberReference t;

            public JRightPadded<Expression> getContaining() {
                return this.t.containing;
            }

            public MemberReference withContaining(JRightPadded<Expression> containing) {
                return this.t.containing == containing ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, containing, this.t.typeParameters, this.t.reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            @Nullable
            public JContainer<Expression> getTypeParameters() {
                return this.t.typeParameters;
            }

            public MemberReference withTypeParameters(@Nullable JContainer<Expression> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, typeParameters, this.t.reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            public JLeftPadded<Identifier> getReference() {
                return this.t.reference;
            }

            public MemberReference withReference(JLeftPadded<Identifier> reference) {
                return this.t.reference == reference ? this.t : new MemberReference(this.t.id, this.t.prefix, this.t.markers, this.t.containing, this.t.typeParameters, reference, this.t.type, this.t.methodType, this.t.variableType);
            }

            public Padding(MemberReference t) {
                this.t = t;
            }
        }
    }

    public static final class Literal
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Object value;
        @Nullable
        private final String valueSource;
        @Nullable
        private final List<UnicodeEscape> unicodeEscapes;
        private final JavaType.Primitive type;

        public Literal withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type instanceof JavaType.Primitive) {
                return new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, (JavaType.Primitive)type);
            }
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Incubating(since="7.25.0")
        public static boolean isLiteralValue(@Nullable Expression maybeLiteral, Object value) {
            if (maybeLiteral instanceof Literal) {
                Literal literal = (Literal)maybeLiteral;
                return literal.getValue() != null && literal.getValue().equals(value);
            }
            return false;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Literal(UUID id, Space prefix, Markers markers, @Nullable Object value, @Nullable String valueSource, @Nullable List<UnicodeEscape> unicodeEscapes, JavaType.Primitive type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
            this.unicodeEscapes = unicodeEscapes;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        @Nullable
        public String getValueSource() {
            return this.valueSource;
        }

        @Nullable
        public List<UnicodeEscape> getUnicodeEscapes() {
            return this.unicodeEscapes;
        }

        @Override
        public JavaType.Primitive getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "J.Literal(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ", unicodeEscapes=" + this.getUnicodeEscapes() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        public Literal withValue(@Nullable Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        public Literal withValueSource(@Nullable String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource, this.unicodeEscapes, this.type);
        }

        @NonNull
        public Literal withUnicodeEscapes(@Nullable List<UnicodeEscape> unicodeEscapes) {
            return this.unicodeEscapes == unicodeEscapes ? this : new Literal(this.id, this.prefix, this.markers, this.value, this.valueSource, unicodeEscapes, this.type);
        }

        public static final class UnicodeEscape {
            private final int valueSourceIndex;
            private final String codePoint;

            public UnicodeEscape(int valueSourceIndex, String codePoint) {
                this.valueSourceIndex = valueSourceIndex;
                this.codePoint = codePoint;
            }

            public int getValueSourceIndex() {
                return this.valueSourceIndex;
            }

            public String getCodePoint() {
                return this.codePoint;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UnicodeEscape)) {
                    return false;
                }
                UnicodeEscape other = (UnicodeEscape)o;
                if (this.getValueSourceIndex() != other.getValueSourceIndex()) {
                    return false;
                }
                String this$codePoint = this.getCodePoint();
                String other$codePoint = other.getCodePoint();
                return !(this$codePoint == null ? other$codePoint != null : !this$codePoint.equals(other$codePoint));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getValueSourceIndex();
                String $codePoint = this.getCodePoint();
                result = result * 59 + ($codePoint == null ? 43 : $codePoint.hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "J.Literal.UnicodeEscape(valueSourceIndex=" + this.getValueSourceIndex() + ", codePoint=" + this.getCodePoint() + ")";
            }

            @NonNull
            public UnicodeEscape withValueSourceIndex(int valueSourceIndex) {
                return this.valueSourceIndex == valueSourceIndex ? this : new UnicodeEscape(valueSourceIndex, this.codePoint);
            }

            @NonNull
            public UnicodeEscape withCodePoint(String codePoint) {
                return this.codePoint == codePoint ? this : new UnicodeEscape(this.valueSourceIndex, codePoint);
            }
        }
    }

    public static final class Lambda
    implements J,
    Statement,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Parameters parameters;
        private final Space arrow;
        private final J body;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLambda(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lambda)) {
                return false;
            }
            Lambda other = (Lambda)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Lambda(UUID id, Space prefix, Markers markers, Parameters parameters, Space arrow, J body, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.parameters = parameters;
            this.arrow = arrow;
            this.body = body;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public Space getArrow() {
            return this.arrow;
        }

        public J getBody() {
            return this.body;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "J.Lambda(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parameters=" + this.getParameters() + ", arrow=" + this.getArrow() + ", body=" + this.getBody() + ", type=" + this.getType() + ")";
        }

        @NonNull
        public Lambda withId(UUID id) {
            return this.id == id ? this : new Lambda(id, this.prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Lambda(this.id, prefix, this.markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withMarkers(Markers markers) {
            return this.markers == markers ? this : new Lambda(this.id, this.prefix, markers, this.parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withParameters(Parameters parameters) {
            return this.parameters == parameters ? this : new Lambda(this.id, this.prefix, this.markers, parameters, this.arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withArrow(Space arrow) {
            return this.arrow == arrow ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, arrow, this.body, this.type);
        }

        @NonNull
        public Lambda withBody(J body) {
            return this.body == body ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, body, this.type);
        }

        @NonNull
        public Lambda withType(@Nullable JavaType type) {
            return this.type == type ? this : new Lambda(this.id, this.prefix, this.markers, this.parameters, this.arrow, this.body, type);
        }

        public static final class Parameters
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final boolean parenthesized;
            private final List<JRightPadded<J>> parameters;

            public List<J> getParameters() {
                return JRightPadded.getElements(this.parameters);
            }

            public Parameters withParameters(List<J> parameters) {
                return this.getPadding().withParams(JRightPadded.withElements(this.parameters, parameters));
            }

            @Transient
            public CoordinateBuilder.Lambda.Parameters getCoordinates() {
                return new CoordinateBuilder.Lambda.Parameters(this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.Lambda.Parameters(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", parenthesized=" + this.isParenthesized() + ", parameters=" + this.getParameters() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters other = (Parameters)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Parameters(UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            private Parameters(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, boolean parenthesized, List<JRightPadded<J>> parameters) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.parenthesized = parenthesized;
                this.parameters = parameters;
            }

            @NonNull
            public Parameters withId(UUID id) {
                return this.id == id ? this : new Parameters(this.padding, id, this.prefix, this.markers, this.parenthesized, this.parameters);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Parameters withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Parameters(this.padding, this.id, prefix, this.markers, this.parenthesized, this.parameters);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Parameters withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameters(this.padding, this.id, this.prefix, markers, this.parenthesized, this.parameters);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            public Parameters withParenthesized(boolean parenthesized) {
                return this.parenthesized == parenthesized ? this : new Parameters(this.padding, this.id, this.prefix, this.markers, parenthesized, this.parameters);
            }

            public boolean isParenthesized() {
                return this.parenthesized;
            }

            public static class Padding {
                private final Parameters t;

                public List<JRightPadded<J>> getParams() {
                    return this.t.parameters;
                }

                public Parameters withParams(List<JRightPadded<J>> parameters) {
                    return this.t.parameters == parameters ? this.t : new Parameters(this.t.id, this.t.prefix, this.t.markers, this.t.parenthesized, parameters);
                }

                public Padding(Parameters t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class Label
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Identifier> label;
        private final Statement statement;

        public Identifier getLabel() {
            return this.label.getElement();
        }

        public Label withLabel(Identifier label) {
            return this.getPadding().withLabel(this.label.withElement(label));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitLabel(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Label)) {
                return false;
            }
            Label other = (Label)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Label(UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        private Label(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Identifier> label, Statement statement) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
            this.statement = statement;
        }

        @NonNull
        public Label withId(UUID id) {
            return this.id == id ? this : new Label(this.padding, id, this.prefix, this.markers, this.label, this.statement);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Label withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Label(this.padding, this.id, prefix, this.markers, this.label, this.statement);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Label withMarkers(Markers markers) {
            return this.markers == markers ? this : new Label(this.padding, this.id, this.prefix, markers, this.label, this.statement);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Label withStatement(Statement statement) {
            return this.statement == statement ? this : new Label(this.padding, this.id, this.prefix, this.markers, this.label, statement);
        }

        public Statement getStatement() {
            return this.statement;
        }

        public static class Padding {
            private final Label t;

            public JRightPadded<Identifier> getLabel() {
                return this.t.label;
            }

            public Label withLabel(JRightPadded<Identifier> label) {
                return this.t.label == label ? this.t : new Label(this.t.id, this.t.prefix, this.t.markers, label, this.t.statement);
            }

            public Padding(Label t) {
                this.t = t;
            }
        }
    }

    public static final class InstanceOf
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> expression;
        private final J clazz;
        @Nullable
        private final J pattern;
        @Nullable
        private final JavaType type;

        public Expression getExpression() {
            return this.expression.getElement();
        }

        public InstanceOf withExpression(Expression expression) {
            return this.getPadding().withExpr(this.expression.withElement(expression));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitInstanceOf(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceOf)) {
                return false;
            }
            InstanceOf other = (InstanceOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public InstanceOf(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable J pattern, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.pattern = pattern;
            this.type = type;
        }

        private InstanceOf(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, J clazz, @Nullable J pattern, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.clazz = clazz;
            this.pattern = pattern;
            this.type = type;
        }

        @NonNull
        public InstanceOf withId(UUID id) {
            return this.id == id ? this : new InstanceOf(this.padding, id, this.prefix, this.markers, this.expression, this.clazz, this.pattern, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public InstanceOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InstanceOf(this.padding, this.id, prefix, this.markers, this.expression, this.clazz, this.pattern, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public InstanceOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new InstanceOf(this.padding, this.id, this.prefix, markers, this.expression, this.clazz, this.pattern, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public InstanceOf withClazz(J clazz) {
            return this.clazz == clazz ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, clazz, this.pattern, this.type);
        }

        public J getClazz() {
            return this.clazz;
        }

        @NonNull
        public InstanceOf withPattern(@Nullable J pattern) {
            return this.pattern == pattern ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, this.clazz, pattern, this.type);
        }

        @Nullable
        public J getPattern() {
            return this.pattern;
        }

        @NonNull
        public InstanceOf withType(@Nullable JavaType type) {
            return this.type == type ? this : new InstanceOf(this.padding, this.id, this.prefix, this.markers, this.expression, this.clazz, this.pattern, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final InstanceOf t;

            public JRightPadded<Expression> getExpr() {
                return this.t.expression;
            }

            public InstanceOf withExpr(JRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new InstanceOf(this.t.id, this.t.prefix, this.t.markers, expression, this.t.clazz, this.t.pattern, this.t.type);
            }

            public Padding(InstanceOf t) {
                this.t = t;
            }
        }
    }

    public static final class Import
    implements Statement,
    Comparable<Import> {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> statik;
        private final FieldAccess qualid;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Import withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitImport(this, p);
        }

        public String getTypeName() {
            if (this.isStatic()) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
                if (fq == null) {
                    String possibleInnerClassFqn = this.getTypeName(this.qualid);
                    String possibleInnerClassName = possibleInnerClassFqn.substring(possibleInnerClassFqn.lastIndexOf(36) + 1);
                    if ("*".equals(possibleInnerClassName)) {
                        return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                    }
                    while (possibleInnerClassName.indexOf(36) >= 0) {
                        possibleInnerClassName = possibleInnerClassName.substring(possibleInnerClassName.indexOf(36) + 1);
                    }
                    JavaType.Class owner = TypeUtils.asClass(this.qualid.getTarget().getType());
                    if (owner != null && !(this.qualid.getTarget().getType() instanceof JavaType.ShallowClass)) {
                        Iterator<JavaType.Method> visibleMethods = owner.getVisibleMethods();
                        while (visibleMethods.hasNext()) {
                            JavaType.Method method = visibleMethods.next();
                            if (!method.getName().equals(possibleInnerClassName)) continue;
                            return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                        }
                        Iterator<JavaType.Variable> visibleMembers = owner.getVisibleMembers();
                        while (visibleMembers.hasNext()) {
                            JavaType.Variable member = visibleMembers.next();
                            if (!member.getName().equals(possibleInnerClassName)) continue;
                            return possibleInnerClassFqn.substring(0, possibleInnerClassFqn.lastIndexOf(36));
                        }
                        return possibleInnerClassFqn;
                    }
                }
                return this.getTypeName((FieldAccess)this.qualid.getTarget());
            }
            return this.getTypeName(this.qualid);
        }

        private String getTypeName(FieldAccess type) {
            String name;
            StringBuilder typeName = new StringBuilder();
            FieldAccess part = type;
            while (true) {
                name = part.getSimpleName();
                if (part.getTarget() instanceof Identifier) break;
                String delim = Character.isUpperCase((part = (FieldAccess)part.getTarget()).getSimpleName().charAt(0)) ? "$" : ".";
                typeName.insert(0, delim + name);
            }
            typeName.insert(0, ((Identifier)part.getTarget()).getSimpleName() + "." + name);
            return typeName.toString();
        }

        public String getPackageName() {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
            if (fq != null) {
                return fq.getPackageName();
            }
            String typeName = this.getTypeName();
            int lastDot = typeName.lastIndexOf(46);
            return lastDot < 0 ? "" : typeName.substring(0, lastDot);
        }

        public String getClassName() {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified(this.qualid.getType());
            if (fq != null) {
                return fq.getClassName();
            }
            String typeName = this.getTypeName();
            int lastDot = typeName.lastIndexOf(46);
            return lastDot < 0 ? typeName : typeName.substring(lastDot + 1);
        }

        @Override
        public int compareTo(Import o) {
            String p1 = this.getPackageName();
            String p2 = o.getPackageName();
            String[] p1s = p1.split("\\.");
            String[] p2s = p2.split("\\.");
            for (int i = 0; i < p1s.length; ++i) {
                String s = p1s[i];
                if (p2s.length < i + 1) {
                    return 1;
                }
                if (s.equals(p2s[i])) continue;
                return s.compareTo(p2s[i]);
            }
            return p1s.length < p2s.length ? -1 : this.getQualid().getSimpleName().compareTo(o.getQualid().getSimpleName());
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Import(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
        }

        private Import(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> statik, FieldAccess qualid) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.qualid = qualid;
        }

        @NonNull
        public Import withId(UUID id) {
            return this.id == id ? this : new Import(this.padding, id, this.prefix, this.markers, this.statik, this.qualid);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.padding, this.id, prefix, this.markers, this.statik, this.qualid);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.padding, this.id, this.prefix, markers, this.statik, this.qualid);
        }

        @NonNull
        public Import withQualid(FieldAccess qualid) {
            return this.qualid == qualid ? this : new Import(this.padding, this.id, this.prefix, this.markers, this.statik, qualid);
        }

        public FieldAccess getQualid() {
            return this.qualid;
        }

        public static class Padding {
            private final Import t;

            public JLeftPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Import withStatic(JLeftPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, statik, this.t.qualid);
            }

            public Padding(Import t) {
                this.t = t;
            }
        }
    }

    public static final class If
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final ControlParentheses<Expression> ifCondition;
        private final JRightPadded<Statement> thenPart;
        @Nullable
        private final Else elsePart;

        public Statement getThenPart() {
            return this.thenPart.getElement();
        }

        public If withThenPart(Statement thenPart) {
            return this.getPadding().withThenPart(this.thenPart.withElement(thenPart));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIf(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.If(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", ifCondition=" + this.getIfCondition() + ", thenPart=" + this.getThenPart() + ", elsePart=" + this.getElsePart() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof If)) {
                return false;
            }
            If other = (If)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public If(UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        private If(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, ControlParentheses<Expression> ifCondition, JRightPadded<Statement> thenPart, @Nullable Else elsePart) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.ifCondition = ifCondition;
            this.thenPart = thenPart;
            this.elsePart = elsePart;
        }

        @NonNull
        public If withId(UUID id) {
            return this.id == id ? this : new If(this.padding, id, this.prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public If withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new If(this.padding, this.id, prefix, this.markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public If withMarkers(Markers markers) {
            return this.markers == markers ? this : new If(this.padding, this.id, this.prefix, markers, this.ifCondition, this.thenPart, this.elsePart);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public If withIfCondition(ControlParentheses<Expression> ifCondition) {
            return this.ifCondition == ifCondition ? this : new If(this.padding, this.id, this.prefix, this.markers, ifCondition, this.thenPart, this.elsePart);
        }

        public ControlParentheses<Expression> getIfCondition() {
            return this.ifCondition;
        }

        @NonNull
        public If withElsePart(@Nullable Else elsePart) {
            return this.elsePart == elsePart ? this : new If(this.padding, this.id, this.prefix, this.markers, this.ifCondition, this.thenPart, elsePart);
        }

        @Nullable
        public Else getElsePart() {
            return this.elsePart;
        }

        public static final class Else
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Statement> body;

            public Statement getBody() {
                return this.body.getElement();
            }

            public Else withBody(Statement body) {
                return this.getPadding().withBody(this.body.withElement(body));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitElse(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @NonNull
            public String toString() {
                return "J.If.Else(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ")";
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Else)) {
                    return false;
                }
                Else other = (Else)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Else(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            private Else(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.body = body;
            }

            @NonNull
            public Else withId(UUID id) {
                return this.id == id ? this : new Else(this.padding, id, this.prefix, this.markers, this.body);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Else withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Else(this.padding, this.id, prefix, this.markers, this.body);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Else withMarkers(Markers markers) {
                return this.markers == markers ? this : new Else(this.padding, this.id, this.prefix, markers, this.body);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Else t;

                public JRightPadded<Statement> getBody() {
                    return this.t.body;
                }

                public Else withBody(JRightPadded<Statement> body) {
                    return this.t.body == body ? this.t : new Else(this.t.id, this.t.prefix, this.t.markers, body);
                }

                public Padding(Else t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final If t;

            public JRightPadded<Statement> getThenPart() {
                return this.t.thenPart;
            }

            public If withThenPart(JRightPadded<Statement> thenPart) {
                return this.t.thenPart == thenPart ? this.t : new If(this.t.id, this.t.prefix, this.t.markers, this.t.ifCondition, thenPart, this.t.elsePart);
            }

            public Padding(If t) {
                this.t = t;
            }
        }
    }

    public static final class Identifier
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String simpleName;
        @Nullable
        private final JavaType type;
        @Nullable
        private final JavaType.Variable fieldType;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Identifier getCoordinates() {
            return new CoordinateBuilder.Identifier(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public Identifier(UUID id, Space prefix, Markers markers, String simpleName, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.simpleName = simpleName;
            this.type = type;
            this.fieldType = fieldType;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @Nullable
        public JavaType.Variable getFieldType() {
            return this.fieldType;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.simpleName, this.type, this.fieldType);
        }

        @NonNull
        public Identifier withSimpleName(String simpleName) {
            return this.simpleName == simpleName ? this : new Identifier(this.id, this.prefix, this.markers, simpleName, this.type, this.fieldType);
        }

        @NonNull
        public Identifier withType(@Nullable JavaType type) {
            return this.type == type ? this : new Identifier(this.id, this.prefix, this.markers, this.simpleName, type, this.fieldType);
        }

        @NonNull
        public Identifier withFieldType(@Nullable JavaType.Variable fieldType) {
            return this.fieldType == fieldType ? this : new Identifier(this.id, this.prefix, this.markers, this.simpleName, this.type, fieldType);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class ForLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public ForLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ForLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        private ForLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @NonNull
        public ForLoop withId(UUID id) {
            return this.id == id ? this : new ForLoop(this.padding, id, this.prefix, this.markers, this.control, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForLoop withControl(Control control) {
            return this.control == control ? this : new ForLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        public Control getControl() {
            return this.control;
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final List<JRightPadded<Statement>> init;
            private final JRightPadded<Expression> condition;
            private final List<JRightPadded<Statement>> update;

            public List<Statement> getInit() {
                return JRightPadded.getElements(this.init);
            }

            public Control withInit(List<Statement> init) {
                return this.getPadding().withInit(JRightPadded.withElements(this.init, init));
            }

            public Expression getCondition() {
                return this.condition.getElement();
            }

            public Control withCondition(Expression condition) {
                return this.getPadding().withCondition(this.condition.withElement(condition));
            }

            public List<Statement> getUpdate() {
                return JRightPadded.getElements(this.update);
            }

            public Control withUpdate(List<Statement> update) {
                return this.getPadding().withUpdate(JRightPadded.withElements(this.update, update));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForControl(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Control(UUID id, Space prefix, Markers markers, List<JRightPadded<Statement>> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Statement>> init, JRightPadded<Expression> condition, List<JRightPadded<Statement>> update) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.init = init;
                this.condition = condition;
                this.update = update;
            }

            @NonNull
            public Control withId(UUID id) {
                return this.id == id ? this : new Control(this.padding, id, this.prefix, this.markers, this.init, this.condition, this.update);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.init, this.condition, this.update);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.init, this.condition, this.update);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public List<JRightPadded<Statement>> getInit() {
                    return this.t.init;
                }

                public Control withInit(List<JRightPadded<Statement>> init) {
                    return this.t.init == init ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, init, this.t.condition, this.t.update);
                }

                public JRightPadded<Expression> getCondition() {
                    return this.t.condition;
                }

                public Control withCondition(JRightPadded<Expression> condition) {
                    return this.t.condition == condition ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, condition, this.t.update);
                }

                public List<JRightPadded<Statement>> getUpdate() {
                    return this.t.update;
                }

                public Control withUpdate(List<JRightPadded<Statement>> update) {
                    return this.t.update == update ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.init, this.t.condition, update);
                }

                public Padding(Control t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final ForLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            public Padding(ForLoop t) {
                this.t = t;
            }
        }
    }

    public static final class ForEachLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Control control;
        private final JRightPadded<Statement> body;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public ForEachLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitForEachLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.ForEachLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", control=" + this.getControl() + ", body=" + this.getBody() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForEachLoop)) {
                return false;
            }
            ForEachLoop other = (ForEachLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ForEachLoop(UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        private ForEachLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @NonNull
        public ForEachLoop withId(UUID id) {
            return this.id == id ? this : new ForEachLoop(this.padding, id, this.prefix, this.markers, this.control, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ForEachLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForEachLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ForEachLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForEachLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ForEachLoop withControl(Control control) {
            return this.control == control ? this : new ForEachLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        public Control getControl() {
            return this.control;
        }

        public static final class Control
        implements J {
            @Nullable
            private transient WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<VariableDeclarations> variable;
            private final JRightPadded<Expression> iterable;

            public VariableDeclarations getVariable() {
                return this.variable.getElement();
            }

            public Control withVariable(VariableDeclarations variable) {
                return this.getPadding().withVariable(this.variable.withElement(variable));
            }

            public Expression getIterable() {
                return this.iterable.getElement();
            }

            public Control withIterable(Expression iterable) {
                return this.getPadding().withIterable(this.iterable.withElement(iterable));
            }

            @Override
            public <P> J acceptJava(JavaVisitor<P> v, P p) {
                return v.visitForEachControl(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            public String toString() {
                return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Control)) {
                    return false;
                }
                Control other = (Control)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Control(UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            private Control(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<VariableDeclarations> variable, JRightPadded<Expression> iterable) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.variable = variable;
                this.iterable = iterable;
            }

            @NonNull
            public Control withId(UUID id) {
                return this.id == id ? this : new Control(this.padding, id, this.prefix, this.markers, this.variable, this.iterable);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Control withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Control(this.padding, this.id, prefix, this.markers, this.variable, this.iterable);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Control withMarkers(Markers markers) {
                return this.markers == markers ? this : new Control(this.padding, this.id, this.prefix, markers, this.variable, this.iterable);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final Control t;

                public JRightPadded<VariableDeclarations> getVariable() {
                    return this.t.variable;
                }

                public Control withVariable(JRightPadded<VariableDeclarations> variable) {
                    return this.t.variable == variable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, variable, this.t.iterable);
                }

                public JRightPadded<Expression> getIterable() {
                    return this.t.iterable;
                }

                public Control withIterable(JRightPadded<Expression> iterable) {
                    return this.t.iterable == iterable ? this.t : new Control(this.t.id, this.t.prefix, this.t.markers, this.t.variable, iterable);
                }

                public Padding(Control t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final ForEachLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForEachLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForEachLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            public Padding(ForEachLoop t) {
                this.t = t;
            }
        }
    }

    public static final class FieldAccess
    implements J,
    TypeTree,
    Expression,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression target;
        private final JLeftPadded<Identifier> name;
        @Nullable
        private final JavaType type;

        public Identifier getName() {
            return this.name.getElement();
        }

        public FieldAccess withName(Identifier name) {
            return this.getPadding().withName(this.name.withElement(name));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitFieldAccess(this, p);
        }

        public String getSimpleName() {
            return this.name.getElement().getSimpleName();
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return this.target.getSideEffects();
        }

        @Nullable
        public NameTree asClassReference() {
            if (this.target instanceof NameTree) {
                String fqn = null;
                if (this.type instanceof JavaType.FullyQualified) {
                    fqn = ((JavaType.FullyQualified)this.type).getFullyQualifiedName();
                }
                return "java.lang.Class".equals(fqn) ? (NameTree)((Object)this.target) : null;
            }
            return null;
        }

        public boolean isFullyQualifiedClassReference(String className) {
            return this.isFullyQualifiedClassReference(this, className);
        }

        private boolean isFullyQualifiedClassReference(FieldAccess fieldAccess, String className) {
            if (!className.contains(".")) {
                return false;
            }
            if (!fieldAccess.getName().getSimpleName().equals(className.substring(className.lastIndexOf(46) + 1))) {
                return false;
            }
            if (fieldAccess.getTarget() instanceof FieldAccess) {
                return this.isFullyQualifiedClassReference((FieldAccess)fieldAccess.getTarget(), className.substring(0, className.lastIndexOf(46)));
            }
            if (fieldAccess.getTarget() instanceof Identifier) {
                return ((Identifier)fieldAccess.getTarget()).getSimpleName().equals(className.substring(0, className.lastIndexOf(46)));
            }
            return false;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldAccess)) {
                return false;
            }
            FieldAccess other = (FieldAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public FieldAccess(UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        private FieldAccess(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Identifier> name, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.name = name;
            this.type = type;
        }

        @NonNull
        public FieldAccess withId(UUID id) {
            return this.id == id ? this : new FieldAccess(this.padding, id, this.prefix, this.markers, this.target, this.name, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public FieldAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FieldAccess(this.padding, this.id, prefix, this.markers, this.target, this.name, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public FieldAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new FieldAccess(this.padding, this.id, this.prefix, markers, this.target, this.name, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public FieldAccess withTarget(Expression target) {
            return this.target == target ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, target, this.name, this.type);
        }

        public Expression getTarget() {
            return this.target;
        }

        @NonNull
        public FieldAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new FieldAccess(this.padding, this.id, this.prefix, this.markers, this.target, this.name, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final FieldAccess t;

            public JLeftPadded<Identifier> getName() {
                return this.t.name;
            }

            public FieldAccess withName(JLeftPadded<Identifier> name) {
                return this.t.name == name ? this.t : new FieldAccess(this.t.id, this.t.prefix, this.t.markers, this.t.target, name, this.t.type);
            }

            public Padding(FieldAccess t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValueSet
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<EnumValue>> enums;
        private final boolean terminatedWithSemicolon;

        public List<EnumValue> getEnums() {
            return JRightPadded.getElements(this.enums);
        }

        public EnumValueSet withEnums(List<EnumValue> enums) {
            return this.getPadding().withEnums(JRightPadded.withElements(this.enums, enums));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValueSet(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.EnumValueSet(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", enums=" + this.getEnums() + ", terminatedWithSemicolon=" + this.isTerminatedWithSemicolon() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValueSet)) {
                return false;
            }
            EnumValueSet other = (EnumValueSet)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public EnumValueSet(UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        private EnumValueSet(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<EnumValue>> enums, boolean terminatedWithSemicolon) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.enums = enums;
            this.terminatedWithSemicolon = terminatedWithSemicolon;
        }

        @NonNull
        public EnumValueSet withId(UUID id) {
            return this.id == id ? this : new EnumValueSet(this.padding, id, this.prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public EnumValueSet withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValueSet(this.padding, this.id, prefix, this.markers, this.enums, this.terminatedWithSemicolon);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public EnumValueSet withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValueSet(this.padding, this.id, this.prefix, markers, this.enums, this.terminatedWithSemicolon);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public EnumValueSet withTerminatedWithSemicolon(boolean terminatedWithSemicolon) {
            return this.terminatedWithSemicolon == terminatedWithSemicolon ? this : new EnumValueSet(this.padding, this.id, this.prefix, this.markers, this.enums, terminatedWithSemicolon);
        }

        public boolean isTerminatedWithSemicolon() {
            return this.terminatedWithSemicolon;
        }

        public static class Padding {
            private final EnumValueSet t;

            public List<JRightPadded<EnumValue>> getEnums() {
                return this.t.enums;
            }

            public EnumValueSet withEnums(List<JRightPadded<EnumValue>> enums) {
                return this.t.enums == enums ? this.t : new EnumValueSet(this.t.id, this.t.prefix, this.t.markers, enums, this.t.terminatedWithSemicolon);
            }

            public Padding(EnumValueSet t) {
                this.t = t;
            }
        }
    }

    public static final class EnumValue
    implements J {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final Identifier name;
        @Nullable
        private final NewClass initializer;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEnumValue(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumValue)) {
                return false;
            }
            EnumValue other = (EnumValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public EnumValue(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Identifier name, @Nullable NewClass initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.name = name;
            this.initializer = initializer;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Identifier getName() {
            return this.name;
        }

        @Nullable
        public NewClass getInitializer() {
            return this.initializer;
        }

        @NonNull
        public EnumValue withId(UUID id) {
            return this.id == id ? this : new EnumValue(id, this.prefix, this.markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new EnumValue(this.id, prefix, this.markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new EnumValue(this.id, this.prefix, markers, this.annotations, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new EnumValue(this.id, this.prefix, this.markers, annotations, this.name, this.initializer);
        }

        @NonNull
        public EnumValue withName(Identifier name) {
            return this.name == name ? this : new EnumValue(this.id, this.prefix, this.markers, this.annotations, name, this.initializer);
        }

        @NonNull
        public EnumValue withInitializer(@Nullable NewClass initializer) {
            return this.initializer == initializer ? this : new EnumValue(this.id, this.prefix, this.markers, this.annotations, this.name, initializer);
        }
    }

    public static final class Empty
    implements J,
    Statement,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public JavaType getType() {
            return null;
        }

        public Empty withType(@Nullable JavaType type) {
            return this;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public String toString() {
            return "J.Empty(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        @NonNull
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static final class DoWhileLoop
    implements J,
    Loop {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Statement> body;
        private final JLeftPadded<ControlParentheses<Expression>> whileCondition;

        @Override
        public Statement getBody() {
            return this.body.getElement();
        }

        public DoWhileLoop withBody(Statement body) {
            return this.getPadding().withBody(this.body.withElement(body));
        }

        public ControlParentheses<Expression> getWhileCondition() {
            return this.whileCondition.getElement();
        }

        public DoWhileLoop withWhileCondition(ControlParentheses<Expression> whileCondition) {
            return this.getPadding().withWhileCondition(this.whileCondition.withElement(whileCondition));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitDoWhileLoop(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        public String toString() {
            return "J.DoWhileLoop(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", body=" + this.getBody() + ", whileCondition=" + this.getWhileCondition() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileLoop)) {
                return false;
            }
            DoWhileLoop other = (DoWhileLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DoWhileLoop(UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        private DoWhileLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Statement> body, JLeftPadded<ControlParentheses<Expression>> whileCondition) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.body = body;
            this.whileCondition = whileCondition;
        }

        @NonNull
        public DoWhileLoop withId(UUID id) {
            return this.id == id ? this : new DoWhileLoop(this.padding, id, this.prefix, this.markers, this.body, this.whileCondition);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public DoWhileLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DoWhileLoop(this.padding, this.id, prefix, this.markers, this.body, this.whileCondition);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public DoWhileLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new DoWhileLoop(this.padding, this.id, this.prefix, markers, this.body, this.whileCondition);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final DoWhileLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public DoWhileLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, body, this.t.whileCondition);
            }

            public JLeftPadded<ControlParentheses<Expression>> getWhileCondition() {
                return this.t.whileCondition;
            }

            public DoWhileLoop withWhileCondition(JLeftPadded<ControlParentheses<Expression>> whileCondition) {
                return this.t.whileCondition == whileCondition ? this.t : new DoWhileLoop(this.t.id, this.t.prefix, this.t.markers, this.t.body, whileCondition);
            }

            public Padding(DoWhileLoop t) {
                this.t = t;
            }
        }
    }

    public static final class Continue
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitContinue(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Continue)) {
                return false;
            }
            Continue other = (Continue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Continue(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        public Continue withId(UUID id) {
            return this.id == id ? this : new Continue(id, this.prefix, this.markers, this.label);
        }

        @NonNull
        public Continue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Continue(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        public Continue withMarkers(Markers markers) {
            return this.markers == markers ? this : new Continue(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        public Continue withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Continue(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class CompilationUnit
    implements J,
    JavaSourceFile,
    SourceFile {
        @Nullable
        private transient SoftReference<TypesInUse> typesInUse;
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        @Nullable
        private final JRightPadded<Package> packageDeclaration;
        private final List<JRightPadded<Import>> imports;
        private final List<ClassDeclaration> classes;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        @Nullable
        public Package getPackageDeclaration() {
            return this.packageDeclaration == null ? null : this.packageDeclaration.getElement();
        }

        @Override
        public CompilationUnit withPackageDeclaration(Package packageDeclaration) {
            return this.getPadding().withPackageDeclaration(JRightPadded.withElement(this.packageDeclaration, packageDeclaration));
        }

        @Override
        public List<Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<Import> imports) {
            return this.getPadding().withImports((List)JRightPadded.withElements(this.imports, imports));
        }

        @Transient
        public long getWeight(final Predicate<Object> uniqueIdentity) {
            AtomicInteger n = new AtomicInteger();
            new JavaVisitor<AtomicInteger>(){
                final JavaTypeVisitor<AtomicInteger> typeVisitor = new JavaTypeVisitor<AtomicInteger>(){

                    @Override
                    public JavaType visit(@Nullable JavaType javaType, AtomicInteger n) {
                        if (javaType != null && uniqueIdentity.test(javaType)) {
                            n.incrementAndGet();
                            return super.visit(javaType, n);
                        }
                        return javaType;
                    }
                };
                final JavadocVisitor<AtomicInteger> javadocVisitor = new JavadocVisitor<AtomicInteger>((JavaVisitor)this){

                    @Nullable
                    public Javadoc visit(@Nullable Tree tree, AtomicInteger n) {
                        if (tree != null) {
                            n.incrementAndGet();
                        }
                        return (Javadoc)super.visit(tree, (Object)n);
                    }
                };

                @Nullable
                public J visit(@Nullable Tree tree, AtomicInteger n) {
                    if (tree != null) {
                        n.incrementAndGet();
                    }
                    return (J)super.visit(tree, (Object)n);
                }

                @Override
                public JavaType visitType(@Nullable JavaType javaType, AtomicInteger n) {
                    return this.typeVisitor.visit(javaType, n);
                }

                @Override
                protected JavadocVisitor<AtomicInteger> getJavadocVisitor() {
                    return this.javadocVisitor;
                }
            }.visit(this, n);
            return n.get();
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitJavaSourceFile(this, p);
        }

        public Set<NameTree> findType(String clazz) {
            return FindTypes.find(this, clazz);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JavaPrinter();
        }

        @Override
        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build(this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build(this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        @Override
        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable JRightPadded<Package> packageDeclaration, List<JRightPadded<Import>> imports, List<ClassDeclaration> classes, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.packageDeclaration = packageDeclaration;
            this.imports = imports;
            this.classes = classes;
            this.eof = eof;
        }

        @NonNull
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Override
        @NonNull
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Override
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @NonNull
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.packageDeclaration, this.imports, this.classes, this.eof);
        }

        @Nullable
        public Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        public CompilationUnit withClasses(List<ClassDeclaration> classes) {
            return this.classes == classes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, classes, this.eof);
        }

        @Override
        public List<ClassDeclaration> getClasses() {
            return this.classes;
        }

        @Override
        @NonNull
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.packageDeclaration, this.imports, this.classes, eof);
        }

        @Override
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            @Nullable
            public JRightPadded<Package> getPackageDeclaration() {
                return this.t.packageDeclaration;
            }

            public CompilationUnit withPackageDeclaration(@Nullable JRightPadded<Package> packageDeclaration) {
                return this.t.packageDeclaration == packageDeclaration ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, packageDeclaration, this.t.imports, this.t.classes, this.t.eof);
            }

            @Override
            public List<JRightPadded<Import>> getImports() {
                return this.t.imports;
            }

            @Override
            public CompilationUnit withImports(List<JRightPadded<Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, this.t.packageDeclaration, imports, this.t.classes, this.t.eof);
            }

            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }

    public static final class ClassDeclaration
    implements J,
    Statement,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        @Nullable
        private transient WeakReference<Annotations> annotations;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> leadingAnnotations;
        private final List<Modifier> modifiers;
        private final Kind kind;
        private final Identifier name;
        @Nullable
        private final JContainer<TypeParameter> typeParameters;
        @Nullable
        private final JContainer<Statement> primaryConstructor;
        @Nullable
        private final JLeftPadded<TypeTree> extendings;
        @Nullable
        private final JContainer<TypeTree> implementings;
        private final Block body;
        @Nullable
        private final JavaType.FullyQualified type;

        public Kind.Type getKind() {
            return this.kind.getType();
        }

        public ClassDeclaration withKind(Kind.Type type) {
            Kind k = this.getAnnotations().getKind();
            if (k.type == type) {
                return this;
            }
            return this.getAnnotations().withKind(k.withType(type));
        }

        @Nullable
        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters == null ? null : this.typeParameters.getElements();
        }

        public ClassDeclaration withTypeParameters(@Nullable List<TypeParameter> typeParameters) {
            return this.getPadding().withTypeParameters(JContainer.withElementsNullable(this.typeParameters, typeParameters));
        }

        @Nullable
        public List<Statement> getPrimaryConstructor() {
            return this.primaryConstructor == null ? null : this.primaryConstructor.getElements();
        }

        public ClassDeclaration withPrimaryConstructor(@Nullable List<Statement> primaryConstructor) {
            return this.getPadding().withPrimaryConstructor(JContainer.withElementsNullable(this.primaryConstructor, primaryConstructor));
        }

        @Nullable
        public TypeTree getExtends() {
            return this.extendings == null ? null : this.extendings.getElement();
        }

        public ClassDeclaration withExtends(@Nullable TypeTree extendings) {
            return this.getPadding().withExtends(JLeftPadded.withElement(this.extendings, extendings));
        }

        @Nullable
        public List<TypeTree> getImplements() {
            return this.implementings == null ? null : this.implementings.getElements();
        }

        public ClassDeclaration withImplements(@Nullable List<TypeTree> implementings) {
            return this.getPadding().withImplements(JContainer.withElementsNullable(this.implementings, implementings));
        }

        public ClassDeclaration withType(@Nullable JavaType type) {
            if (type == this.type) {
                return this;
            }
            if (type != null && !(type instanceof JavaType.FullyQualified)) {
                throw new IllegalArgumentException("A class can only be type attributed with a fully qualified type name");
            }
            return new ClassDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, (JavaType.FullyQualified)type);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitClassDeclaration(this, p);
        }

        public List<Annotation> getAllAnnotations() {
            ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.leadingAnnotations);
            for (Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            allAnnotations.addAll(this.kind.getAnnotations());
            return allAnnotations;
        }

        @Override
        @Transient
        public CoordinateBuilder.ClassDeclaration getCoordinates() {
            return new CoordinateBuilder.ClassDeclaration(this);
        }

        public String getSimpleName() {
            return this.name.getSimpleName();
        }

        public boolean hasModifier(Modifier.Type modifier) {
            return Modifier.hasModifier(this.getModifiers(), modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public Annotations getAnnotations() {
            Annotations a;
            if (this.annotations == null) {
                a = new Annotations(this);
                this.annotations = new WeakReference<Annotations>(a);
            } else {
                a = (Annotations)this.annotations.get();
                if (a == null || a.t != this) {
                    a = new Annotations(this);
                    this.annotations = new WeakReference<Annotations>(a);
                }
            }
            return a;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDeclaration)) {
                return false;
            }
            ClassDeclaration other = (ClassDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ClassDeclaration(UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, Kind kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JContainer<Statement> primaryConstructor, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, Block body, @Nullable JavaType.FullyQualified type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.primaryConstructor = primaryConstructor;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
        }

        private ClassDeclaration(@Nullable WeakReference<Padding> padding, @Nullable WeakReference<Annotations> annotations, UUID id, Space prefix, Markers markers, List<Annotation> leadingAnnotations, List<Modifier> modifiers, Kind kind, Identifier name, @Nullable JContainer<TypeParameter> typeParameters, @Nullable JContainer<Statement> primaryConstructor, @Nullable JLeftPadded<TypeTree> extendings, @Nullable JContainer<TypeTree> implementings, Block body, @Nullable JavaType.FullyQualified type) {
            this.padding = padding;
            this.annotations = annotations;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.kind = kind;
            this.name = name;
            this.typeParameters = typeParameters;
            this.primaryConstructor = primaryConstructor;
            this.extendings = extendings;
            this.implementings = implementings;
            this.body = body;
            this.type = type;
        }

        @NonNull
        public ClassDeclaration withId(UUID id) {
            return this.id == id ? this : new ClassDeclaration(this.padding, this.annotations, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public ClassDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ClassDeclaration(this.padding, this.annotations, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public ClassDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ClassDeclaration(this.padding, this.annotations, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public ClassDeclaration withLeadingAnnotations(List<Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ClassDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        public ClassDeclaration withModifiers(List<Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ClassDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        public List<Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        public ClassDeclaration withName(Identifier name) {
            return this.name == name ? this : new ClassDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, this.body, this.type);
        }

        public Identifier getName() {
            return this.name;
        }

        @NonNull
        public ClassDeclaration withBody(Block body) {
            return this.body == body ? this : new ClassDeclaration(this.padding, this.annotations, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.kind, this.name, this.typeParameters, this.primaryConstructor, this.extendings, this.implementings, body, this.type);
        }

        public Block getBody() {
            return this.body;
        }

        @Override
        @Nullable
        public JavaType.FullyQualified getType() {
            return this.type;
        }

        public static final class Kind
        implements J {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final List<Annotation> annotations;
            private final Type type;

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kind)) {
                    return false;
                }
                Kind other = (Kind)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            public Kind(UUID id, Space prefix, Markers markers, List<Annotation> annotations, Type type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.annotations = annotations;
                this.type = type;
            }

            @NonNull
            public String toString() {
                return "J.ClassDeclaration.Kind(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", annotations=" + this.getAnnotations() + ", type=" + (Object)((Object)this.getType()) + ")";
            }

            @NonNull
            public Kind withId(UUID id) {
                return this.id == id ? this : new Kind(id, this.prefix, this.markers, this.annotations, this.type);
            }

            public UUID getId() {
                return this.id;
            }

            @NonNull
            public Kind withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Kind(this.id, prefix, this.markers, this.annotations, this.type);
            }

            @Override
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            public Kind withMarkers(Markers markers) {
                return this.markers == markers ? this : new Kind(this.id, this.prefix, markers, this.annotations, this.type);
            }

            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            public Kind withAnnotations(List<Annotation> annotations) {
                return this.annotations == annotations ? this : new Kind(this.id, this.prefix, this.markers, annotations, this.type);
            }

            public List<Annotation> getAnnotations() {
                return this.annotations;
            }

            @NonNull
            public Kind withType(Type type) {
                return this.type == type ? this : new Kind(this.id, this.prefix, this.markers, this.annotations, type);
            }

            public Type getType() {
                return this.type;
            }

            public static enum Type {
                Class,
                Enum,
                Interface,
                Annotation,
                Record;

            }
        }

        public static class Annotations {
            private final ClassDeclaration t;

            public Kind getKind() {
                return this.t.kind;
            }

            public ClassDeclaration withKind(Kind kind) {
                return this.t.kind == kind ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            public Annotations(ClassDeclaration t) {
                this.t = t;
            }
        }

        public static class Padding {
            private final ClassDeclaration t;

            @Nullable
            public JContainer<Statement> getPrimaryConstructor() {
                return this.t.primaryConstructor;
            }

            public ClassDeclaration withPrimaryConstructor(@Nullable JContainer<Statement> primaryConstructor) {
                return this.t.primaryConstructor == primaryConstructor ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, primaryConstructor, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JLeftPadded<TypeTree> getExtends() {
                return this.t.extendings;
            }

            public ClassDeclaration withExtends(@Nullable JLeftPadded<TypeTree> extendings) {
                return this.t.extendings == extendings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, extendings, this.t.implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeTree> getImplements() {
                return this.t.implementings;
            }

            public ClassDeclaration withImplements(@Nullable JContainer<TypeTree> implementings) {
                return this.t.implementings == implementings ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, implementings, this.t.body, this.t.type);
            }

            public Kind getKind() {
                return this.t.kind;
            }

            public ClassDeclaration withKind(Kind kind) {
                return this.t.kind == kind ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, kind, this.t.name, this.t.typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            @Nullable
            public JContainer<TypeParameter> getTypeParameters() {
                return this.t.typeParameters;
            }

            public ClassDeclaration withTypeParameters(@Nullable JContainer<TypeParameter> typeParameters) {
                return this.t.typeParameters == typeParameters ? this.t : new ClassDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.kind, this.t.name, typeParameters, this.t.primaryConstructor, this.t.extendings, this.t.implementings, this.t.body, this.t.type);
            }

            public Padding(ClassDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class Case
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type type;
        private final JContainer<Expression> expressions;
        private final JContainer<Statement> statements;
        @Nullable
        private final JRightPadded<J> body;

        public Type getType() {
            return this.type == null ? Type.Statement : this.type;
        }

        @Deprecated
        public Expression getPattern() {
            return this.getExpressions().get(0);
        }

        @Deprecated
        public Case withPattern(@Nullable Expression pattern) {
            return this.withExpressions(ListUtils.mapFirst(this.getExpressions(), first -> pattern));
        }

        public List<Expression> getExpressions() {
            return this.expressions.getElements();
        }

        public Case withExpressions(List<Expression> expressions) {
            return this.getPadding().withExpressions(Objects.requireNonNull(JContainer.withElementsNullable(this.expressions, expressions)));
        }

        public List<Statement> getStatements() {
            return this.statements.getElements();
        }

        public Case withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JContainer.withElements(this.statements, statements));
        }

        @Nullable
        public J getBody() {
            return this.body == null ? null : this.body.getElement();
        }

        public Case withBody(J body) {
            return this.getPadding().withBody(JRightPadded.withElement(this.body, body));
        }

        @JsonCreator
        public Case(UUID id, Space prefix, Markers markers, Type type, @Deprecated @Nullable Expression pattern, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = pattern != null ? Objects.requireNonNull(JContainer.withElementsNullable(null, Collections.singletonList(pattern))) : expressions;
            this.statements = statements;
            this.body = body;
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitCase(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Case)) {
                return false;
            }
            Case other = (Case)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Case(UUID id, Space prefix, Markers markers, Type type, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = expressions;
            this.statements = statements;
            this.body = body;
        }

        private Case(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Type type, JContainer<Expression> expressions, JContainer<Statement> statements, @Nullable JRightPadded<J> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.expressions = expressions;
            this.statements = statements;
            this.body = body;
        }

        @NonNull
        public Case withId(UUID id) {
            return this.id == id ? this : new Case(this.padding, id, this.prefix, this.markers, this.type, this.expressions, this.statements, this.body);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Case withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Case(this.padding, this.id, prefix, this.markers, this.type, this.expressions, this.statements, this.body);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Case withMarkers(Markers markers) {
            return this.markers == markers ? this : new Case(this.padding, this.id, this.prefix, markers, this.type, this.expressions, this.statements, this.body);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Case withType(Type type) {
            return this.type == type ? this : new Case(this.padding, this.id, this.prefix, this.markers, type, this.expressions, this.statements, this.body);
        }

        public static enum Type {
            Statement,
            Rule;

        }

        public static class Padding {
            private final Case t;

            @Nullable
            public JRightPadded<J> getBody() {
                return this.t.body;
            }

            public Case withBody(@Nullable JRightPadded<J> body) {
                return this.t.body == body ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, (JContainer<Expression>)this.t.expressions, (JContainer<Statement>)this.t.statements, body);
            }

            public JContainer<Statement> getStatements() {
                return this.t.statements;
            }

            public Case withStatements(JContainer<Statement> statements) {
                return this.t.statements == statements ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, (JContainer<Expression>)this.t.expressions, statements, (JRightPadded<J>)this.t.body);
            }

            public JContainer<Expression> getExpressions() {
                return this.t.expressions;
            }

            public Case withExpressions(JContainer<Expression> expressions) {
                return this.t.expressions == expressions ? this.t : new Case(this.t.id, this.t.prefix, this.t.markers, this.t.type, null, expressions, (JContainer<Statement>)this.t.statements, (JRightPadded<J>)this.t.body);
            }

            public Padding(Case t) {
                this.t = t;
            }
        }
    }

    public static final class Break
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Identifier label;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBreak(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Break)) {
                return false;
            }
            Break other = (Break)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Break(UUID id, Space prefix, Markers markers, @Nullable Identifier label) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.label = label;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @Nullable
        public Identifier getLabel() {
            return this.label;
        }

        @NonNull
        public Break withId(UUID id) {
            return this.id == id ? this : new Break(id, this.prefix, this.markers, this.label);
        }

        @NonNull
        public Break withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Break(this.id, prefix, this.markers, this.label);
        }

        @NonNull
        public Break withMarkers(Markers markers) {
            return this.markers == markers ? this : new Break(this.id, this.prefix, markers, this.label);
        }

        @NonNull
        public Break withLabel(@Nullable Identifier label) {
            return this.label == label ? this : new Break(this.id, this.prefix, this.markers, label);
        }
    }

    public static final class Block
    implements J,
    Statement {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Boolean> statik;
        private final List<JRightPadded<Statement>> statements;
        private final Space end;

        public boolean isStatic() {
            return this.statik.getElement();
        }

        public Block withStatic(boolean statik) {
            return this.getPadding().withStatic(this.statik.withElement(statik));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public Block withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBlock(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Block getCoordinates() {
            return new CoordinateBuilder.Block(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @SelfLoathing(name="Jonathan Leitschuh")
        @LoathingOfOthers(value="Who didn't encode this in the model?!")
        @Incubating(since="7.25.0")
        public static boolean isInitBlock(Cursor cursor) {
            if (!(cursor.getValue() instanceof Block)) {
                throw new IllegalArgumentException("Cursor must point to a J.Block!");
            }
            Block block = (Block)cursor.getValue();
            if (block.isStatic()) {
                return false;
            }
            Block parentBlock = null;
            Iterator path = cursor.getPath();
            if (path.hasNext()) {
                path.next();
            }
            while (path.hasNext()) {
                Object next = path.next();
                if (parentBlock != null && next instanceof Block) {
                    return false;
                }
                if (next instanceof Block) {
                    parentBlock = (Block)next;
                    if (parentBlock.getStatements().contains(block)) continue;
                    return false;
                }
                if (next instanceof ClassDeclaration) {
                    ClassDeclaration classDeclaration = (ClassDeclaration)next;
                    return classDeclaration.getBody() == parentBlock;
                }
                if (!(next instanceof NewClass)) continue;
                NewClass newClass = (NewClass)next;
                return newClass.getBody() == parentBlock;
            }
            return false;
        }

        @Incubating(since="7.25.0")
        public static boolean isStaticOrInitBlock(Cursor cursor) {
            if (!(cursor.getValue() instanceof Block)) {
                throw new IllegalArgumentException("Cursor must point to a J.Block!");
            }
            Block block = (Block)cursor.getValue();
            return block.isStatic() || Block.isInitBlock(cursor);
        }

        @NonNull
        public String toString() {
            return "J.Block(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statik=" + this.statik + ", statements=" + this.getStatements() + ", end=" + this.getEnd() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block other = (Block)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Block(UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        private Block(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Boolean> statik, List<JRightPadded<Statement>> statements, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statik = statik;
            this.statements = statements;
            this.end = end;
        }

        @NonNull
        public Block withId(UUID id) {
            return this.id == id ? this : new Block(this.padding, id, this.prefix, this.markers, this.statik, this.statements, this.end);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Block withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Block(this.padding, this.id, prefix, this.markers, this.statik, this.statements, this.end);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Block withMarkers(Markers markers) {
            return this.markers == markers ? this : new Block(this.padding, this.id, this.prefix, markers, this.statik, this.statements, this.end);
        }

        public Space getEnd() {
            return this.end;
        }

        @NonNull
        public Block withEnd(Space end) {
            return this.end == end ? this : new Block(this.padding, this.id, this.prefix, this.markers, this.statik, this.statements, end);
        }

        public static class Padding {
            private final Block t;

            public JRightPadded<Boolean> getStatic() {
                return this.t.statik;
            }

            public Block withStatic(JRightPadded<Boolean> statik) {
                return this.t.statik == statik ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, statik, this.t.statements, this.t.end);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public Block withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new Block(this.t.id, this.t.prefix, this.t.markers, this.t.statik, statements, this.t.end);
            }

            public Padding(Block t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements J,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            ArrayList<J> sideEffects = new ArrayList<J>(2);
            sideEffects.addAll(this.left.getSideEffects());
            sideEffects.addAll(this.right.getSideEffects());
            return sideEffects;
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @NonNull
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @NonNull
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            Addition,
            Subtraction,
            Multiplication,
            Division,
            Modulo,
            LessThan,
            GreaterThan,
            LessThanOrEqual,
            GreaterThanOrEqual,
            Equal,
            NotEqual,
            BitAnd,
            BitOr,
            BitXor,
            LeftShift,
            RightShift,
            UnsignedRightShift,
            Or,
            And;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class AssignmentOperation
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Type> operator;
        private final Expression assignment;
        @Nullable
        private final JavaType type;

        public Type getOperator() {
            return this.operator.getElement();
        }

        public AssignmentOperation withOperator(Type operator) {
            return this.getPadding().withOperator(this.operator.withElement(operator));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignmentOperation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentOperation)) {
                return false;
            }
            AssignmentOperation other = (AssignmentOperation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AssignmentOperation(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        private AssignmentOperation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        @NonNull
        public AssignmentOperation withId(UUID id) {
            return this.id == id ? this : new AssignmentOperation(this.padding, id, this.prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public AssignmentOperation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssignmentOperation(this.padding, this.id, prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public AssignmentOperation withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignmentOperation(this.padding, this.id, this.prefix, markers, this.variable, this.operator, this.assignment, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public AssignmentOperation withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, variable, this.operator, this.assignment, this.type);
        }

        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        public AssignmentOperation withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, assignment, this.type);
        }

        public Expression getAssignment() {
            return this.assignment;
        }

        @NonNull
        public AssignmentOperation withType(@Nullable JavaType type) {
            return this.type == type ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, this.assignment, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static enum Type {
            Addition,
            BitAnd,
            BitOr,
            BitXor,
            Division,
            LeftShift,
            Modulo,
            Multiplication,
            RightShift,
            Subtraction,
            UnsignedRightShift;

        }

        public static class Padding {
            private final AssignmentOperation t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public AssignmentOperation withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new AssignmentOperation(this.t.id, this.t.prefix, this.t.markers, this.t.variable, operator, this.t.assignment, this.t.type);
            }

            public Padding(AssignmentOperation t) {
                this.t = t;
            }
        }
    }

    public static final class Assignment
    implements J,
    Statement,
    Expression,
    TypedTree {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Expression> assignment;
        @Nullable
        private final JavaType type;

        public Expression getAssignment() {
            return this.assignment.getElement();
        }

        public Assignment withAssignment(Expression assignment) {
            return this.getPadding().withAssignment(this.assignment.withElement(assignment));
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssignment(this, p);
        }

        @Override
        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Assignment(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        private Assignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Expression> assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
            this.type = type;
        }

        @NonNull
        public Assignment withId(UUID id) {
            return this.id == id ? this : new Assignment(this.padding, id, this.prefix, this.markers, this.variable, this.assignment, this.type);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Assignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assignment(this.padding, this.id, prefix, this.markers, this.variable, this.assignment, this.type);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Assignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assignment(this.padding, this.id, this.prefix, markers, this.variable, this.assignment, this.type);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Assignment withVariable(Expression variable) {
            return this.variable == variable ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, variable, this.assignment, this.type);
        }

        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        public Assignment withType(@Nullable JavaType type) {
            return this.type == type ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, this.variable, this.assignment, type);
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final Assignment t;

            public JLeftPadded<Expression> getAssignment() {
                return this.t.assignment;
            }

            public Assignment withAssignment(JLeftPadded<Expression> assignment) {
                return this.t.assignment == assignment ? this.t : new Assignment(this.t.id, this.t.prefix, this.t.markers, this.t.variable, assignment, this.t.type);
            }

            public Padding(Assignment t) {
                this.t = t;
            }
        }
    }

    public static final class Assert
    implements J,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression condition;
        @Nullable
        private final JLeftPadded<Expression> detail;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAssert(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assert)) {
                return false;
            }
            Assert other = (Assert)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Assert(UUID id, Space prefix, Markers markers, Expression condition, @Nullable JLeftPadded<Expression> detail) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.condition = condition;
            this.detail = detail;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getCondition() {
            return this.condition;
        }

        @Nullable
        public JLeftPadded<Expression> getDetail() {
            return this.detail;
        }

        @NonNull
        public Assert withId(UUID id) {
            return this.id == id ? this : new Assert(id, this.prefix, this.markers, this.condition, this.detail);
        }

        @NonNull
        public Assert withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assert(this.id, prefix, this.markers, this.condition, this.detail);
        }

        @NonNull
        public Assert withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assert(this.id, this.prefix, markers, this.condition, this.detail);
        }

        @NonNull
        public Assert withCondition(Expression condition) {
            return this.condition == condition ? this : new Assert(this.id, this.prefix, this.markers, condition, this.detail);
        }

        @NonNull
        public Assert withDetail(@Nullable JLeftPadded<Expression> detail) {
            return this.detail == detail ? this : new Assert(this.id, this.prefix, this.markers, this.condition, detail);
        }
    }

    public static final class ArrayType
    implements J,
    TypeTree,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree elementType;
        private final List<JRightPadded<Space>> dimensions;

        @Override
        public JavaType getType() {
            return this.elementType.getType();
        }

        public ArrayType withType(@Nullable JavaType type) {
            return type == this.getType() ? this : this.withElementType((TypeTree)this.elementType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayType(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayType)) {
                return false;
            }
            ArrayType other = (ArrayType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayType(UUID id, Space prefix, Markers markers, TypeTree elementType, List<JRightPadded<Space>> dimensions) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elementType = elementType;
            this.dimensions = dimensions;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public TypeTree getElementType() {
            return this.elementType;
        }

        public List<JRightPadded<Space>> getDimensions() {
            return this.dimensions;
        }

        @NonNull
        public ArrayType withId(UUID id) {
            return this.id == id ? this : new ArrayType(id, this.prefix, this.markers, this.elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayType(this.id, prefix, this.markers, this.elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayType(this.id, this.prefix, markers, this.elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withElementType(TypeTree elementType) {
            return this.elementType == elementType ? this : new ArrayType(this.id, this.prefix, this.markers, elementType, this.dimensions);
        }

        @NonNull
        public ArrayType withDimensions(List<JRightPadded<Space>> dimensions) {
            return this.dimensions == dimensions ? this : new ArrayType(this.id, this.prefix, this.markers, this.elementType, dimensions);
        }
    }

    public static final class ArrayAccess
    implements J,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression indexed;
        private final ArrayDimension dimension;
        @Nullable
        private final JavaType type;

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitArrayAccess(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ArrayAccess(UUID id, Space prefix, Markers markers, Expression indexed, ArrayDimension dimension, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.indexed = indexed;
            this.dimension = dimension;
            this.type = type;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Expression getIndexed() {
            return this.indexed;
        }

        public ArrayDimension getDimension() {
            return this.dimension;
        }

        @Override
        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public ArrayAccess withId(UUID id) {
            return this.id == id ? this : new ArrayAccess(id, this.prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayAccess(this.id, prefix, this.markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayAccess(this.id, this.prefix, markers, this.indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withIndexed(Expression indexed) {
            return this.indexed == indexed ? this : new ArrayAccess(this.id, this.prefix, this.markers, indexed, this.dimension, this.type);
        }

        @NonNull
        public ArrayAccess withDimension(ArrayDimension dimension) {
            return this.dimension == dimension ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, dimension, this.type);
        }

        @NonNull
        public ArrayAccess withType(@Nullable JavaType type) {
            return this.type == type ? this : new ArrayAccess(this.id, this.prefix, this.markers, this.indexed, this.dimension, type);
        }
    }

    public static final class Annotation
    implements J,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final NameTree annotationType;
        @Nullable
        private final JContainer<Expression> arguments;

        public String getSimpleName() {
            return this.annotationType instanceof Identifier ? ((Identifier)this.annotationType).getSimpleName() : ((FieldAccess)this.annotationType).getSimpleName();
        }

        @Nullable
        public List<Expression> getArguments() {
            return this.arguments == null ? null : this.arguments.getElements();
        }

        public Annotation withArguments(@Nullable List<Expression> arguments) {
            return this.getPadding().withArguments(JContainer.withElementsNullable(this.arguments, arguments));
        }

        @Override
        public JavaType getType() {
            return this.annotationType.getType();
        }

        public Annotation withType(@Nullable JavaType type) {
            return this.withAnnotationType((NameTree)this.annotationType.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotation(this, p);
        }

        @Override
        @Transient
        public CoordinateBuilder.Annotation getCoordinates() {
            return new CoordinateBuilder.Annotation(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotation)) {
                return false;
            }
            Annotation other = (Annotation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Annotation(UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        private Annotation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, NameTree annotationType, @Nullable JContainer<Expression> arguments) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        @NonNull
        public Annotation withId(UUID id) {
            return this.id == id ? this : new Annotation(this.padding, id, this.prefix, this.markers, this.annotationType, this.arguments);
        }

        public UUID getId() {
            return this.id;
        }

        @NonNull
        public Annotation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Annotation(this.padding, this.id, prefix, this.markers, this.annotationType, this.arguments);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        public Annotation withMarkers(Markers markers) {
            return this.markers == markers ? this : new Annotation(this.padding, this.id, this.prefix, markers, this.annotationType, this.arguments);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        public Annotation withAnnotationType(NameTree annotationType) {
            return this.annotationType == annotationType ? this : new Annotation(this.padding, this.id, this.prefix, this.markers, annotationType, this.arguments);
        }

        public NameTree getAnnotationType() {
            return this.annotationType;
        }

        public static class Padding {
            private final Annotation t;

            @Nullable
            public JContainer<Expression> getArguments() {
                return this.t.arguments;
            }

            public Annotation withArguments(@Nullable JContainer<Expression> arguments) {
                return this.t.arguments == arguments ? this.t : new Annotation(this.t.id, this.t.prefix, this.t.markers, this.t.annotationType, arguments);
            }

            public Padding(Annotation t) {
                this.t = t;
            }
        }
    }

    public static final class AnnotatedType
    implements J,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<Annotation> annotations;
        private final TypeTree typeExpression;

        @Override
        public JavaType getType() {
            return this.typeExpression.getType();
        }

        public AnnotatedType withType(@Nullable JavaType type) {
            return this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        @Override
        public <P> J acceptJava(JavaVisitor<P> v, P p) {
            return v.visitAnnotatedType(this, p);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed(new JavaPrinter());
        }

        @Override
        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression(this);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnnotatedType)) {
                return false;
            }
            AnnotatedType other = (AnnotatedType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public AnnotatedType(UUID id, Space prefix, Markers markers, List<Annotation> annotations, TypeTree typeExpression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.annotations = annotations;
            this.typeExpression = typeExpression;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @NonNull
        public AnnotatedType withId(UUID id) {
            return this.id == id ? this : new AnnotatedType(id, this.prefix, this.markers, this.annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AnnotatedType(this.id, prefix, this.markers, this.annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new AnnotatedType(this.id, this.prefix, markers, this.annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withAnnotations(List<Annotation> annotations) {
            return this.annotations == annotations ? this : new AnnotatedType(this.id, this.prefix, this.markers, annotations, this.typeExpression);
        }

        @NonNull
        public AnnotatedType withTypeExpression(TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new AnnotatedType(this.id, this.prefix, this.markers, this.annotations, typeExpression);
        }
    }
}

