/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

@Incubating(since="7.0.0")
public class FinalizeLocalVariables
extends Recipe {
    public String getDisplayName() {
        return "Finalize local variables";
    }

    public String getDescription() {
        return "Adds the `final` modifier keyword to local variables which are not reassigned.";
    }

    public JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext p) {
                J mv = super.visitVariableDeclarations(multiVariable, p);
                if (((J.VariableDeclarations)mv).hasModifier(J.Modifier.Type.Final)) {
                    return mv;
                }
                if (((J.VariableDeclarations)mv).getVariables().stream().anyMatch(nv -> nv.getInitializer() == null)) {
                    return mv;
                }
                if (FinalizeLocalVariables.this.isDeclaredInForLoopControl(this.getCursor())) {
                    return mv;
                }
                if (((J.VariableDeclarations)mv).getVariables().stream().anyMatch(v -> v.isField(this.getCursor()) || FinalizeLocalVariables.this.isField(this.getCursor()))) {
                    return mv;
                }
                if (((J.VariableDeclarations)mv).getVariables().stream().noneMatch(v -> FindAssignmentReferencesToVariable.find((J)this.getCursor().getParentTreeCursor().getValue(), v).get())) {
                    mv = this.autoFormat(((J.VariableDeclarations)mv).withModifiers(ListUtils.concat(((J.VariableDeclarations)mv).getModifiers(), (Object)new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Final, Collections.emptyList()))), p);
                }
                return mv;
            }
        };
    }

    private boolean isDeclaredInForLoopControl(Cursor cursor) {
        return cursor.getParentTreeCursor().getValue() instanceof J.ForLoop.Control;
    }

    private boolean isField(Cursor cursor) {
        return cursor.dropParentUntil(parent -> parent instanceof J.ClassDeclaration || parent instanceof J.MethodDeclaration).getValue() instanceof J.ClassDeclaration;
    }

    private static final class FindAssignmentReferencesToVariable
    extends JavaIsoVisitor<AtomicBoolean> {
        private final J.VariableDeclarations.NamedVariable variable;

        static AtomicBoolean find(J j, J.VariableDeclarations.NamedVariable variable) {
            return (AtomicBoolean)new FindAssignmentReferencesToVariable(variable).reduce(j, new AtomicBoolean());
        }

        @Override
        public J.Assignment visitAssignment(J.Assignment assignment, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return assignment;
            }
            J a = super.visitAssignment(assignment, hasAssignment);
            if (((J.Assignment)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.Assignment)a).getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return a;
        }

        @Override
        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return assignOp;
            }
            J a = super.visitAssignmentOperation(assignOp, hasAssignment);
            if (((J.AssignmentOperation)a).getVariable() instanceof J.Identifier && (i = (J.Identifier)((J.AssignmentOperation)a).getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return a;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return unary;
            }
            J u = super.visitUnary(unary, hasAssignment);
            if (((J.Unary)u).getExpression() instanceof J.Identifier && (i = (J.Identifier)((J.Unary)u).getExpression()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return u;
        }

        public FindAssignmentReferencesToVariable(J.VariableDeclarations.NamedVariable variable) {
            this.variable = variable;
        }

        public J.VariableDeclarations.NamedVariable getVariable() {
            return this.variable;
        }

        @NonNull
        public String toString() {
            return "FinalizeLocalVariables.FindAssignmentReferencesToVariable(variable=" + this.getVariable() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindAssignmentReferencesToVariable)) {
                return false;
            }
            FindAssignmentReferencesToVariable other = (FindAssignmentReferencesToVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            J.VariableDeclarations.NamedVariable this$variable = this.getVariable();
            J.VariableDeclarations.NamedVariable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !((Object)this$variable).equals(other$variable));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FindAssignmentReferencesToVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            J.VariableDeclarations.NamedVariable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : ((Object)$variable).hashCode());
            return result;
        }
    }
}

