/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Cursor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.style.UnnecessaryParenthesesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;

public class UnnecessaryParenthesesVisitor<P>
extends JavaVisitor<P> {
    private final UnnecessaryParenthesesStyle style;
    private static final String UNNECESSARY_PARENTHESES_MARKER = "unnecessaryParenthesesUnwrapTarget";

    public UnnecessaryParenthesesVisitor(UnnecessaryParenthesesStyle style) {
        this.style = style;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, P p) {
        J par = super.visitParentheses(parens, p);
        Cursor c = (Cursor)this.getCursor().pollNearestMessage(UNNECESSARY_PARENTHESES_MARKER);
        if (c != null && (c.getValue() instanceof J.Literal || c.getValue() instanceof J.Identifier)) {
            par = (J)new UnwrapParentheses((J.Parentheses)par).visit(par, p, this.getCursor());
        }
        assert (par != null);
        if (par instanceof J.Parentheses) {
            if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Parentheses) {
                return ((J.Parentheses)par).getTree().withPrefix(Space.EMPTY);
            }
        }
        return par;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, P p) {
        J.Identifier i = (J.Identifier)this.visitAndCast(ident, p, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
        if (this.style.getIdent().booleanValue()) {
            if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Parentheses) {
                this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MARKER, (Object)this.getCursor());
            }
        }
        return i;
    }

    @Override
    public J visitLiteral(J.Literal literal, P p) {
        J.Literal l;
        block5: {
            block4: {
                l = (J.Literal)this.visitAndCast(literal, p, (x$0, x$1) -> super.visitLiteral((J.Literal)x$0, x$1));
                JavaType.Primitive type = l.getType();
                if (this.style.getNumInt().booleanValue() && type == JavaType.Primitive.Int || this.style.getNumDouble().booleanValue() && type == JavaType.Primitive.Double || this.style.getNumLong().booleanValue() && type == JavaType.Primitive.Long || this.style.getNumFloat().booleanValue() && type == JavaType.Primitive.Float || this.style.getStringLiteral().booleanValue() && type == JavaType.Primitive.String || this.style.getLiteralNull().booleanValue() && type == JavaType.Primitive.Null || this.style.getLiteralFalse().booleanValue() && type == JavaType.Primitive.Boolean && l.getValue() == Boolean.valueOf(false)) break block4;
                if (!this.style.getLiteralTrue().booleanValue() || type != JavaType.Primitive.Boolean || l.getValue() != Boolean.valueOf(true)) break block5;
            }
            if (this.getCursor().dropParentUntil(J.class::isInstance).getValue() instanceof J.Parentheses) {
                this.getCursor().putMessageOnFirstEnclosing(J.Parentheses.class, UNNECESSARY_PARENTHESES_MARKER, (Object)this.getCursor());
            }
        }
        return l;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, P p) {
        J.AssignmentOperation a = (J.AssignmentOperation)this.visitAndCast(assignOp, p, (x$0, x$1) -> super.visitAssignmentOperation((J.AssignmentOperation)x$0, x$1));
        J.AssignmentOperation.Type op = a.getOperator();
        if (a.getAssignment() instanceof J.Parentheses && (this.style.getBitAndAssign() != false && op == J.AssignmentOperation.Type.BitAnd || this.style.getBitOrAssign() != false && op == J.AssignmentOperation.Type.BitOr || this.style.getBitShiftRightAssign() != false && op == J.AssignmentOperation.Type.UnsignedRightShift || this.style.getBitXorAssign() != false && op == J.AssignmentOperation.Type.BitXor || this.style.getShiftRightAssign() != false && op == J.AssignmentOperation.Type.RightShift || this.style.getShiftLeftAssign() != false && op == J.AssignmentOperation.Type.LeftShift || this.style.getMinusAssign() != false && op == J.AssignmentOperation.Type.Subtraction || this.style.getDivAssign() != false && op == J.AssignmentOperation.Type.Division || this.style.getPlusAssign() != false && op == J.AssignmentOperation.Type.Addition || this.style.getStarAssign() != false && op == J.AssignmentOperation.Type.Multiplication || this.style.getModAssign().booleanValue() && op == J.AssignmentOperation.Type.Modulo)) {
            a = (J.AssignmentOperation)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visitNonNull(a, p, this.getCursor());
        }
        return a;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, P p) {
        J.Assignment a = (J.Assignment)this.visitAndCast(assignment, p, (x$0, x$1) -> super.visitAssignment((J.Assignment)x$0, x$1));
        if (this.style.getAssign().booleanValue() && a.getAssignment() instanceof J.Parentheses) {
            a = (J.Assignment)new UnwrapParentheses((J.Parentheses)a.getAssignment()).visitNonNull(a, p, this.getCursor());
        }
        return a;
    }

    @Override
    public J visitReturn(J.Return retrn, P p) {
        J.Return rtn = (J.Return)this.visitAndCast(retrn, p, (x$0, x$1) -> super.visitReturn((J.Return)x$0, x$1));
        if (this.style.getExpr().booleanValue() && rtn.getExpression() instanceof J.Parentheses) {
            rtn = (J.Return)new UnwrapParentheses((J.Parentheses)rtn.getExpression()).visitNonNull(rtn, p, this.getCursor());
        }
        return rtn;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)this.visitAndCast(variable, p, (x$0, x$1) -> super.visitVariable((J.VariableDeclarations.NamedVariable)x$0, x$1));
        if (this.style.getAssign().booleanValue() && v.getInitializer() != null && v.getInitializer() instanceof J.Parentheses) {
            v = (J.VariableDeclarations.NamedVariable)new UnwrapParentheses((J.Parentheses)v.getInitializer()).visitNonNull(v, p, this.getCursor());
        }
        return v;
    }

    @Override
    public J visitLambda(J.Lambda lambda, P p) {
        J.Lambda l = (J.Lambda)this.visitAndCast(lambda, p, (x$0, x$1) -> super.visitLambda((J.Lambda)x$0, x$1));
        if (l.getParameters().getParameters().size() == 1 && l.getParameters().isParenthesized() && l.getParameters().getParameters().get(0) instanceof J.VariableDeclarations && ((J.VariableDeclarations)l.getParameters().getParameters().get(0)).getTypeExpression() == null) {
            l = l.withParameters(l.getParameters().withParenthesized(false));
        }
        return l;
    }
}

