/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.search.FindDeprecatedClasses;
import org.openrewrite.java.search.FindDeprecatedFields;
import org.openrewrite.java.search.FindDeprecatedMethods;

public class FindDeprecatedUses
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find deprecations from certain types.", example="org.springframework..*", required=false)
    @Nullable
    private final String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    @Nullable
    private final Boolean matchInherited;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated type is used in a deprecated method or class, ignore it.", required=false)
    @Nullable
    private final Boolean ignoreDeprecatedScopes;

    public FindDeprecatedUses(@Nullable String typePattern, @Nullable Boolean matchInherited, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
        this.doNext(new FindDeprecatedMethods((typePattern == null ? "*..*" : typePattern) + " *(..)", ignoreDeprecatedScopes));
        this.doNext(new FindDeprecatedClasses(typePattern, matchInherited, ignoreDeprecatedScopes));
        this.doNext(new FindDeprecatedFields(typePattern, ignoreDeprecatedScopes));
    }

    public String getDisplayName() {
        return "Find uses of deprecated classes, methods, and fields";
    }

    public String getDescription() {
        return "Find deprecated uses of methods, fields, and types. Optionally ignore those classes that are inside of deprecated scopes.";
    }

    @Nullable
    public String getTypePattern() {
        return this.typePattern;
    }

    @Nullable
    public Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Nullable
    public Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }
}

