/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow.internal.csv;

import java.util.Optional;
import java.util.regex.Matcher;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.dataflow.internal.csv.Internal;

public interface GenericExternalModel {
    public String getNamespace();

    public String getType();

    public boolean isSubtypes();

    public String getName();

    public String getSignature();

    public String getArguments();

    default public String getFullyQualifiedName() {
        return this.getNamespace() + "." + this.getType();
    }

    default public boolean isConstructor() {
        return this.getType().equals(this.getName());
    }

    default public MethodMatcherKey asMethodMatcherKey() {
        String signature = this.getSignature().isEmpty() ? "(..)" : this.getSignature();
        String fullSignature = this.isConstructor() ? this.getNamespace() + '.' + this.getType() + ' ' + "<constructor>" + signature : this.getNamespace() + '.' + this.getType() + ' ' + this.getName() + signature;
        return new MethodMatcherKey(fullSignature, this.isSubtypes());
    }

    default public Optional<ArgumentRange> getArgumentRange() {
        Matcher argumentMatcher = Internal.ARGUMENT_MATCHER.matcher(this.getArguments());
        if (argumentMatcher.matches()) {
            int argumentIndexStart = Integer.parseInt(argumentMatcher.group(1));
            if (argumentMatcher.group(2) != null) {
                int argumentIndexEnd = Integer.parseInt(argumentMatcher.group(2));
                return Optional.of(new ArgumentRange(argumentIndexStart, argumentIndexEnd));
            }
            return Optional.of(new ArgumentRange(argumentIndexStart, argumentIndexStart));
        }
        return Optional.empty();
    }

    public static class MethodMatcherKey {
        final String signature;
        final boolean matchOverrides;

        public MethodMatcherKey(String signature, boolean matchOverrides) {
            this.signature = signature;
            this.matchOverrides = matchOverrides;
        }

        public String getSignature() {
            return this.signature;
        }

        public boolean isMatchOverrides() {
            return this.matchOverrides;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodMatcherKey)) {
                return false;
            }
            MethodMatcherKey other = (MethodMatcherKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMatchOverrides() != other.isMatchOverrides()) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MethodMatcherKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatchOverrides() ? 79 : 97);
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "GenericExternalModel.MethodMatcherKey(signature=" + this.getSignature() + ", matchOverrides=" + this.isMatchOverrides() + ")";
        }
    }

    public static class ArgumentRange {
        final int start;
        final int end;

        public ArgumentRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArgumentRange)) {
                return false;
            }
            ArgumentRange other = (ArgumentRange)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ArgumentRange;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStart();
            result = result * 59 + this.getEnd();
            return result;
        }

        @NonNull
        public String toString() {
            return "GenericExternalModel.ArgumentRange(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

