/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.AdditionalFlowStepPredicate;
import org.openrewrite.java.dataflow.MethodMatcherCache;
import org.openrewrite.java.dataflow.internal.InvocationMatcher;
import org.openrewrite.java.dataflow.internal.csv.CsvLoader;
import org.openrewrite.java.dataflow.internal.csv.GenericExternalModel;
import org.openrewrite.java.dataflow.internal.csv.Mergeable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.24.1")
final class ExternalFlowModels {
    private static final String CURSOR_MESSAGE_KEY = "OPTIMIZED_FLOW_MODELS";
    private static final ExternalFlowModels instance = new ExternalFlowModels();
    private WeakReference<FullyQualifiedNameToFlowModels> fullyQualifiedNameToFlowModels;

    public static ExternalFlowModels instance() {
        return instance;
    }

    private FullyQualifiedNameToFlowModels getFullyQualifiedNameToFlowModels() {
        FullyQualifiedNameToFlowModels f;
        if (this.fullyQualifiedNameToFlowModels == null) {
            f = Loader.create().load();
            this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
        } else {
            f = (FullyQualifiedNameToFlowModels)this.fullyQualifiedNameToFlowModels.get();
            if (f == null) {
                f = Loader.create().load();
                this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
            }
        }
        return f;
    }

    private OptimizedFlowModels getOptimizedFlowModelsForTypesInUse(TypesInUse typesInUse) {
        return Optimizer.optimize(this.getFullyQualifiedNameToFlowModels().forTypesInUse(typesInUse));
    }

    private OptimizedFlowModels getOrComputeOptimizedFlowModels(Cursor cursor) {
        Cursor cuCursor = cursor.dropParentUntil(J.CompilationUnit.class::isInstance);
        return (OptimizedFlowModels)cuCursor.computeMessageIfAbsent(CURSOR_MESSAGE_KEY, __ -> this.getOptimizedFlowModelsForTypesInUse(((J.CompilationUnit)cuCursor.getValue()).getTypesInUse()));
    }

    boolean isAdditionalFlowStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
        return this.getOrComputeOptimizedFlowModels(srcCursor).value.stream().anyMatch(value -> value.isAdditionalFlowStep(srcExpression, srcCursor, sinkExpression, sinkCursor));
    }

    boolean isAdditionalTaintStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
        return this.getOrComputeOptimizedFlowModels(srcCursor).taint.stream().anyMatch(taint -> taint.isAdditionalFlowStep(srcExpression, srcCursor, sinkExpression, sinkCursor));
    }

    private ExternalFlowModels() {
    }

    private static class Loader {
        private Loader() {
        }

        private static Loader create() {
            return new Loader();
        }

        FullyQualifiedNameToFlowModels load() {
            return this.loadModelFromFile();
        }

        private FullyQualifiedNameToFlowModels loadModelFromFile() {
            return CsvLoader.loadFromFile("model.csv", FullyQualifiedNameToFlowModels.empty(), Loader::createFullyQualifiedNameToFlowModels, tokens -> new FlowModel(tokens[0], tokens[1], Boolean.parseBoolean(tokens[2]), tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[8]));
        }

        private static FullyQualifiedNameToFlowModels createFullyQualifiedNameToFlowModels(Iterable<FlowModel> flowModels) {
            HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>();
            HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>();
            for (FlowModel model : flowModels) {
                if ("value".equals(model.kind)) {
                    value.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                    continue;
                }
                if ("taint".equals(model.kind)) {
                    taint.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                    continue;
                }
                throw new IllegalArgumentException("Unknown kind: " + model.kind);
            }
            return new FullyQualifiedNameToFlowModels(value, taint);
        }
    }

    static class FullyQualifiedNameToFlowModels
    implements Mergeable<FullyQualifiedNameToFlowModels> {
        private final Map<String, List<FlowModel>> value;
        private final Map<String, List<FlowModel>> taint;

        boolean isEmpty() {
            return this.value.isEmpty() && this.taint.isEmpty();
        }

        @Override
        public FullyQualifiedNameToFlowModels merge(FullyQualifiedNameToFlowModels other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>(this.value);
            other.value.forEach((k, v) -> value.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>(this.taint);
            other.taint.forEach((k, v) -> taint.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            return new FullyQualifiedNameToFlowModels(value, taint);
        }

        FlowModels forTypesInUse(TypesInUse typesInUse) {
            HashSet<FlowModel> value = new HashSet<FlowModel>();
            HashSet<FlowModel> taint = new HashSet<FlowModel>();
            typesInUse.getUsedMethods().stream().map(JavaType.Method::getDeclaringType).filter(o -> o != null && !(o instanceof JavaType.Unknown)).map(JavaType.FullyQualified::getFullyQualifiedName).distinct().forEach(fqn -> {
                value.addAll(this.value.getOrDefault(fqn, Collections.emptyList()));
                taint.addAll(this.taint.getOrDefault(fqn, Collections.emptyList()));
            });
            return new FlowModels(value, taint);
        }

        static FullyQualifiedNameToFlowModels empty() {
            return new FullyQualifiedNameToFlowModels(new HashMap<String, List<FlowModel>>(0), new HashMap<String, List<FlowModel>>(0));
        }

        public FullyQualifiedNameToFlowModels(Map<String, List<FlowModel>> value, Map<String, List<FlowModel>> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class FlowModels {
        Set<FlowModel> value;
        Set<FlowModel> taint;

        public FlowModels(Set<FlowModel> value, Set<FlowModel> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    private static class Optimizer {
        private final MethodMatcherCache methodMatcherCache = MethodMatcherCache.create();

        private AdditionalFlowStepPredicate forFlowFromArgumentIndexToReturn(int argumentIndex, Collection<MethodMatcher> methodMatchers) {
            InvocationMatcher callMatcher = InvocationMatcher.fromMethodMatchers(methodMatchers);
            if (argumentIndex == -1) {
                return (srcExpression, srcCursor, sinkExpression, sinkCursor) -> callMatcher.advanced().isSelect(srcCursor);
            }
            return (srcExpression, srcCursor, sinkExpression, sinkCursor) -> callMatcher.advanced().isParameter(srcCursor, argumentIndex);
        }

        private List<AdditionalFlowStepPredicate> optimize(Collection<FlowModel> models) {
            HashMap flowFromArgumentIndexToReturn = new HashMap();
            models.forEach(model -> {
                if ("ReturnValue".equals(model.output) || model.isConstructor()) {
                    model.getArgumentRange().ifPresent(argumentRange -> {
                        for (int i = argumentRange.getStart(); i <= argumentRange.getEnd(); ++i) {
                            flowFromArgumentIndexToReturn.computeIfAbsent(i, __ -> new ArrayList()).add(model);
                        }
                    });
                }
            });
            return flowFromArgumentIndexToReturn.entrySet().stream().map(entry -> {
                Collection<MethodMatcher> methodMatchers = this.methodMatcherCache.provideMethodMatchers((Collection)entry.getValue());
                return this.forFlowFromArgumentIndexToReturn((Integer)entry.getKey(), methodMatchers);
            }).collect(Collectors.toList());
        }

        private static OptimizedFlowModels optimize(FlowModels flowModels) {
            Optimizer optimizer = new Optimizer();
            return new OptimizedFlowModels(optimizer.optimize(flowModels.value), optimizer.optimize(flowModels.taint));
        }

        private Optimizer() {
        }
    }

    private static class OptimizedFlowModels {
        private final List<AdditionalFlowStepPredicate> value;
        private final List<AdditionalFlowStepPredicate> taint;

        public OptimizedFlowModels(List<AdditionalFlowStepPredicate> value, List<AdditionalFlowStepPredicate> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class FlowModel
    implements GenericExternalModel {
        String namespace;
        String type;
        boolean subtypes;
        String name;
        String signature;
        String ext;
        String input;
        String output;
        String kind;

        @Override
        public String getArguments() {
            return this.input;
        }

        public FlowModel(String namespace, String type, boolean subtypes, String name, String signature, String ext, String input, String output, String kind) {
            this.namespace = namespace;
            this.type = type;
            this.subtypes = subtypes;
            this.name = name;
            this.signature = signature;
            this.ext = ext;
            this.input = input;
            this.output = output;
            this.kind = kind;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isSubtypes() {
            return this.subtypes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }
    }
}

