/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public class UnnecessaryCloseInTryWithResources
extends Recipe {
    public String getDisplayName() {
        return "Unnecessary close in try-with-resources";
    }

    public String getDescription() {
        return "Remove unnecessary `AutoCloseable#close()` statements in try-with-resources.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-4087");
    }

    protected JavaIsoVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Try.Resource visitTryResource(J.Try.Resource tryResource, ExecutionContext executionContext) {
                return tryResource.withMarkers(tryResource.getMarkers().searchResult());
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UnnecessaryAutoCloseableVisitor();
    }

    private static class UnnecessaryAutoCloseableVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher AUTO_CLOSEABLE_METHOD_MATCHER = new MethodMatcher("java.lang.AutoCloseable close()", true);

        private UnnecessaryAutoCloseableVisitor() {
        }

        @Override
        public J.Try visitTry(J.Try _try, ExecutionContext executionContext) {
            J tr = super.visitTry(_try, executionContext);
            if (((J.Try)tr).getResources() != null) {
                String[] resourceNames = new String[((J.Try)tr).getResources().size()];
                for (int i = 0; i < ((J.Try)tr).getResources().size(); ++i) {
                    J.Try.Resource tryResource = ((J.Try)tr).getResources().get(i);
                    if (tryResource.getVariableDeclarations() instanceof J.VariableDeclarations) {
                        J.VariableDeclarations varDecls = (J.VariableDeclarations)tryResource.getVariableDeclarations();
                        resourceNames[i] = varDecls.getVariables().get(0).getSimpleName();
                        continue;
                    }
                    if (!(tryResource.getVariableDeclarations() instanceof J.Identifier)) continue;
                    J.Identifier identifier = (J.Identifier)tryResource.getVariableDeclarations();
                    resourceNames[i] = identifier.getSimpleName();
                }
                tr = ((J.Try)tr).withBody(((J.Try)tr).getBody().withStatements(ListUtils.map(((J.Try)tr).getBody().getStatements(), statement -> {
                    J.MethodInvocation mi;
                    if (statement instanceof J.MethodInvocation && AUTO_CLOSEABLE_METHOD_MATCHER.matches(mi = (J.MethodInvocation)statement) && mi.getSelect() instanceof J.Identifier) {
                        String selectName = ((J.Identifier)mi.getSelect()).getSimpleName();
                        for (String resourceName : resourceNames) {
                            if (!resourceName.equals(selectName)) continue;
                            return null;
                        }
                    }
                    return statement;
                })));
            }
            return tr;
        }
    }
}

