/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class ControlFlowJavaPrinter<P>
extends JavaPrinter<P> {
    final List<J> nodesToPrint;

    @Override
    public J visitAssert(J.Assert azzert, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(azzert, p);
        J j = super.visitAssert(azzert, p);
        return j;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(assignment, p);
        J j = super.visitAssignment(assignment, p);
        return j;
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(assignOp, p);
        J j = super.visitAssignmentOperation(assignOp, p);
        return j;
    }

    @Override
    public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(binary, p);
        J j = super.visitBinary(binary, p);
        return j;
    }

    @Override
    public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(block, p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_PREFIX, p);
        this.visitMarkers(block.getMarkers(), p);
        if (block.isStatic()) {
            p.append("static");
            this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
        }
        p.append('{');
        this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
        p.append('}');
        return block;
    }

    @Override
    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.maybeEnableOrDisable(paddedStat.getElement(), p);
        super.visitStatement(paddedStat, location, p);
    }

    @Override
    public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(breakStatement, p);
        J j = super.visitBreak(breakStatement, p);
        return j;
    }

    @Override
    public J visitCase(J.Case caze, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(caze, p);
        J j = super.visitCase(caze, p);
        return j;
    }

    @Override
    public J visitCatch(J.Try.Catch catzh, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(catzh, p);
        J j = super.visitCatch(catzh, p);
        return j;
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(classDecl, p);
        J j = super.visitClassDeclaration(classDecl, p);
        return j;
    }

    @Override
    public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(continueStatement, p);
        J j = super.visitContinue(continueStatement, p);
        return j;
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
        J.If enclosing = (J.If)this.getCursor().firstEnclosing(J.If.class);
        if (enclosing != null && enclosing.getIfCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.WhileLoop enclosingLoop = (J.WhileLoop)this.getCursor().firstEnclosing(J.WhileLoop.class);
        if (enclosingLoop != null && enclosingLoop.getCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        J.DoWhileLoop enclosingDoWhileLoop = (J.DoWhileLoop)this.getCursor().firstEnclosing(J.DoWhileLoop.class);
        if (enclosingDoWhileLoop != null && enclosingDoWhileLoop.getWhileCondition() == controlParens) {
            return super.visitControlParentheses(controlParens, p);
        }
        this.maybeEnableOrDisable(controlParens, p);
        J j = super.visitControlParentheses(controlParens, p);
        return j;
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(doWhileLoop, p);
        J j = super.visitDoWhileLoop(doWhileLoop, p);
        return j;
    }

    @Override
    public J visitEnumValue(J.EnumValue enoom, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(enoom, p);
        J j = super.visitEnumValue(enoom, p);
        return j;
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(enums, p);
        J j = super.visitEnumValueSet(enums, p);
        return j;
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(fieldAccess, p);
        J j = super.visitFieldAccess(fieldAccess, p);
        return j;
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(forLoop, p);
        J j = super.visitForLoop(forLoop, p);
        return j;
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(forEachLoop, p);
        J j = super.visitForEachLoop(forEachLoop, p);
        return j;
    }

    @Override
    public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
        J.Assignment parentAssignment = (J.Assignment)this.getCursor().firstEnclosing(J.Assignment.class);
        if (parentAssignment != null && parentAssignment.getVariable().unwrap() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.VariableDeclarations.NamedVariable parentNamedVariable = (J.VariableDeclarations.NamedVariable)this.getCursor().firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        if (parentNamedVariable != null && parentNamedVariable.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.FieldAccess parentFieldAccess = (J.FieldAccess)this.getCursor().firstEnclosing(J.FieldAccess.class);
        if (parentFieldAccess != null && parentFieldAccess.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.NewClass parentNewClass = (J.NewClass)this.getCursor().firstEnclosing(J.NewClass.class);
        if (parentNewClass != null && parentNewClass.getClazz() == ident) {
            return super.visitIdentifier(ident, p);
        }
        J.MethodInvocation parentMethodInvocation = (J.MethodInvocation)this.getCursor().firstEnclosing(J.MethodInvocation.class);
        if (parentMethodInvocation != null && parentMethodInvocation.getName() == ident) {
            return super.visitIdentifier(ident, p);
        }
        this.maybeEnableOrDisable(ident, p);
        J j = super.visitIdentifier(ident, p);
        return j;
    }

    @Override
    public J visitIf(J.If iff, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(iff, p);
        J j = super.visitIf(iff, p);
        return j;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(instanceOf, p);
        J j = super.visitInstanceOf(instanceOf, p);
        return j;
    }

    @Override
    public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(lambda, p);
        J j = super.visitLambda(lambda, p);
        return j;
    }

    @Override
    public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(literal, p);
        J j = super.visitLiteral(literal, p);
        return j;
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(memberRef, p);
        J j = super.visitMemberReference(memberRef, p);
        return j;
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(method, p);
        J j = super.visitMethodDeclaration(method, p);
        return j;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(method, p);
        J j = super.visitMethodInvocation(method, p);
        return j;
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(multiCatch, p);
        J j = super.visitMultiCatch(multiCatch, p);
        return j;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(multiVariable, p);
        J j = super.visitVariableDeclarations(multiVariable, p);
        return j;
    }

    @Override
    public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(newArray, p);
        J j = super.visitNewArray(newArray, p);
        return j;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(parens, p);
        J j = super.visitParentheses(parens, p);
        return j;
    }

    @Override
    public J visitSwitch(J.Switch switzh, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(switzh, p);
        J j = super.visitSwitch(switzh, p);
        return j;
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(synch, p);
        J j = super.visitSynchronized(synch, p);
        return j;
    }

    @Override
    public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(ternary, p);
        J j = super.visitTernary(ternary, p);
        return j;
    }

    @Override
    public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(thrown, p);
        J j = super.visitThrow(thrown, p);
        return j;
    }

    @Override
    public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(tryable, p);
        J j = super.visitTry(tryable, p);
        return j;
    }

    @Override
    public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(unary, p);
        J j = super.visitUnary(unary, p);
        return j;
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(variable, p);
        J j = super.visitVariable(variable, p);
        return j;
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, PrintOutputCapture<P> p) {
        this.maybeEnableOrDisable(whileLoop, p);
        J j = super.visitWhileLoop(whileLoop, p);
        return j;
    }

    private void maybeEnableOrDisable(J j, PrintOutputCapture<P> p) {
        if (this.nodesToPrint.contains(j)) {
            ControlFlowJavaPrinter.castPrint(p).enable();
        } else {
            ControlFlowJavaPrinter.castPrint(p).disable();
        }
    }

    private static <P> ControlFlowPrintOutputCapture<P> castPrint(PrintOutputCapture<P> print) {
        return (ControlFlowPrintOutputCapture)print;
    }

    public ControlFlowJavaPrinter(List<J> nodesToPrint) {
        this.nodesToPrint = nodesToPrint;
    }

    static class ControlFlowPrintOutputCapture<P>
    extends PrintOutputCapture<P> {
        boolean enabled = false;

        public ControlFlowPrintOutputCapture(P p) {
            super(p);
        }

        public PrintOutputCapture<P> append(char c) {
            if (this.enabled) {
                return super.append(c);
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    return super.append(c);
                }
            }
            return super.append(' ');
        }

        public PrintOutputCapture<P> append(@Nullable String text) {
            if (this.enabled) {
                return super.append(text);
            }
            if (text != null) {
                return super.append(text.replaceAll("[^ \\t\\n\\r]", " "));
            }
            return this;
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
        }
    }
}

