/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.NameCaseConvention;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public final class MethodNameCasing
extends Recipe {
    @Option(displayName="Apply recipe to test source set", description="Changes only apply to main by default. `includeTestSources` will apply the recipe to `test` source files.", required=false, example="true")
    @Nullable
    private final Boolean includeTestSources;

    public String getDisplayName() {
        return "Method name casing";
    }

    public String getDescription() {
        return "Method names should comply with a naming convention.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-100");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern standardMethodName = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
        final Pattern snakeCase = Pattern.compile("^[a-zA-Z0-9_]*$");
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                Optional sourceSet = cu.getMarkers().findFirst(JavaSourceSet.class);
                if (sourceSet.isPresent() && (Boolean.TRUE.equals(MethodNameCasing.this.includeTestSources) || "main".equals(((JavaSourceSet)sourceSet.get()).getName()))) {
                    return super.visitCompilationUnit(cu, executionContext);
                }
                return cu;
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                if (!(method.getMethodType() == null || ((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType() == null || method.isConstructor() || TypeUtils.isOverride(method.getMethodType()) || standardMethodName.matcher(method.getSimpleName()).matches())) {
                    StringBuilder standardized = new StringBuilder();
                    char[] name = method.getSimpleName().toCharArray();
                    if (snakeCase.matcher(method.getSimpleName()).matches()) {
                        standardized.append(NameCaseConvention.format((NameCaseConvention)NameCaseConvention.LOWER_CAMEL, (String)method.getSimpleName().toLowerCase()));
                    } else {
                        for (int i = 0; i < name.length; ++i) {
                            char c = name[i];
                            if (i == 0) {
                                if (c == '$' || c == '_') continue;
                                standardized.append(Character.toLowerCase(c));
                                continue;
                            }
                            if (!Character.isLetterOrDigit(c)) {
                                while (!(i >= name.length || Character.isLetterOrDigit(name[i]) && name[i] <= 'z')) {
                                    ++i;
                                }
                                if (i >= name.length) continue;
                                standardized.append(Character.toUpperCase(name[i]));
                                continue;
                            }
                            standardized.append(c);
                        }
                    }
                    if (!StringUtils.isBlank((String)standardized.toString())) {
                        MethodNameCasing.this.doNext(new ChangeMethodName(MethodMatcher.methodPattern(method), standardized.toString(), true, false));
                    }
                }
                return super.visitMethodDeclaration(method, executionContext);
            }
        };
    }

    public MethodNameCasing(@Nullable Boolean includeTestSources) {
        this.includeTestSources = includeTestSources;
    }

    @Nullable
    public Boolean getIncludeTestSources() {
        return this.includeTestSources;
    }

    @NonNull
    public String toString() {
        return "MethodNameCasing(includeTestSources=" + this.getIncludeTestSources() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodNameCasing)) {
            return false;
        }
        MethodNameCasing other = (MethodNameCasing)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$includeTestSources = this.getIncludeTestSources();
        Boolean other$includeTestSources = other.getIncludeTestSources();
        return !(this$includeTestSources == null ? other$includeTestSources != null : !((Object)this$includeTestSources).equals(other$includeTestSources));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MethodNameCasing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $includeTestSources = this.getIncludeTestSources();
        result = result * 59 + ($includeTestSources == null ? 43 : ((Object)$includeTestSources).hashCode());
        return result;
    }
}

