/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public final class ChangeType
extends Recipe {
    @Option(displayName="Old fully-qualified type name", description="Fully-qualified class name of the original type.", example="org.junit.Assume")
    private final String oldFullyQualifiedTypeName;
    @Option(displayName="New fully-qualified type name", description="Fully-qualified class name of the replacement type, or the name of a primitive such as \"int\". The `OuterClassName$NestedClassName` naming convention should be used for nested classes.", example="org.junit.jupiter.api.Assumptions")
    private final String newFullyQualifiedTypeName;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", example="true", required=false)
    @Nullable
    private final Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Change type";
    }

    public String getDescription() {
        return "Change a given type to another.";
    }

    public boolean causesAnotherCycle() {
        return true;
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
                Boolean visit;
                J sf = super.visitJavaSourceFile(cu, executionContext);
                if (!Boolean.TRUE.equals(ChangeType.this.ignoreDefinition) && (visit = (Boolean)this.getCursor().pollNearestMessage("TARGET_CLASS")) != null && visit.booleanValue()) {
                    return (JavaSourceFile)sf.withMarkers(sf.getMarkers().searchResult());
                }
                this.doAfterVisit(new UsesType(ChangeType.this.oldFullyQualifiedTypeName));
                return sf;
            }

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J cd = super.visitClassDeclaration(classDecl, executionContext);
                if (!Boolean.TRUE.equals(ChangeType.this.ignoreDefinition) && TypeUtils.isOfClassType(((J.ClassDeclaration)cd).getType(), ChangeType.this.oldFullyQualifiedTypeName)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "TARGET_CLASS", (Object)true);
                }
                return cd;
            }
        };
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new ChangeTypeVisitor(this.oldFullyQualifiedTypeName, this.newFullyQualifiedTypeName, this.ignoreDefinition);
    }

    public ChangeType(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName, @Nullable Boolean ignoreDefinition) {
        this.oldFullyQualifiedTypeName = oldFullyQualifiedTypeName;
        this.newFullyQualifiedTypeName = newFullyQualifiedTypeName;
        this.ignoreDefinition = ignoreDefinition;
    }

    public String getOldFullyQualifiedTypeName() {
        return this.oldFullyQualifiedTypeName;
    }

    public String getNewFullyQualifiedTypeName() {
        return this.newFullyQualifiedTypeName;
    }

    @Nullable
    public Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @NonNull
    public String toString() {
        return "ChangeType(oldFullyQualifiedTypeName=" + this.getOldFullyQualifiedTypeName() + ", newFullyQualifiedTypeName=" + this.getNewFullyQualifiedTypeName() + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeType)) {
            return false;
        }
        ChangeType other = (ChangeType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        String other$oldFullyQualifiedTypeName = other.getOldFullyQualifiedTypeName();
        if (this$oldFullyQualifiedTypeName == null ? other$oldFullyQualifiedTypeName != null : !this$oldFullyQualifiedTypeName.equals(other$oldFullyQualifiedTypeName)) {
            return false;
        }
        String this$newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        String other$newFullyQualifiedTypeName = other.getNewFullyQualifiedTypeName();
        return !(this$newFullyQualifiedTypeName == null ? other$newFullyQualifiedTypeName != null : !this$newFullyQualifiedTypeName.equals(other$newFullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $oldFullyQualifiedTypeName = this.getOldFullyQualifiedTypeName();
        result = result * 59 + ($oldFullyQualifiedTypeName == null ? 43 : $oldFullyQualifiedTypeName.hashCode());
        String $newFullyQualifiedTypeName = this.getNewFullyQualifiedTypeName();
        result = result * 59 + ($newFullyQualifiedTypeName == null ? 43 : $newFullyQualifiedTypeName.hashCode());
        return result;
    }

    private static class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private final JavaType.Class originalType;
        private final JavaType targetType;
        @Nullable
        private final Boolean ignoreDefinition;
        private final Map<String, JavaType> oldNameToChangedType = new HashMap<String, JavaType>();

        private ChangeTypeVisitor(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName, @Nullable Boolean ignoreDefinition) {
            this.originalType = JavaType.ShallowClass.build(oldFullyQualifiedTypeName);
            this.targetType = JavaType.buildType(newFullyQualifiedTypeName);
            this.ignoreDefinition = ignoreDefinition;
        }

        @Override
        public J visitJavaSourceFile(JavaSourceFile cu, ExecutionContext executionContext) {
            JavaType.FullyQualified fq;
            if (!Boolean.TRUE.equals(this.ignoreDefinition) && (fq = TypeUtils.asFullyQualified(this.targetType)) != null) {
                ChangeClassDefinition changeClassDefinition = new ChangeClassDefinition(this.originalType.getFullyQualifiedName(), fq.getFullyQualifiedName());
                cu = (JavaSourceFile)changeClassDefinition.visit(cu, executionContext);
                assert (cu != null);
            }
            return super.visitJavaSourceFile(cu, executionContext);
        }

        @Override
        public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            JavaType.FullyQualified fullyQualifiedTarget;
            J.CompilationUnit c = (J.CompilationUnit)this.visitAndCast(cu, ctx, (x$0, x$1) -> super.visitCompilationUnit((J.CompilationUnit)x$0, x$1));
            c = (J.CompilationUnit)new RemoveImport(this.originalType.getFullyQualifiedName()).visit(c, ctx);
            if (this.originalType.getOwningClass() != null) {
                c = (J.CompilationUnit)new RemoveImport(this.originalType.getOwningClass().getFullyQualifiedName()).visit(c, ctx);
            }
            if ((fullyQualifiedTarget = TypeUtils.asFullyQualified(this.targetType)) != null) {
                if (fullyQualifiedTarget.getOwningClass() != null && !"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                    c = (J.CompilationUnit)new AddImport(fullyQualifiedTarget.getOwningClass().getFullyQualifiedName(), null, true).visit(c, ctx);
                }
                if (!"java.lang".equals(fullyQualifiedTarget.getPackageName())) {
                    c = (J.CompilationUnit)new AddImport(fullyQualifiedTarget.getFullyQualifiedName(), null, true).visit(c, ctx);
                }
            }
            if (c != null) {
                c = c.withImports(ListUtils.map(c.getImports(), i -> (J.Import)this.visitAndCast((Tree)i, ctx, (x$0, x$1) -> super.visitImport((J.Import)x$0, x$1))));
            }
            return c;
        }

        @Override
        public J visitImport(J.Import impoort, ExecutionContext executionContext) {
            return impoort;
        }

        @Override
        @Nullable
        public JavaType visitType(@Nullable JavaType javaType, ExecutionContext executionContext) {
            return this.updateType(javaType);
        }

        @Nullable
        public J postVisit(J tree, ExecutionContext executionContext) {
            J j = (J)super.postVisit((Tree)tree, (Object)executionContext);
            if (j instanceof J.MethodDeclaration) {
                J.MethodDeclaration method = (J.MethodDeclaration)j;
                j = method.withMethodType(this.updateType(method.getMethodType()));
            } else if (j instanceof J.MethodInvocation) {
                J.MethodInvocation method = (J.MethodInvocation)j;
                j = method.withMethodType(this.updateType(method.getMethodType()));
            } else if (j instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)j;
                j = n.withConstructorType(this.updateType(n.getConstructorType()));
            } else if (tree instanceof TypedTree) {
                j = ((TypedTree)tree).withType(this.updateType(((TypedTree)tree).getType()));
            }
            return j;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            if (fieldAccess.isFullyQualifiedClassReference(this.originalType.getFullyQualifiedName())) {
                if (this.targetType instanceof JavaType.FullyQualified) {
                    return this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName()).withPrefix(fieldAccess.getPrefix()));
                }
                if (this.targetType instanceof JavaType.Primitive) {
                    return new J.Primitive(fieldAccess.getId(), fieldAccess.getPrefix(), Markers.EMPTY, (JavaType.Primitive)this.targetType);
                }
            } else {
                StringBuilder maybeClass = new StringBuilder();
                Expression target = fieldAccess;
                while (target != null) {
                    if (target instanceof J.FieldAccess) {
                        J.FieldAccess fa = target;
                        maybeClass.insert(0, fa.getSimpleName()).insert(0, '.');
                        target = fa.getTarget();
                        continue;
                    }
                    if (target instanceof J.Identifier) {
                        maybeClass.insert(0, ((J.Identifier)target).getSimpleName());
                        target = null;
                        continue;
                    }
                    maybeClass = new StringBuilder("__NOT_IT__");
                    break;
                }
                JavaType.ShallowClass oldType = JavaType.ShallowClass.build(this.originalType.getFullyQualifiedName());
                if (maybeClass.toString().equals(oldType.getClassName())) {
                    this.maybeRemoveImport(oldType.getOwningClass());
                    Expression e = this.updateOuterClassTypes((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName()).withPrefix(fieldAccess.getPrefix()));
                    if (e instanceof J.Identifier && e.getType() == null) {
                        J.Identifier i = (J.Identifier)e;
                        e = i.withType(this.targetType);
                    }
                    return e;
                }
            }
            return super.visitFieldAccess(fieldAccess, ctx);
        }

        @Override
        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            if (TypeUtils.isOfClassType(ident.getType(), this.originalType.getFullyQualifiedName())) {
                String className = this.originalType.getClassName();
                JavaType.FullyQualified iType = TypeUtils.asFullyQualified(ident.getType());
                if (iType != null && iType.getOwningClass() != null) {
                    className = this.originalType.getFullyQualifiedName().substring(iType.getOwningClass().getFullyQualifiedName().length() + 1);
                }
                if (ident.getSimpleName().equals(className)) {
                    if (this.targetType instanceof JavaType.FullyQualified) {
                        if (((JavaType.FullyQualified)this.targetType).getOwningClass() != null) {
                            return this.updateOuterClassTypes((Expression)((Expression)TypeTree.build(((JavaType.FullyQualified)this.targetType).getClassName())).withType(null).withPrefix(ident.getPrefix()));
                        }
                        ident = ident.withSimpleName(((JavaType.FullyQualified)this.targetType).getClassName());
                    } else if (this.targetType instanceof JavaType.Primitive) {
                        ident = ident.withSimpleName(((JavaType.Primitive)this.targetType).getKeyword());
                    }
                }
            }
            ident = ident.withType(this.updateType(ident.getType()));
            return (J)this.visitAndCast(ident, ctx, (x$0, x$1) -> super.visitIdentifier((J.Identifier)x$0, x$1));
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() != null && method.getMethodType().hasFlags(Flag.Static) && method.getMethodType().getDeclaringType().isAssignableFrom(this.originalType)) {
                J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class);
                for (J.Import anImport : cu.getImports()) {
                    JavaType.FullyQualified fqn;
                    if (!anImport.isStatic() || anImport.getQualid().getTarget().getType() == null || (fqn = TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType())) == null || !TypeUtils.isOfClassType(fqn, this.originalType.getFullyQualifiedName()) || !method.getSimpleName().equals(anImport.getQualid().getSimpleName())) continue;
                    this.maybeAddImport(((JavaType.FullyQualified)this.targetType).getFullyQualifiedName(), method.getName().getSimpleName());
                    break;
                }
            }
            return super.visitMethodInvocation(method, ctx);
        }

        private Expression updateOuterClassTypes(Expression typeTree) {
            if (typeTree instanceof J.FieldAccess) {
                JavaType.FullyQualified type = (JavaType.FullyQualified)this.targetType;
                if (type.getOwningClass() == null) {
                    typeTree.withType(this.updateType(this.targetType));
                }
                Stack<Expression> typeStack = new Stack<Expression>();
                typeStack.push(typeTree);
                Stack<JavaType.FullyQualified> attrStack = new Stack<JavaType.FullyQualified>();
                attrStack.push(type);
                Expression t = ((J.FieldAccess)typeTree).getTarget();
                while (true) {
                    typeStack.push(t);
                    if (t instanceof J.FieldAccess) {
                        if (Character.isUpperCase(((J.FieldAccess)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                            attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                        }
                        t = ((J.FieldAccess)t).getTarget();
                        continue;
                    }
                    if (t instanceof J.Identifier) break;
                }
                if (Character.isUpperCase(((J.Identifier)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                    attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                }
                Expression attributed = null;
                Expression e = (Expression)typeStack.pop();
                while (true) {
                    if (e instanceof J.Identifier) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.Identifier)e).withType((JavaType)attrStack.pop()) : e;
                    } else if (e instanceof J.FieldAccess) {
                        attributed = attrStack.size() == typeStack.size() + 1 ? ((J.FieldAccess)e).withTarget(attributed).withType((JavaType)attrStack.pop()) : ((J.FieldAccess)e).withTarget(attributed);
                    }
                    if (typeStack.isEmpty()) break;
                    e = (Expression)typeStack.pop();
                }
                assert (attributed != null);
                return attributed;
            }
            return typeTree;
        }

        private JavaType updateType(@Nullable JavaType oldType) {
            JavaType type;
            if (oldType != null && !(oldType instanceof JavaType.Unknown) && (type = this.oldNameToChangedType.get(oldType.toString())) != null) {
                return type;
            }
            if (oldType instanceof JavaType.Parameterized) {
                JavaType.Parameterized pt = (JavaType.Parameterized)oldType;
                if (this.isTargetFullyQualifiedType(pt = pt.withTypeParameters(ListUtils.map(pt.getTypeParameters(), tp -> {
                    JavaType.FullyQualified tpFq;
                    if (tp instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType(tpFq = (JavaType.FullyQualified)tp)) {
                        return this.targetType;
                    }
                    return tp;
                })))) {
                    pt = pt.withType((JavaType.FullyQualified)this.updateType(pt.getType()));
                }
                this.oldNameToChangedType.put(oldType.toString(), pt);
                return pt;
            }
            if (oldType instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified original = TypeUtils.asFullyQualified(oldType);
                if (this.isTargetFullyQualifiedType(original)) {
                    return this.targetType;
                }
            } else {
                if (oldType instanceof JavaType.GenericTypeVariable) {
                    JavaType.GenericTypeVariable gtv = (JavaType.GenericTypeVariable)oldType;
                    gtv = gtv.withBounds(ListUtils.map(gtv.getBounds(), b -> {
                        if (b instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType((JavaType.FullyQualified)b)) {
                            return this.updateType((JavaType)b);
                        }
                        return b;
                    }));
                    this.oldNameToChangedType.put(oldType.toString(), gtv);
                    return gtv;
                }
                if (oldType instanceof JavaType.Variable) {
                    JavaType.Variable variable = (JavaType.Variable)oldType;
                    variable = variable.withType(this.updateType(variable.getType()));
                    this.oldNameToChangedType.put(oldType.toString(), variable);
                    return variable;
                }
                if (oldType instanceof JavaType.Array) {
                    JavaType.Array array = (JavaType.Array)oldType;
                    array = array.withElemType(this.updateType(array.getElemType()));
                    this.oldNameToChangedType.put(oldType.toString(), array);
                    return array;
                }
            }
            return oldType;
        }

        @Nullable
        private JavaType.Method updateType(@Nullable JavaType.Method mt) {
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withReturnType(this.updateType(mt.getReturnType())).withParameterTypes(ListUtils.map(mt.getParameterTypes(), this::updateType));
            }
            return null;
        }

        private boolean isTargetFullyQualifiedType(@Nullable JavaType.FullyQualified fq) {
            return fq != null && TypeUtils.isOfClassType(fq, this.originalType.getFullyQualifiedName()) && this.targetType instanceof JavaType.FullyQualified;
        }
    }

    private static class ChangeClassDefinition
    extends JavaIsoVisitor<ExecutionContext> {
        private final JavaType.Class originalType;
        private final JavaType.Class targetType;
        private final MethodMatcher originalConstructor;

        private ChangeClassDefinition(String oldFullyQualifiedTypeName, String newFullyQualifiedTypeName) {
            this.originalType = JavaType.ShallowClass.build(oldFullyQualifiedTypeName);
            this.targetType = JavaType.ShallowClass.build(newFullyQualifiedTypeName);
            this.originalConstructor = new MethodMatcher(oldFullyQualifiedTypeName + "<constructor>(..)");
        }

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile sf, ExecutionContext ctx) {
            String newFqn;
            String oldFqn;
            Path newPath;
            String oldPath = ((SourceFile)sf).getSourcePath().toString().replace('\\', '/');
            if (this.updatePath(sf, oldPath, (newPath = Paths.get(oldPath.replaceFirst(oldFqn = this.fqnToPath(this.originalType.getFullyQualifiedName()), newFqn = this.fqnToPath(this.targetType.getFullyQualifiedName())), new String[0])).toString())) {
                sf = (JavaSourceFile)((SourceFile)sf).withSourcePath(newPath);
            }
            return super.visitJavaSourceFile(sf, ctx);
        }

        private String fqnToPath(String fullyQualifiedName) {
            int index = fullyQualifiedName.indexOf("$");
            String topLevelClassName = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(0, index);
            return topLevelClassName.replace('.', '/');
        }

        private boolean updatePath(JavaSourceFile sf, String oldPath, String newPath) {
            return !oldPath.equals(newPath) && sf.getClasses().stream().anyMatch(o -> J.Modifier.hasModifier(o.getModifiers(), J.Modifier.Type.Public) && o.getType() != null && !o.getType().getFullyQualifiedName().contains("$") && TypeUtils.isOfClassType(o.getType(), this.getTopLevelClassName(this.originalType)));
        }

        private String getTopLevelClassName(JavaType.FullyQualified classType) {
            if (classType.getOwningClass() == null) {
                return classType.getFullyQualifiedName();
            }
            return this.getTopLevelClassName(classType.getOwningClass());
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext executionContext) {
            JavaType.FullyQualified fq;
            J p = super.visitPackage(pkg, executionContext);
            String original = ((J.Package)p).getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            if (original.equals(this.originalType.getPackageName()) && (fq = TypeUtils.asFullyQualified(this.targetType)) != null) {
                if (fq.getPackageName().isEmpty()) {
                    this.getCursor().putMessageOnFirstEnclosing(J.CompilationUnit.class, "UPDATE_PREFIX", (Object)true);
                    p = null;
                } else {
                    String newPkg = this.targetType.getPackageName();
                    p = (J.Package)p.withTemplate(JavaTemplate.builder(() -> ((ChangeClassDefinition)this).getCursor(), newPkg).build(), ((J.Package)p).getCoordinates().replace(), new Object[0]);
                }
            }
            return p;
        }

        @Override
        public J.Import visitImport(J.Import _import, ExecutionContext executionContext) {
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                _import = _import.withPrefix(Space.EMPTY);
            }
            return super.visitImport(_import, executionContext);
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J cd = super.visitClassDeclaration(classDecl, executionContext);
            Boolean updatePrefix = (Boolean)this.getCursor().pollNearestMessage("UPDATE_PREFIX");
            if (updatePrefix != null && updatePrefix.booleanValue()) {
                cd = ((J.ClassDeclaration)cd).withPrefix(Space.EMPTY);
            }
            if (TypeUtils.isOfClassType(classDecl.getType(), this.originalType.getFullyQualifiedName())) {
                String newClassName = this.getNewClassName(this.targetType);
                cd = ((J.ClassDeclaration)cd).withName(((J.ClassDeclaration)cd).getName().withSimpleName(newClassName));
                cd = ((J.ClassDeclaration)cd).withType(this.updateType(((J.ClassDeclaration)cd).getType()));
            }
            return cd;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            if (method.isConstructor() && this.originalConstructor.matches(method.getMethodType())) {
                method = method.withName(method.getName().withSimpleName(this.targetType.getClassName()));
                method = method.withMethodType(this.updateType(method.getMethodType()));
            }
            return super.visitMethodDeclaration(method, executionContext);
        }

        private String getNewClassName(JavaType.FullyQualified fq) {
            return fq.getOwningClass() == null ? fq.getClassName() : fq.getFullyQualifiedName().substring(fq.getOwningClass().getFullyQualifiedName().length() + 1);
        }

        private JavaType updateType(@Nullable JavaType oldType) {
            JavaType.FullyQualified original;
            if (oldType instanceof JavaType.FullyQualified && this.isTargetFullyQualifiedType(original = TypeUtils.asFullyQualified(oldType))) {
                return this.targetType;
            }
            return oldType;
        }

        @Nullable
        private JavaType.Method updateType(@Nullable JavaType.Method mt) {
            if (mt != null) {
                return mt.withDeclaringType((JavaType.FullyQualified)this.updateType(mt.getDeclaringType())).withReturnType(this.updateType(mt.getReturnType())).withParameterTypes(ListUtils.map(mt.getParameterTypes(), this::updateType));
            }
            return null;
        }

        private boolean isTargetFullyQualifiedType(@Nullable JavaType.FullyQualified fq) {
            return fq != null && TypeUtils.isOfClassType(fq, this.originalType.getFullyQualifiedName());
        }
    }
}

