/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.internal.csv.GenericExternalModel;

final class MethodMatcherCache {
    private final Map<GenericExternalModel.MethodMatcherKey, MethodMatcher> methodMapperCache = new WeakHashMap<GenericExternalModel.MethodMatcherKey, MethodMatcher>();

    private MethodMatcher provideMethodMatcher(GenericExternalModel.MethodMatcherKey key) {
        return this.methodMapperCache.computeIfAbsent(key, k -> new MethodMatcher(k.getSignature(), k.isMatchOverrides()));
    }

    Collection<MethodMatcher> provideMethodMatchers(Collection<? extends GenericExternalModel> models) {
        ArrayList<MethodMatcher> mms = new ArrayList<MethodMatcher>();
        for (GenericExternalModel genericExternalModel : models) {
            GenericExternalModel.MethodMatcherKey asMethodMatcherKey = genericExternalModel.asMethodMatcherKey();
            MethodMatcher methodMatcher = this.provideMethodMatcher(asMethodMatcherKey);
            mms.add(methodMatcher);
        }
        return mms;
    }

    private MethodMatcherCache() {
    }

    @NonNull
    static MethodMatcherCache create() {
        return new MethodMatcherCache();
    }
}

