/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.controlflow.ControlFlowNode;
import org.openrewrite.java.controlflow.ControlFlowSummary;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.25.0")
public class ControlFlow {
    private static final String CONTROL_FLOW_MESSAGE_KEY = "__CONTROL_FLOW_SUMMARY";
    @Nullable
    private Cursor start;

    public Optional<ControlFlowSummary> findControlFlow() {
        if (this.start == null) {
            return Optional.empty();
        }
        return (Optional)this.start.computeMessageIfAbsent(CONTROL_FLOW_MESSAGE_KEY, __ -> {
            ControlFlowNode.Start startNode = ControlFlowNode.Start.create();
            ControlFlowAnalysis analysis = new ControlFlowAnalysis(startNode, true);
            analysis.visit((Tree)this.start.getValue(), 1, this.start);
            ControlFlowNode.End end = (ControlFlowNode.End)analysis.current.iterator().next();
            return Optional.of(ControlFlowSummary.forGraph(startNode, end));
        });
    }

    public static ControlFlow startingAt(Cursor start) {
        Iterator cursorPath = start.getPathAsCursors();
        Cursor methodDeclarationBlockCursor = null;
        while (cursorPath.hasNext()) {
            Cursor nextCursor = (Cursor)cursorPath.next();
            Object next = nextCursor.getValue();
            if (next instanceof J.Block) {
                methodDeclarationBlockCursor = nextCursor;
                if (!J.Block.isStaticOrInitBlock(nextCursor)) continue;
                return new ControlFlow(nextCursor);
            }
            if (!(next instanceof J.MethodDeclaration)) continue;
            return new ControlFlow(methodDeclarationBlockCursor);
        }
        return new ControlFlow(null);
    }

    private ControlFlow(@Nullable Cursor start) {
        this.start = start;
    }

    private static class ControlFlowAnalysis<P>
    extends JavaIsoVisitor<P> {
        protected Set<? extends ControlFlowNode> current;
        private final boolean methodEntryPoint;
        private final Set<ControlFlowNode> exitFlow = new HashSet<ControlFlowNode>();
        private final Set<ControlFlowNode> continueFlow = new HashSet<ControlFlowNode>();
        private final Set<ControlFlowNode> breakFlow = new HashSet<ControlFlowNode>();

        ControlFlowAnalysis(ControlFlowNode start, boolean methodEntryPoint) {
            this.current = Collections.singleton(Objects.requireNonNull(start, "start cannot be null"));
            this.methodEntryPoint = methodEntryPoint;
        }

        ControlFlowAnalysis(Set<? extends ControlFlowNode> current) {
            this.current = Objects.requireNonNull(current, "current cannot be null");
            this.methodEntryPoint = false;
        }

        ControlFlowNode.BasicBlock currentAsBasicBlock() {
            assert (!this.current.isEmpty()) : "No current node!";
            if (this.current.size() == 1 && this.current.iterator().next() instanceof ControlFlowNode.BasicBlock) {
                return (ControlFlowNode.BasicBlock)this.current.iterator().next();
            }
            return this.addBasicBlockToCurrent();
        }

        ControlFlowNode.BasicBlock addBasicBlockToCurrent() {
            HashSet<ControlFlowNode> newCurrent = new HashSet<ControlFlowNode>(this.current);
            ControlFlowNode.BasicBlock basicBlock = ControlFlowAnalysis.addBasicBlock(newCurrent);
            this.current = Collections.singleton(basicBlock);
            return basicBlock;
        }

        <C extends ControlFlowNode> C addSuccessorToCurrent(C node) {
            this.current.forEach(c -> c.addSuccessor(node));
            this.current = Collections.singleton(node);
            return node;
        }

        private void addCursorToBasicBlock() {
            this.currentAsBasicBlock().addCursorToBasicBlock(this.getCursor());
        }

        ControlFlowAnalysis<P> visitRecursive(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = new ControlFlowAnalysis<P>(start);
            analysis.visit(toVisit, param, this.getCursor());
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringExit(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursive(start, toVisit, param);
            if (!analysis.exitFlow.isEmpty()) {
                this.exitFlow.addAll(analysis.exitFlow);
            }
            return analysis;
        }

        ControlFlowAnalysis<P> visitRecursiveTransferringAll(Set<? extends ControlFlowNode> start, Tree toVisit, P param) {
            ControlFlowAnalysis<P> analysis = this.visitRecursiveTransferringExit(start, toVisit, param);
            if (!analysis.continueFlow.isEmpty()) {
                this.continueFlow.addAll(analysis.continueFlow);
            }
            if (!analysis.breakFlow.isEmpty()) {
                this.breakFlow.addAll(analysis.breakFlow);
            }
            return analysis;
        }

        @Override
        public J.Block visitBlock(J.Block block, P p) {
            this.addCursorToBasicBlock();
            for (Statement statement : block.getStatements()) {
                ControlFlowAnalysis<P> analysis = this.visitRecursive(this.current, statement, p);
                this.current = analysis.current;
                this.continueFlow.addAll(analysis.continueFlow);
                this.breakFlow.addAll(analysis.breakFlow);
                this.exitFlow.addAll(analysis.exitFlow);
                if (!this.current.isEmpty() || !(statement instanceof J.Try)) continue;
                break;
            }
            if (this.methodEntryPoint) {
                ControlFlowNode.End end = ControlFlowNode.End.create();
                this.addSuccessorToCurrent(end);
                this.exitFlow.forEach(exit -> exit.addSuccessor(end));
                this.current = Collections.singleton(end);
            }
            return block;
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, P p) {
            this.addCursorToBasicBlock();
            this.visit(_sync.getLock(), p);
            this.visit(_sync.getBody(), p);
            return _sync;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
            this.visit(method.getSelect(), p);
            this.visit(method.getArguments(), p);
            this.addCursorToBasicBlock();
            return method;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, P p) {
            this.visit(newClass.getEnclosing(), p);
            this.visit(newClass.getArguments(), p);
            this.addCursorToBasicBlock();
            return newClass;
        }

        @Override
        public J.Literal visitLiteral(J.Literal literal, P p) {
            this.addCursorToBasicBlock();
            return literal;
        }

        @Override
        public <T extends J> J.Parentheses<T> visitParentheses(J.Parentheses<T> parens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)parens.getTree(), p);
            return parens;
        }

        @Override
        public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, P p) {
            this.addCursorToBasicBlock();
            this.visit((Tree)controlParens.getTree(), p);
            return controlParens;
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
            this.visit(typeCast.getExpression(), p);
            this.addCursorToBasicBlock();
            return typeCast;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
            for (J.VariableDeclarations.NamedVariable variable : multiVariable.getVariables()) {
                this.visit(variable.getInitializer(), p);
            }
            this.addCursorToBasicBlock();
            return multiVariable;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
            this.visit(variable.getInitializer(), p);
            this.visit(variable.getName(), p);
            this.addCursorToBasicBlock();
            return variable;
        }

        @Override
        public J.Unary visitUnary(J.Unary unary, P p) {
            if (unary.getOperator() == J.Unary.Type.Not) {
                this.addCursorToBasicBlock();
                this.visit(unary.getExpression(), p);
                this.current.forEach(controlFlowNode -> {
                    if (controlFlowNode instanceof ControlFlowNode.BasicBlock) {
                        ControlFlowNode.BasicBlock basicBlock = (ControlFlowNode.BasicBlock)controlFlowNode;
                        basicBlock.invertNextConditional();
                    }
                });
            } else {
                this.visit(unary.getExpression(), p);
                this.addCursorToBasicBlock();
            }
            return unary;
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingTruthFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeTruthFirst();
            }).collect(Collectors.toSet());
        }

        private static Set<ControlFlowNode.ConditionNode> allAsConditionNodesMissingFalseFirst(Set<? extends ControlFlowNode> nodes) {
            return nodes.stream().map(controlFlowNode -> {
                if (controlFlowNode instanceof ControlFlowNode.ConditionNode) {
                    return (ControlFlowNode.ConditionNode)controlFlowNode;
                }
                return controlFlowNode.addConditionNodeFalseFirst();
            }).collect(Collectors.toSet());
        }

        private static ControlFlowNode.ConditionNode getControlFlowNodeMissingSuccessors(Set<ControlFlowNode.ConditionNode> nodes) {
            for (ControlFlowNode.ConditionNode node : nodes) {
                if (node.getTruthySuccessor() != null && node.getFalsySuccessor() != null) continue;
                return node;
            }
            throw new IllegalArgumentException("No control flow node missing successors");
        }

        private void visitBranching(BranchingAdapter branching, P p) {
            this.addCursorToBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursiveTransferringAll(this.current, branching.getCondition(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> thenAnalysis = this.visitRecursiveTransferringAll(conditionNodes, branching.getTruePart(), p);
            Set<ControlFlowNode.ConditionNode> newCurrent = Collections.singleton(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(conditionNodes));
            if (branching.getFalsePart() != null) {
                ControlFlowAnalysis<P> elseAnalysis = this.visitRecursiveTransferringAll(newCurrent, branching.getFalsePart(), p);
                this.current = Stream.concat(thenAnalysis.current.stream(), elseAnalysis.current.stream()).collect(Collectors.toSet());
            } else {
                this.current = Stream.concat(newCurrent.stream(), thenAnalysis.current.stream()).collect(Collectors.toSet());
            }
        }

        @Override
        public J.Ternary visitTernary(J.Ternary ternary, P p) {
            this.visitBranching(BranchingAdapter.of(ternary), p);
            return ternary;
        }

        @Override
        public J.If visitIf(J.If iff, P p) {
            this.visitBranching(BranchingAdapter.of(iff), p);
            return iff;
        }

        @Override
        public J.Binary visitBinary(J.Binary binary, P p) {
            if (J.Binary.Type.And.equals((Object)binary.getOperator())) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, binary.getRight(), p);
                this.current = Stream.concat(right.current.stream(), Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(conditionNodes))).collect(Collectors.toSet());
            } else if (J.Binary.Type.Or.equals((Object)binary.getOperator())) {
                ControlFlowAnalysis<P> left = this.visitRecursive(this.current, binary.getLeft(), p);
                Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingFalseFirst(left.current);
                ControlFlowAnalysis<P> right = this.visitRecursive(conditionNodes, binary.getRight(), p);
                this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(conditionNodes)), right.current.stream()).collect(Collectors.toSet());
            } else {
                this.visit(binary.getLeft(), p);
                this.visit(binary.getRight(), p);
                this.addCursorToBasicBlock();
            }
            return binary;
        }

        @Override
        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, P p) {
            this.visit(instanceOf.getExpression(), p);
            this.addCursorToBasicBlock();
            return instanceOf;
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock entryBlock = this.currentAsBasicBlock();
            ControlFlowNode.BasicBlock basicBlock = entryBlock.addBasicBlock();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(Collections.singleton(basicBlock), doWhileLoop.getBody(), p);
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(bodyAnalysis.current, doWhileLoop.getWhileCondition().getTree(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            conditionNodes.forEach(conditionNode -> {
                conditionNode.addSuccessor(basicBlock);
                bodyAnalysis.continueFlow.forEach(continueNode -> continueNode.addSuccessor(conditionNode));
            });
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return doWhileLoop;
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowNode.BasicBlock entryBlock = this.currentAsBasicBlock();
            ControlFlowAnalysis<P> conditionAnalysis = this.visitRecursive(Collections.singleton(entryBlock), whileLoop.getCondition().getTree(), p);
            Set<ControlFlowNode.ConditionNode> conditionNodes = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(conditionNodes, whileLoop.getBody(), p);
            bodyAnalysis.current.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            bodyAnalysis.continueFlow.forEach(controlFlowNode -> controlFlowNode.addSuccessor(entryBlock.getSuccessor()));
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(conditionNodes)), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return whileLoop;
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
            this.addCursorToBasicBlock();
            final ControlFlowNode.BasicBlock[] entryBlock = new ControlFlowNode.BasicBlock[1];
            ControlFlowAnalysis controlAnalysisFirstBit = new ControlFlowAnalysis<P>(this.current){

                @Override
                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    this.visit(control.getInit(), p);
                    entryBlock[0] = this.currentAsBasicBlock();
                    ControlFlowAnalysis conditionAnalysis = this.visitRecursive(this.current, control.getCondition(), p);
                    this.current = ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(conditionAnalysis.current);
                    return control;
                }
            };
            controlAnalysisFirstBit.visit(forLoop.getControl(), p, this.getCursor());
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringExit(controlAnalysisFirstBit.current, forLoop.getBody(), p);
            ControlFlowAnalysis controlAnalysisSecondBit = new ControlFlowAnalysis<P>(bodyAnalysis.current){

                @Override
                public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
                    if (control.getUpdate().isEmpty() || control.getUpdate().get(0) instanceof J.Empty) {
                        this.visit(control.getUpdate(), p);
                        return control;
                    }
                    this.current = Collections.singleton(this.currentAsBasicBlock().addBasicBlock());
                    this.visit(control.getUpdate(), p);
                    return control;
                }
            };
            controlAnalysisSecondBit.visit(forLoop.getControl(), p, this.getCursor());
            controlAnalysisSecondBit.current.forEach(controlFlowNode -> {
                bodyAnalysis.continueFlow.forEach(continueControlFlowNode -> continueControlFlowNode.addSuccessor(controlFlowNode));
                controlFlowNode.addSuccessor(entryBlock[0].getSuccessor());
            });
            this.current = Stream.concat(Stream.of(ControlFlowAnalysis.getControlFlowNodeMissingSuccessors(ControlFlowAnalysis.allAsConditionNodesMissingTruthFirst(controlAnalysisFirstBit.current))), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, P p) {
            this.addCursorToBasicBlock();
            ControlFlowAnalysis controlAnalysis = new ControlFlowAnalysis<P>(this.current){

                @Override
                public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
                    this.visit(control.getIterable(), p);
                    this.visit(control.getVariable(), p);
                    this.addBasicBlockToCurrent();
                    return control;
                }
            };
            J.MethodInvocation fakeConditionalMethod = this.createFakeConditionalMethod(forLoop.getControl().getIterable());
            this.visit(fakeConditionalMethod, p);
            ControlFlowNode.ConditionNode conditionalEntry = controlAnalysis.currentAsBasicBlock().addConditionNodeTruthFirst();
            ControlFlowAnalysis<P> bodyAnalysis = this.visitRecursiveTransferringAll(Collections.singleton(conditionalEntry), forLoop.getBody(), p);
            bodyAnalysis.current.forEach(controlFlowNode -> {
                controlFlowNode.addSuccessor(conditionalEntry);
                bodyAnalysis.continueFlow.forEach(continueFlowNode -> continueFlowNode.addSuccessor(controlFlowNode));
            });
            this.current = Stream.concat(Stream.of(conditionalEntry), bodyAnalysis.breakFlow.stream()).collect(Collectors.toSet());
            return forLoop;
        }

        private J.MethodInvocation createFakeConditionalMethod(Expression iterable) {
            JavaCoordinates coordinates;
            JavaTemplate fakeConditionalTemplate = iterable.getType() instanceof JavaType.Array ? JavaTemplate.builder(() -> ((ControlFlowAnalysis)this).getCursor(), "Arrays.asList(#{any()}).iterator().hasNext()").imports("java.util.Arrays").build() : JavaTemplate.builder(() -> ((ControlFlowAnalysis)this).getCursor(), "#{any(java.lang.Iterable)}.iterator().hasNext()").build();
            J.MethodInvocation fakeConditional = (J.MethodInvocation)iterable.withTemplate(fakeConditionalTemplate, coordinates = iterable.getCoordinates().replace(), iterable);
            if (iterable == fakeConditional) {
                throw new IllegalStateException("Failed to create a fake conditional!");
            }
            return fakeConditional;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, P p) {
            this.addCursorToBasicBlock();
            return identifier;
        }

        @Override
        public J.Assert visitAssert(J.Assert _assert, P p) {
            this.visit(_assert.getCondition(), p);
            if (_assert.getDetail() != null) {
                this.visit(_assert.getDetail().getElement(), p);
            }
            this.addCursorToBasicBlock();
            return _assert;
        }

        @Override
        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
            this.addCursorToBasicBlock();
            return arrayAccess;
        }

        @Override
        public J.Try visitTry(J.Try _try, P p) {
            this.addCursorToBasicBlock();
            this.visit(_try.getResources(), p);
            if (_try.getFinally() == null) {
                this.visit(_try.getBody(), p);
            } else {
                ControlFlowAnalysis<P> tryBodyAnalysis = new ControlFlowAnalysis<P>(this.current);
                tryBodyAnalysis.visit(_try.getBody(), p, this.getCursor());
                if (!tryBodyAnalysis.current.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromCurrent = this.visitRecursiveTransferringAll(tryBodyAnalysis.current, _try.getFinally(), p);
                    this.current = finallyAnalysisFromCurrent.current;
                } else {
                    this.current = Collections.emptySet();
                }
                if (!tryBodyAnalysis.exitFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromExitFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.exitFlow, _try.getFinally(), p);
                    this.exitFlow.addAll(finallyAnalysisFromExitFlow.current);
                }
                if (!tryBodyAnalysis.breakFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromBreakFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.breakFlow, _try.getFinally(), p);
                    this.breakFlow.addAll(finallyAnalysisFromBreakFlow.current);
                }
                if (!tryBodyAnalysis.continueFlow.isEmpty()) {
                    ControlFlowAnalysis<P> finallyAnalysisFromContinueFlow = this.visitRecursiveTransferringAll(tryBodyAnalysis.continueFlow, _try.getFinally(), p);
                    this.continueFlow.addAll(finallyAnalysisFromContinueFlow.current);
                }
            }
            return _try;
        }

        @Override
        public J.Try.Resource visitTryResource(J.Try.Resource tryResource, P p) {
            this.visit(tryResource.getVariableDeclarations(), p);
            return tryResource;
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, P p) {
            this.addCursorToBasicBlock();
            return _switch;
        }

        @Override
        public J.Return visitReturn(J.Return _return, P p) {
            this.visit(_return.getExpression(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return _return;
        }

        @Override
        public J.Throw visitThrow(J.Throw thrown, P p) {
            this.visit(thrown.getException(), p);
            this.addCursorToBasicBlock();
            this.exitFlow.addAll(this.current);
            this.current = Collections.emptySet();
            return thrown;
        }

        @Override
        public J.Continue visitContinue(J.Continue continueStatement, P p) {
            this.addCursorToBasicBlock();
            this.continueFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return continueStatement;
        }

        @Override
        public J.Break visitBreak(J.Break breakStatement, P p) {
            this.addCursorToBasicBlock();
            this.breakFlow.add(this.currentAsBasicBlock());
            this.current = Collections.emptySet();
            return breakStatement;
        }

        private static ControlFlowNode.BasicBlock addBasicBlock(Collection<ControlFlowNode> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalStateException("No nodes to add to a basic block!");
            }
            Iterator<ControlFlowNode> cfnIterator = nodes.iterator();
            ControlFlowNode.BasicBlock basicBlock = cfnIterator.next().addBasicBlock();
            while (cfnIterator.hasNext()) {
                cfnIterator.next().addSuccessor(basicBlock);
            }
            return basicBlock;
        }

        private static interface BranchingAdapter {
            public Expression getCondition();

            public J getTruePart();

            @Nullable
            public J getFalsePart();

            public static BranchingAdapter of(final J.If ifStatement) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ifStatement.getIfCondition().getTree();
                    }

                    @Override
                    public J getTruePart() {
                        return ifStatement.getThenPart();
                    }

                    @Override
                    @Nullable
                    public J getFalsePart() {
                        return ifStatement.getElsePart();
                    }
                };
            }

            public static BranchingAdapter of(final J.Ternary ternary) {
                return new BranchingAdapter(){

                    @Override
                    public Expression getCondition() {
                        return ternary.getCondition();
                    }

                    @Override
                    public J getTruePart() {
                        return ternary.getTruePart();
                    }

                    @Override
                    public J getFalsePart() {
                        return ternary.getFalsePart();
                    }
                };
            }
        }
    }
}

