/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.controlflow;

import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.controlflow.ControlFlow;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Incubating(since="7.25.0")
public class ControlFlowBasicBlockVisitor<P>
extends JavaIsoVisitor<P> {
    private final String methodName;

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
        if (block == methodDeclaration.getBody() && methodDeclaration.getName().getSimpleName().equals(this.methodName)) {
            ControlFlow.startingAt(this.getCursor()).findControlFlow().ifPresent(summary -> {
                final Set inBasicBlock = summary.getBasicBlocks().stream().flatMap(b -> b.getNodeValues().stream()).collect(Collectors.toSet());
                this.doAfterVisit(new JavaIsoVisitor<P>(){

                    @Override
                    public Statement visitStatement(Statement statement, P p) {
                        return inBasicBlock.contains(statement) ? (Statement)statement.withMarkers(statement.getMarkers().searchResult()) : statement;
                    }

                    @Override
                    public Expression visitExpression(Expression expression, P p) {
                        return inBasicBlock.contains(expression) ? (Expression)expression.withMarkers(expression.getMarkers().searchResult()) : expression;
                    }
                });
            });
        }
        return super.visitBlock(block, (Object)p);
    }

    public ControlFlowBasicBlockVisitor(String methodName) {
        this.methodName = methodName;
    }
}

