/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Javadoc;

public class RemoveJavaDocAuthorTag
extends Recipe {
    public String getDisplayName() {
        return "Remove author tags from JavaDocs";
    }

    public String getDescription() {
        return "Removes author tags from JavaDocs to reduce code maintenance.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                    @Override
                    public Javadoc visitDocComment(Javadoc.DocComment javadoc, ExecutionContext executionContext) {
                        Javadoc.DocComment dc = (Javadoc.DocComment)super.visitDocComment(javadoc, executionContext);
                        ArrayList<Javadoc> newBody = new ArrayList<Javadoc>();
                        boolean isChanged = false;
                        boolean removeNextLineBreak = false;
                        for (int i = javadoc.getBody().size() - 1; i >= 0; --i) {
                            Javadoc doc = javadoc.getBody().get(i);
                            if (removeNextLineBreak) {
                                if (!(doc instanceof Javadoc.LineBreak)) continue;
                                removeNextLineBreak = false;
                                continue;
                            }
                            if (doc instanceof Javadoc.Author) {
                                isChanged = true;
                                removeNextLineBreak = true;
                                continue;
                            }
                            newBody.add(doc);
                        }
                        if (isChanged) {
                            Collections.reverse(newBody);
                            dc = dc.withBody(newBody);
                        }
                        return dc;
                    }
                };
            }
        };
    }
}

