/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ChangePackage;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;

public class LowercasePackage
extends Recipe {
    public String getDisplayName() {
        return "Rename packages to lowercase";
    }

    public String getDescription() {
        return "By convention all Java package names should contain only lowercase letters, numbers, and dashes. This recipe converts any uppercase letters in package names to be lowercase.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-120");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Package visitPackage(J.Package pkg, ExecutionContext executionContext) {
                String lowerCase;
                String packageText = pkg.getExpression().print(this.getCursor()).replaceAll("\\s", "");
                if (!packageText.equals(lowerCase = packageText.toLowerCase())) {
                    LowercasePackage.this.doNext(new ChangePackage(packageText, lowerCase, true));
                }
                return pkg;
            }
        };
    }
}

