/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.FormalParameterVisitor;
import org.openrewrite.java.TypeVisitor;
import org.openrewrite.java.internal.grammar.MethodSignatureLexer;
import org.openrewrite.java.internal.grammar.MethodSignatureParser;
import org.openrewrite.java.internal.grammar.MethodSignatureParserBaseVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class MethodMatcher {
    private Pattern targetTypePattern;
    private Pattern methodNamePattern;
    private Pattern argumentPattern;
    private final boolean matchOverrides;

    public MethodMatcher(String signature, @Nullable Boolean matchOverrides) {
        this(signature, Boolean.TRUE.equals(matchOverrides));
    }

    public MethodMatcher(String signature, boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
        MethodSignatureParser parser = new MethodSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new MethodSignatureLexer((CharStream)CharStreams.fromString((String)signature))));
        new MethodSignatureParserBaseVisitor<Void>(){

            @Override
            public Void visitMethodPattern(MethodSignatureParser.MethodPatternContext ctx) {
                MethodMatcher.this.targetTypePattern = Pattern.compile((String)new TypeVisitor().visitTargetTypePattern(ctx.targetTypePattern()));
                MethodMatcher.this.methodNamePattern = Pattern.compile(ctx.simpleNamePattern().children.stream().map(c -> StringUtils.aspectjNameToPattern((String)c.toString())).collect(Collectors.joining("")));
                MethodMatcher.this.argumentPattern = Pattern.compile(new FormalParameterVisitor().visitFormalParametersPattern(ctx.formalParametersPattern()));
                return null;
            }
        }.visit((ParseTree)parser.methodPattern());
    }

    public MethodMatcher(J.MethodDeclaration method, boolean matchOverrides) {
        this(MethodMatcher.methodPattern(method), matchOverrides);
    }

    public MethodMatcher(String signature) {
        this(signature, false);
    }

    public MethodMatcher(J.MethodDeclaration method) {
        this(method, false);
    }

    public MethodMatcher(JavaType.Method method) {
        this(MethodMatcher.methodPattern(method), false);
    }

    public boolean matches(@Nullable JavaType.Method type) {
        if (type == null) {
            return false;
        }
        if (!this.matchesTargetType(type.getDeclaringType()) || !this.methodNamePattern.matcher(type.getName()).matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : type.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    public boolean matches(J.MethodDeclaration method, J.ClassDeclaration enclosing) {
        boolean matchesTargetType;
        if (enclosing.getType() == null) {
            return false;
        }
        boolean bl = matchesTargetType = "[^.]*".equals(this.targetTypePattern.toString()) || this.matchesTargetType(enclosing.getType());
        if (!matchesTargetType) {
            return false;
        }
        boolean matchesMethodName = this.methodNamePattern.matcher(method.getSimpleName()).matches() || method.getMethodType() != null && this.methodNamePattern.matcher(method.getMethodType().getName()).matches();
        return matchesMethodName && this.argumentPattern.matcher(method.getParameters().stream().map(v -> {
            if (v instanceof J.VariableDeclarations) {
                J.VariableDeclarations vd = (J.VariableDeclarations)v;
                if (vd.getTypeAsFullyQualified() != null) {
                    return vd.getTypeAsFullyQualified();
                }
                return vd.getTypeExpression() != null ? vd.getTypeExpression().getType() : null;
            }
            return null;
        }).filter(Objects::nonNull).map(MethodMatcher::typePattern).filter(Objects::nonNull).collect(Collectors.joining(","))).matches();
    }

    public boolean matches(Expression maybeMethod) {
        return maybeMethod instanceof J.MethodInvocation && this.matches((J.MethodInvocation)maybeMethod) || maybeMethod instanceof J.NewClass && this.matches((J.NewClass)maybeMethod);
    }

    public boolean matches(J.MethodInvocation method) {
        if (method.getMethodType() == null) {
            return false;
        }
        if (!this.matchesTargetType(method.getMethodType().getDeclaringType()) || !this.methodNamePattern.matcher(method.getSimpleName()).matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : method.getMethodType().getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    public boolean matches(J.NewClass constructor) {
        JavaType.FullyQualified type = TypeUtils.asFullyQualified(constructor.getType());
        if (type == null || constructor.getConstructorType() == null) {
            return false;
        }
        if (!this.matchesTargetType(type) || !this.methodNamePattern.matcher("<constructor>").matches()) {
            return false;
        }
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : constructor.getConstructorType().getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            joiner.add(s);
        }
        return this.argumentPattern.matcher(joiner.toString()).matches();
    }

    boolean matchesTargetType(@Nullable JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        if (this.targetTypePattern.matcher(type.getFullyQualifiedName()).matches()) {
            return true;
        }
        if (this.matchOverrides) {
            if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && this.matchesTargetType(JavaType.ShallowClass.build("java.lang.Object"))) {
                return true;
            }
            if (this.matchesTargetType(type.getSupertype())) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!this.matchesTargetType(anInterface)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFullyQualifiedClassReference(J.FieldAccess fieldAccess) {
        String hopefullyFullyQualifiedMethod = this.getTargetTypePattern().pattern() + "." + this.getMethodNamePattern().pattern();
        return fieldAccess.isFullyQualifiedClassReference(hopefullyFullyQualifiedMethod);
    }

    @Nullable
    private static String typePattern(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.FullyQualified) {
            return ((JavaType.FullyQualified)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Array) {
            JavaType elemType = ((JavaType.Array)type).getElemType();
            return MethodMatcher.typePattern(elemType) + "[]";
        }
        return null;
    }

    public static String methodPattern(J.MethodDeclaration method) {
        assert (method.getMethodType() != null);
        return MethodMatcher.methodPattern(method.getMethodType());
    }

    public static String methodPattern(JavaType.Method method) {
        StringJoiner parameters = new StringJoiner(",");
        for (JavaType javaType : method.getParameterTypes()) {
            String s = MethodMatcher.typePattern(javaType);
            if (s == null) continue;
            parameters.add(s);
        }
        return MethodMatcher.typePattern(method.getDeclaringType()) + " " + method.getName() + "(" + parameters + ")";
    }

    public Pattern getTargetTypePattern() {
        return this.targetTypePattern;
    }

    public Pattern getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public Pattern getArgumentPattern() {
        return this.argumentPattern;
    }

    public boolean isMatchOverrides() {
        return this.matchOverrides;
    }
}

