/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ImplementInterface<P>
extends JavaIsoVisitor<P> {
    private final J.ClassDeclaration scope;
    private final JavaType.FullyQualified interfaceType;

    public ImplementInterface(J.ClassDeclaration scope, JavaType.FullyQualified interfaceType) {
        this.scope = scope;
        this.interfaceType = interfaceType;
    }

    public ImplementInterface(J.ClassDeclaration scope, String interfaze) {
        this(scope, JavaType.ShallowClass.build(interfaze));
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J c = super.visitClassDeclaration(classDecl, (Object)p);
        if (c.isScope(this.scope) && (((J.ClassDeclaration)c).getImplements() == null || ((J.ClassDeclaration)c).getImplements().stream().noneMatch(f -> TypeUtils.isAssignableTo(f.getType(), (JavaType)this.interfaceType)))) {
            if (!classDecl.getSimpleName().equals(this.interfaceType.getClassName())) {
                this.maybeAddImport(this.interfaceType);
            }
            TypeTree impl = (TypeTree)TypeTree.build(classDecl.getSimpleName().equals(this.interfaceType.getClassName()) ? this.interfaceType.getFullyQualifiedName() : this.interfaceType.getClassName()).withType(this.interfaceType).withPrefix(Space.format(" "));
            c = ((J.ClassDeclaration)c).withImplements(ListUtils.concat(((J.ClassDeclaration)c).getImplements(), (Object)impl));
            JContainer<TypeTree> anImplements = ((J.ClassDeclaration)c).getPadding().getImplements();
            assert (anImplements != null);
            if (anImplements.getBefore().getWhitespace().isEmpty()) {
                c = ((J.ClassDeclaration)c).getPadding().withImplements(anImplements.withBefore(Space.format(" ")));
            }
        }
        return c;
    }
}

