/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.ImplementInterface;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ExtractInterface {
    public static List<JavaSourceFile> extract(JavaSourceFile cu, String fullyQualifiedInterfaceName) {
        return Arrays.asList((JavaSourceFile)new CreateInterface(fullyQualifiedInterfaceName).visitNonNull(cu, 0), (JavaSourceFile)new ImplementAndAddOverrideAnnotations(fullyQualifiedInterfaceName).visitNonNull(cu, 0));
    }

    private static final class CreateInterface
    extends JavaIsoVisitor<Integer> {
        private final String fullyQualifiedInterfaceName;

        @Override
        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, Integer p) {
            String pkg = cu.getPackageDeclaration() == null ? "" : Arrays.stream(cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).split("\\.")).map(subpackage -> "..").collect(Collectors.joining("/", "", "/"));
            J c = super.visitJavaSourceFile(cu, p);
            String interfacePkg = JavaType.ShallowClass.build(this.fullyQualifiedInterfaceName).getPackageName();
            if (!interfacePkg.isEmpty()) {
                c = c.withPackageDeclaration(new J.Package(Tree.randomId(), cu.getPackageDeclaration() == null ? Space.EMPTY : cu.getPackageDeclaration().getPrefix(), Markers.EMPTY, (Expression)TypeTree.build(interfacePkg).withPrefix(Space.format(" ")), cu.getPackageDeclaration() == null ? Collections.emptyList() : cu.getPackageDeclaration().getAnnotations()));
            }
            c = (JavaSourceFile)c.withSourcePath(cu.getSourcePath().resolve(pkg + this.fullyQualifiedInterfaceName.replace('.', '/') + ".java"));
            return c;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Integer p) {
            J.ClassDeclaration c = classDecl;
            c = c.withKind(J.ClassDeclaration.Kind.Type.Interface);
            c = c.withBody(c.getBody().withStatements(ListUtils.map(c.getBody().getStatements(), s -> s instanceof J.MethodDeclaration ? s : null)));
            c = c.withName(c.getName().withSimpleName(this.fullyQualifiedInterfaceName.substring(this.fullyQualifiedInterfaceName.lastIndexOf(46) + 1)));
            return (J.ClassDeclaration)this.autoFormat(super.visitClassDeclaration(c, p), p);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Integer p) {
            if (method.hasModifier(J.Modifier.Type.Static) || !method.hasModifier(J.Modifier.Type.Public) || method.isConstructor()) {
                return null;
            }
            return method.withModifiers(ListUtils.map(method.getModifiers(), m -> m.getType() == J.Modifier.Type.Public || m.getType() == J.Modifier.Type.Final || m.getType() == J.Modifier.Type.Native ? null : m)).withBody(null);
        }

        public CreateInterface(String fullyQualifiedInterfaceName) {
            this.fullyQualifiedInterfaceName = fullyQualifiedInterfaceName;
        }

        public String getFullyQualifiedInterfaceName() {
            return this.fullyQualifiedInterfaceName;
        }

        @NonNull
        public String toString() {
            return "ExtractInterface.CreateInterface(fullyQualifiedInterfaceName=" + this.getFullyQualifiedInterfaceName() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateInterface)) {
                return false;
            }
            CreateInterface other = (CreateInterface)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            String other$fullyQualifiedInterfaceName = other.getFullyQualifiedInterfaceName();
            return !(this$fullyQualifiedInterfaceName == null ? other$fullyQualifiedInterfaceName != null : !this$fullyQualifiedInterfaceName.equals(other$fullyQualifiedInterfaceName));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof CreateInterface;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            result = result * 59 + ($fullyQualifiedInterfaceName == null ? 43 : $fullyQualifiedInterfaceName.hashCode());
            return result;
        }
    }

    private static final class ImplementAndAddOverrideAnnotations
    extends JavaIsoVisitor<Integer> {
        private final String fullyQualifiedInterfaceName;

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Integer p) {
            this.maybeAddImport(this.fullyQualifiedInterfaceName);
            JavaType.ShallowClass type = JavaType.ShallowClass.build(this.fullyQualifiedInterfaceName);
            J.Block body = classDecl.getBody();
            return ((J.ClassDeclaration)new ImplementInterface(classDecl, type).visitNonNull(classDecl, p)).withBody(body.withStatements(ListUtils.map(body.getStatements(), s -> {
                if (s instanceof J.MethodDeclaration) {
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)s;
                    try {
                        if (!methodDeclaration.hasModifier(J.Modifier.Type.Public) || methodDeclaration.hasModifier(J.Modifier.Type.Static) || methodDeclaration.isConstructor()) {
                            return s;
                        }
                        if (FindAnnotations.find(methodDeclaration, "@java.lang.Override").isEmpty()) {
                            return (Statement)methodDeclaration.withTemplate(JavaTemplate.builder(() -> ((ImplementAndAddOverrideAnnotations)this).getCursor(), "@Override").build(), methodDeclaration.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName, new RuleBasedCollator("< Override"))), new Object[0]);
                        }
                        return methodDeclaration;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return s;
            })));
        }

        public ImplementAndAddOverrideAnnotations(String fullyQualifiedInterfaceName) {
            this.fullyQualifiedInterfaceName = fullyQualifiedInterfaceName;
        }

        public String getFullyQualifiedInterfaceName() {
            return this.fullyQualifiedInterfaceName;
        }

        @NonNull
        public String toString() {
            return "ExtractInterface.ImplementAndAddOverrideAnnotations(fullyQualifiedInterfaceName=" + this.getFullyQualifiedInterfaceName() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImplementAndAddOverrideAnnotations)) {
                return false;
            }
            ImplementAndAddOverrideAnnotations other = (ImplementAndAddOverrideAnnotations)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            String other$fullyQualifiedInterfaceName = other.getFullyQualifiedInterfaceName();
            return !(this$fullyQualifiedInterfaceName == null ? other$fullyQualifiedInterfaceName != null : !this$fullyQualifiedInterfaceName.equals(other$fullyQualifiedInterfaceName));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ImplementAndAddOverrideAnnotations;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedInterfaceName = this.getFullyQualifiedInterfaceName();
            result = result * 59 + ($fullyQualifiedInterfaceName == null ? 43 : $fullyQualifiedInterfaceName.hashCode());
            return result;
        }
    }
}

