/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.AdditionalFlowStepPredicate;
import org.openrewrite.java.dataflow.internal.InvocationMatcher;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

class ExternalFlowModels {
    private static final String CURSOR_MESSAGE_KEY = "OPTIMIZED_FLOW_MODELS";
    private static final Pattern ARGUMENT_MATCHER = Pattern.compile("Argument\\[(-?\\d+)\\.?\\.?(\\d+)?]");
    private static final ExternalFlowModels instance = new ExternalFlowModels();
    private WeakReference<FullyQualifiedNameToFlowModels> fullyQualifiedNameToFlowModels;

    public static ExternalFlowModels instance() {
        return instance;
    }

    private FullyQualifiedNameToFlowModels getFullyQualifiedNameToFlowModels() {
        FullyQualifiedNameToFlowModels f;
        if (this.fullyQualifiedNameToFlowModels == null) {
            f = Loader.create().load();
            this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
        } else {
            f = (FullyQualifiedNameToFlowModels)this.fullyQualifiedNameToFlowModels.get();
            if (f == null) {
                f = Loader.create().load();
                this.fullyQualifiedNameToFlowModels = new WeakReference<FullyQualifiedNameToFlowModels>(f);
            }
        }
        return f;
    }

    private OptimizedFlowModels getOptimizedFlowModelsForTypesInUse(TypesInUse typesInUse) {
        return Optimizer.optimize(this.getFullyQualifiedNameToFlowModels().forTypesInUse(typesInUse));
    }

    private OptimizedFlowModels getOrComputeOptimizedFlowModels(Cursor cursor) {
        Cursor cuCursor = cursor.dropParentUntil(J.CompilationUnit.class::isInstance);
        return (OptimizedFlowModels)cuCursor.computeMessageIfAbsent(CURSOR_MESSAGE_KEY, __ -> this.getOptimizedFlowModelsForTypesInUse(((J.CompilationUnit)cuCursor.getValue()).getTypesInUse()));
    }

    boolean isAdditionalFlowStep(Expression startExpression, Cursor startCursor, Expression endExpression, Cursor endCursor) {
        return this.getOrComputeOptimizedFlowModels(startCursor).value.stream().anyMatch(value -> value.isAdditionalFlowStep(startExpression, startCursor, endExpression, endCursor));
    }

    boolean isAdditionalTaintStep(Expression startExpression, Cursor startCursor, Expression endExpression, Cursor endCursor) {
        return this.getOrComputeOptimizedFlowModels(startCursor).taint.stream().anyMatch(taint -> taint.isAdditionalFlowStep(startExpression, startCursor, endExpression, endCursor));
    }

    private static FullyQualifiedNameToFlowModels createFullyQualifiedNameToFlowModels(Iterable<FlowModel> flowModels) {
        HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>();
        HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>();
        for (FlowModel model : flowModels) {
            if ("value".equals(model.kind)) {
                value.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                continue;
            }
            if ("taint".equals(model.kind)) {
                taint.computeIfAbsent(model.getFullyQualifiedName(), k -> new ArrayList()).add(model);
                continue;
            }
            throw new IllegalArgumentException("Unknown kind: " + model.kind);
        }
        return new FullyQualifiedNameToFlowModels(value, taint);
    }

    private ExternalFlowModels() {
    }

    static class FullyQualifiedNameToFlowModels {
        private final Map<String, List<FlowModel>> value;
        private final Map<String, List<FlowModel>> taint;

        boolean isEmpty() {
            return this.value.isEmpty() && this.taint.isEmpty();
        }

        FullyQualifiedNameToFlowModels merge(FullyQualifiedNameToFlowModels other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            HashMap<String, List<FlowModel>> value = new HashMap<String, List<FlowModel>>(this.value);
            other.value.forEach((k, v) -> value.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            HashMap<String, List<FlowModel>> taint = new HashMap<String, List<FlowModel>>(this.taint);
            other.taint.forEach((k, v) -> taint.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            return new FullyQualifiedNameToFlowModels(value, taint);
        }

        FlowModels forTypesInUse(TypesInUse typesInUse) {
            HashSet<FlowModel> value = new HashSet<FlowModel>();
            HashSet<FlowModel> taint = new HashSet<FlowModel>();
            typesInUse.getUsedMethods().stream().map(JavaType.Method::getDeclaringType).map(JavaType.FullyQualified::getFullyQualifiedName).distinct().forEach(fqn -> {
                value.addAll(this.value.getOrDefault(fqn, Collections.emptyList()));
                taint.addAll(this.taint.getOrDefault(fqn, Collections.emptyList()));
            });
            return new FlowModels(value, taint);
        }

        static FullyQualifiedNameToFlowModels empty() {
            return new FullyQualifiedNameToFlowModels(new HashMap<String, List<FlowModel>>(), new HashMap<String, List<FlowModel>>());
        }

        public FullyQualifiedNameToFlowModels(Map<String, List<FlowModel>> value, Map<String, List<FlowModel>> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    private static class Loader {
        private Loader() {
        }

        private static Loader create() {
            return new Loader();
        }

        FullyQualifiedNameToFlowModels load() {
            return this.loadModelFromFile();
        }

        private FullyQualifiedNameToFlowModels loadModelFromFile() {
            FullyQualifiedNameToFlowModels[] models = new FullyQualifiedNameToFlowModels[]{FullyQualifiedNameToFlowModels.empty()};
            try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[]{"data-flow"}).enableMemoryMapping().scan();){
                scanResult.getResourcesWithLeafName("model.csv").forEachInputStreamIgnoringIOException((res, input) -> {
                    models[0] = models[0].merge(this.loadCvs(input, res.getURI()));
                });
            }
            return models[0];
        }

        private FullyQualifiedNameToFlowModels loadCvs(InputStream input, URI source) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            ArrayList<FlowModel> flowModels = new ArrayList<FlowModel>();
            try {
                String line = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(";");
                    flowModels.add(new FlowModel(tokens[0], tokens[1], Boolean.parseBoolean(tokens[2]), tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[8]));
                }
                return ExternalFlowModels.createFullyQualifiedNameToFlowModels(flowModels);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to read data-flow values from " + source, e);
            }
        }
    }

    static class FlowModels {
        Set<FlowModel> value;
        Set<FlowModel> taint;

        public FlowModels(Set<FlowModel> value, Set<FlowModel> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    private static class Optimizer {
        private final Map<FlowModel.MethodMatcherKey, MethodMatcher> methodMapperCache = new HashMap<FlowModel.MethodMatcherKey, MethodMatcher>();

        private MethodMatcher provideMethodMatcher(FlowModel.MethodMatcherKey key) {
            return this.methodMapperCache.computeIfAbsent(key, k -> new MethodMatcher(k.signature, k.matchOverrides));
        }

        private Set<MethodMatcher> provideMethodMatchers(Collection<FlowModel> models) {
            return models.stream().map(FlowModel::asMethodMatcherKey).map(this::provideMethodMatcher).collect(Collectors.toSet());
        }

        private AdditionalFlowStepPredicate forFlowFromArgumentIndexToReturn(int argumentIndex, Set<MethodMatcher> methodMatchers) {
            InvocationMatcher callMatcher = InvocationMatcher.fromMethodMatchers(methodMatchers);
            if (argumentIndex == -1) {
                return (startExpression, startCursor, endExpression, endCursor) -> callMatcher.advanced().isSelect(startCursor);
            }
            return (startExpression, startCursor, endExpression, endCursor) -> callMatcher.advanced().isParameter(startCursor, argumentIndex);
        }

        private List<AdditionalFlowStepPredicate> optimize(Collection<FlowModel> models) {
            HashMap flowFromArgumentIndexToReturn = new HashMap();
            models.forEach(model -> {
                Matcher argumentMatcher = ARGUMENT_MATCHER.matcher(model.input);
                if (argumentMatcher.matches() && ("ReturnValue".equals(model.output) || model.isConstructor())) {
                    int argumentIndexStart = Integer.parseInt(argumentMatcher.group(1));
                    flowFromArgumentIndexToReturn.computeIfAbsent(argumentIndexStart, k -> new ArrayList()).add(model);
                    if (argumentMatcher.group(2) != null) {
                        int argumentIndexEnd = Integer.parseInt(argumentMatcher.group(2));
                        for (int i = argumentIndexStart + 1; i <= argumentIndexEnd; ++i) {
                            flowFromArgumentIndexToReturn.computeIfAbsent(i, k -> new ArrayList()).add(model);
                        }
                    }
                }
            });
            return flowFromArgumentIndexToReturn.entrySet().stream().map(entry -> {
                Set<MethodMatcher> methodMatchers = this.provideMethodMatchers((Collection)entry.getValue());
                return this.forFlowFromArgumentIndexToReturn((Integer)entry.getKey(), methodMatchers);
            }).collect(Collectors.toList());
        }

        private static OptimizedFlowModels optimize(FlowModels flowModels) {
            Optimizer optimizer = new Optimizer();
            return new OptimizedFlowModels(optimizer.optimize(flowModels.value), optimizer.optimize(flowModels.taint));
        }

        private Optimizer() {
        }
    }

    private static class OptimizedFlowModels {
        private final List<AdditionalFlowStepPredicate> value;
        private final List<AdditionalFlowStepPredicate> taint;

        public OptimizedFlowModels(List<AdditionalFlowStepPredicate> value, List<AdditionalFlowStepPredicate> taint) {
            this.value = value;
            this.taint = taint;
        }
    }

    static class FlowModel {
        String namespace;
        String type;
        boolean subtypes;
        String name;
        String signature;
        String ext;
        String input;
        String output;
        String kind;

        final String getFullyQualifiedName() {
            return this.namespace + "." + this.type;
        }

        boolean isConstructor() {
            return this.type.equals(this.name);
        }

        @Deprecated
        AdditionalFlowStepPredicate asAdditionalFlowStepPredicate() {
            MethodMatcherKey key = this.asMethodMatcherKey();
            InvocationMatcher matcher = InvocationMatcher.fromMethodMatcher(new MethodMatcher(key.signature, key.matchOverrides));
            Matcher argumentMatcher = ARGUMENT_MATCHER.matcher(this.input);
            if ("Argument[-1]".equals(this.input) && "ReturnValue".equals(this.output)) {
                return (startExpression, startCursor, endExpression, endCursor) -> matcher.advanced().isSelect(startCursor);
            }
            if (argumentMatcher.matches() && "ReturnValue".equals(this.output)) {
                int argumentIndex = Integer.parseInt(argumentMatcher.group(1));
                return (startExpression, startCursor, endExpression, endCursor) -> matcher.advanced().isParameter(startCursor, argumentIndex);
            }
            return (startExpression, startCursor, endExpression, endCursor) -> false;
        }

        MethodMatcherKey asMethodMatcherKey() {
            String signature = this.signature.isEmpty() ? "(..)" : this.signature;
            String fullSignature = this.isConstructor() ? this.namespace + '.' + this.type + ' ' + "<constructor>" + signature : this.namespace + '.' + this.type + ' ' + this.name + signature;
            return new MethodMatcherKey(fullSignature, this.subtypes);
        }

        public FlowModel(String namespace, String type, boolean subtypes, String name, String signature, String ext, String input, String output, String kind) {
            this.namespace = namespace;
            this.type = type;
            this.subtypes = subtypes;
            this.name = name;
            this.signature = signature;
            this.ext = ext;
            this.input = input;
            this.output = output;
            this.kind = kind;
        }

        static class MethodMatcherKey {
            final String signature;
            final boolean matchOverrides;

            public MethodMatcherKey(String signature, boolean matchOverrides) {
                this.signature = signature;
                this.matchOverrides = matchOverrides;
            }

            public String getSignature() {
                return this.signature;
            }

            public boolean isMatchOverrides() {
                return this.matchOverrides;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MethodMatcherKey)) {
                    return false;
                }
                MethodMatcherKey other = (MethodMatcherKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isMatchOverrides() != other.isMatchOverrides()) {
                    return false;
                }
                String this$signature = this.getSignature();
                String other$signature = other.getSignature();
                return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof MethodMatcherKey;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isMatchOverrides() ? 79 : 97);
                String $signature = this.getSignature();
                result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "ExternalFlowModels.FlowModel.MethodMatcherKey(signature=" + this.getSignature() + ", matchOverrides=" + this.isMatchOverrides() + ")";
            }
        }
    }
}

