/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;

@Incubating(since="7.0.0")
public class SimplifyBooleanExpression
extends Recipe {
    public String getDisplayName() {
        return "Simplify boolean expression";
    }

    public String getDescription() {
        return "Checks for over-complicated boolean expressions. Finds code like `if (b == true)`, `b || true`, `!false`, etc.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1125");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new SimplifyBooleanExpressionVisitor<ExecutionContext>();
    }

    public boolean causesAnotherCycle() {
        return true;
    }
}

