/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.DefaultComesLast;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public class MinimumSwitchCases
extends Recipe {
    public String getDisplayName() {
        return "`switch` statements should have at least 3 `case` clauses";
    }

    public String getDescription() {
        return "`switch` statements are useful when many code paths branch depending on the value of a single expression. For just one or two code paths, the code will be more readable with `if` statements.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1301");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final JavaTemplate ifElseIfPrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n} else if(#{any()} == #{any()}) {\n}").build();
            final JavaTemplate ifElseIfString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n} else if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n}").build();
            final JavaTemplate ifElseIfEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n} else if(#{any()} == #{}) {\n}").build();
            final JavaTemplate ifElsePrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n} else {\n}").build();
            final JavaTemplate ifElseString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n} else {\n}").build();
            final JavaTemplate ifElseEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n} else {\n}").build();
            final JavaTemplate ifPrimitive = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{any()}) {\n}").build();
            final JavaTemplate ifString = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any(java.lang.String)}.equals(#{any(java.lang.String)})) {\n}").build();
            final JavaTemplate ifEnum = JavaTemplate.builder(() -> (this).getCursor(), "if(#{any()} == #{}) {\n}").build();

            @Override
            public J visitSwitch(J.Switch switzh, ExecutionContext ctx) {
                if (switzh.getCases().getStatements().size() < 3) {
                    J.Switch sortedSwitch = (J.Switch)new DefaultComesLast().getVisitor().visit((Tree)switzh, (Object)ctx);
                    assert (sortedSwitch != null);
                    J.Case[] cases = new J.Case[2];
                    int i = 0;
                    for (Statement statement : sortedSwitch.getCases().getStatements()) {
                        if (!(statement instanceof J.Case)) continue;
                        cases[i++] = (J.Case)statement;
                    }
                    if (i == 0) {
                        return super.visitSwitch(switzh, ctx);
                    }
                    Expression tree = sortedSwitch.getSelector().getTree();
                    J.If generatedIf = TypeUtils.isString(tree.getType()) ? (cases[1] == null ? (J.If)switzh.withTemplate(this.ifString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree) : (this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElseString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree) : (J.If)switzh.withTemplate(this.ifElseIfString, switzh.getCoordinates().replace(), cases[0].getPattern(), tree, cases[1].getPattern(), tree))) : (this.switchesOnEnum(switzh) ? (cases[1] == null ? (J.If)switzh.withTemplate(this.ifEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern())) : (this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElseEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern())) : (J.If)switzh.withTemplate(this.ifElseIfEnum, switzh.getCoordinates().replace(), tree, this.enumIdentToFieldAccessString(cases[0].getPattern()), tree, this.enumIdentToFieldAccessString(cases[1].getPattern())))) : (cases[1] == null ? (J.If)switzh.withTemplate(this.ifPrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern()) : (this.isDefault(cases[1]) ? (J.If)switzh.withTemplate(this.ifElsePrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern()) : (J.If)switzh.withTemplate(this.ifElseIfPrimitive, switzh.getCoordinates().replace(), tree, cases[0].getPattern(), tree, cases[1].getPattern()))));
                    ArrayList<Statement> statements = new ArrayList<Statement>();
                    for (Statement statement : cases[0].getStatements()) {
                        if (statement instanceof J.Block) {
                            statements.addAll(((J.Block)statement).getStatements());
                            continue;
                        }
                        statements.add(statement);
                    }
                    generatedIf = generatedIf.withThenPart(((J.Block)generatedIf.getThenPart()).withStatements(ListUtils.map(statements, s -> s instanceof J.Break ? null : s)));
                    if (cases[1] != null) {
                        assert (generatedIf.getElsePart() != null);
                        if (this.isDefault(cases[1])) {
                            generatedIf = generatedIf.withElsePart(generatedIf.getElsePart().withBody(((J.Block)generatedIf.getElsePart().getBody()).withStatements(ListUtils.map(cases[1].getStatements(), s -> s instanceof J.Break ? null : s))));
                        } else {
                            J.If elseIf = (J.If)generatedIf.getElsePart().getBody();
                            generatedIf = generatedIf.withElsePart(generatedIf.getElsePart().withBody(elseIf.withThenPart(((J.Block)elseIf.getThenPart()).withStatements(ListUtils.map(cases[1].getStatements(), s -> s instanceof J.Break ? null : s)))));
                        }
                    }
                    return this.autoFormat(generatedIf, ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitSwitch(switzh, ctx);
            }

            private boolean isDefault(J.Case caze) {
                return caze.getPattern() instanceof J.Identifier && ((J.Identifier)caze.getPattern()).getSimpleName().equals("default");
            }

            private boolean switchesOnEnum(J.Switch switzh) {
                JavaType selectorType = switzh.getSelector().getTree().getType();
                return selectorType instanceof JavaType.Class && ((JavaType.Class)selectorType).getKind() == JavaType.FullyQualified.Kind.Enum;
            }

            private String enumIdentToFieldAccessString(Expression casePattern) {
                J.Identifier ident = (J.Identifier)casePattern;
                return ((JavaType.Class)ident.getType()).getClassName() + "." + ident.getSimpleName();
            }
        };
    }
}

