/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.EmptyBlockVisitor;
import org.openrewrite.java.cleanup.RemoveUnneededBlock;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.style.EmptyBlockStyle;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

public class SimplifyConstantIfBranchExecution
extends Recipe {
    public String getDisplayName() {
        return "Simplify constant if branch execution";
    }

    public String getDescription() {
        return "Checks for if expressions that are always `true` or `false` and simplifies them.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new SimplifyConstantIfBranchExecutionVisitor();
    }

    private static class SimplifyConstantIfBranchExecutionVisitor
    extends JavaVisitor<ExecutionContext> {
        private SimplifyConstantIfBranchExecutionVisitor() {
        }

        @Override
        public J visitBlock(J.Block block, ExecutionContext executionContext) {
            J.Block bl = (J.Block)super.visitBlock(block, executionContext);
            if (bl != block) {
                bl = (J.Block)new RemoveUnneededBlock.RemoveUnneededBlockStatementVisitor().visitNonNull(bl, executionContext, this.getCursor().getParentOrThrow());
                EmptyBlockStyle style = (EmptyBlockStyle)((SourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getStyle(EmptyBlockStyle.class);
                if (style == null) {
                    style = Checkstyle.emptyBlock();
                }
                bl = (J.Block)new EmptyBlockVisitor(style).visitNonNull(bl, executionContext, this.getCursor().getParentOrThrow());
            }
            return bl;
        }

        private J.ControlParentheses<Expression> cleanupControlParentheses(J.ControlParentheses<Expression> controlParentheses, ExecutionContext context) {
            J.ControlParentheses cp1 = (J.ControlParentheses)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(controlParentheses, context, this.getCursor().getParentOrThrow());
            J.ControlParentheses cp2 = (J.ControlParentheses)new SimplifyBooleanExpressionVisitor().visitNonNull(cp1, context, this.getCursor().getParentOrThrow());
            return cp2;
        }

        @Override
        public J visitIf(J.If if_, ExecutionContext context) {
            J.If if__ = (J.If)super.visitIf(if_, context);
            J.ControlParentheses<Expression> cp = this.cleanupControlParentheses(if__.getIfCondition(), context);
            Optional<Boolean> compileTimeConstantBoolean = SimplifyConstantIfBranchExecutionVisitor.isLiteralTrue(cp.getTree()) ? Optional.of(true) : (SimplifyConstantIfBranchExecutionVisitor.isLiteralFalse(cp.getTree()) ? Optional.of(false) : Optional.empty());
            if (!compileTimeConstantBoolean.isPresent()) {
                return if__;
            }
            if (compileTimeConstantBoolean.get().booleanValue()) {
                Statement s = if__.getThenPart();
                return this.maybeAutoFormat(if__, s, context, this.getCursor().getParentOrThrow());
            }
            if (if__.getElsePart() != null) {
                Statement s = if__.getElsePart().getBody();
                return this.maybeAutoFormat(if__, s, context, this.getCursor().getParentOrThrow());
            }
            return SimplifyConstantIfBranchExecutionVisitor.emptyJBlock();
        }

        private static J.Block emptyJBlock() {
            return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build(false), Collections.emptyList(), Space.EMPTY);
        }

        private static boolean isLiteralTrue(@Nullable Expression expression) {
            return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
        }

        private static boolean isLiteralFalse(@Nullable Expression expression) {
            return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
        }
    }
}

