/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class SimplifyConstantIfBranchExecution
extends Recipe {
    public String getDisplayName() {
        return "Simplify constant if branch execution";
    }

    public String getDescription() {
        return "Checks for if expressions that are always `true` or `false` and simplifies them.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new SimplifyConstantIfBranchExecutionVisitor();
    }

    private static class SimplifyConstantIfBranchExecutionVisitor
    extends JavaVisitor<ExecutionContext> {
        private SimplifyConstantIfBranchExecutionVisitor() {
        }

        @Override
        public J visitWhileLoop(J.WhileLoop whileLoop, ExecutionContext executionContext) {
            return whileLoop;
        }

        @Override
        public J visitBlock(J.Block block, ExecutionContext executionContext) {
            J.Block bl = (J.Block)super.visitBlock(block, executionContext);
            List addStatements = (List)this.getCursor().pollMessage("statements");
            J.If removeIf = (J.If)this.getCursor().pollMessage("remove-if");
            if (removeIf != null) {
                bl = this.maybeAutoFormat(bl, bl.withStatements(ListUtils.flatMap(bl.getStatements(), stmt -> {
                    if (stmt == removeIf) {
                        return addStatements;
                    }
                    return stmt;
                })), executionContext, this.getCursor().getParent());
            }
            return bl;
        }

        @Override
        public J visitIf(J.If if_, ExecutionContext context) {
            J.If if__ = (J.If)super.visitIf(if_, context);
            final AtomicReference<Object> b = new AtomicReference<Object>(null);
            new JavaIsoVisitor<ExecutionContext>(){

                @Override
                public <T extends J> J.ControlParentheses<T> visitControlParentheses(J.ControlParentheses<T> controlParens, ExecutionContext executionContext) {
                    J cp = super.visitControlParentheses((J.ControlParentheses)controlParens, executionContext);
                    J.ControlParentheses cp2 = (J.ControlParentheses)new SimplifyBooleanExpressionVisitor().visitNonNull(cp, executionContext);
                    if (SimplifyConstantIfBranchExecutionVisitor.isLiteralTrue((Expression)cp2.getTree())) {
                        b.getAndSet(true);
                    } else if (SimplifyConstantIfBranchExecutionVisitor.isLiteralFalse((Expression)cp2.getTree())) {
                        b.getAndSet(false);
                    }
                    return cp;
                }
            }.visit(if__, context);
            Boolean compileTimeConstantBoolean = b.get();
            if (compileTimeConstantBoolean == null) {
                return if__;
            }
            if (compileTimeConstantBoolean.booleanValue()) {
                Statement s = if__.getThenPart();
                if (s instanceof J.Block) {
                    this.getCursor().dropParentUntil(J.Block.class::isInstance).putMessage("statements", ((J.Block)s).getStatements());
                    this.getCursor().dropParentUntil(J.Block.class::isInstance).putMessage("remove-if", (Object)if__);
                    return if__;
                }
                return this.maybeAutoFormat(if__, s, context, this.getCursor().getParent());
            }
            if (if__.getElsePart() != null) {
                Statement s = if__.getElsePart().getBody();
                if (s instanceof J.Block) {
                    this.getCursor().dropParentUntil(J.Block.class::isInstance).putMessage("statements", ((J.Block)s).getStatements());
                    this.getCursor().dropParentUntil(J.Block.class::isInstance).putMessage("remove-if", (Object)if__);
                    return if__;
                }
                return this.maybeAutoFormat(if__, s, context, this.getCursor().getParent());
            }
            return null;
        }

        private static boolean isLiteralTrue(@Nullable Expression expression) {
            return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
        }

        private static boolean isLiteralFalse(@Nullable Expression expression) {
            return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
        }
    }
}

