/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface JavaType {
    @JsonProperty(value="@c")
    default public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    @Nullable
    default public Integer getManagedReference() {
        return null;
    }

    default public JavaType withManagedReference(Integer id) {
        return this;
    }

    default public JavaType unsafeSetManagedReference(Integer id) {
        return this;
    }

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return ShallowClass.build(typeName);
    }

    default public boolean isAssignableFrom(Pattern pattern) {
        if (this instanceof FullyQualified) {
            FullyQualified fq = (FullyQualified)this;
            if (pattern.matcher(fq.getFullyQualifiedName()).matches()) {
                return true;
            }
            if (fq.getSupertype() != null && fq.getSupertype().isAssignableFrom(pattern)) {
                return true;
            }
            for (FullyQualified anInterface : fq.getInterfaces()) {
                if (!anInterface.isAssignableFrom(pattern)) continue;
                return true;
            }
            return false;
        }
        if (this instanceof GenericTypeVariable) {
            GenericTypeVariable generic = (GenericTypeVariable)this;
            for (JavaType bound : generic.getBounds()) {
                if (!bound.isAssignableFrom(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static final class Unknown
    extends FullyQualified {
        private static final Unknown INSTANCE = new Unknown();

        private Unknown() {
        }

        @JsonCreator
        public static Unknown getInstance() {
            return INSTANCE;
        }

        @Override
        public String getFullyQualifiedName() {
            return "<unknown>";
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            return this;
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return false;
        }

        @Override
        public Set<Flag> getFlags() {
            return Collections.emptySet();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return Collections.emptyList();
        }

        @Override
        public FullyQualified.Kind getKind() {
            return FullyQualified.Kind.Class;
        }

        @Override
        public List<Variable> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public List<Method> getMethods() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return null;
        }

        @Override
        @Nullable
        public FullyQualified getSupertype() {
            return null;
        }

        public String toString() {
            return "Unknown";
        }
    }

    public static class Variable
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        private final String name;
        @Nullable
        private JavaType owner;
        @Nullable
        private JavaType type;
        @Nullable
        private List<FullyQualified> annotations;

        public Variable(@Nullable Integer managedReference, long flagsBitMap, String name, @Nullable JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.name = name;
            this.owner = owner;
            this.type = type;
            this.annotations = ListUtils.nullIfEmpty(annotations);
        }

        @Nullable
        public JavaType getOwner() {
            return this.owner;
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : this.annotations;
        }

        public Variable withAnnotations(@Nullable List<FullyQualified> annotations) {
            if (annotations != null && annotations.isEmpty()) {
                annotations = null;
            }
            if (this.annotations == annotations) {
                return this;
            }
            return new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, this.type, annotations);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        @Override
        public Variable unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Variable unsafeSet(JavaType owner, @Nullable JavaType type, @Nullable List<FullyQualified> annotations) {
            this.owner = owner;
            this.type = type;
            this.annotations = ListUtils.nullIfEmpty(annotations);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            assert (this.owner != null);
            return this.name.equals(variable.name) && this.owner.equals(variable.owner);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.variableSignature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @Override
        @NonNull
        public Variable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Variable(managedReference, this.flagsBitMap, this.name, this.owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withName(String name) {
            return this.name == name ? this : new Variable(this.managedReference, this.flagsBitMap, name, this.owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withOwner(@Nullable JavaType owner) {
            return this.owner == owner ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, owner, this.type, this.annotations);
        }

        @NonNull
        public Variable withType(@Nullable JavaType type) {
            return this.type == type ? this : new Variable(this.managedReference, this.flagsBitMap, this.name, this.owner, type, this.annotations);
        }
    }

    public static class Method
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        @Nullable
        private FullyQualified declaringType;
        private final String name;
        @Nullable
        private JavaType returnType;
        @Nullable
        private final List<String> parameterNames;
        @Nullable
        private List<JavaType> parameterTypes;
        @Nullable
        private List<FullyQualified> thrownExceptions;
        @Nullable
        private List<FullyQualified> annotations;

        public Method(@Nullable Integer managedReference, long flagsBitMap, @Nullable FullyQualified declaringType, String name, @Nullable JavaType returnType, @Nullable List<String> parameterNames, @Nullable List<JavaType> parameterTypes, @Nullable List<FullyQualified> thrownExceptions, @Nullable List<FullyQualified> annotations) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_FLAGS;
            this.declaringType = declaringType;
            this.name = name;
            this.returnType = returnType;
            this.parameterNames = ListUtils.nullIfEmpty(parameterNames);
            this.parameterTypes = ListUtils.nullIfEmpty(parameterTypes);
            this.thrownExceptions = ListUtils.nullIfEmpty(thrownExceptions);
            this.annotations = ListUtils.nullIfEmpty(annotations);
        }

        @Override
        public Method unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Method unsafeSet(FullyQualified declaringType, JavaType returnType, @Nullable List<JavaType> parameterTypes, @Nullable List<FullyQualified> thrownExceptions, @Nullable List<FullyQualified> annotations) {
            this.declaringType = declaringType;
            this.returnType = returnType;
            this.parameterTypes = ListUtils.nullIfEmpty(parameterTypes);
            this.thrownExceptions = ListUtils.nullIfEmpty(thrownExceptions);
            this.annotations = ListUtils.nullIfEmpty(annotations);
            return this;
        }

        public boolean isConstructor() {
            return "<constructor>".equals(this.name);
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public boolean isInheritedFrom(String fullyQualifiedTypeName) {
            if (this.declaringType == null) {
                return false;
            }
            Stack<FullyQualified> interfaces = new Stack<FullyQualified>();
            interfaces.addAll(this.declaringType.getInterfaces());
            while (!interfaces.isEmpty()) {
                FullyQualified declaring = (FullyQualified)interfaces.pop();
                interfaces.addAll(declaring.getInterfaces());
                if (declaring.getFullyQualifiedName().equals(fullyQualifiedTypeName)) continue;
                block1: for (Method method : declaring.getMethods()) {
                    if (!method.getName().equals(this.name)) continue;
                    List<JavaType> params = method.getParameterTypes();
                    if (this.getParameterTypes().size() != method.getParameterTypes().size()) continue;
                    for (int i = 0; i < params.size(); ++i) {
                        if (!TypeUtils.isOfType(this.getParameterTypes().get(i), params.get(i))) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        public List<String> getParameterNames() {
            return this.parameterNames == null ? Collections.emptyList() : this.parameterNames;
        }

        public Method withParameterNames(@Nullable List<String> parameterNames) {
            if (parameterNames != null && parameterNames.isEmpty()) {
                parameterNames = null;
            }
            if (parameterNames == this.parameterNames) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }

        public List<JavaType> getParameterTypes() {
            return this.parameterTypes == null ? Collections.emptyList() : this.parameterTypes;
        }

        public Method withParameterTypes(@Nullable List<JavaType> parameterTypes) {
            if (parameterTypes != null && parameterTypes.isEmpty()) {
                parameterTypes = null;
            }
            if (parameterTypes == this.parameterTypes) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, parameterTypes, this.thrownExceptions, this.annotations);
        }

        public List<FullyQualified> getThrownExceptions() {
            return this.thrownExceptions == null ? Collections.emptyList() : this.thrownExceptions;
        }

        public Method withThrownExceptions(@Nullable List<FullyQualified> thrownExceptions) {
            if (thrownExceptions != null && thrownExceptions.isEmpty()) {
                thrownExceptions = null;
            }
            if (thrownExceptions == this.thrownExceptions) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, thrownExceptions, this.annotations);
        }

        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : this.annotations;
        }

        public Method withAnnotations(@Nullable List<FullyQualified> annotations) {
            if (annotations != null && annotations.isEmpty()) {
                annotations = null;
            }
            if (annotations == this.annotations) {
                return this;
            }
            return new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, annotations);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Method withFlags(Set<Flag> flags) {
            return this.withFlagsBitMap(Flag.flagsToBitMap(flags));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            assert (this.declaringType != null);
            assert (this.returnType != null);
            return this.declaringType.equals(method.declaringType) && this.name.equals(method.name) && this.returnType.equals(method.returnType) && Objects.equals(this.parameterTypes, method.parameterTypes);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.methodSignature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public JavaType getReturnType() {
            return this.returnType;
        }

        @Override
        @NonNull
        public Method withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Method(managedReference, this.flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }

        @NonNull
        private Method withFlagsBitMap(long flagsBitMap) {
            return this.flagsBitMap == flagsBitMap ? this : new Method(this.managedReference, flagsBitMap, this.declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }

        @NonNull
        public Method withDeclaringType(@Nullable FullyQualified declaringType) {
            return this.declaringType == declaringType ? this : new Method(this.managedReference, this.flagsBitMap, declaringType, this.name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }

        @NonNull
        public Method withName(String name) {
            return this.name == name ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, name, this.returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }

        @NonNull
        public Method withReturnType(@Nullable JavaType returnType) {
            return this.returnType == returnType ? this : new Method(this.managedReference, this.flagsBitMap, this.declaringType, this.name, returnType, this.parameterNames, this.parameterTypes, this.thrownExceptions, this.annotations);
        }
    }

    public static enum Primitive implements JavaType
    {
        Boolean,
        Byte,
        Char,
        Double,
        Float,
        Int,
        Long,
        Short,
        Void,
        String,
        None,
        Null;


        @Nullable
        public static Primitive fromKeyword(String keyword) {
            switch (keyword) {
                case "boolean": {
                    return Boolean;
                }
                case "byte": {
                    return Byte;
                }
                case "char": {
                    return Char;
                }
                case "double": {
                    return Double;
                }
                case "float": {
                    return Float;
                }
                case "int": {
                    return Int;
                }
                case "long": {
                    return Long;
                }
                case "short": {
                    return Short;
                }
                case "void": {
                    return Void;
                }
                case "String": {
                    return String;
                }
                case "null": {
                    return Null;
                }
                case "": {
                    return None;
                }
            }
            return null;
        }

        public String getKeyword() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Int: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
                case Void: {
                    return "void";
                }
                case String: {
                    return "String";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        public String toString() {
            return this.getKeyword();
        }

        public boolean isNumeric() {
            return this == Double || this == Int || this == Float || this == Long || this == Short;
        }
    }

    public static class Array
    implements JavaType {
        @Nullable
        private Integer managedReference;
        @Nullable
        private JavaType elemType;

        public Array(@Nullable Integer managedReference, @Nullable JavaType elemType) {
            this.managedReference = managedReference;
            this.elemType = elemType;
        }

        public JavaType getElemType() {
            assert (this.elemType != null);
            return this.elemType;
        }

        @Override
        public Array unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Array unsafeSet(JavaType elemType) {
            this.elemType = elemType;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Array array = (Array)o;
            assert (this.elemType != null);
            return this.elemType.equals(array.elemType);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.signature(this);
        }

        @Override
        @NonNull
        public Array withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Array(managedReference, this.elemType);
        }

        @NonNull
        public Array withElemType(@Nullable JavaType elemType) {
            return this.elemType == elemType ? this : new Array(this.managedReference, elemType);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }
    }

    public static class GenericTypeVariable
    implements JavaType {
        @Nullable
        private Integer managedReference;
        private final String name;
        private Variance variance;
        @Nullable
        private List<JavaType> bounds;

        public GenericTypeVariable(@Nullable Integer managedReference, String name, Variance variance, @Nullable List<JavaType> bounds) {
            this.managedReference = managedReference;
            this.name = name;
            this.variance = variance;
            this.bounds = ListUtils.nullIfEmpty(bounds);
        }

        public List<JavaType> getBounds() {
            return this.bounds == null ? Collections.emptyList() : this.bounds;
        }

        public GenericTypeVariable withBounds(@Nullable List<JavaType> bounds) {
            if (bounds != null && bounds.isEmpty()) {
                bounds = null;
            }
            if (bounds == this.bounds) {
                return this;
            }
            return new GenericTypeVariable(this.managedReference, this.name, this.variance, bounds);
        }

        @Override
        public GenericTypeVariable unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public GenericTypeVariable unsafeSet(Variance variance, @Nullable List<JavaType> bounds) {
            this.variance = variance;
            this.bounds = ListUtils.nullIfEmpty(bounds);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GenericTypeVariable that = (GenericTypeVariable)o;
            assert (this.bounds != null);
            return this.name.equals(that.name) && this.variance == that.variance && this.bounds.equals(that.bounds);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.signature(this);
        }

        @Override
        @NonNull
        public GenericTypeVariable withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new GenericTypeVariable(managedReference, this.name, this.variance, this.bounds);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        @NonNull
        public GenericTypeVariable withName(String name) {
            return this.name == name ? this : new GenericTypeVariable(this.managedReference, name, this.variance, this.bounds);
        }

        public String getName() {
            return this.name;
        }

        @NonNull
        public GenericTypeVariable withVariance(Variance variance) {
            return this.variance == variance ? this : new GenericTypeVariable(this.managedReference, this.name, variance, this.bounds);
        }

        public Variance getVariance() {
            return this.variance;
        }

        public static enum Variance {
            INVARIANT,
            COVARIANT,
            CONTRAVARIANT;

        }
    }

    public static class Parameterized
    extends FullyQualified {
        @Nullable
        private Integer managedReference;
        @Nullable
        private FullyQualified type;
        @Nullable
        private List<JavaType> typeParameters;

        public Parameterized(@Nullable Integer managedReference, @Nullable FullyQualified type, @Nullable List<JavaType> typeParameters) {
            this.managedReference = managedReference;
            this.type = type;
            this.typeParameters = ListUtils.nullIfEmpty(typeParameters);
        }

        public FullyQualified getType() {
            assert (this.type != null);
            return this.type;
        }

        public List<JavaType> getTypeParameters() {
            return this.typeParameters == null ? Collections.emptyList() : this.typeParameters;
        }

        public Parameterized withTypeParameters(@Nullable List<JavaType> typeParameters) {
            if (typeParameters != null && typeParameters.isEmpty()) {
                typeParameters = null;
            }
            if (typeParameters == this.typeParameters) {
                return this;
            }
            return new Parameterized(this.managedReference, this.type, typeParameters);
        }

        @Override
        public Parameterized unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Parameterized unsafeSet(FullyQualified type, List<JavaType> typeParameters) {
            assert (type != this);
            this.type = type;
            this.typeParameters = ListUtils.nullIfEmpty(typeParameters);
            return this;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.type == null ? "" : this.type.getFullyQualifiedName();
        }

        @Override
        public FullyQualified withFullyQualifiedName(String fullyQualifiedName) {
            assert (this.type != null);
            return this.type.withFullyQualifiedName(fullyQualifiedName);
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            assert (this.type != null);
            return this.type.getAnnotations();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            assert (this.type != null);
            return this.type.hasFlags(test);
        }

        @Override
        public Set<Flag> getFlags() {
            assert (this.type != null);
            return this.type.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            assert (this.type != null);
            return this.type.getInterfaces();
        }

        @Override
        public FullyQualified.Kind getKind() {
            assert (this.type != null);
            return this.type.getKind();
        }

        @Override
        public List<Variable> getMembers() {
            assert (this.type != null);
            return this.type.getMembers();
        }

        @Override
        public List<Method> getMethods() {
            assert (this.type != null);
            return this.type.getMethods();
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            assert (this.type != null);
            return this.type.getOwningClass();
        }

        @Override
        public FullyQualified getSupertype() {
            assert (this.type != null);
            return this.type.getSupertype();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameterized that = (Parameterized)o;
            assert (this.type != null && this.typeParameters != null);
            return this.type.equals(that.type) && this.typeParameters.equals(that.typeParameters);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.signature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        @Override
        @NonNull
        public Parameterized withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Parameterized(managedReference, this.type, this.typeParameters);
        }

        @NonNull
        public Parameterized withType(@Nullable FullyQualified type) {
            return this.type == type ? this : new Parameterized(this.managedReference, type, this.typeParameters);
        }
    }

    public static class ShallowClass
    extends Class {
        public ShallowClass(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            super(managedReference, flagsBitMap, fullyQualifiedName, kind, supertype, owningClass, annotations, interfaces, members, methods);
        }

        public static ShallowClass build(String fullyQualifiedName) {
            ShallowClass owningClass = null;
            int firstClassNameIndex = 0;
            int lastDot = 0;
            char[] fullyQualifiedNameChars = fullyQualifiedName.replace('$', '.').toCharArray();
            int prev = 32;
            for (int i = 0; i < fullyQualifiedNameChars.length; ++i) {
                int c = fullyQualifiedNameChars[i];
                if (firstClassNameIndex == 0 && prev == 46 && Character.isUpperCase((char)c)) {
                    firstClassNameIndex = i;
                } else if (c == 46) {
                    lastDot = i;
                }
                prev = c;
            }
            if (lastDot > firstClassNameIndex) {
                owningClass = ShallowClass.build(fullyQualifiedName.substring(0, lastDot));
            }
            return new ShallowClass(null, 1L, fullyQualifiedName, FullyQualified.Kind.Class, null, owningClass, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
    }

    public static class Class
    extends FullyQualified {
        @Nullable
        private Integer managedReference;
        private final long flagsBitMap;
        private final String fullyQualifiedName;
        private final FullyQualified.Kind kind;
        @Nullable
        private FullyQualified supertype;
        @Nullable
        private FullyQualified owningClass;
        @Nullable
        private List<FullyQualified> annotations;
        @Nullable
        private List<FullyQualified> interfaces;
        @Nullable
        private List<Variable> members;
        @Nullable
        private List<Method> methods;

        public Class(@Nullable Integer managedReference, long flagsBitMap, String fullyQualifiedName, FullyQualified.Kind kind, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this.managedReference = managedReference;
            this.flagsBitMap = flagsBitMap & Flag.VALID_CLASS_FLAGS;
            this.fullyQualifiedName = fullyQualifiedName;
            this.kind = kind;
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = ListUtils.nullIfEmpty(annotations);
            this.interfaces = ListUtils.nullIfEmpty(interfaces);
            this.members = ListUtils.nullIfEmpty(members);
            this.methods = ListUtils.nullIfEmpty(methods);
        }

        @Deprecated
        public static Class build(String fullyQualifiedName) {
            return ShallowClass.build(fullyQualifiedName);
        }

        @Override
        public List<FullyQualified> getAnnotations() {
            return this.annotations == null ? Collections.emptyList() : this.annotations;
        }

        public Class withAnnotations(@Nullable List<FullyQualified> annotations) {
            if (annotations != null && annotations.isEmpty()) {
                annotations = null;
            }
            if (annotations == this.annotations) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, this.owningClass, annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.interfaces == null ? Collections.emptyList() : this.interfaces;
        }

        public Class withInterfaces(@Nullable List<FullyQualified> interfaces) {
            if (interfaces != null && interfaces.isEmpty()) {
                interfaces = null;
            }
            if (interfaces == this.interfaces) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, this.owningClass, this.annotations, interfaces, this.members, this.methods);
        }

        @Override
        public List<Variable> getMembers() {
            return this.members == null ? Collections.emptyList() : this.members;
        }

        public Class withMembers(@Nullable List<Variable> members) {
            if (members != null && members.isEmpty()) {
                members = null;
            }
            if (members == this.members) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, this.owningClass, this.annotations, this.interfaces, members, this.methods);
        }

        @Override
        public List<Method> getMethods() {
            return this.methods == null ? Collections.emptyList() : this.methods;
        }

        public Class withMethods(@Nullable List<Method> methods) {
            if (methods != null && methods.isEmpty()) {
                methods = null;
            }
            if (methods == this.methods) {
                return this;
            }
            return new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, methods);
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        @Override
        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        @Override
        public Class unsafeSetManagedReference(Integer id) {
            this.managedReference = id;
            return this;
        }

        public Class unsafeSet(@Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, @Nullable List<FullyQualified> annotations, @Nullable List<FullyQualified> interfaces, @Nullable List<Variable> members, @Nullable List<Method> methods) {
            this.supertype = supertype;
            this.owningClass = owningClass;
            this.annotations = ListUtils.nullIfEmpty(annotations);
            this.interfaces = ListUtils.nullIfEmpty(interfaces);
            this.members = ListUtils.nullIfEmpty(members);
            this.methods = ListUtils.nullIfEmpty(methods);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Class aClass = (Class)o;
            return TypeUtils.fullyQualifiedNamesAreEqual(this.fullyQualifiedName, aClass.fullyQualifiedName);
        }

        public String toString() {
            return DefaultJavaTypeSignatureBuilder.TO_STRING.signature(this);
        }

        @Override
        @Nullable
        public Integer getManagedReference() {
            return this.managedReference;
        }

        public long getFlagsBitMap() {
            return this.flagsBitMap;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public FullyQualified.Kind getKind() {
            return this.kind;
        }

        @Override
        @Nullable
        public FullyQualified getSupertype() {
            return this.supertype;
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return this.owningClass;
        }

        @Override
        @NonNull
        public Class withManagedReference(@Nullable Integer managedReference) {
            return this.managedReference == managedReference ? this : new Class(managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @Override
        @NonNull
        public Class withFullyQualifiedName(String fullyQualifiedName) {
            return this.fullyQualifiedName == fullyQualifiedName ? this : new Class(this.managedReference, this.flagsBitMap, fullyQualifiedName, this.kind, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withKind(FullyQualified.Kind kind) {
            return this.kind == kind ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, kind, this.supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withSupertype(@Nullable FullyQualified supertype) {
            return this.supertype == supertype ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, supertype, this.owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }

        @NonNull
        public Class withOwningClass(@Nullable FullyQualified owningClass) {
            return this.owningClass == owningClass ? this : new Class(this.managedReference, this.flagsBitMap, this.fullyQualifiedName, this.kind, this.supertype, owningClass, this.annotations, this.interfaces, this.members, this.methods);
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        public abstract FullyQualified withFullyQualifiedName(String var1);

        public abstract List<FullyQualified> getAnnotations();

        public abstract boolean hasFlags(Flag ... var1);

        public abstract Set<Flag> getFlags();

        public abstract List<FullyQualified> getInterfaces();

        public abstract Kind getKind();

        public abstract List<Variable> getMembers();

        public abstract List<Method> getMethods();

        public Iterator<Method> getVisibleMethods() {
            return this.getVisibleMethods(this.getPackageName());
        }

        private Iterator<Method> getVisibleMethods(String packageName) {
            return new FullyQualifiedIterator<Method>(this, packageName, Method::getFlagsBitMap, FullyQualified::getMethods, fq -> fq.getVisibleMethods(packageName));
        }

        public Iterator<Variable> getVisibleMembers() {
            return this.getVisibleMembers(this.getPackageName());
        }

        private Iterator<Variable> getVisibleMembers(String packageName) {
            return new FullyQualifiedIterator<Variable>(this, packageName, Variable::getFlagsBitMap, FullyQualified::getMembers, fq -> fq.getVisibleMembers(packageName));
        }

        @Nullable
        public abstract FullyQualified getOwningClass();

        @Nullable
        public abstract FullyQualified getSupertype();

        public String getClassName() {
            String fqn = this.getFullyQualifiedName();
            String className = fqn.substring(fqn.lastIndexOf(46) + 1);
            return className.replace('$', '.');
        }

        public String getPackageName() {
            String fqn = this.getFullyQualifiedName();
            int endPackage = fqn.lastIndexOf(46);
            return endPackage < 0 ? "" : fqn.substring(0, endPackage);
        }

        public boolean isAssignableTo(String fullyQualifiedName) {
            return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), fullyQualifiedName) || this.getInterfaces().stream().anyMatch(anInterface -> anInterface.isAssignableTo(fullyQualifiedName)) || this.getSupertype() != null && this.getSupertype().isAssignableTo(fullyQualifiedName);
        }

        public boolean isAssignableFrom(@Nullable JavaType type) {
            if (type instanceof FullyQualified) {
                FullyQualified clazz = (FullyQualified)type;
                return TypeUtils.fullyQualifiedNamesAreEqual(this.getFullyQualifiedName(), clazz.getFullyQualifiedName()) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(this::isAssignableFrom);
            }
            if (type instanceof GenericTypeVariable) {
                GenericTypeVariable generic = (GenericTypeVariable)type;
                for (JavaType bound : generic.getBounds()) {
                    if (!this.isAssignableFrom(bound)) continue;
                    return true;
                }
            }
            return false;
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation;

        }

        private static class FullyQualifiedIterator<E>
        implements Iterator<E> {
            private final FullyQualified fq;
            private final String visibleFromPackage;
            private final Function<E, Long> flags;
            private final Function<FullyQualified, Iterator<E>> recursive;
            private FullyQualified rec;
            private E peek;
            private Iterator<E> current;
            @Nullable
            private Iterator<E> supertypeE;
            @Nullable
            private Iterator<FullyQualified> interfaces;
            @Nullable
            private Iterator<E> interfaceE;

            private FullyQualifiedIterator(FullyQualified fq, String visibleFromPackage, Function<E, Long> flags, Function<FullyQualified, List<E>> base, Function<FullyQualified, Iterator<E>> recursive) {
                this.fq = fq;
                this.rec = fq;
                this.visibleFromPackage = visibleFromPackage;
                this.flags = flags;
                this.recursive = recursive;
                this.current = base.apply(fq).iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.current.hasNext()) {
                    this.peek = this.current.next();
                    long peekFlags = this.flags.apply(this.peek);
                    if (((Flag.Public.getBitMask() | Flag.Protected.getBitMask()) & peekFlags) != 0L) {
                        return true;
                    }
                    if ((Flag.Private.getBitMask() & peekFlags) == 0L && this.rec.getPackageName().equals(this.visibleFromPackage)) {
                        return true;
                    }
                    return true;
                }
                if (this.supertypeE == null) {
                    this.supertypeE = this.fq.getSupertype() == null ? Collections.emptyIterator() : this.recursive.apply(this.fq.getSupertype());
                    this.current = this.supertypeE;
                    this.rec = this.fq.getSupertype();
                    return this.hasNext();
                }
                if (this.interfaces == null) {
                    this.interfaces = this.fq.getInterfaces().iterator();
                    return this.hasNext();
                }
                if (this.interfaces.hasNext()) {
                    this.rec = this.interfaces.next();
                    this.current = this.recursive.apply(this.rec);
                    return this.hasNext();
                }
                return false;
            }

            @Override
            public E next() {
                return this.peek;
            }
        }
    }

    public static class MultiCatch
    implements JavaType {
        private List<JavaType> throwableTypes;

        public MultiCatch unsafeSet(List<JavaType> throwableTypes) {
            this.throwableTypes = throwableTypes;
            return this;
        }

        public List<JavaType> getThrowableTypes() {
            return this.throwableTypes;
        }

        public MultiCatch(List<JavaType> throwableTypes) {
            this.throwableTypes = throwableTypes;
        }

        @NonNull
        public MultiCatch withThrowableTypes(List<JavaType> throwableTypes) {
            return this.throwableTypes == throwableTypes ? this : new MultiCatch(throwableTypes);
        }
    }
}

