/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.dataflow.GuardedBy;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;

@Incubating(since="7.20.0")
public class UpdateGuardedBy
extends Recipe {
    public String getDisplayName() {
        return "Guarded-by data flow analysis";
    }

    public String getDescription() {
        return "Update guarded-by edges tracking places where access to a variable has been guarded by a condition or the negation of a condition.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
                ((HashMap)this.getCursor().dropParentUntil(J.Block.class::isInstance).computeMessageIfAbsent("variables", v -> new HashMap())).put(variable.getSimpleName(), variable.getId());
                return super.visitVariable(variable, ctx);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                GuardedBy guardedBy;
                UUID id;
                J i = super.visitIdentifier(identifier, ctx);
                i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().removeByType(GuardedBy.class));
                Object parent = this.getCursor().dropParentUntil(t -> t instanceof J && !(t instanceof J.Parentheses)).getValue();
                if (parent instanceof J.Binary || parent instanceof J.Unary) {
                    return i;
                }
                Map variableIds = (Map)this.getCursor().getNearestMessage("variables");
                if (variableIds != null && (id = (UUID)variableIds.get(identifier.getSimpleName())) != null && (guardedBy = this.guardedBy(id, null)) != null) {
                    i = ((J.Identifier)i).withMarkers(((J.Identifier)i).getMarkers().setByType((Marker)guardedBy));
                }
                return i;
            }

            @Nullable
            private GuardedBy guardedBy(final UUID variableId, @Nullable J skip) {
                AtomicBoolean skipped = new AtomicBoolean(skip == null);
                J guard = this.getCursor().getPathAsStream().filter(t -> {
                    if (!skipped.get()) {
                        if (t == skip) {
                            skipped.set(true);
                        }
                        return false;
                    }
                    return t instanceof J.If || t instanceof J.If.Else || t instanceof J.ForLoop || t instanceof J.WhileLoop || t instanceof J.DoWhileLoop;
                }).findFirst().orElse(null);
                if (guard != null) {
                    boolean negated = false;
                    Expression guardCondition = null;
                    if (guard instanceof J.If) {
                        guardCondition = ((J.If)guard).getIfCondition().getTree();
                    } else if (guard instanceof J.If.Else) {
                        guardCondition = ((J.If)this.getCursor().firstEnclosingOrThrow(J.If.class)).getIfCondition().getTree();
                        negated = true;
                    } else if (guard instanceof J.ForLoop) {
                        guardCondition = ((J.ForLoop)guard).getControl().getCondition();
                    } else if (guard instanceof J.WhileLoop) {
                        guardCondition = ((J.WhileLoop)guard).getCondition().getTree();
                    } else if (guard instanceof J.DoWhileLoop) {
                        guardCondition = ((J.DoWhileLoop)guard).getWhileCondition().getTree();
                    }
                    if (!(guardCondition instanceof J.Empty)) {
                        assert (guardCondition != null);
                        Map variableIds = (Map)this.getCursor().getNearestMessage("variables");
                        final AtomicBoolean conditionUsesVariable = new AtomicBoolean(false);
                        new JavaIsoVisitor<Integer>(){

                            @Override
                            public J.Identifier visitIdentifier(J.Identifier identifier, Integer integer) {
                                Map variableIds = (Map)this.getCursor().getNearestMessage("variables");
                                assert (variableIds != null);
                                if (variableId.equals(variableIds.get(identifier.getSimpleName()))) {
                                    conditionUsesVariable.set(true);
                                }
                                return identifier;
                            }
                        }.visit(guardCondition, 0, this.getCursor());
                        if (conditionUsesVariable.get()) {
                            return new GuardedBy(Tree.randomId(), guardCondition.getId(), negated);
                        }
                    } else {
                        return this.guardedBy(variableId, guardCondition);
                    }
                }
                return null;
            }
        };
    }
}

