/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class AddImport<P>
extends JavaIsoVisitor<P> {
    private final String type;
    @Nullable
    private final String statik;
    private final boolean onlyIfReferenced;
    private final JavaType.Class classType;

    public AddImport(String type, @Nullable String statik, boolean onlyIfReferenced) {
        this.type = type;
        this.classType = JavaType.ShallowClass.build(type);
        this.statik = statik;
        this.onlyIfReferenced = onlyIfReferenced;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, P p) {
        String packageName;
        if (JavaType.Primitive.fromKeyword(this.classType.getFullyQualifiedName()) != null) {
            return cu;
        }
        int dotIndex = this.classType.getFullyQualifiedName().lastIndexOf(46);
        if (dotIndex >= 0 && ("java.lang".equals(packageName = this.classType.getFullyQualifiedName().substring(0, dotIndex)) || ((J.CompilationUnit)cu).getPackageDeclaration() != null && packageName.equals(((J.CompilationUnit)cu).getPackageDeclaration().getExpression().printTrimmed(this.getCursor())))) {
            return cu;
        }
        if (this.onlyIfReferenced && !this.hasReference((J.CompilationUnit)cu)) {
            return cu;
        }
        if (this.classType.getPackageName().isEmpty()) {
            return cu;
        }
        if (((J.CompilationUnit)cu).getImports().stream().anyMatch(i -> {
            String ending = i.getQualid().getSimpleName();
            if (this.statik == null) {
                return !i.isStatic() && i.getPackageName().equals(this.classType.getPackageName()) && (ending.equals(this.classType.getClassName()) || "*".equals(ending));
            }
            return i.isStatic() && i.getTypeName().equals(this.classType.getFullyQualifiedName()) && (ending.equals(this.statik) || "*".equals(ending));
        })) {
            return cu;
        }
        J.Import importToAdd = new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded<Boolean>(this.statik == null ? Space.EMPTY : Space.format(" "), this.statik != null, Markers.EMPTY), (J.FieldAccess)TypeTree.build(this.classType.getFullyQualifiedName() + (this.statik == null ? "" : "." + this.statik)).withPrefix(Space.format(" ")));
        ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(((J.CompilationUnit)cu).getPadding().getImports());
        if (imports.isEmpty() && !((J.CompilationUnit)cu).getClasses().isEmpty()) {
            if (((J.CompilationUnit)cu).getPackageDeclaration() == null) {
                Space firstClassPrefix = ((J.CompilationUnit)cu).getClasses().get(0).getPrefix();
                importToAdd = importToAdd.withPrefix(firstClassPrefix.withComments(ListUtils.map(firstClassPrefix.getComments(), comment -> comment instanceof Javadoc ? null : comment)).withWhitespace(""));
                cu = ((J.CompilationUnit)cu).withClasses(ListUtils.map(((J.CompilationUnit)cu).getClasses(), (i, clazz) -> {
                    Space prefix = clazz.getPrefix();
                    return i == 0 ? clazz.withPrefix(prefix.withComments(ListUtils.map(prefix.getComments(), comment -> comment instanceof Javadoc ? comment : null))) : clazz;
                }));
            } else {
                importToAdd = importToAdd.withPrefix(Space.format("\n\n"));
            }
        }
        ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
        List<JavaType.FullyQualified> classpath = ((J.CompilationUnit)cu).getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getClasspath).orElse(Collections.emptyList());
        JavaSourceFile c = cu = ((J.CompilationUnit)cu).getPadding().withImports((List)layoutStyle.addImport(((J.CompilationUnit)cu).getPadding().getImports(), importToAdd, ((J.CompilationUnit)cu).getPackageDeclaration(), classpath));
        cu = ((J.CompilationUnit)cu).withClasses(ListUtils.map(((J.CompilationUnit)cu).getClasses(), (arg_0, arg_1) -> this.lambda$visitCompilationUnit$4(p, (J.CompilationUnit)c, arg_0, arg_1)));
        return cu;
    }

    private boolean isTypeReference(NameTree t) {
        boolean isTypRef = true;
        if (t instanceof J.FieldAccess) {
            isTypRef = TypeUtils.isOfClassType(((J.FieldAccess)t).getTarget().getType(), this.type);
        }
        return isTypRef;
    }

    private boolean hasReference(J.CompilationUnit compilationUnit) {
        if (this.statik == null) {
            for (NameTree t : FindTypes.find(compilationUnit, this.type)) {
                if (t instanceof J.FieldAccess && ((J.FieldAccess)t).isFullyQualifiedClassReference(this.type) || !this.isTypeReference(t)) continue;
                return true;
            }
            return false;
        }
        for (J invocation : FindMethods.find(compilationUnit, this.type + " *(..)")) {
            J.MethodInvocation mi;
            if (!(invocation instanceof J.MethodInvocation) || (mi = (J.MethodInvocation)invocation).getSelect() != null || !"*".equals(this.statik) && !mi.getName().getSimpleName().equals(this.statik)) continue;
            return true;
        }
        AtomicReference<Boolean> hasStaticFieldAccess = new AtomicReference<Boolean>(false);
        new FindStaticFieldAccess().visit(compilationUnit, hasStaticFieldAccess);
        return hasStaticFieldAccess.get();
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$statik = this.statik;
        String other$statik = other.statik;
        return !(this$statik == null ? other$statik != null : !this$statik.equals(other$statik));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $statik = this.statik;
        result = result * 59 + ($statik == null ? 43 : $statik.hashCode());
        return result;
    }

    private /* synthetic */ J.ClassDeclaration lambda$visitCompilationUnit$4(Object p, J.CompilationUnit c, Integer i, J.ClassDeclaration clazz) {
        return i == 0 ? this.autoFormat(clazz, clazz.getName(), p, new Cursor(null, (Object)c)) : clazz;
    }

    private class FindStaticFieldAccess
    extends JavaIsoVisitor<AtomicReference<Boolean>> {
        private FindStaticFieldAccess() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, AtomicReference<Boolean> found) {
            for (JavaType.Variable varType : cu.getTypesInUse().getVariables()) {
                if (!varType.getName().equals(AddImport.this.statik) || !TypeUtils.isOfClassType(varType.getType(), AddImport.this.type)) continue;
                return super.visitCompilationUnit(cu, found);
            }
            return cu;
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, AtomicReference<Boolean> found) {
            assert (this.getCursor().getParent() != null);
            if (identifier.getSimpleName().equals(AddImport.this.statik) && TypeUtils.isOfClassType(identifier.getType(), AddImport.this.type) && !(this.getCursor().getParent().firstEnclosingOrThrow(J.class) instanceof J.FieldAccess)) {
                found.set(true);
            }
            return identifier;
        }
    }
}

