/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.java.internal.grammar.AnnotationSignatureParser;
import org.openrewrite.java.internal.grammar.AspectJLexer;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AnnotationMatcher {
    private final AnnotationSignatureParser.AnnotationContext match;

    public AnnotationMatcher(String signature) {
        this.match = new AnnotationSignatureParser((TokenStream)new CommonTokenStream((TokenSource)new AspectJLexer((CharStream)CharStreams.fromString((String)signature)))).annotation();
    }

    public boolean matches(J.Annotation annotation) {
        return this.matchesAnnotationName(annotation) && this.matchesSingleParameter(annotation) && this.matchesNamedParameters(annotation);
    }

    private boolean matchesAnnotationName(J.Annotation annotation) {
        JavaType.Class typeAsClass = TypeUtils.asClass(annotation.getType());
        return this.match.annotationName().getText().equals(typeAsClass == null ? null : typeAsClass.getFullyQualifiedName());
    }

    private boolean matchesNamedParameters(J.Annotation annotation) {
        AnnotationSignatureParser.ElementValuePairsContext pairs = this.match.elementValuePairs();
        if (pairs == null || pairs.elementValuePair() == null) {
            return true;
        }
        if (annotation.getArguments() == null) {
            return false;
        }
        for (AnnotationSignatureParser.ElementValuePairContext elementValuePair : pairs.elementValuePair()) {
            String argumentName = elementValuePair.Identifier().getText();
            String matchText = elementValuePair.elementValue().getText();
            if (!annotation.getArguments().stream().noneMatch(arg -> this.argumentValueMatches(argumentName, (Expression)arg, matchText))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesSingleParameter(J.Annotation annotation) {
        if (this.match.elementValue() == null) {
            return true;
        }
        return annotation.getArguments() == null || annotation.getArguments().stream().findAny().map(arg -> this.argumentValueMatches("value", (Expression)arg, this.match.elementValue().getText())).orElse(true) != false;
    }

    private boolean argumentValueMatches(String matchOnArgumentName, Expression arg, String matchText) {
        if (matchOnArgumentName.equals("value")) {
            if (arg instanceof J.Literal) {
                return ((J.Literal)arg).getValueSource().equals(matchText);
            }
            if (arg instanceof J.FieldAccess && ((J.FieldAccess)arg).getSimpleName().equals("class") && matchText.endsWith(".class")) {
                JavaType argType = ((J.FieldAccess)arg).getTarget().getType();
                if (argType instanceof JavaType.FullyQualified) {
                    String queryTypeFqn = JavaType.Class.build(matchText.replaceAll("\\.class$", "")).getFullyQualifiedName();
                    String targetTypeFqn = ((JavaType.FullyQualified)argType).getFullyQualifiedName();
                    return queryTypeFqn.equals(targetTypeFqn);
                }
                return false;
            }
            if (arg instanceof J.NewArray) {
                J.NewArray na = (J.NewArray)arg;
                if (na.getInitializer() == null || na.getInitializer().size() != 1) {
                    return false;
                }
                return this.argumentValueMatches("value", na.getInitializer().get(0), matchText);
            }
        }
        if (!(arg instanceof J.Assignment)) {
            return false;
        }
        J.Assignment assignment = (J.Assignment)arg;
        if (!assignment.getVariable().printTrimmed().equals(matchOnArgumentName)) {
            return false;
        }
        return this.argumentValueMatches("value", assignment.getAssignment(), matchText);
    }
}

